/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaSSpecialMarkers {
    public static final String TRANS_MARKER = "//";
    public static final String SPEAKER_MARKER = "[^@\\s]*@[^:\\s@]+:";
    public static final Pattern SPEAKER_PATTERN = Pattern.compile("[^@\\s]*@[^:\\s@]+:");
    public static boolean speakerMarkerOnlyAtLineStart = false;

    public static int[] getTranslationIndices(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        if (text.indexOf(TRANS_MARKER) > -1) {
            Matcher m = SPEAKER_PATTERN.matcher(text);
            ArrayList<Integer> indicesList = new ArrayList<Integer>(10);
            int index = text.indexOf(TRANS_MARKER);
            indicesList.add(index);
            while (index > -1 && m.find(index)) {
                index = text.indexOf(TRANS_MARKER, m.end());
                if (index <= -1) continue;
                indicesList.add(index);
            }
            int[] indices = new int[indicesList.size()];
            for (int j = 0; j < indicesList.size(); ++j) {
                indices[j] = (Integer)indicesList.get(j);
            }
            indicesList.clear();
            return indices;
        }
        return null;
    }

    public static boolean hasTranslationMarker(String text) {
        if (text != null && !text.isEmpty()) {
            return text.indexOf(TRANS_MARKER) > -1;
        }
        return false;
    }

    public static int[][] getSpeakerIndices(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        Matcher m = SPEAKER_PATTERN.matcher(text);
        ArrayList<int[]> speakIndicesList = new ArrayList<int[]>(10);
        int fromIndex = 0;
        while (m.find(fromIndex)) {
            int[] match;
            if (speakerMarkerOnlyAtLineStart) {
                if (m.start() == fromIndex) {
                    match = new int[]{m.start(), m.end()};
                    speakIndicesList.add(match);
                }
                if ((fromIndex = text.indexOf(10, fromIndex)) < 0) break;
                ++fromIndex;
            } else {
                match = new int[]{m.start(), m.end()};
                speakIndicesList.add(match);
                fromIndex = m.end() + 1;
            }
            if (fromIndex < text.length() - 1) continue;
        }
        if (!speakIndicesList.isEmpty()) {
            int[][] matches = new int[speakIndicesList.size()][];
            for (int j = 0; j < speakIndicesList.size(); ++j) {
                matches[j] = (int[])speakIndicesList.get(j);
            }
            speakIndicesList.clear();
            return matches;
        }
        return null;
    }

    public static boolean hasSpeakerMarker(String text) {
        if (text != null && !text.isEmpty()) {
            Matcher m = SPEAKER_PATTERN.matcher(text);
            int fromIndex = 0;
            while (m.find(fromIndex)) {
                if (speakerMarkerOnlyAtLineStart) {
                    if (m.start() == fromIndex) {
                        return true;
                    }
                    if ((fromIndex = text.indexOf(10, fromIndex) + 1) > 0 && fromIndex < text.length() - 1) continue;
                    break;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

