/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.turnsandscenemode.TurnsAndSceneViewer;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class TaSViewerControlPanel
extends JPanel
implements ItemListener,
ACMEditListener {
    private TurnsAndSceneViewer viewer;
    private JComboBox tierComboBox;

    public TaSViewerControlPanel(TurnsAndSceneViewer viewer) {
        this.viewer = viewer;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.tierComboBox = new JComboBox();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.tierComboBox, gbc);
        this.initTierBox();
        this.tierComboBox.addItemListener(this);
    }

    private void initTierBox() {
        List<TierImpl> tierList = ((TranscriptionImpl)this.viewer.getViewerManager().getTranscription()).getTiers();
        ArrayList<String> rootTiers = new ArrayList<String>();
        for (Tier tier : tierList) {
            if (tier.getParentTier() != null) continue;
            rootTiers.add(tier.getName());
        }
        this.setTierNames(rootTiers);
    }

    protected void setTierNames(List<String> tierList) {
        if (tierList != null) {
            Object selectedItem = this.tierComboBox.getSelectedItem();
            this.tierComboBox.removeItemListener(this);
            this.tierComboBox.removeAllItems();
            for (String s : tierList) {
                this.tierComboBox.addItem(s);
            }
            this.tierComboBox.addItemListener(this);
            if (tierList.contains(selectedItem)) {
                this.tierComboBox.setSelectedItem(selectedItem);
            } else if (this.tierComboBox.getItemCount() > 0) {
                this.tierComboBox.setSelectedIndex(0);
            }
        }
    }

    public void selectTierByName(String tierName) {
        if (tierName != null) {
            this.tierComboBox.setSelectedItem(tierName);
        }
    }

    private void addTierName(String tierName) {
        if (tierName != null) {
            int itemCount = this.tierComboBox.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                if (!this.tierComboBox.getItemAt(i).equals(tierName)) continue;
                return;
            }
            this.tierComboBox.addItem(tierName);
        }
    }

    private void removeTierName(String tierName) {
        if (tierName != null) {
            int itemCount = this.tierComboBox.getItemCount();
            Object selItem = this.tierComboBox.getSelectedItem();
            for (int i = 0; i < itemCount; ++i) {
                if (!this.tierComboBox.getItemAt(i).equals(tierName)) continue;
                this.tierComboBox.removeItemAt(i);
                if (tierName.equals(selItem)) {
                    this.tierComboBox.setSelectedIndex(Math.max(0, i - 1));
                } else {
                    this.tierComboBox.setSelectedItem(selItem);
                }
                return;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.tierComboBox) {
            String selTierName = (String)e.getItem();
            this.viewer.setTierByName(selTierName);
        }
    }

    private void tierAdded(TierImpl t) {
    }

    private void tierRemoved(TierImpl t) {
    }

    private void tierChanged(TierImpl t) {
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: {
                if (!(e.getModification() instanceof TierImpl)) break;
                this.tierAdded((TierImpl)e.getModification());
                break;
            }
            case 1: {
                if (!(e.getModification() instanceof TierImpl)) break;
                this.tierRemoved((TierImpl)e.getModification());
                break;
            }
            case 2: {
                if (!(e.getInvalidatedObject() instanceof TierImpl)) break;
                this.tierChanged((TierImpl)e.getInvalidatedObject());
                break;
            }
        }
    }
}

