/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode.commands;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.turnsandscenemode.TaSAnno;
import mpi.eudico.client.annotator.turnsandscenemode.TurnsAndSceneViewer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;

public class TaSDeleteAction
extends AbstractAction {
    private TurnsAndSceneViewer viewer;

    public TaSDeleteAction(TurnsAndSceneViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.viewer != null) {
            this.deleteSegment();
        }
    }

    private void deleteSegment() {
        int editingRow = this.viewer.getAnnotationTable().getEditingRow();
        if (editingRow == -1) {
            ClientLogger.LOG.info("A delete action occurred but it is unknown which cell to delete.");
            return;
        }
        TaSAnno curAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow, 0);
        Transcription transcription = this.viewer.getViewerManager().getTranscription();
        if (curAnno.getAnnotation() != null) {
            Command deleteCommand = ELANCommandFactory.createCommand(transcription, "Menu.Annotation.DeleteAnnotation");
            Object[] args = new Object[]{ELANCommandFactory.getViewerManager(transcription), curAnno.getAnnotation()};
            deleteCommand.execute(curAnno.getAnnotation().getTier(), args);
        } else {
            ClientLogger.LOG.info("A delete action occurred but the active cell represents a gap.");
        }
    }
}

