/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode.commands;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.turnsandscenemode.TaSAnno;
import mpi.eudico.client.annotator.turnsandscenemode.TurnsAndSceneViewer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

public class TaSMergeAction
extends AbstractAction {
    private TurnsAndSceneViewer viewer;
    private MERGE_ROW mergeWith;
    private int sourceRow = -1;

    public TaSMergeAction(TurnsAndSceneViewer viewer, MERGE_ROW rowToMergeWith) {
        this.viewer = viewer;
        this.mergeWith = rowToMergeWith;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.viewer != null) {
            if (this.mergeWith == MERGE_ROW.PREVIOUS) {
                this.mergeWithPrevious(this.sourceRow);
            } else {
                this.mergeWithNext(this.sourceRow);
            }
            this.sourceRow = -1;
        }
    }

    public void setSourceRow(int sourceRow) {
        this.sourceRow = sourceRow;
    }

    private void mergeWithNext(int sourceRow) {
        int editingRow = this.viewer.getAnnotationTable().getSelectedRow();
        if (sourceRow > -1) {
            editingRow = sourceRow;
        }
        if (editingRow == -1) {
            ClientLogger.LOG.info("Cannot merge with the next cell: there is no cell selected.");
            return;
        }
        if (editingRow == this.viewer.getAnnotationTable().getRowCount() - 1) {
            ClientLogger.LOG.info("Cannot merge with the next cell: the active cell is the last cell.");
            return;
        }
        TaSAnno curAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow, 0);
        TaSAnno nextAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow + 1, 0);
        this.viewer.getEditor().getTextArea().transferFocusUpCycle();
        if (this.viewer.getAnnotationTable().getCellEditor() != null) {
            this.viewer.getAnnotationTable().getCellEditor().stopCellEditing();
        }
        Transcription transcription = this.viewer.getViewerManager().getTranscription();
        if (curAnno.getAnnotation() != null) {
            if (nextAnno.getAnnotation() != null) {
                boolean ann2HasDepending;
                boolean ann1HasDepending = !((AbstractAnnotation)curAnno.getAnnotation()).getParentListeners().isEmpty();
                boolean bl = ann2HasDepending = !((AbstractAnnotation)nextAnno.getAnnotation()).getParentListeners().isEmpty();
                if (!ann1HasDepending && !ann2HasDepending) {
                    Command com = ELANCommandFactory.createCommand(transcription, "Menu.Annotation.MergeWithNext");
                    com.execute(transcription, new Object[]{curAnno.getAnnotation(), Boolean.TRUE});
                } else {
                    ClientLogger.LOG.info("Cannot merge with the next cell: the annotation has depending annotations.");
                    JOptionPane.showMessageDialog(this.viewer, "Cannot merge with the next annotation: \nthe annotation has depending annotations.", "", 2);
                }
            } else {
                Command com = ELANCommandFactory.createCommand(transcription, "CommandActions.ModifyAnnotationTime");
                com.execute(curAnno.getAnnotation(), new Object[]{curAnno.getBeginTime(), nextAnno.getEndTime()});
            }
        } else if (nextAnno.getAnnotation() != null) {
            Command com = ELANCommandFactory.createCommand(transcription, "CommandActions.ModifyAnnotationTime");
            com.execute(nextAnno.getAnnotation(), new Object[]{curAnno.getBeginTime(), nextAnno.getEndTime()});
        } else {
            ClientLogger.LOG.warning("Unexpected state of the sequence of annotations: cannot merge a gap with another gap");
        }
        this.viewer.getAnnotationTable().editCellAt(editingRow, 0);
        this.viewer.getEditor().startEditing();
    }

    private void mergeWithPrevious(int sourceRow) {
        int editingRow = this.viewer.getAnnotationTable().getSelectedRow();
        if (sourceRow > -1) {
            editingRow = sourceRow;
        }
        if (editingRow == -1) {
            ClientLogger.LOG.info("Cannot merge with the previous cell: there is no cell selected.");
            return;
        }
        if (editingRow == 0) {
            ClientLogger.LOG.info("Cannot merge with the previous cell: the active cell is the first cell.");
            return;
        }
        TaSAnno curAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow, 0);
        TaSAnno prevAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow - 1, 0);
        this.viewer.getEditor().getTextArea().transferFocusUpCycle();
        if (this.viewer.getAnnotationTable().getCellEditor() != null) {
            this.viewer.getAnnotationTable().getCellEditor().stopCellEditing();
        }
        Transcription transcription = this.viewer.getViewerManager().getTranscription();
        if (curAnno.getAnnotation() != null) {
            if (prevAnno.getAnnotation() != null) {
                boolean ann2HasDepending;
                boolean ann1HasDepending = !((AbstractAnnotation)curAnno.getAnnotation()).getParentListeners().isEmpty();
                boolean bl = ann2HasDepending = !((AbstractAnnotation)prevAnno.getAnnotation()).getParentListeners().isEmpty();
                if (!ann1HasDepending && !ann2HasDepending) {
                    Command com = ELANCommandFactory.createCommand(transcription, "Menu.Annotation.MergeWithBefore");
                    com.execute(transcription, new Object[]{curAnno.getAnnotation(), Boolean.FALSE});
                } else {
                    ClientLogger.LOG.info("Cannot merge with the previous cell: the active annotation has depending annotations.");
                    JOptionPane.showMessageDialog(this.viewer, "Cannot merge with the previous annotation: \nthe annotation has depending annotations.", "", 2);
                }
            } else {
                Command com = ELANCommandFactory.createCommand(transcription, "CommandActions.ModifyAnnotationTime");
                com.execute(curAnno.getAnnotation(), new Object[]{prevAnno.getBeginTime(), curAnno.getEndTime()});
            }
        } else if (prevAnno.getAnnotation() != null) {
            Command com = ELANCommandFactory.createCommand(transcription, "CommandActions.ModifyAnnotationTime");
            com.execute(prevAnno.getAnnotation(), new Object[]{prevAnno.getBeginTime(), curAnno.getEndTime()});
        } else {
            ClientLogger.LOG.warning("Unexpected state of the sequence of annotations: cannot merge a gap with another gap");
        }
        this.viewer.getAnnotationTable().getSelectionModel().setSelectionInterval(editingRow - 1, editingRow - 1);
        this.viewer.getAnnotationTable().editCellAt(editingRow - 1, 0);
        this.viewer.getEditor().startEditing();
    }

    public static enum MERGE_ROW {
        PREVIOUS,
        NEXT;

    }
}

