/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.update;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ELAN;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.update.UpdateXmlParser;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import org.xml.sax.InputSource;

public class ElanUpdateDialog {
    private int major = 0;
    private int minor = 0;
    private String downloadURL;
    private final String websiteURL = "https://tla.mpi.nl/tools/tla-tools/elan/";
    private String summary;
    private boolean update = false;
    private boolean error = false;
    private boolean automaticUpdate;
    private Frame parent;

    public ElanUpdateDialog(Frame frame) {
        this(frame, false);
    }

    public ElanUpdateDialog(Frame frame, boolean autoUpdate) {
        this.parent = frame;
        this.automaticUpdate = autoUpdate;
    }

    public void checkForUpdates() {
        String errorMessage = ElanLocale.getString("ElanUpdateDialog.Error.UnKnown");
        try {
            String test = System.getProperty("UpdateTest");
            String url = test != null && test.toLowerCase().equals("true") ? "https://www.mpi.nl/tools/elan/TestUpdateInfo.xml" : "https://www.mpi.nl/tools/elan/ElanUpdateInfo.xml";
            URLConnection con = new URL(url).openConnection();
            UpdateXmlParser reader = new UpdateXmlParser(new InputSource(con.getInputStream()));
            reader.parse();
            this.major = reader.getMajorVersion();
            this.minor = reader.getMinorVersion();
            this.downloadURL = reader.getWebsiteURL();
            this.summary = reader.getSummary();
            this.validateVersionFromFile();
            if (!this.error) {
                if (this.major > ELAN.major) {
                    this.update = true;
                } else if (this.minor > ELAN.minor) {
                    this.update = true;
                }
            }
        }
        catch (ParseException e) {
            this.error = true;
            ClientLogger.LOG.info("Cannot parse the file: " + e.getMessage());
            errorMessage = ElanLocale.getString("ElanUpdateDialog.Error.Parse");
        }
        catch (IOException e) {
            this.error = true;
            ClientLogger.LOG.info("URL Connection not available: " + e.getMessage());
            errorMessage = ElanLocale.getString("ElanUpdateDialog.Error.Internet");
        }
        if (!this.error) {
            Preferences.set("ElanUpdater.LastUpdate", Calendar.getInstance().getTimeInMillis(), null, false, true);
            if (this.update) {
                this.showUpdateDialog();
            } else if (!this.automaticUpdate) {
                this.showMessageDialog(ElanLocale.getString("ElanUpdateDialog.UpToDate"));
            }
        } else if (!this.automaticUpdate) {
            this.showMessageDialog(errorMessage + " " + ElanLocale.getString("ElanUpdateDialog.Error.Part2"));
        }
    }

    private void showMessageDialog(String message) {
        int message_Type;
        JLabel messageLabel = new JLabel();
        JLabel linkLabel = this.getLinkLabel("https://tla.mpi.nl/tools/tla-tools/elan/");
        linkLabel.setText("ELAN website");
        JPanel messagePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(4, 6, 4, 6);
        messagePanel.add((Component)messageLabel, gbc);
        if (!message.startsWith(ElanLocale.getString("ElanUpdateDialog.Error.Internet"))) {
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            messagePanel.add((Component)new JLabel(" " + ElanLocale.getString("ElanUpdateDialog.Message")), gbc);
            gbc.gridx = 1;
            gbc.insets = new Insets(4, 0, 4, 6);
            messagePanel.add((Component)linkLabel, gbc);
        }
        ImageIcon icon = null;
        if (this.error) {
            messageLabel.setText(message);
            message_Type = 0;
        } else {
            messageLabel.setText(message);
            message_Type = -1;
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN64.png"));
        }
        JOptionPane.showMessageDialog(this.parent, messagePanel, ElanLocale.getString("ElanUpdateDialog.Title"), message_Type, icon);
    }

    private void validateVersionFromFile() {
        if (this.major < ELAN.major) {
            this.error = true;
        } else if (this.major == ELAN.major && this.minor < ELAN.minor) {
            this.error = true;
        }
    }

    private JLabel getLinkLabel(final String linkURL) {
        final JLabel linkLabel = new JLabel();
        linkLabel.setForeground(Color.BLUE);
        linkLabel.setCursor(Cursor.getPredefinedCursor(12));
        linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                linkLabel.setForeground(Color.MAGENTA);
                try {
                    URI r = new URI(linkURL);
                    Desktop.getDesktop().browse(r);
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        });
        return linkLabel;
    }

    private void showUpdateDialog() {
        final JDialog dialog = new JDialog(this.parent);
        dialog.setTitle(ElanLocale.getString("ElanUpdateDialog.Title"));
        if (this.automaticUpdate) {
            dialog.setModal(false);
            dialog.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
            dialog.setAlwaysOnTop(true);
        } else {
            dialog.setModal(true);
        }
        ImageIcon elanIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN128.png"));
        JLabel imageLabel = new JLabel(elanIcon);
        JLabel linkLabel = this.getLinkLabel(this.downloadURL);
        linkLabel.setText("<html><u>" + ElanLocale.getString("ElanUpdateDialog.Update2.Part1") + "</u></html>");
        JPanel textPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(4, 6, 4, 6);
        textPanel.add((Component)new JLabel(ElanLocale.getString("ElanUpdateDialog.Update1")), gbc);
        gbc.gridy = 1;
        textPanel.add((Component)new JLabel("ELAN " + this.major + "." + this.minor), gbc);
        gbc.gridy = 2;
        textPanel.add((Component)new JLabel(ElanLocale.getString("ElanUpdateDialog.Update2")), gbc);
        gbc.gridy = 3;
        textPanel.add((Component)linkLabel, gbc);
        JEditorPane textArea = new JEditorPane();
        textArea.setMargin(new Insets(5, 5, 5, 5));
        textArea.setContentType("text/html");
        textArea.setText("<span style=\"font-size: 20pt\"><b>" + ElanLocale.getString("ElanUpdateDialog.Summary") + "</b></span><br>" + this.summary);
        textArea.setEditable(false);
        textArea.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(textArea);
        JButton okButton = new JButton(ElanLocale.getString("Button.OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        JPanel outerPanel = new JPanel(new GridBagLayout());
        outerPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        outerPanel.add((Component)imageLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(4, 6, 4, 6);
        outerPanel.add((Component)textPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        outerPanel.add((Component)scrollPane, gbc);
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 15;
        gbc.fill = 0;
        outerPanel.add((Component)okButton, gbc);
        dialog.getContentPane().add(outerPanel);
        dialog.setPreferredSize(new Dimension(500, 600));
        dialog.pack();
        dialog.setLocationRelativeTo(this.parent);
        dialog.setVisible(true);
    }
}

