/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class UpdateXmlParser {
    private XMLReader reader;
    public String major;
    public String minor;
    public String micro;
    private String fileName;
    private String summary;
    private InputSource source;
    private String websiteURL;

    public UpdateXmlParser(String fileName) throws ParseException {
        this(fileName, false);
    }

    public UpdateXmlParser(InputSource source) throws ParseException {
        this(source, false);
    }

    public UpdateXmlParser(InputSource source, boolean strict) throws ParseException {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.initParser(strict);
    }

    public UpdateXmlParser(String fileName, boolean strict) throws ParseException {
        if (fileName == null) {
            throw new NullPointerException();
        }
        this.fileName = fileName;
        this.initParser(strict);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initParser(boolean strict) throws ParseException {
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.reader.setContentHandler(new UpdateSkeletonHandler());
            if (!strict) return;
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new ParseException(se.getMessage());
        }
    }

    public void parse() throws ParseException {
        try {
            if (this.fileName != null) {
                this.reader.parse(this.fileName);
            } else if (this.source != null) {
                this.reader.parse(this.source);
            }
        }
        catch (SAXException sax) {
            System.out.println("Parsing error: " + sax.getMessage());
            if (this.fileName != null) {
                this.retryParsing();
            }
            throw new ParseException(sax.getMessage(), sax.getCause());
        }
        catch (IOException ioe) {
            System.out.println("IO error: " + ioe.getMessage());
            if (this.fileName != null) {
                this.retryParsing();
            }
            throw new ParseException(ioe.getMessage(), ioe.getCause());
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), e.getCause());
        }
        catch (Throwable t) {
            throw new ParseException(t.getMessage(), t.getCause());
        }
    }

    private void retryParsing() throws ParseException {
        File f = new File(this.fileName);
        if (f.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                InputSource source = new InputSource(fis);
                this.reader.parse(source);
            }
            catch (Exception ee) {
                System.out.println("Parsing retry error: " + ee.getMessage());
                throw new ParseException(ee.getMessage(), ee.getCause());
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int getMajorVersion() {
        int n = -1;
        if (this.major != null) {
            try {
                n = Integer.parseInt(this.major);
            }
            catch (NumberFormatException e) {
                n = -1;
            }
        }
        return n;
    }

    public int getMinorVersion() {
        int n = -1;
        if (this.minor != null) {
            try {
                n = Integer.parseInt(this.minor);
            }
            catch (NumberFormatException e) {
                n = -1;
            }
        }
        return n;
    }

    public int getMicroVersion() {
        int n = -1;
        if (this.micro != null) {
            try {
                n = Integer.parseInt(this.micro);
            }
            catch (NumberFormatException e) {
                n = -1;
            }
        }
        return n;
    }

    public String getWebsiteURL() {
        return this.websiteURL;
    }

    public String getSummary() {
        return this.summary;
    }

    class UpdateSkeletonHandler
    implements ContentHandler {
        String content;

        UpdateSkeletonHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.content = "";
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("major")) {
                UpdateXmlParser.this.major = this.content;
            } else if (localName.equals("minor")) {
                UpdateXmlParser.this.minor = this.content;
            } else if (localName.equals("micro")) {
                UpdateXmlParser.this.micro = this.content;
            } else if (localName.equals("summary")) {
                UpdateXmlParser.this.summary = this.content;
            } else if (localName.equals("website")) {
                UpdateXmlParser.this.websiteURL = this.content;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.content = this.content + new String(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }
}

