/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.Serializable;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.TimeInterval;

public class AnnotationDataRecord
extends TimeInterval
implements Serializable {
    private String tierName;
    private String value;
    private String id;
    private boolean beginTimeAligned;
    private boolean endTimeAligned;
    private ExternalReference extRef;
    private String cvEntryId;
    private String filePath;

    public AnnotationDataRecord(Annotation annotation) {
        super(0L, 0L);
        TimeSlot ts = null;
        if (annotation != null) {
            this.value = annotation.getValue();
            this.beginTime = annotation.getBeginTimeBoundary();
            this.endTime = annotation.getEndTimeBoundary();
            this.cvEntryId = annotation.getCVEntryId();
            this.tierName = annotation.getTier().getName();
            if (annotation instanceof AlignableAnnotation) {
                ts = ((AlignableAnnotation)annotation).getBegin();
                this.beginTimeAligned = ts.isTimeAligned();
                ts = ((AlignableAnnotation)annotation).getEnd();
                this.endTimeAligned = ts.isTimeAligned();
            }
            if (annotation instanceof AbstractAnnotation) {
                AbstractAnnotation abstractAnnotation = (AbstractAnnotation)annotation;
                if (abstractAnnotation.getExtRef() instanceof ExternalReference) {
                    try {
                        this.extRef = abstractAnnotation.getExtRef().clone();
                    }
                    catch (CloneNotSupportedException cnse) {
                        System.out.println("Could not clone:" + cnse.getMessage());
                    }
                }
                this.id = abstractAnnotation.getIdLazily();
            } else {
                this.id = annotation.getId();
            }
            String fp = annotation.getTier().getTranscription().getFullPath();
            this.filePath = "aishug294879ryshfda9763afo8947a5gf".equals(fp) ? "" : fp;
        }
    }

    public AnnotationDataRecord(String tierName, String value, long beginTime, long endTime) {
        super(beginTime, endTime);
        this.tierName = tierName;
        this.value = value;
        if (this.endTime < this.beginTime && this.endTime >= 0L) {
            this.endTime = this.beginTime + 1L;
        }
        if (this.beginTime > -1L) {
            this.beginTimeAligned = true;
        }
        if (this.endTime > -1L) {
            this.endTimeAligned = true;
        }
    }

    public boolean isBeginTimeAligned() {
        return this.beginTimeAligned;
    }

    public boolean isEndTimeAligned() {
        return this.endTimeAligned;
    }

    public void setBeginTimeAligned(boolean beginTimeAligned) {
        if (beginTimeAligned) {
            if (this.beginTime > -1L) {
                this.beginTimeAligned = beginTimeAligned;
            }
        } else {
            this.beginTimeAligned = beginTimeAligned;
        }
    }

    public void setEndTimeAligned(boolean endTimeAligned) {
        if (endTimeAligned) {
            if (this.endTime > -1L) {
                this.endTimeAligned = endTimeAligned;
            }
        } else {
            this.endTimeAligned = endTimeAligned;
        }
    }

    public String getTierName() {
        return this.tierName;
    }

    public void setTierName(String tierName) {
        this.tierName = tierName;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExternalReference getExtRef() {
        return this.extRef;
    }

    public void setExtRef(ExternalReference extRef) {
        this.extRef = extRef;
    }

    public String getCvEntryId() {
        return this.cvEntryId;
    }

    public void setCvEntryId(String cveId) {
        this.cvEntryId = cveId;
    }

    public void setCvEntry(CVEntry cve) {
        this.setExtRef(cve.getExternalRef());
        this.setCvEntryId(cve.getId());
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

