/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.ControlledVocabulary;

public class AnnotationRecreator {
    private static final Logger LOG = Logger.getLogger(AnnotationRecreator.class.getName());

    private static void convertAnnotations(TranscriptionImpl trans, LinguisticType type) {
        if (trans == null || type == null) {
            return;
        }
        ArrayList<TierImpl> convertedTiers = new ArrayList<TierImpl>();
        List<TierImpl> tiersToConvert = null;
        tiersToConvert = trans.getTiersWithLinguisticType(type.getLinguisticTypeName());
        ArrayList<TierImpl> rootTiers = new ArrayList<TierImpl>();
        for (TierImpl t : tiersToConvert) {
            if (t.hasParentTier()) continue;
            rootTiers.add(t);
        }
        for (TierImpl t : tiersToConvert) {
            if (rootTiers.contains(t)) continue;
            rootTiers.add(t);
        }
        tiersToConvert = rootTiers;
        for (TierImpl curTier : tiersToConvert) {
            if (convertedTiers.contains(curTier)) continue;
            AnnotationRecreator.convertAnnotations((Transcription)trans, curTier);
            convertedTiers.add(curTier);
            List<TierImpl> depTiers = curTier.getDependentTiers();
            for (TierImpl depTier : depTiers) {
                if (convertedTiers.contains(depTier)) continue;
                convertedTiers.add(depTier);
            }
        }
    }

    private static void convertAnnotations(Transcription trans, TierImpl tier) {
        if (trans == null || tier == null) {
            return;
        }
        List<AbstractAnnotation> annotations = tier.getAnnotations();
        ArrayList<DefaultMutableTreeNode> annTreeList = new ArrayList<DefaultMutableTreeNode>(annotations.size());
        for (AbstractAnnotation absAnn : annotations) {
            DefaultMutableTreeNode root = AnnotationRecreator.createTreeForAnnotation(absAnn);
            annTreeList.add(root);
        }
        for (AbstractAnnotation absAnn : annotations) {
            tier.removeAnnotation(absAnn);
        }
        for (DefaultMutableTreeNode root : annTreeList) {
            AnnotationRecreator.createAnnotationFromTree(trans, root);
        }
    }

    public static DefaultMutableTreeNode createTreeForAnnotation(AbstractAnnotation aa) {
        DefaultMutableTreeNode root = null;
        root = new DefaultMutableTreeNode(new AnnotationDataRecord(aa));
        List<Annotation> children = null;
        AbstractAnnotation next = null;
        AbstractAnnotation parent = null;
        DefaultMutableTreeNode nextNode = null;
        DefaultMutableTreeNode parentNode = root;
        String tierName = null;
        DefaultMutableTreeNode tempNode = null;
        AnnotationDataRecord dataRecord = null;
        children = aa.getParentListeners();
        if (children.size() > 0) {
            block0: for (int i = 0; i < children.size(); ++i) {
                next = (AbstractAnnotation)children.get(i);
                nextNode = AnnotationRecreator.createNodeForAnnotation(next);
                if (parentNode.getChildCount() == 0) {
                    parentNode.add(nextNode);
                } else {
                    long bt = next.getBeginTimeBoundary();
                    for (int k = 0; k < parentNode.getChildCount(); ++k) {
                        tempNode = (DefaultMutableTreeNode)parentNode.getChildAt(k);
                        dataRecord = (AnnotationDataRecord)tempNode.getUserObject();
                        tierName = next.getTier().getName();
                        if (dataRecord.getBeginTime() > bt && tierName != null && dataRecord.getTierName().equals(tierName)) {
                            parentNode.insert(nextNode, k);
                            break;
                        }
                        if (k != parentNode.getChildCount() - 1) continue;
                        parentNode.add(nextNode);
                    }
                }
                if (next.getParentListeners().size() > 0) {
                    children = next.getParentListeners();
                    parentNode = nextNode;
                    i = -1;
                    continue;
                }
                if (i != children.size() - 1) continue;
                while ((parent = (AbstractAnnotation)next.getParentAnnotation()) != null) {
                    parentNode = (DefaultMutableTreeNode)nextNode.getParent();
                    children = parent.getParentListeners();
                    int j = children.indexOf(next);
                    if (j == children.size() - 1) {
                        if (parent == aa) break block0;
                        next = parent;
                        nextNode = parentNode;
                        continue;
                    }
                    i = j;
                    continue block0;
                }
                break block0;
            }
        }
        return root;
    }

    public static DefaultMutableTreeNode createNodeForAnnotation(AbstractAnnotation aa) {
        DefaultMutableTreeNode node = null;
        node = new DefaultMutableTreeNode(new AnnotationDataRecord(aa));
        return node;
    }

    public static boolean restoreValueEtc(AbstractAnnotation aa, AnnotationDataRecord annData, boolean includeID) {
        if (aa != null) {
            if (annData.getExtRef() != null) {
                aa.setExtRef(annData.getExtRef());
            } else if (aa.getExtRef() != null && LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("External reference not removed for annotation: Tier: %s, BT: %d, ET: %d", aa.getTier().getName(), aa.getBeginTimeBoundary(), aa.getEndTimeBoundary()));
            }
            if (annData.getCvEntryId() != null) {
                ControlledVocabulary cv;
                String otherCVName;
                Tier otherTier;
                String cvName = aa.getTier().getLinguisticType().getControlledVocabularyName();
                if (cvName != null && !aa.getTier().getName().equals(annData.getTierName()) && (otherTier = aa.getTier().getTranscription().getTierWithId(annData.getTierName())) != null && !cvName.equals(otherCVName = otherTier.getLinguisticType().getControlledVocabularyName())) {
                    cvName = null;
                }
                if (cvName != null && (cv = aa.getTier().getTranscription().getControlledVocabulary(cvName)) != null && cv.getEntrybyId(annData.getCvEntryId()) != null) {
                    aa.setCVEntryId(annData.getCvEntryId());
                }
            }
            if (includeID) {
                aa.setId(annData.getId());
            }
            aa.setValue(annData.getValue());
            return true;
        }
        String type = aa instanceof RefAnnotation ? "Reference annotation" : (aa instanceof AlignableAnnotation ? "Alignable annotation" : "Annotation");
        LOG.severe(type + " could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime() + " et: " + annData.getEndTime());
        return false;
    }

    public static AbstractAnnotation createAnnotationFromTree(Transcription trans, DefaultMutableTreeNode root) {
        return AnnotationRecreator.createAnnotationFromTree(trans, root, false);
    }

    public static AbstractAnnotation createAnnotationFromTree(Transcription trans, DefaultMutableTreeNode root, boolean includeID) {
        return AnnotationRecreator.createAnnotationFromTree(trans, root, includeID, null);
    }

    public static AbstractAnnotation createAnnotationFromTree(Transcription trans, DefaultMutableTreeNode root, boolean includeID, Map<String, String> tierMapping) {
        long end;
        long begin;
        DefaultMutableTreeNode node;
        String tierName;
        if (trans == null || root == null) {
            return null;
        }
        AbstractAnnotation annotation = null;
        AlignableAnnotation aa = null;
        RefAnnotation ra = null;
        Annotation an = null;
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        AnnotationDataRecord annData = null;
        TierImpl tier = null;
        int linStereoType = -1;
        if (tierMapping != null && (tier = (TierImpl)trans.getTierWithId(tierName = tierMapping.get((annData = (AnnotationDataRecord)root.getUserObject()).getTierName()))) == null) {
            LOG.warning("Cannot recreate annotations: tier copy does not exist: " + tierName);
        }
        while (en.hasMoreElements()) {
            AlignableAnnotation curAnn;
            aa = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            if (tierMapping == null) {
                tier = (TierImpl)trans.getTierWithId(annData.getTierName());
            } else {
                tierName = tierMapping.get(annData.getTierName());
                tier = (TierImpl)trans.getTierWithId(tierName);
            }
            if (tier == null) {
                LOG.severe("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (!tier.isTimeAlignable() || !annData.isBeginTimeAligned()) continue;
            begin = annData.getBeginTime();
            end = annData.getEndTime();
            if (!annData.isEndTimeAligned() && end == begin) {
                ++end;
            }
            aa = tierMapping != null ? (AlignableAnnotation)tier.createAnnotation(begin, end) : (!annData.isEndTimeAligned() && tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().supportsInsertion() ? ((curAnn = (AlignableAnnotation)tier.getAnnotationAtTime(annData.getBeginTime())) != null && curAnn.getBeginTimeBoundary() == annData.getBeginTime() ? (AlignableAnnotation)tier.createAnnotationBefore(curAnn) : (AlignableAnnotation)tier.createAnnotation(begin, end)) : (AlignableAnnotation)tier.createAnnotation(begin, end));
            if (node == root) {
                annotation = aa;
            }
            AnnotationRecreator.restoreValueEtc(aa, annData, includeID);
        }
        en = root.breadthFirstEnumeration();
        Annotation prevAnn = null;
        while (en.hasMoreElements()) {
            String tierName2;
            aa = null;
            an = null;
            ra = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            if (tierMapping == null) {
                tier = (TierImpl)trans.getTierWithId(annData.getTierName());
            } else {
                tierName2 = tierMapping.get(annData.getTierName());
                tier = (TierImpl)trans.getTierWithId(tierName2);
            }
            if (tier == null) {
                LOG.severe("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (tier.isTimeAlignable()) {
                if (!annData.isBeginTimeAligned()) {
                    tierName2 = annData.getTierName();
                    if (tierMapping != null) {
                        tierName2 = tierMapping.get(tierName2);
                    }
                    if (!(prevAnn == null || prevAnn.getTier().getName().equals(tierName2) && prevAnn.getEndTimeBoundary() > annData.getBeginTime())) {
                        prevAnn = null;
                    }
                    if (prevAnn == null) {
                        begin = annData.getBeginTime();
                        end = annData.getEndTime();
                        an = tier.getAnnotationAtTime(begin);
                        if (an != null) {
                            aa = (AlignableAnnotation)tier.createAnnotationAfter(an);
                            prevAnn = aa;
                        } else {
                            aa = (AlignableAnnotation)tier.createAnnotation(begin, end);
                            prevAnn = aa;
                        }
                    } else {
                        aa = (AlignableAnnotation)tier.createAnnotationAfter(prevAnn);
                        prevAnn = aa;
                    }
                    if (node == root) {
                        annotation = aa;
                    }
                    AnnotationRecreator.restoreValueEtc(aa, annData, includeID);
                    continue;
                }
                prevAnn = null;
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 3) {
                begin = annData.getBeginTime();
                tierName2 = annData.getTierName();
                if (tierMapping != null) {
                    tierName2 = tierMapping.get(tierName2);
                }
                if (prevAnn != null && !prevAnn.getTier().getName().equals(tierName2)) {
                    prevAnn = null;
                }
                if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                    prevAnn = null;
                }
                if (prevAnn == null) {
                    an = tier.getAnnotationAtTime(begin);
                    ra = an != null ? (an.getBeginTimeBoundary() == begin ? (RefAnnotation)tier.createAnnotationBefore(an) : (RefAnnotation)tier.createAnnotationAfter(an)) : (RefAnnotation)tier.createAnnotation(begin, begin);
                    prevAnn = ra;
                } else {
                    ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                    prevAnn = ra;
                }
                if (node == root) {
                    annotation = ra;
                }
                AnnotationRecreator.restoreValueEtc(ra, annData, includeID);
                continue;
            }
            if (linStereoType != 4) continue;
            begin = annData.getBeginTime();
            an = tier.getAnnotationAtTime(begin);
            if (an == null) {
                ra = (RefAnnotation)tier.createAnnotation(begin, begin);
            }
            if (node == root) {
                annotation = ra;
            }
            AnnotationRecreator.restoreValueEtc(ra, annData, includeID);
        }
        return annotation;
    }

    public static void createAnnotationsSequentially(Transcription trans, List<DefaultMutableTreeNode> annotationsNodes) {
        AnnotationRecreator.createAnnotationsSequentially(trans, annotationsNodes, false);
    }

    public static void createAnnotationsSequentially(Transcription trans, List<DefaultMutableTreeNode> annotationsNodes, boolean includeId) {
        DefaultMutableTreeNode node;
        int i;
        if (trans == null || annotationsNodes == null || annotationsNodes.size() == 0) {
            return;
        }
        AnnotationDataRecord annData = null;
        TierImpl tier = null;
        LinguisticType linType = null;
        for (i = 0; i < annotationsNodes.size(); ++i) {
            node = annotationsNodes.get(i);
            annData = (AnnotationDataRecord)node.getUserObject();
            if (!annData.isBeginTimeAligned()) continue;
            AnnotationRecreator.createAnnotationFromTree(trans, node, includeId);
        }
        block1: for (i = 0; i < annotationsNodes.size(); ++i) {
            node = annotationsNodes.get(i);
            annData = (AnnotationDataRecord)node.getUserObject();
            if (annData.isBeginTimeAligned()) continue;
            tier = (TierImpl)trans.getTierWithId(annData.getTierName());
            if (tier == null) {
                LOG.severe("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            linType = tier.getLinguisticType();
            if (linType.getConstraints() != null && linType.getConstraints().getStereoType() == 4) {
                AnnotationRecreator.createAnnotationFromTree(trans, node, includeId);
                continue;
            }
            TierImpl parentTier = tier.getParentTier();
            AbstractAnnotation parentAnn = (AbstractAnnotation)parentTier.getAnnotationAtTime(annData.getBeginTime());
            if (parentAnn == null) {
                LOG.severe("Cannot recreate annotations: parent annotation does not exist.");
                continue;
            }
            DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode("parent");
            parentNode.add(node);
            while (i < annotationsNodes.size()) {
                node = annotationsNodes.get(i);
                annData = (AnnotationDataRecord)node.getUserObject();
                if (parentTier.getAnnotationAtTime(annData.getBeginTime()) == parentAnn && !annData.isBeginTimeAligned()) {
                    parentNode.add(node);
                    if (i == annotationsNodes.size() - 1) {
                        AnnotationRecreator.createChildAnnotationsSkipRoot(trans, parentNode, includeId);
                    }
                } else {
                    AnnotationRecreator.createChildAnnotationsSkipRoot(trans, parentNode, includeId);
                    --i;
                    continue block1;
                }
                ++i;
            }
        }
    }

    static void createChildAnnotationsSkipRoot(Transcription trans, DefaultMutableTreeNode parentNode) {
        AnnotationRecreator.createChildAnnotationsSkipRoot(trans, parentNode, false);
    }

    static void createChildAnnotationsSkipRoot(Transcription trans, DefaultMutableTreeNode parentNode, boolean includeId) {
        if (trans == null || parentNode == null || parentNode.getChildCount() == 0) {
            return;
        }
        Annotation prevAnn = null;
        AlignableAnnotation aa = null;
        RefAnnotation ra = null;
        Annotation an = null;
        AnnotationDataRecord annData = null;
        TierImpl tier = null;
        int linStereoType = -1;
        Enumeration<TreeNode> en = parentNode.breadthFirstEnumeration();
        en.nextElement();
        while (en.hasMoreElements()) {
            long begin;
            aa = null;
            an = null;
            ra = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            tier = (TierImpl)trans.getTierWithId(annData.getTierName());
            if (tier == null) {
                LOG.severe("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (tier.isTimeAlignable()) {
                if (!annData.isBeginTimeAligned()) {
                    if (!(prevAnn == null || prevAnn.getTier().getName().equals(annData.getTierName()) && prevAnn.getEndTimeBoundary() > annData.getBeginTime())) {
                        prevAnn = null;
                    }
                    if (prevAnn == null) {
                        begin = annData.getBeginTime();
                        an = tier.getAnnotationAtTime(begin);
                        if (an != null) {
                            aa = (AlignableAnnotation)tier.createAnnotationAfter(an);
                            prevAnn = aa;
                        } else {
                            aa = (AlignableAnnotation)tier.createAnnotation(begin, annData.getEndTime());
                            prevAnn = aa;
                        }
                    } else {
                        aa = (AlignableAnnotation)tier.createAnnotationAfter(prevAnn);
                        prevAnn = aa;
                    }
                    AnnotationRecreator.restoreValueEtc(aa, annData, includeId);
                    continue;
                }
                prevAnn = null;
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 3) {
                begin = annData.getBeginTime();
                if (prevAnn != null && !prevAnn.getTier().getName().equals(annData.getTierName())) {
                    prevAnn = null;
                }
                if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                    prevAnn = null;
                }
                if (prevAnn == null) {
                    ra = (RefAnnotation)tier.createAnnotation(begin, begin);
                    prevAnn = ra;
                } else {
                    ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                    prevAnn = ra;
                }
                AnnotationRecreator.restoreValueEtc(ra, annData, includeId);
                continue;
            }
            if (linStereoType != 4) continue;
            begin = annData.getBeginTime();
            an = tier.getAnnotationAtTime(begin);
            if (an == null) {
                ra = (RefAnnotation)tier.createAnnotation(begin, begin);
            }
            AnnotationRecreator.restoreValueEtc(ra, annData, includeId);
        }
    }

    public static void createAnnotationsSequentiallyDepthless(Transcription trans, List<List<AnnotationDataRecord>> annotationsRecords) {
        AnnotationRecreator.createAnnotationsSequentiallyDepthless(trans, annotationsRecords, false);
    }

    public static void createAnnotationsSequentiallyDepthless(Transcription trans, List<List<AnnotationDataRecord>> annotationsRecords, boolean includeId) {
        if (trans == null || annotationsRecords == null || annotationsRecords.size() == 0) {
            return;
        }
        List<AnnotationDataRecord> siblingList = null;
        for (int i = 0; i < annotationsRecords.size(); ++i) {
            siblingList = annotationsRecords.get(i);
            AnnotationRecreator.createSiblingAnnotations(trans, siblingList, includeId);
        }
    }

    static void createSiblingAnnotations(Transcription trans, List<AnnotationDataRecord> siblings, boolean includeId) {
        if (trans == null || siblings == null || siblings.size() == 0) {
            return;
        }
        AbstractAnnotation prevAnn = null;
        AlignableAnnotation aa = null;
        RefAnnotation ra = null;
        Annotation an = null;
        AnnotationDataRecord annData = null;
        TierImpl tier = null;
        int linStereoType = -1;
        for (int i = 0; i < siblings.size(); ++i) {
            long begin;
            aa = null;
            an = null;
            ra = null;
            annData = siblings.get(i);
            if (tier == null) {
                tier = (TierImpl)trans.getTierWithId(annData.getTierName());
            }
            if (tier == null) {
                LOG.severe("Cannot recreate annotations: tier does not exist.");
                return;
            }
            if (tier.isTimeAlignable()) {
                if (annData.isBeginTimeAligned()) {
                    prevAnn = aa = (AlignableAnnotation)tier.createAnnotation(annData.getBeginTime(), annData.getEndTime());
                } else if (prevAnn == null) {
                    begin = annData.getBeginTime();
                    an = tier.getAnnotationAtTime(begin);
                    if (an != null) {
                        prevAnn = aa = (AlignableAnnotation)tier.createAnnotationAfter(an);
                    }
                } else {
                    prevAnn = aa = (AlignableAnnotation)tier.createAnnotationAfter(prevAnn);
                }
                AnnotationRecreator.restoreValueEtc(aa, annData, includeId);
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 3) {
                begin = annData.getBeginTime();
                if (prevAnn != null && !prevAnn.getTier().getName().equals(annData.getTierName())) {
                    prevAnn = null;
                }
                if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                    prevAnn = null;
                }
                if (prevAnn == null) {
                    ra = (RefAnnotation)tier.createAnnotation(begin, begin);
                    prevAnn = ra;
                } else {
                    ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                    prevAnn = ra;
                }
                AnnotationRecreator.restoreValueEtc(ra, annData, includeId);
                continue;
            }
            if (linStereoType != 4) continue;
            begin = annData.getBeginTime();
            an = tier.getAnnotationAtTime(begin);
            if (an == null) {
                ra = (RefAnnotation)tier.createAnnotation(begin, begin);
            }
            AnnotationRecreator.restoreValueEtc(ra, annData, includeId);
        }
    }
}

