/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeInterval;

public class AnnotationsToTiersUtil {
    public Map<String, List<TimeInterval>> convertToTiers(TierImpl tier, String splitDelimiter) {
        if (tier == null) {
            return null;
        }
        if (tier.getNumberOfAnnotations() == 0) {
            return null;
        }
        HashMap<String, List<TimeInterval>> tierMap = new HashMap<String, List<TimeInterval>>();
        List<AbstractAnnotation> annotations = tier.getAnnotations();
        for (int i = 0; i < annotations.size(); ++i) {
            String[] vals;
            List<TimeInterval> curList;
            Annotation ann = annotations.get(i);
            if (ann.getValue() == null || ann.getValue().length() <= 0) continue;
            if (splitDelimiter == null) {
                curList = (ArrayList<TimeInterval>)tierMap.get(ann.getValue());
                if (curList == null) {
                    curList = new ArrayList<TimeInterval>();
                    tierMap.put(ann.getValue(), curList);
                }
                curList.add(new TimeInterval(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary()));
                continue;
            }
            for (String s : vals = ann.getValue().split(splitDelimiter)) {
                curList = (List)tierMap.get(s);
                if (curList == null) {
                    curList = new ArrayList();
                    tierMap.put(s, curList);
                }
                curList.add(new TimeInterval(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary()));
            }
        }
        return tierMap;
    }
}

