/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FileUtility {
    public static String pathToURLString(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.replace('\\', '/')).startsWith("rtsp:")) {
            return path;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        int n = 0;
        while (!path.isEmpty() && path.charAt(0) == '/') {
            path = path.substring(1);
            ++n;
        }
        if (n == 2) {
            return "file://" + path;
        }
        return "file:///" + path;
    }

    public static String urlStringToPath(String urlString) {
        if (urlString == null) {
            return urlString;
        }
        String path = urlString;
        if (path.startsWith("file:")) {
            if (path.length() > 5) {
                path = path.substring(5);
            }
            if (path.startsWith("///")) {
                path = path.substring(2);
            }
        } else if (path.startsWith("rtsp://")) {
            if (path.length() > 7) {
                path = path.substring(7);
            }
        } else if (path.startsWith("http://")) {
            if (path.length() > 7) {
                path = path.substring(7);
            }
        } else if (path.startsWith("https://") && path.length() > 8) {
            path = path.substring(8);
        }
        return path;
    }

    public static boolean sameNameIgnoreExtension(String path1, String path2) {
        String name2;
        if (path1 == null || path2 == null) {
            return false;
        }
        String name1 = FileUtility.fileNameFromPath(path1);
        int extensionPos = name1.lastIndexOf(46);
        if (extensionPos >= 0) {
            name1 = name1.substring(0, extensionPos);
        }
        if ((extensionPos = (name2 = FileUtility.fileNameFromPath(path2)).lastIndexOf(46)) >= 0) {
            name2 = name2.substring(0, extensionPos);
        }
        return name1.equals(name2);
    }

    public static String fileNameFromPath(String path) {
        if (path == null) {
            return null;
        }
        String name = path.replace('\\', '/');
        int delimiterPos = name.lastIndexOf(47);
        if (delimiterPos >= 0) {
            name = name.substring(delimiterPos + 1);
        }
        return name;
    }

    public static String directoryFromPath(String path) {
        if (path == null) {
            return null;
        }
        String name = path.replace('\\', '/');
        int delimiterPos = name.lastIndexOf(47);
        if (delimiterPos >= 0) {
            name = name.substring(0, delimiterPos);
        }
        return name;
    }

    public static boolean fileExists(String path) {
        File file;
        if (path == null) {
            return false;
        }
        int colonPos = path.indexOf(58);
        String fileName = path;
        if (colonPos > -1) {
            fileName = path.substring(colonPos + 1);
        }
        return (file = new File(fileName = fileName.replace('\\', '/'))).exists();
    }

    public static final String getExtension(File f) {
        String name = f.getName();
        return FileUtility.getExtension(name);
    }

    public static final String getExtension(String name) {
        int li = name.lastIndexOf(".");
        return li == -1 ? null : name.substring(li + 1);
    }

    public static final String getExtension(String name, String defaultExtension) {
        int li = name.lastIndexOf(".");
        return li == -1 ? defaultExtension : name.substring(li + 1);
    }

    public static final String dropExtension(String name) {
        int dot = name.lastIndexOf(".");
        if (dot == -1) {
            return name;
        }
        String basename = name.substring(0, dot);
        int slash = name.lastIndexOf(47);
        return slash < dot ? basename : name;
    }

    public void copyToDir(File sourceFile, File destDir) throws Exception {
        int len;
        byte[] buffer = new byte[4096];
        destDir.mkdirs();
        File destFile = new File(destDir, sourceFile.getName());
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
    }

    public static void copyToFile(File sourceFile, File destFile) throws Exception {
        int len;
        byte[] buffer = new byte[4096];
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
    }

    public static String urlToAbsPath(String filename) {
        if (filename == null) {
            return filename;
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring("file:".length());
        }
        return filename;
    }

    public static String getRelativePath(String referenceFilename, String resourceFilename) {
        int i;
        int numSlashesRes;
        int numSlashesRef;
        if (referenceFilename == null || resourceFilename == null) {
            return resourceFilename;
        }
        if (resourceFilename.startsWith("../") || resourceFilename.startsWith("./")) {
            return resourceFilename;
        }
        String refNoProt = FileUtility.urlToAbsPath(referenceFilename);
        String resourceNoProt = FileUtility.urlToAbsPath(resourceFilename);
        for (numSlashesRef = 0; numSlashesRef < refNoProt.length() && refNoProt.charAt(numSlashesRef) == '/'; ++numSlashesRef) {
        }
        for (numSlashesRes = 0; numSlashesRes < resourceNoProt.length() && resourceNoProt.charAt(numSlashesRes) == '/'; ++numSlashesRes) {
        }
        if (numSlashesRef != numSlashesRes) {
            return null;
        }
        String[] refFields2 = refNoProt.split("/");
        String[] resourceFields2 = resourceNoProt.split("/");
        String[] refFields = new String[refFields2.length - numSlashesRef];
        for (int i2 = 0; i2 < refFields.length; ++i2) {
            refFields[i2] = refFields2[i2 + numSlashesRef];
        }
        String[] resourceFields = new String[resourceFields2.length - numSlashesRes];
        for (int i3 = 0; i3 < resourceFields.length; ++i3) {
            resourceFields[i3] = resourceFields2[i3 + numSlashesRes];
        }
        if (refFields.length > 0 && resourceFields.length > 0 && !refFields[0].equals(resourceFields[0])) {
            return null;
        }
        int refFieldsLen = refFields.length;
        int resourceFieldsLen = resourceFields.length;
        int minFieldsLen = Math.min(refFieldsLen, resourceFieldsLen);
        for (i = 0; i < minFieldsLen && refFields[i].equals(resourceFields[i]); ++i) {
        }
        int restIndex = i;
        StringBuilder relPathBuf = new StringBuilder();
        if (i == refFieldsLen - 1) {
            relPathBuf.append("./");
        } else if (i == refFieldsLen) {
            relPathBuf.append("./");
            --restIndex;
        } else {
            while (i < refFieldsLen - 1) {
                relPathBuf.append("../");
                ++i;
            }
        }
        for (i = restIndex; i < resourceFieldsLen - 1; ++i) {
            relPathBuf.append(resourceFields[i] + "/");
        }
        relPathBuf.append(resourceFields[i]);
        return relPathBuf.toString();
    }

    public static String getAbsolutePath(String referenceFilename, String resourceFilename) {
        if (referenceFilename == null || resourceFilename == null) {
            return resourceFilename;
        }
        if (resourceFilename.startsWith("../") || resourceFilename.startsWith("./")) {
            int i;
            String[] refFields = FileUtility.urlToAbsPath(referenceFilename).split("/");
            String[] resourceFields = FileUtility.urlToAbsPath(resourceFilename).split("/");
            int refFieldsLen = refFields.length;
            int resourceFieldsLen = resourceFields.length;
            int minFieldsLen = refFieldsLen;
            if (resourceFieldsLen < refFieldsLen) {
                minFieldsLen = resourceFieldsLen;
            }
            for (i = 0; i < resourceFieldsLen && resourceFields[i].equalsIgnoreCase(".."); ++i) {
            }
            int refBaseIndex = i;
            StringBuilder absPathBuf = new StringBuilder();
            for (int s = 0; s < refFieldsLen - refBaseIndex - 1; ++s) {
                absPathBuf.append(refFields[s] + "/");
            }
            if (resourceFilename.startsWith("./")) {
                i = 1;
            }
            while (i < resourceFieldsLen - 1) {
                absPathBuf.append(resourceFields[i] + "/");
                ++i;
            }
            absPathBuf.append(resourceFields[i]);
            return absPathBuf.toString();
        }
        return resourceFilename;
    }
}

