/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;

public class LocaleDiff {
    public void run() {
        ResourceBundle english = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage", new Locale("", "", ""));
        Locale loc2 = null;
        PropertyResourceBundle other = null;
        Enumeration<String> engEn = null;
        Collection<Locale> allLocs = ELANCommandFactory.getLocales();
        for (Locale loc2 : allLocs) {
            if (loc2.equals(Locale.ENGLISH)) continue;
            try {
                other = (PropertyResourceBundle)ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage", loc2);
            }
            catch (Exception ee) {
                System.out.println("Could not load resource: " + ee.getMessage());
                continue;
            }
            engEn = english.getKeys();
            ArrayList<String> list = new ArrayList<String>();
            while (engEn.hasMoreElements()) {
                String key = engEn.nextElement();
                try {
                    Integer.valueOf(english.getString(key));
                }
                catch (NumberFormatException numberFormatException) {
                    if (other.handleGetObject(key) != null) continue;
                    list.add(key + "=" + english.getString(key));
                }
            }
            Collections.sort(list);
            this.writeProperties(loc2, list);
        }
    }

    private void writeProperties(Locale loc, StringBuilder props) {
        try {
            File f = new File(System.getProperty("user.home") + File.separator + "LangDiff_" + loc.getLanguage() + ".properties");
            FileWriter writer = new FileWriter(f);
            writer.write(props.toString());
            writer.close();
        }
        catch (Exception e) {
            System.out.println("Could not write file: " + e.getMessage());
        }
    }

    private void writeProperties(Locale loc, List<String> props) {
        try {
            File f = new File(System.getProperty("user.home") + File.separator + "LangDiff_" + loc.getLanguage() + ".properties");
            FileWriter writer = new FileWriter(f);
            for (int i = 0; i < props.size(); ++i) {
                if (props.get(i).indexOf(10) >= 0) {
                    writer.write(props.get(i).replaceAll("\n", "\\\\n") + "\n");
                    continue;
                }
                writer.write(props.get(i) + "\n");
            }
            writer.close();
        }
        catch (Exception e) {
            System.out.println("Could not write file: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        new LocaleDiff().run();
    }
}

