/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class SquelchOutput {
    PrintStream oldStdout = null;
    PrintStream oldStderr = null;

    public void squelchOutput() throws IOException {
        if (this.oldStdout != null) {
            throw new IOException("Output already squelched");
        }
        this.oldStdout = System.out;
        this.oldStderr = System.err;
        System.setOut(new PrintStream(new SilentPrintStream(), true));
        System.setErr(new PrintStream(new SilentPrintStream(), true));
    }

    public void restoreOutput() throws IOException {
        if (this.oldStdout == null) {
            throw new IOException("Output was not squelched");
        }
        System.out.close();
        System.err.close();
        System.setOut(this.oldStdout);
        System.setErr(this.oldStderr);
        this.oldStdout = null;
        this.oldStderr = null;
    }

    private class SilentPrintStream
    extends ByteArrayOutputStream {
        private SilentPrintStream() {
        }

        @Override
        public void flush() throws IOException {
            super.reset();
        }
    }
}

