/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.util.List;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class TierMenuStringFormatter {
    private static int cellWidth = 0;
    private static int maxCharacterLength = 0;

    public static void InitializeWithTierList(List<TierImpl> tierList) {
        maxCharacterLength = 0;
        for (TierImpl t : tierList) {
            int currLength = t.getName().length();
            if (currLength <= maxCharacterLength) continue;
            maxCharacterLength = currLength;
        }
        cellWidth = maxCharacterLength * 8;
    }

    public static void UpdateWithTier(TierImpl tier) {
        int length = tier.getName().length();
        if (length > maxCharacterLength) {
            maxCharacterLength = length;
        }
    }

    public static void UpdateWithString(String value) {
        int length = value.length();
        if (length > maxCharacterLength) {
            maxCharacterLength = length;
        }
    }

    public static String GetFormattedString(TierImpl tier) {
        Boolean boolPref = Preferences.getBool("UI.MenuItems.ShowAnnotationCount", null);
        if (boolPref == null || !boolPref.booleanValue()) {
            return tier.getName();
        }
        return "<html><table cellpadding='0' cellspacing='0'><tr><td width ='" + cellWidth + "'>" + tier.getName() + "</td><td>[" + tier.getNumberOfAnnotations() + "]</td></tr></table></html>";
    }

    public static String GetFormattedString(String tierName, String suffix) {
        Boolean boolPref = Preferences.getBool("UI.MenuItems.ShowAnnotationCount", null);
        if (boolPref == null || !boolPref.booleanValue()) {
            return tierName;
        }
        return "<html><table cellpadding='0' cellspacing='0'><tr><td width ='" + cellWidth + "'>" + tierName + "</td><td>" + suffix + "</td></tr></table></html>";
    }
}

