/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.global.MenuAction;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.CommentManager;
import mpi.eudico.client.annotator.comments.CommentSearchDialog;
import mpi.eudico.client.annotator.comments.CommentTable;
import mpi.eudico.client.annotator.comments.CommentTableModel;
import mpi.eudico.client.annotator.comments.CommentsFilterDialog;
import mpi.eudico.client.annotator.comments.CommentsSettingsDialog;
import mpi.eudico.client.annotator.comments.DefaultCommentTableModel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.server.corpora.util.ACMEditableObject;

public class CommentViewer
extends AbstractViewer
implements ACMEditListener,
ActionListener,
ElanLocaleListener,
ClientLogger,
ListDataListener,
ListSelectionListener,
ACMEditableObject,
MultiTierViewer,
KeyListener,
MouseListener {
    public static final boolean USE_WEB_SERVICE = true;
    public static final boolean DEBUG = false;
    private static Color readonlyColor = Constants.LIGHT_YELLOW;
    private static Color modifiableColor = Color.WHITE;
    private static Color filteredLightColor = new Color(208, 240, 255);
    private Color unfilteredLightColor;
    private static Color filteredDarkColor = new Color(0, 0, 255);
    private Transcription transcription;
    private CommentManager commentManager;
    private Tier activeTier;
    private Annotation activeAnnotation;
    private JPanel rightPanel;
    private DefaultCommentTableModel tableModel;
    private CommentTable commentTable;
    private JSplitPane splitPane;
    private JTextArea text;
    private JButton addCommentButton;
    private JButton deleteCommentButton;
    private JButton changeCommentButton;
    private JButton filterButton;
    private JButton logInOutButton;
    private JButton menuButton;
    private JPopupMenu popupMenu;
    private MenuAction addCommentMA;
    private MenuAction changeCommentMA;
    private MenuAction deleteCommentsMA;
    private MenuAction filterCommentsMA;
    private MenuAction toMailMA;
    private MenuAction toClipboardMA;
    private MenuAction fromClipboardMA;
    private MenuAction searchMA;
    private MenuAction settingsMA;
    private Set<String> visibleTiers;
    private int totalNumberOfTiers;
    private long fileWatcherInterval = 600000L;
    private Thread fileWatcherThread;
    private long approximateNextWakeupTime;
    private Semaphore updateCheckCanBeEnqueued;
    private CommentEnvelope commentOfText;
    private RowFilter<CommentTableModel, Integer> stringFilter;
    private RowFilter<CommentTableModel, Integer> tierFilter;
    private String stringFilterString;
    private boolean stringFilterCaseSensitive = true;
    protected long rePopUpMillis;
    private DocumentListener documentListener;
    public static final int POSTPONE_OPTION = 0;
    public static final int KEEP_LOCAL_AS_NEW_OPTION = 1;
    public static final int REJECT_OPTION = 2;
    public static final int ACCEPT_OPTION = 3;
    public static final int IMPORT_AS_NEW_OPTION = -99;
    private static final int MAYBE_REMOVE_POSTPONE = 0;
    private static final int MAYBE_REMOVE_ACCEPT = 1;
    private static final int MAYBE_REMOVE_REJECT = 2;

    public CommentViewer(TranscriptionImpl transcription) {
        this.transcription = transcription;
        this.visibleTiers = new HashSet<String>();
        this.updateCheckCanBeEnqueued = new Semaphore(1);
        this.commentManager = new CommentManager(transcription, this);
        this.initComponents();
        this.updateList();
        this.updateGUI();
        this.startFileWatcherThread(transcription.getName());
    }

    private void initComponents() {
        this.tableModel = new DefaultCommentTableModel(this.commentManager);
        this.commentTable = new CommentTable(this.tableModel);
        this.newTierFilter();
        this.unfilteredLightColor = this.commentTable.getBackground();
        this.applyPreferences();
        JScrollPane scrollCommentList = new JScrollPane(this.commentTable);
        this.commentTable.setScrollPane(scrollCommentList);
        this.commentTable.addListeners(this);
        int NUM_BUTTONS_X = 3;
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        JScrollPane scrollText = this.createScrollTextArea();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        this.rightPanel.add((Component)scrollText, gbc);
        this.popupMenu = new JPopupMenu();
        this.toMailMA = new ToMailMenuAction("CommentViewer.ToMail");
        this.popupMenu.add(this.toMailMA);
        this.toClipboardMA = new ToClipboardMenuAction("CommentViewer.ToClipboard");
        this.popupMenu.add(this.toClipboardMA);
        this.fromClipboardMA = new FromClipboardMenuAction("CommentViewer.FromClipboard");
        this.popupMenu.add(this.fromClipboardMA);
        this.searchMA = new SearchMenuAction("CommentViewer.Search");
        this.popupMenu.add(this.searchMA);
        this.settingsMA = new SettingsMenuAction("CommentViewer.Settings");
        this.popupMenu.add(this.settingsMA);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                    CommentViewer.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.rightPanel.addMouseListener(mouseListener);
        this.text.addMouseListener(mouseListener);
        this.addCommentMA = new AddCommentAction("CommentViewer.NewComment");
        this.addCommentButton = new JButton(this.addCommentMA);
        gbc.anchor = 23;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.rightPanel.add((Component)this.addCommentButton, gbc);
        this.changeCommentMA = new ChangeCommentAction("CommentViewer.ChangeComment");
        this.changeCommentButton = new JButton(this.changeCommentMA);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.rightPanel.add((Component)this.changeCommentButton, gbc);
        this.deleteCommentsMA = new DeleteCommentsAction("CommentViewer.DeleteComment");
        this.deleteCommentButton = new JButton(this.deleteCommentsMA);
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.rightPanel.add((Component)this.deleteCommentButton, gbc);
        this.filterCommentsMA = new FilterCommentsAction("CommentViewer.Filter");
        this.filterButton = new JButton(this.filterCommentsMA);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.rightPanel.add((Component)this.filterButton, gbc);
        this.logInOutButton = new JButton("Log In");
        this.logInOutButton.addActionListener(this);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.rightPanel.add((Component)this.logInOutButton, gbc);
        this.menuButton = new JButton("Other...");
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.rightPanel.add((Component)this.menuButton, gbc);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (System.currentTimeMillis() < CommentViewer.this.rePopUpMillis) {
                    CommentViewer.this.popupMenu.setVisible(false);
                    CommentViewer.this.rePopUpMillis = 0L;
                } else {
                    Component c = e.getComponent();
                    CommentViewer.this.popupMenu.show(c, 0, c.getHeight());
                }
            }
        };
        this.menuButton.addMouseListener(ml);
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                CommentViewer.this.rePopUpMillis = System.currentTimeMillis() + 3L;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.splitPane = new JSplitPane(1, scrollCommentList, this.rightPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setBorder(null);
        this.splitPane.setDividerSize(6);
        this.splitPane.setContinuousLayout(true);
        Dimension minimumSize = new Dimension(100, 50);
        scrollCommentList.setMinimumSize(minimumSize);
        this.rightPanel.setMinimumSize(minimumSize);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.splitPane, gbc);
        this.updateLocale();
    }

    private JScrollPane createScrollTextArea() {
        this.text = new JTextArea();
        this.text.setLineWrap(true);
        this.text.setToolTipText(ElanLocale.getString("CommentViewer.TextToolTip"));
        this.documentListener = new RedTextDocumentListener();
        this.text.getDocument().addDocumentListener(this.documentListener);
        InputMap inputMap = this.text.getInputMap();
        ActionMap actionMap = this.text.getActionMap();
        KeyStroke key = KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(key, "change-or-add-comment");
        actionMap.put("change-or-add-comment", new ChangeOrAddCommentAction());
        JScrollPane scrollText = new JScrollPane(this.text);
        return scrollText;
    }

    private void applyPreferences() {
        this.commentTable.applyPreferences("CommentViewer", this.transcription);
    }

    private void savePreferences() {
        this.commentTable.savePreferences("CommentViewer", this.transcription);
    }

    public CommentManager getCommentManager() {
        return this.commentManager;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source != null && source == this.logInOutButton) {
            if (this.commentManager.webClientIsLoggedIn()) {
                this.commentManager.logoutWebClient();
            } else {
                this.loginWebClient();
            }
            this.updateGUI();
        }
    }

    private void loginWebClient() {
        boolean success = false;
        try {
            this.updateCheckCanBeEnqueued.acquire();
            success = this.commentManager.loginWebClient();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.updateCheckCanBeEnqueued.release();
        }
        if (!success) {
            JOptionPane.showMessageDialog(this.logInOutButton, ElanLocale.getString("CommentViewer.LoginFailed"));
        }
    }

    protected int setSelectedIndex(int modelRow) {
        int viewRow = this.commentTable.convertRowIndexToView(modelRow);
        this.commentTable.getSelectionModel().setSelectionInterval(viewRow, viewRow);
        return viewRow;
    }

    public static void scrollToVisible(JTable table, int viewRowIndex, int viewColIndex) {
        table.scrollRectToVisible(table.getCellRect(viewRowIndex, viewColIndex, true));
    }

    public void showTableRow(int modelRow) {
        int viewRow = this.setSelectedIndex(modelRow);
        CommentViewer.scrollToVisible(this.commentTable, viewRow, 0);
    }

    protected int[] getSelectedRows() {
        int[] selected = this.commentTable.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = this.commentTable.convertRowIndexToModel(selected[i]);
        }
        return selected;
    }

    private void newTierFilter() {
        RowFilter<CommentTableModel, Integer> filter;
        if (this.visibleTiers.size() >= this.totalNumberOfTiers) {
            this.tierFilter = null;
            this.setRowFilter();
            return;
        }
        this.tierFilter = filter = new RowFilter<CommentTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends CommentTableModel, ? extends Integer> entry) {
                int index = entry.getIdentifier();
                CommentEnvelope e = entry.getModel().getComment(index);
                String tierName = e.getTierName();
                if (tierName == null || tierName.isEmpty()) {
                    return true;
                }
                return CommentViewer.this.visibleTiers.contains(tierName);
            }
        };
        this.setRowFilter();
    }

    public void setRegexFilter(String match, boolean caseSensitive) {
        RowFilter rf = null;
        this.stringFilterString = match;
        this.stringFilterCaseSensitive = caseSensitive;
        if (match != null && !match.isEmpty()) {
            String flags = caseSensitive ? "" : "(?iu)";
            try {
                rf = RowFilter.regexFilter(flags + match, new int[0]);
            }
            catch (PatternSyntaxException e) {
                try {
                    rf = RowFilter.regexFilter(flags + Pattern.quote(match), new int[0]);
                }
                catch (PatternSyntaxException e2) {
                    rf = null;
                }
            }
        }
        if (rf != null) {
            this.commentTable.setBackground(filteredLightColor);
            this.filterButton.setForeground(filteredDarkColor);
        } else {
            this.commentTable.setBackground(this.unfilteredLightColor);
            this.filterButton.setForeground(null);
        }
        this.stringFilter = rf;
        this.setRowFilter();
    }

    private void setRowFilter() {
        ArrayList<RowFilter<CommentTableModel, Integer>> filters = new ArrayList<RowFilter<CommentTableModel, Integer>>(2);
        if (this.tierFilter != null) {
            filters.add(this.tierFilter);
        }
        if (this.stringFilter != null) {
            filters.add(this.stringFilter);
        }
        if (filters.isEmpty()) {
            this.commentTable.setRowFilter(null);
        } else if (filters.size() == 1) {
            this.commentTable.setRowFilter((RowFilter)filters.get(0));
        } else {
            this.commentTable.setRowFilter(RowFilter.andFilter(filters));
        }
    }

    private void deActivateComment() {
        this.commentOfText = null;
        this.text.setText("");
        this.text.setBackground(modifiableColor);
        this.text.setEditable(true);
    }

    private void activateCommentHalfway() {
        ListSelectionModel selectionModel = this.commentTable.getSelectionModel();
        int index = selectionModel.getLeadSelectionIndex();
        if (index >= 0 && index < this.commentTable.getRowCount() && selectionModel.isSelectedIndex(index)) {
            index = this.commentTable.convertRowIndexToModel(index);
            this.activateCommentHalfway(index);
            return;
        }
        this.deActivateComment();
    }

    private boolean activateCommentHalfway(int index) {
        if (index >= 0) {
            CommentEnvelope comment = this.commentManager.get(index = Math.min(index, this.commentTable.getModel().getRowCount() - 1));
            if (comment.isReadOnly()) {
                this.text.setBackground(readonlyColor);
                this.text.setEditable(false);
            } else {
                this.text.setBackground(modifiableColor);
                this.text.setEditable(true);
            }
            this.commentOfText = comment;
            this.text.setText(comment.getMessage());
            return true;
        }
        return false;
    }

    private void activateComment() {
        ListSelectionModel selectionModel = this.commentTable.getSelectionModel();
        int index = selectionModel.getLeadSelectionIndex();
        if (index >= 0 && selectionModel.isSelectedIndex(index)) {
            index = this.commentTable.convertRowIndexToModel(index);
            this.activateComment(index);
            return;
        }
        this.deActivateComment();
    }

    public void activateComment(int index) {
        Tier tier;
        CommentEnvelope comment;
        index = Math.min(index, this.commentTable.getModel().getRowCount() - 1);
        this.commentOfText = comment = this.commentManager.get(index);
        this.text.setText(comment.getMessage());
        ViewerManager2 vm = this.getViewerManager();
        String id = comment.getTierName();
        if (id != null && (tier = this.transcription.getTierWithId(id)) != null) {
            vm.getMultiTierControlPanel().setActiveTier(tier);
        }
        vm.getSelection().setSelection(comment.getStartTime(), comment.getEndTime());
        vm.getMasterMediaPlayer().setMediaTime(comment.getStartTime());
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        if (e.getOperation() == 6) {
            // empty if block
        }
    }

    private void logURI() {
        long selectionBeginPos = this.getSelectionBeginTime();
        long selectionEndPos = this.getSelectionEndTime();
        LOG.info("selection begin = " + Long.toString(selectionBeginPos) + ", end = " + Long.toString(selectionEndPos));
        ViewerManager2 vm = this.getViewerManager();
        if (vm != null) {
            Transcription transcription = vm.getTranscription();
            long crossHairTime = vm.getMasterMediaPlayer().getMediaTime();
            LOG.info("URI for crosshair: " + CommentEnvelope.getTimeBasedURI(transcription.getURN(), crossHairTime));
            Tier tier = this.activeTier;
            URI uri = tier == null ? CommentEnvelope.getTimeBasedURI(transcription.getURN(), selectionBeginPos, selectionEndPos) : CommentEnvelope.getTierTimeBasedURI(transcription.getURN(), tier.getName(), selectionBeginPos, selectionEndPos);
            LOG.info("URI for active selection: " + uri.toString());
        }
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
    }

    @Override
    public void updateSelection() {
    }

    @Override
    public void updateActiveAnnotation() {
        this.activeAnnotation = this.getActiveAnnotation();
        if (this.activeAnnotation == null) {
            // empty if block
        }
    }

    @Override
    public void updateLocale() {
        if (this.logInOutButton != null) {
            String messageKey = this.commentManager.webClientIsLoggedIn() ? "CommentViewer.LogOut" : "CommentViewer.LogIn";
            this.logInOutButton.setText(ElanLocale.getString(messageKey));
            this.logInOutButton.setToolTipText(ElanLocale.getString("CommentViewer.LogInToolTip"));
        }
        this.menuButton.setText(ElanLocale.getString("CommentViewer.Other"));
        this.menuButton.setToolTipText(ElanLocale.getString("CommentViewer.OtherToolTip"));
        this.addCommentMA.updateLocale();
        this.changeCommentMA.updateLocale();
        this.deleteCommentsMA.updateLocale();
        this.filterCommentsMA.updateLocale();
        this.toMailMA.updateLocale();
        this.toClipboardMA.updateLocale();
        this.fromClipboardMA.updateLocale();
        this.searchMA.updateLocale();
        this.settingsMA.updateLocale();
    }

    @Override
    public void preferencesChanged() {
        this.commentManager.preferencesChanged();
        Integer pref = Preferences.getInt("CommentViewer.UpdateCheckTime", null);
        if (pref != null) {
            long oldInterval = this.fileWatcherInterval;
            this.fileWatcherInterval = (long)(pref * 60) * 1000L;
            if (this.fileWatcherInterval < oldInterval) {
                this.maybeRestartFileWatcher();
            }
        }
    }

    @Override
    public void isClosing() {
        this.stopFileWatcherThread();
        this.savePreferences();
        this.commentManager.isClosing();
    }

    private void updateList() {
        if (this.commentManager != null) {
            List<CommentEnvelope> list = this.commentManager.getList();
            this.tableModel.setComments(list);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        if (this.commentManager != null) {
            List<CommentEnvelope> list = this.commentManager.getList();
            int lwb = event.getIndex0();
            int upb = event.getIndex1();
            if (upb >= list.size()) {
                LOG.info("upb > list.size()");
                upb = list.size() - 1;
            }
            if (lwb >= list.size()) {
                LOG.info("lwb > list.size()");
                lwb = list.size() - 1;
            }
            if (lwb == 0 && upb == list.size() - 1) {
                this.tableModel.fireTableDataChanged();
            } else {
                this.tableModel.fireTableRowsUpdated(lwb, upb);
            }
            this.modified(22, null);
            this.activateCommentHalfway();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
        List<CommentEnvelope> list = this.commentManager.getList();
        int upb = event.getIndex1();
        for (int lwb = event.getIndex0(); lwb <= upb; ++lwb) {
            CommentEnvelope cm = list.get(lwb);
            this.modified(20, cm);
        }
        this.tableModel.fireTableRowsInserted(event.getIndex0(), upb);
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
        int lwb = event.getIndex0();
        int upb = event.getIndex1();
        this.tableModel.fireTableRowsDeleted(lwb, upb);
        this.modified(21, null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel expectedSource = this.commentTable.getSelectionModel();
        if (e.getSource() == expectedSource) {
            try {
                this.activateCommentHalfway();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.deActivateComment();
            }
            this.updateGUI();
        }
    }

    private void updateGUI() {
        int num = this.commentTable.getSelectedRowCount();
        boolean changable = false;
        if (num == 1 && this.commentOfText != null && !this.commentOfText.isReadOnly()) {
            changable = true;
        }
        boolean deletable = false;
        if (num >= 1) {
            int[] selected;
            for (int s : selected = this.getSelectedRows()) {
                CommentEnvelope e = this.commentManager.get(s);
                if (e.isReadOnly()) continue;
                deletable = true;
                break;
            }
        }
        this.changeCommentMA.setEnabled(changable);
        this.deleteCommentsMA.setEnabled(deletable);
        this.toClipboardMA.setEnabled(num >= 1);
        this.fromClipboardMA.setEnabled(true);
        this.toMailMA.setEnabled(num >= 1);
        if (this.logInOutButton != null) {
            this.logInOutButton.setText(ElanLocale.getString(this.commentManager.webClientIsLoggedIn() ? "CommentViewer.LogOut" : "CommentViewer.LogIn"));
        }
    }

    public void addComment(CommentEnvelope ce) {
        ce.setToBeSaved(true);
        int existingIndex = this.commentManager.undoableAddComment(ce);
        if (existingIndex >= 0) {
            String fmt;
            String msg;
            int reply;
            this.showTableRow(existingIndex);
            CommentEnvelope existing = this.commentManager.undoableGet(existingIndex);
            Object changed = ce.valueEquals(existing) ? ElanLocale.getString("CommentViewer.WarnDeleted.Identical") : ElanLocale.getString("CommentViewer.WarnDeleted.Different");
            if (ce.isNewerThan(existing)) {
                changed = (String)changed + ElanLocale.getString("CommentViewer.WarnDeleted.MoreRecent");
            }
            if ((reply = this.showYesNoKeepasnewDialog(msg = String.format(fmt = ElanLocale.getString("CommentViewer.WarnDeleted"), changed))) == 3) {
                this.commentManager.undoableReplace(existingIndex, ce);
            } else if (reply != 2) {
                if (reply == -99) {
                    this.commentManager.updateAsNewComment(ce, true);
                    this.commentManager.undoableAddComment(ce);
                    this.commentManager.undoableRelease(existingIndex, existing);
                } else if (reply == 1) {
                    this.commentManager.updateAsNewComment(existing, false);
                    this.commentManager.undoableRelease(existingIndex, existing);
                    this.commentManager.undoableAddComment(ce);
                } else if (reply == 0) {
                    // empty if block
                }
            }
        }
    }

    public int showYesNoKeepasnewDialog(String msg) {
        Object[] options = new String[]{ElanLocale.getString("CommentViewer.PostponeOption"), ElanLocale.getString("CommentViewer.KeepLocalAsNewOption"), ElanLocale.getString("CommentViewer.RejectOption"), ElanLocale.getString("CommentViewer.AcceptOption")};
        String title = ElanLocale.getString("CommentViewer.WarnConflicting");
        int n = JOptionPane.showOptionDialog(null, msg, title, 1, 3, null, options, options[3]);
        return n;
    }

    public void modifyComment(int existingIndex, CommentEnvelope newCE, int reloadFromWhere) {
        String initials;
        assert (existingIndex >= 0);
        this.showTableRow(existingIndex);
        Object newtext = newCE.getMessage();
        if (((String)newtext).length() > 200) {
            newtext = ((String)newtext).substring(0, 200) + "...";
        }
        if (!(initials = newCE.getInitials()).isEmpty()) {
            newtext = "[" + initials + "] " + (String)newtext;
        }
        StringBuilder msg = new StringBuilder();
        msg.append(ElanLocale.getString("CommentViewer.CommentChangedExternally"));
        msg.append("\n\"");
        msg.append((String)newtext);
        msg.append("\"\n\n");
        msg.append(ElanLocale.getString("CommentViewer.ReplaceIt"));
        int reply = this.showYesNoKeepasnewDialog(msg.toString());
        CommentEnvelope existing = this.commentManager.undoableGet(existingIndex);
        if (reply == 3) {
            this.commentManager.undoableReplace(existingIndex, newCE);
        } else if (reply == 2) {
            if (reloadFromWhere == 1) {
                this.commentManager.undoableRelease(existingIndex, existing);
            }
        } else if (reply == -99) {
            this.commentManager.updateAsNewComment(newCE, true);
            this.commentManager.undoableRelease(existingIndex, existing);
            this.commentManager.undoableAddComment(newCE);
        } else if (reply == 1) {
            this.commentManager.updateAsNewComment(existing, false);
            this.commentManager.undoableRelease(existingIndex, existing);
            this.commentManager.undoableAddComment(newCE);
        } else if (reply == 0) {
            // empty if block
        }
    }

    public void maybeRemoveComment(int existingIndex, CommentEnvelope ce, int reloadFromWhere) {
        this.showTableRow(existingIndex);
        String message = ce.getMessage();
        if (message.length() > 64) {
            message = message.substring(0, 64);
        }
        StringBuilder msg = new StringBuilder();
        msg.append(ElanLocale.getString("CommentViewer.CommentDeletedExternally"));
        msg.append("\n\"");
        msg.append(message);
        msg.append("\"\n\n");
        msg.append(ElanLocale.getString("CommentViewer.RemoveIt"));
        if (ce.getToBeSavedToFile()) {
            msg.append('\n');
            msg.append(ElanLocale.getString("CommentViewer.ModifiedRecently"));
        }
        Object[] options = new String[]{ElanLocale.getString("CommentViewer.PostponeOption"), ElanLocale.getString("CommentViewer.RemoveLocal"), ElanLocale.getString("CommentViewer.DontRemoveLocal")};
        int reply = JOptionPane.showOptionDialog(null, msg.toString(), ElanLocale.getString("Message.Warning"), 1, 3, null, options, options[2]);
        if (reply != 0) {
            if (reply == 1) {
                this.commentManager.undoableRemove(existingIndex);
            } else if (reply == 2) {
                if (reloadFromWhere == 1) {
                    ce.setMessageURL("");
                }
                this.commentManager.undoableRelease(existingIndex, ce);
            }
        }
    }

    private void startFileWatcherThread(String name) {
        this.fileWatcherThread = new Thread(null, null, "ElanSavedFileWatcher " + name){

            @Override
            public void run() {
                try {
                    while (true) {
                        CommentViewer.this.approximateNextWakeupTime = System.currentTimeMillis() + CommentViewer.this.fileWatcherInterval;
                        Thread.sleep(CommentViewer.this.fileWatcherInterval);
                        if (!CommentViewer.this.updateCheckCanBeEnqueued.tryAcquire()) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    CommentViewer.this.commentManager.checkForFileModifications(false);
                                }
                                finally {
                                    CommentViewer.this.updateCheckCanBeEnqueued.release();
                                }
                            }
                        });
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        this.fileWatcherThread.setDaemon(true);
        this.fileWatcherThread.start();
    }

    private void stopFileWatcherThread() {
        try {
            this.updateCheckCanBeEnqueued.acquire();
            if (this.fileWatcherThread != null && this.fileWatcherThread.isAlive()) {
                this.fileWatcherThread.interrupt();
                this.fileWatcherThread.join();
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        finally {
            this.fileWatcherThread = null;
            this.updateCheckCanBeEnqueued.release();
        }
    }

    private void maybeRestartFileWatcher() {
        if (System.currentTimeMillis() + this.fileWatcherInterval + 30000L < this.approximateNextWakeupTime) {
            this.stopFileWatcherThread();
            this.startFileWatcherThread(this.transcription.getName());
        }
    }

    public void notifyListeners(ACMEditableObject source, int operation, Object modification) {
        this.transcription.handleModification(source, operation, modification);
    }

    @Override
    public void modified(int operation, Object modification) {
        this.handleModification(this, operation, modification);
    }

    @Override
    public void handleModification(ACMEditableObject commentViewer, int operation, Object modification) {
        this.notifyListeners(commentViewer, operation, modification);
    }

    public void setVisibleTiers(List tiers0) {
        List tiers = tiers0;
        this.visibleTiers.clear();
        for (Tier t : tiers) {
            this.visibleTiers.add(t.getName());
        }
        this.totalNumberOfTiers = this.transcription.getTiers().size();
        this.newTierFilter();
    }

    @Override
    public void setActiveTier(Tier tier) {
        this.activeTier = tier;
    }

    @Override
    public void setMultiTierControlPanel(MultiTierControlPanel controller) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getSource() == this.commentTable && (e.getKeyChar() == ' ' || e.getKeyChar() == '\n')) {
            this.activateComment();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.activateComment();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private final class SettingsMenuAction
    extends ButtonMenuAction {
        public SettingsMenuAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommentsSettingsDialog dialog = new CommentsSettingsDialog(CommentViewer.this.transcription);
            dialog.setVisible(true);
        }
    }

    private final class SearchMenuAction
    extends ButtonMenuAction {
        public SearchMenuAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommentSearchDialog dialog = new CommentSearchDialog(CommentViewer.this.stringFilterString, CommentViewer.this.stringFilterCaseSensitive);
            dialog.setVisible(true);
        }
    }

    private final class FromClipboardMenuAction
    extends ButtonMenuAction {
        public FromClipboardMenuAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommentManager.commentsFromClipboard();
        }
    }

    private final class ToClipboardMenuAction
    extends ButtonMenuAction {
        public ToClipboardMenuAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = CommentViewer.this.getSelectedRows();
            CommentViewer.this.commentManager.commentsToClipboard(selected);
        }
    }

    private final class ToMailMenuAction
    extends ButtonMenuAction {
        public ToMailMenuAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = CommentViewer.this.getSelectedRows();
            CommentViewer.this.commentManager.commentsToMail(selected);
        }
    }

    private final class FilterCommentsAction
    extends ButtonMenuAction {
        public FilterCommentsAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if ((ev.getModifiers() & 1) != 0) {
                CommentViewer.this.setRegexFilter(null, CommentViewer.this.stringFilterCaseSensitive);
            } else {
                CommentsFilterDialog dialog = new CommentsFilterDialog(CommentViewer.this, CommentViewer.this.stringFilterString, CommentViewer.this.stringFilterCaseSensitive);
                dialog.setVisible(true);
            }
        }
    }

    private final class DeleteCommentsAction
    extends ButtonMenuAction {
        public DeleteCommentsAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int[] selected = CommentViewer.this.getSelectedRows();
            Arrays.sort(selected);
            for (int i = selected.length - 1; i >= 0; --i) {
                CommentEnvelope e = CommentViewer.this.commentManager.get(selected[i]);
                if (e.isReadOnly()) continue;
                CommentViewer.this.commentManager.undoableRemove(selected[i]);
            }
        }
    }

    private final class ChangeOrAddCommentAction
    extends AbstractAction {
        private ChangeOrAddCommentAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CommentViewer.this.changeCommentMA.isEnabled()) {
                CommentViewer.this.changeCommentMA.actionPerformed(e);
            } else {
                CommentViewer.this.addCommentMA.actionPerformed(e);
            }
        }
    }

    private final class ChangeCommentAction
    extends ButtonMenuAction {
        public ChangeCommentAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            CommentEnvelope e;
            int[] selected = CommentViewer.this.getSelectedRows();
            if (selected.length == 1 && !(e = CommentViewer.this.commentManager.undoableGet(selected[0])).isReadOnly()) {
                e.setMessage(CommentViewer.this.text.getText());
                e.setModificationDate();
                int newpos = CommentViewer.this.commentManager.undoableRelease(selected[0], e);
                CommentViewer.this.setSelectedIndex(newpos);
                CommentViewer.this.text.setForeground(Color.BLACK);
            }
        }
    }

    private final class AddCommentAction
    extends ButtonMenuAction {
        public AddCommentAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long beginTime = CommentViewer.this.getSelectionBeginTime();
            long endTime = CommentViewer.this.getSelectionEndTime();
            if (beginTime == 0L && endTime == 0L) {
                beginTime = endTime = CommentViewer.this.getMediaTime();
            }
            CommentEnvelope comment = CommentViewer.this.commentManager.createComment(CommentViewer.this.text.getText(), beginTime, endTime);
            if (CommentViewer.this.activeTier != null) {
                comment.setTierName(CommentViewer.this.activeTier.getName());
            }
            int where = CommentViewer.this.commentManager.undoableInsert(comment);
            CommentViewer.this.showTableRow(where);
        }
    }

    private class ButtonMenuAction
    extends MenuAction {
        public ButtonMenuAction(String name) {
            super(name);
            this.putValue("ShortDescription", ElanLocale.getString(name + "ToolTip"));
        }
    }

    private final class RedTextDocumentListener
    implements DocumentListener {
        private RedTextDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (CommentViewer.this.commentOfText == null || !CommentViewer.this.commentOfText.getMessage().equals(CommentViewer.this.text.getText())) {
                CommentViewer.this.text.setForeground(Color.RED);
            } else {
                CommentViewer.this.text.setForeground(Color.BLACK);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

