/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.dcr.ISOCATLanguageCodeMapping;
import mpi.eudico.client.annotator.linkedmedia.LinkedFileDescriptorUtil;
import mpi.eudico.client.annotator.linkedmedia.LinkedFilesDialog;
import mpi.eudico.client.annotator.md.DefaultMDViewerComponent;
import mpi.eudico.client.annotator.md.MDConfigurationDialog;
import mpi.eudico.client.annotator.md.spi.MDContentLanguageUser;
import mpi.eudico.client.annotator.md.spi.MDServiceProvider;
import mpi.eudico.client.annotator.md.spi.MDServiceRegistry;
import mpi.eudico.client.annotator.md.spi.MDViewerComponent;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.viewer.Viewer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.LanguageCollection;

public class MetadataViewer
extends JPanel
implements PreferencesUser,
ElanLocaleListener,
Viewer,
ActionListener {
    private ViewerManager2 viewerManager;
    private String metadataPath;
    private MDServiceProvider mdProvider;
    private MDViewerComponent viewerPanel;
    private JButton selectMDButton;
    private JButton configureMDButton;
    private JLabel mdPathLabel;
    private JPanel viewerContainer;
    public final String MD_SOURCE = "MetadataSource";
    public final String MD_KEYS = "MetadataKeys";
    private String prefContentLanguage;
    private boolean preferenceIsOutdated;

    public MetadataViewer(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
        this.preferenceIsOutdated = false;
        this.initComponents();
        this.linkedFilesChanged();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.selectMDButton = new JButton();
        this.mdPathLabel = new JLabel();
        this.mdPathLabel.setFont(this.mdPathLabel.getFont().deriveFont(10.0f));
        this.configureMDButton = new JButton();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)this.selectMDButton, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.mdPathLabel, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        this.add((Component)this.configureMDButton, gbc);
        this.updateLocale();
        this.selectMDButton.addActionListener(this);
        this.configureMDButton.addActionListener(this);
        this.configureMDButton.setEnabled(false);
        this.mdPathLabel.setText(ElanLocale.getString("MetadataViewer.NoMetadataSource"));
        this.viewerContainer = new JPanel(new GridBagLayout());
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.viewerContainer, gbc);
    }

    private void popupLinkedFilesDialog() {
        LinkedFilesDialog dialog = new LinkedFilesDialog(this.viewerManager.getTranscription());
        dialog.selectSecLinkedFilesPanel();
        dialog.setVisible(true);
    }

    private void removeMDSource() {
        if (this.metadataPath == null) {
            return;
        }
        this.metadataPath = null;
        this.setPreference("MetadataSource", this.metadataPath, this.viewerManager.getTranscription());
        if (this.viewerPanel != null) {
            this.viewerContainer.remove((Component)((Object)this.viewerPanel));
            this.viewerContainer.repaint();
            this.viewerContainer.revalidate();
            this.viewerPanel = null;
        }
        this.mdProvider = null;
        this.mdPathLabel.setText(ElanLocale.getString("MetadataViewer.NoMetadataSource"));
        this.configureMDButton.setEnabled(false);
    }

    private void configureMD() {
        if (this.mdProvider == null) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("MetadataViewer.NoMetadataSource"), ElanLocale.getString("Message.Error"), 0);
        }
        MDConfigurationDialog dialog = new MDConfigurationDialog((Frame)ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()), this.mdProvider.getConfigurationPanel());
        dialog.setVisible(true);
        List<String> selKeys = this.mdProvider.getSelectedKeys();
        if (selKeys == null || selKeys.size() == 0) {
            return;
        }
        this.setPreference("MetadataKeys", selKeys, this.viewerManager.getTranscription());
        Map<String, String> allSelKeysVals = this.mdProvider.getSelectedKeysAndValues();
        if (allSelKeysVals != null && this.viewerPanel != null) {
            this.viewerPanel.setSelectedKeysAndValues(allSelKeysVals);
        }
    }

    private void updateProviderLanguage() {
        if (this.mdProvider instanceof MDContentLanguageUser) {
            String lang3L = null;
            String lang2L = null;
            if (this.prefContentLanguage != null) {
                if (this.prefContentLanguage.length() == 2) {
                    lang2L = this.prefContentLanguage;
                } else {
                    LangInfo info = LanguageCollection.getLanguageInfo(this.prefContentLanguage);
                    if (info != null) {
                        lang3L = info.getId();
                    }
                    if (lang3L != null) {
                        lang2L = ISOCATLanguageCodeMapping.get2LetterLanguageCode(lang3L);
                    }
                }
            }
            ((MDContentLanguageUser)((Object)this.mdProvider)).setContentLanguage(this.prefContentLanguage, lang3L, lang2L);
        }
    }

    @Override
    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    private void prependLinkedMetaDataPath(String path, Transcription document) {
        LinkedFileDescriptor lfd = LinkedFileDescriptorUtil.createLFDescriptor(path);
        List<LinkedFileDescriptor> lfds = document.getLinkedFileDescriptors();
        lfds.add(0, lfd);
        document.setChanged();
    }

    private String getFirstLinkedMetaDataPath(Transcription document) {
        String path;
        List<LinkedFileDescriptor> lfds = document.getLinkedFileDescriptors();
        for (LinkedFileDescriptor lfd : lfds) {
            if (!"application/x-cmdi+xml".equals(lfd.mimeType) && !"application/x-imdi+xml".equals(lfd.mimeType)) continue;
            this.preferenceIsOutdated = true;
            return lfd.linkURL;
        }
        if (!this.preferenceIsOutdated && (path = Preferences.getString("MetadataSource", document)) != null) {
            this.prependLinkedMetaDataPath(path, document);
            this.preferenceIsOutdated = true;
            return path;
        }
        return null;
    }

    public void removeFirstLinkedMetaDataPath(Transcription document) {
        List<LinkedFileDescriptor> lfds = document.getLinkedFileDescriptors();
        Iterator<LinkedFileDescriptor> iter = lfds.iterator();
        while (iter.hasNext()) {
            LinkedFileDescriptor lfd = iter.next();
            if (!"application/x-cmdi+xml".equals(lfd.mimeType) && !"application/x-imdi+xml".equals(lfd.mimeType)) continue;
            iter.remove();
            return;
        }
    }

    public void linkedFilesChanged() {
        String newFile = this.getFirstLinkedMetaDataPath(this.viewerManager.getTranscription());
        this.metadataFileChangedMaybe(newFile);
    }

    @Override
    public void preferencesChanged() {
        String lang = Preferences.getString("DefaultControlledVocabularyLanguage", null);
        if (lang != null) {
            if (this.prefContentLanguage == null || !this.prefContentLanguage.equals(lang)) {
                this.prefContentLanguage = lang;
                this.updateProviderLanguage();
            }
        } else if (this.prefContentLanguage != null) {
            this.updateProviderLanguage();
        }
    }

    private void metadataFileChangedMaybe(String newFile) {
        if (newFile == null) {
            this.removeMDSource();
            return;
        }
        if ((newFile = FileUtility.urlToAbsPath(newFile)).startsWith(".")) {
            newFile = newFile.replace("\\", "/");
            String eafPath = ((TranscriptionImpl)this.viewerManager.getTranscription()).getFullPath();
            eafPath = FileUtility.urlToAbsPath(eafPath);
            eafPath = eafPath.replace("\\", "/");
            ClientLogger.LOG.info(eafPath);
            ClientLogger.LOG.info(this.metadataPath);
            newFile = FileUtility.getAbsolutePath(eafPath, newFile);
        }
        if (newFile.equals(this.metadataPath)) {
            return;
        }
        this.metadataPath = newFile;
        if (this.mdProvider == null || !this.metadataPath.equals(this.mdProvider.getMetadataFile())) {
            this.mdProvider = MDServiceRegistry.getInstance().getProviderForMDFile(this.metadataPath);
            if (this.mdProvider == null) {
                this.configureMDButton.setEnabled(false);
                return;
            }
            MDViewerComponent oldPanel = this.viewerPanel;
            this.configureMDButton.setEnabled(this.mdProvider.isConfigurable());
            this.mdPathLabel.setText(this.metadataPath);
            this.viewerPanel = this.mdProvider.getMDViewerComponent();
            if (this.viewerPanel == null) {
                this.viewerPanel = new DefaultMDViewerComponent(this.mdProvider);
            }
            if (oldPanel instanceof Component) {
                this.viewerContainer.remove((Component)((Object)oldPanel));
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.viewerContainer.add((Component)((Object)this.viewerPanel), gbc);
        }
        List<String> pref = null;
        if ("IMDI".equals(this.mdProvider.getMDFormatDescription())) {
            pref = Preferences.getListOfString("Metadata.IMDI.Defaults", null);
        }
        if (pref == null) {
            pref = Preferences.getListOfString("MetadataKeys", this.viewerManager.getTranscription());
        }
        if (pref != null) {
            this.mdProvider.setSelectedKeys(new ArrayList<String>(pref));
            Map<String, String> allSelKeysVals = this.mdProvider.getSelectedKeysAndValues();
            if (allSelKeysVals != null && this.viewerPanel != null) {
                this.viewerPanel.setSelectedKeysAndValues(allSelKeysVals);
            }
        }
        this.updateProviderLanguage();
    }

    @Override
    public void updateLocale() {
        this.selectMDButton.setText(ElanLocale.getString("MetadataViewer.SelectSource"));
        this.configureMDButton.setText(ElanLocale.getString("MetadataViewer.Configure"));
        if (this.viewerPanel != null) {
            this.viewerPanel.setResourceBundle(ElanLocale.getResourceBundle());
        }
    }

    @Override
    public ViewerManager2 getViewerManager() {
        return this.viewerManager;
    }

    @Override
    public void setViewerManager(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectMDButton) {
            this.popupLinkedFilesDialog();
        } else if (e.getSource() == this.configureMDButton) {
            this.configureMD();
        }
    }
}

