/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.TierOrder;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.TierDependenciesCA;
import mpi.eudico.client.annotator.gui.AdvancedAttributeSettingOptionDialog;
import mpi.eudico.client.annotator.gui.MenuScroller;
import mpi.eudico.client.annotator.gui.ShowHideMoreTiersDlg;
import mpi.eudico.client.annotator.tiersets.TierSet;
import mpi.eudico.client.annotator.tiersets.TierSetListener;
import mpi.eudico.client.annotator.tiersets.TierSetUtil;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.util.TierMenuStringFormatter;
import mpi.eudico.client.annotator.viewer.InterlinearViewer;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.annotator.viewer.TimeLineViewer;
import mpi.eudico.client.util.TierSorter;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MultiTierControlPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ActionListener,
ComponentListener,
ElanLocaleListener,
PreferencesUser,
TierSetListener {
    public static final int MIN_WIDTH = 120;
    public static final int MARGIN = 5;
    public static final int LEVEL_INDENT = 10;
    public static final int MARKER_SIZE = 6;
    private static final int UNSORTED = 0;
    private static final int SORT_BY_HIERARCHY = 1;
    private static final int SORT_BY_PARTICIPANT = 2;
    private static final int SORT_BY_LINGUISTIC_TYPE = 3;
    private static final int SORT_BY_ANNOTATOR = 4;
    private static final int SORT_BY_LANGUAGE = 5;
    private static final int SORT_BY_NAME = 6;
    private final String NOT_SPECIFIED = "\uffff";
    private final String TIER_AC = "@&@";
    private final String TIERSET_AC = "@TS@";
    private JPopupMenu popup;
    private JMenu viewerMenu;
    private JMenu visTiersMenu;
    private JMenuItem showHideMoreMI;
    private JMenu sortTiersMenu;
    private JCheckBoxMenuItem workWithTiersetsMI;
    private JMenu tiersetMenu;
    private JMenuItem hideAllMI;
    private JMenuItem showAllMI;
    private JMenuItem collapseAllMI;
    private JMenuItem expandAllMI;
    private JMenuItem hideMI;
    private JMenuItem changeMI;
    private JMenuItem applyMI;
    private JMenuItem deleteMI;
    private JMenuItem activateMI;
    private JMenuItem colOrExpMI;
    private JMenuItem showHierMI;
    private JCheckBoxMenuItem numAnnosMI;
    private JRadioButtonMenuItem timelineMI;
    private JRadioButtonMenuItem interlinearMI;
    private JRadioButtonMenuItem sortByHierarchMI;
    private JRadioButtonMenuItem sortByTypeMI;
    private JRadioButtonMenuItem sortByPartMI;
    private JRadioButtonMenuItem sortByAnnotMI;
    private JRadioButtonMenuItem sortByLanguageMI;
    private JRadioButtonMenuItem sortByNameMI;
    private JRadioButtonMenuItem unsortedMI;
    private JCheckBoxMenuItem sortAlphabeticallyMI;
    private Dimension dimension;
    private TranscriptionImpl transcription;
    private List<TierImpl> tiers;
    private List<TierImpl> sortedTiers;
    private List<TierImpl> visibleTiers;
    private List<TierImpl> displayableTiers;
    private List<TierTreeNode> displayableTierNodes;
    private Map<String, TierTreeNode> tierTreeNodeMap;
    private Map<TierImpl, String> tierNames;
    private DefaultMutableTreeNode sortedRootNode;
    private TierOrder tierOrder;
    private int oldSortMode;
    private int sortMode;
    private BufferedImage bi;
    private Graphics2D big2d;
    private FontMetrics fontMetrics;
    private Font boldFont;
    private FontMetrics boldMetrics;
    private Font smallFont;
    private FontMetrics smallMetrics;
    private boolean dragging;
    private int dragX;
    private int dragY;
    private int dragIndex;
    private String dragLabel;
    private MultiTierViewer viewer;
    private List<MultiTierViewer> viewers;
    private int[] tierPositions;
    private Tier activeTier;
    private TierImpl rightClickTier;
    private int[] colorValues;
    private Map<TierImpl, Color> prefTierColors;
    private int tierHeight;
    private Map<String, String> numAnnosPerTier;
    private JComponent resizer = null;
    private final Color demarcColor = new Color(200, 200, 200);
    private boolean showNumberOfAnnotations = true;
    private boolean reducedTierHeight = false;
    private boolean disableInterlinearMI = false;
    private boolean sortAlphabetically = false;
    private boolean hideAllTiers = false;
    private boolean preferenceChanged = false;
    private boolean sortingChanged = false;
    private boolean useBufferedImage = false;
    private TierSetUtil tierSetUtil;
    private boolean workWithTierSet = false;

    public MultiTierControlPanel(TranscriptionImpl transcription, TierOrder tierOrder) {
        this.setLayout(null);
        this.dimension = new Dimension();
        this.visibleTiers = new ArrayList<TierImpl>();
        this.displayableTiers = new ArrayList<TierImpl>();
        this.sortedTiers = new ArrayList<TierImpl>();
        this.displayableTierNodes = new ArrayList<TierTreeNode>();
        this.viewers = new ArrayList<MultiTierViewer>();
        this.tierOrder = tierOrder;
        this.setFont(Constants.DEFAULTFONT);
        this.oldSortMode = this.sortMode = 0;
        this.colorValues = new int[]{0, 90, 160};
        this.useBufferedImage = SystemReporting.useBufferedPainting;
        this.setTranscription(transcription);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.tierHeight = 3 * f.getSize();
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.boldFont = this.getFont().deriveFont(1);
        this.boldMetrics = this.getFontMetrics(this.boldFont);
        this.smallFont = Constants.DEFAULT_LF_LABEL_FONT != null ? Constants.DEFAULT_LF_LABEL_FONT.deriveFont(4.0f * f.getSize2D() / 6.0f) : Constants.DEFAULTFONT.deriveFont(Math.max((float)(4 * f.getSize()) / 6.0f, Constants.SMALLFONT_SIZE));
        this.smallMetrics = this.getFontMetrics(this.smallFont);
    }

    public void setResizeComponent(JComponent comp) {
        if (this.resizer != null) {
            this.remove(this.resizer);
        }
        this.resizer = comp;
        if (this.resizer != null) {
            this.add(this.resizer);
            this.resizer.setBounds(this.getWidth() - this.resizer.getWidth(), 1, this.resizer.getWidth(), this.resizer.getHeight());
        }
        this.repaint();
    }

    public void disableShowInterlinearViewer(boolean val) {
        this.disableInterlinearMI = val;
        if (val) {
            if (this.interlinearMI != null) {
                this.interlinearMI.setEnabled(false);
            }
            if (this.timelineMI != null) {
                this.timelineMI.setSelected(true);
            }
        } else if (this.interlinearMI != null) {
            this.interlinearMI.setEnabled(true);
        }
    }

    public void setViewer(MultiTierViewer viewer) {
        this.viewer = viewer;
        viewer.setMultiTierControlPanel(this);
        if (viewer instanceof TimeLineViewer) {
            if (this.timelineMI != null) {
                this.timelineMI.setSelected(true);
            }
        } else if (viewer instanceof InterlinearViewer && this.interlinearMI != null) {
            this.interlinearMI.setSelected(true);
        }
        if (this.displayableTiers != null) {
            this.setVisibleTiers(this.displayableTiers);
        }
        if (this.activeTier != null) {
            this.setActiveTier(this.activeTier);
        }
    }

    public void addViewer(MultiTierViewer viewer) {
        this.viewers.add(viewer);
        viewer.setMultiTierControlPanel(this);
        if (this.displayableTiers != null) {
            this.setVisibleTiers(this.displayableTiers);
        }
        if (this.activeTier != null) {
            this.setActiveTier(this.activeTier);
        }
    }

    public void removeViewer(MultiTierViewer viewer) {
        viewer.setMultiTierControlPanel(null);
        this.viewers.remove(viewer);
    }

    @Override
    public void updateLocale() {
        if (this.popup == null) {
            return;
        }
        this.hideAllMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.HideAllTiers"));
        this.showAllMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ShowAllTiers"));
        this.showHideMoreMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ShowHideMore"));
        this.viewerMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.Viewer"));
        this.visTiersMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.VisibleTiers"));
        this.workWithTiersetsMI.setText(ElanLocale.getString("PreferencesDialog.Edit.TierSet"));
        this.tiersetMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.TierSet"));
        this.sortTiersMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortTiers"));
        this.expandAllMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ExpandAll"));
        this.collapseAllMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.CollapseAll"));
        this.unsortedMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.Unsorted"));
        this.sortByHierarchMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortByHierarchy"));
        this.sortByTypeMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortByType"));
        this.sortByPartMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortByParticipant"));
        this.sortByAnnotMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortByAnnotator"));
        this.sortByLanguageMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortByLanguage"));
        this.sortByNameMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortByName"));
        this.sortAlphabeticallyMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortAlpabetically"));
        this.hideMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Hide"));
        this.changeMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Change"));
        this.applyMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Apply"));
        this.deleteMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Delete"));
        this.activateMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Activate"));
        this.colOrExpMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.CollapseExpand"));
        this.showHierMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.ShowInHierarchy"));
        this.numAnnosMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.NumberAnnotations"));
    }

    private void setTranscription(TranscriptionImpl transcription) {
        this.transcription = transcription;
        this.tierSetUtil = TierSetUtil.getTierSetUtilInstance();
        this.tierSetUtil.addTierSetListener(transcription, this);
        try {
            this.tiers = transcription.getTiers();
            this.tierNames = new HashMap<TierImpl, String>();
            this.prefTierColors = new HashMap<TierImpl, Color>();
            this.numAnnosPerTier = new HashMap<String, String>();
            this.popup = new JPopupMenu("");
            this.viewerMenu = new JMenu();
            this.popup.add(this.viewerMenu);
            this.popup.addSeparator();
            this.visTiersMenu = new JMenu();
            MenuScroller scroller = MenuScroller.setScrollerFor(this.visTiersMenu);
            scroller.setTopFixedCount(2);
            this.hideAllMI = new JMenuItem("");
            this.hideAllMI.setActionCommand("hideAll");
            this.hideAllMI.addActionListener(this);
            this.visTiersMenu.add(this.hideAllMI);
            this.showAllMI = new JMenuItem("");
            this.showAllMI.setActionCommand("showAll");
            this.showAllMI.addActionListener(this);
            this.visTiersMenu.add(this.showAllMI);
            for (int i = 0; i < this.tiers.size(); ++i) {
                TierImpl tier = this.tiers.get(i);
                String tierName = tier.getName();
                this.tierNames.put(tier, tierName);
                if (tier.getParentTier() == null) {
                    this.addToRootColors(tier);
                }
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(tierName);
                menuItem.setSelected(true);
                menuItem.setActionCommand("@&@" + tierName);
                menuItem.addActionListener(this);
                this.visTiersMenu.add(menuItem);
                this.visibleTiers.add(tier);
            }
            this.popup.add(this.visTiersMenu);
            this.showHideMoreMI = new JMenuItem();
            this.showHideMoreMI.setActionCommand("showHideMore");
            this.showHideMoreMI.addActionListener(this);
            this.popup.add(this.showHideMoreMI);
            this.workWithTiersetsMI = new JCheckBoxMenuItem();
            this.workWithTiersetsMI.setActionCommand("workWithTiersets");
            this.workWithTiersetsMI.addActionListener(this);
            this.tiersetMenu = new JMenu();
            this.popup.add(this.tiersetMenu);
            this.updateTierSetMenu();
            this.sortedTiers.clear();
            this.sortedTiers.addAll(this.visibleTiers);
            this.displayableTiers.clear();
            this.displayableTiers.addAll(this.visibleTiers);
            this.sortTiersMenu = new JMenu();
            ButtonGroup sortGroup = new ButtonGroup();
            this.unsortedMI = new JRadioButtonMenuItem();
            this.unsortedMI.setActionCommand("unsorted");
            this.unsortedMI.addActionListener(this);
            sortGroup.add(this.unsortedMI);
            this.sortTiersMenu.add(this.unsortedMI);
            this.sortByHierarchMI = new JRadioButtonMenuItem();
            this.sortByHierarchMI.setActionCommand("sortHier");
            this.sortByHierarchMI.addActionListener(this);
            sortGroup.add(this.sortByHierarchMI);
            this.sortTiersMenu.add(this.sortByHierarchMI);
            this.sortByNameMI = new JRadioButtonMenuItem();
            this.sortByNameMI.setActionCommand("sortName");
            this.sortByNameMI.addActionListener(this);
            sortGroup.add(this.sortByNameMI);
            this.sortTiersMenu.add(this.sortByNameMI);
            this.sortByTypeMI = new JRadioButtonMenuItem();
            this.sortByTypeMI.setActionCommand("sortType");
            this.sortByTypeMI.addActionListener(this);
            sortGroup.add(this.sortByTypeMI);
            this.sortTiersMenu.add(this.sortByTypeMI);
            this.sortByPartMI = new JRadioButtonMenuItem();
            this.sortByPartMI.setActionCommand("sortPart");
            this.sortByPartMI.addActionListener(this);
            sortGroup.add(this.sortByPartMI);
            this.sortTiersMenu.add(this.sortByPartMI);
            this.sortByAnnotMI = new JRadioButtonMenuItem();
            this.sortByAnnotMI.setActionCommand("sortAnn");
            this.sortByAnnotMI.addActionListener(this);
            sortGroup.add(this.sortByAnnotMI);
            this.sortTiersMenu.add(this.sortByAnnotMI);
            this.sortByLanguageMI = new JRadioButtonMenuItem();
            this.sortByLanguageMI.setActionCommand("sortLang");
            this.sortByLanguageMI.addActionListener(this);
            sortGroup.add(this.sortByLanguageMI);
            this.sortTiersMenu.add(this.sortByLanguageMI);
            this.sortTiersMenu.addSeparator();
            this.sortAlphabeticallyMI = new JCheckBoxMenuItem();
            this.sortAlphabeticallyMI.addActionListener(this);
            this.sortTiersMenu.add(this.sortAlphabeticallyMI);
            switch (this.sortMode) {
                case 0: {
                    this.unsortedMI.setSelected(true);
                    break;
                }
                case 1: {
                    this.sortByHierarchMI.setSelected(true);
                    break;
                }
                case 2: {
                    this.sortByPartMI.setSelected(true);
                    break;
                }
                case 3: {
                    this.sortByTypeMI.setSelected(true);
                    break;
                }
                case 5: {
                    this.sortByLanguageMI.setSelected(true);
                    break;
                }
                case 6: {
                    this.sortByNameMI.setSelected(true);
                }
            }
            this.popup.add(this.sortTiersMenu);
            this.expandAllMI = new JMenuItem();
            this.expandAllMI.setActionCommand("expandAll");
            this.expandAllMI.addActionListener(this);
            this.popup.add(this.expandAllMI);
            this.collapseAllMI = new JMenuItem();
            this.collapseAllMI.setActionCommand("collapseAll");
            this.collapseAllMI.addActionListener(this);
            this.popup.add(this.collapseAllMI);
            this.popup.addSeparator();
            this.hideMI = new JMenuItem();
            this.hideMI.setActionCommand("hideThis");
            this.hideMI.addActionListener(this);
            this.hideMI.setEnabled(false);
            this.popup.add(this.hideMI);
            this.changeMI = new JMenuItem();
            this.changeMI.setActionCommand("changeThis");
            this.changeMI.addActionListener(this);
            this.changeMI.setEnabled(false);
            this.popup.add(this.changeMI);
            this.applyMI = new JMenuItem();
            this.applyMI.setActionCommand("applyThis");
            this.applyMI.addActionListener(this);
            this.applyMI.setEnabled(false);
            this.popup.add(this.applyMI);
            this.deleteMI = new JMenuItem();
            this.deleteMI.setActionCommand("deleteThis");
            this.deleteMI.addActionListener(this);
            this.deleteMI.setEnabled(false);
            this.popup.add(this.deleteMI);
            this.activateMI = new JCheckBoxMenuItem();
            this.activateMI.setActionCommand("activateThis");
            this.activateMI.addActionListener(this);
            this.activateMI.setEnabled(false);
            this.popup.add(this.activateMI);
            this.colOrExpMI = new JMenuItem();
            this.colOrExpMI.setActionCommand("toggleExpandThis");
            this.colOrExpMI.addActionListener(this);
            this.colOrExpMI.setEnabled(false);
            this.popup.add(this.colOrExpMI);
            this.showHierMI = new JMenuItem();
            this.showHierMI.setActionCommand("showThis");
            this.showHierMI.addActionListener(this);
            this.showHierMI.setEnabled(false);
            this.popup.add(this.showHierMI);
            this.popup.addSeparator();
            this.numAnnosMI = new JCheckBoxMenuItem();
            this.numAnnosMI.setActionCommand("numAnnos");
            this.numAnnosMI.addActionListener(this);
            this.numAnnosMI.setSelected(true);
            this.popup.add(this.numAnnosMI);
            this.updateLocale();
            this.createSortedTree(false);
            if (this.visibleTiers.size() > 0 && Preferences.get("MultiTierViewer.ActiveTierName", transcription) == null) {
                this.setActiveTier(this.visibleTiers.get(0));
            }
            this.annotationsChanged();
            this.paintBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateTierSetMenu() {
        if (this.tiersetMenu.getMenuComponents().length > 0) {
            this.tiersetMenu.removeAll();
        }
        this.tiersetMenu.add(this.workWithTiersetsMI);
        this.tiersetMenu.add(new JSeparator());
        this.tierSetUtil = TierSetUtil.getTierSetUtilInstance();
        List<String> tierSetList = this.tierSetUtil.getTierSetList();
        if (ClientLogger.LOG.isLoggable(Level.FINE)) {
            ClientLogger.LOG.fine("updateTierSetMenu " + tierSetList.size());
        }
        for (int i = 0; i < tierSetList.size(); ++i) {
            TierSet tierSet = this.tierSetUtil.getTierSet(tierSetList.get(i));
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(tierSet.getName(), tierSet.isVisible());
            if (this.workWithTierSet) {
                int n = 0;
                for (String tierName : tierSet.getTierList()) {
                    if (this.transcription.getTierWithId(tierName) == null) continue;
                    ++n;
                }
                if (n == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setEnabled(false);
            }
            menuItem.setActionCommand("@TS@" + tierSet.getName());
            menuItem.addActionListener(this);
            this.tiersetMenu.add(menuItem);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createSortedTree(boolean storeTierOrder) {
        if (this.sortAlphabetically) {
            Collections.sort(this.visibleTiers, new TierComparer());
        }
        ArrayList<TierImpl> tierList = new ArrayList<TierImpl>(this.sortedTiers);
        if (this.workWithTierSet) {
            ArrayList<TierImpl> newTierList = new ArrayList<TierImpl>();
            ArrayList<String> tiersInVisibleTierSets = new ArrayList<String>(this.tierSetUtil.getTiersInVisibleTierSets());
            for (String string : tiersInVisibleTierSets) {
                TierImpl tierImpl = this.transcription.getTierWithId(string);
                if (tierImpl == null || !tierList.contains(tierImpl)) continue;
                newTierList.add(tierImpl);
            }
            List<TierImpl> tiersInTranscription = this.transcription.getTiers();
            for (TierImpl tier : tiersInTranscription) {
                if (newTierList.contains(tier)) continue;
                newTierList.add(tier);
            }
            tierList = newTierList;
        }
        this.sortedRootNode = new DefaultMutableTreeNode("sortRoot");
        this.tierTreeNodeMap = new HashMap<String, TierTreeNode>();
        switch (this.sortMode) {
            case 1: {
                TierImpl tier;
                int i;
                HashMap<TierImpl, TierTreeNode> nodes = new HashMap<TierImpl, TierTreeNode>();
                for (i = 0; i < tierList.size(); ++i) {
                    tier = tierList.get(i);
                    TierTreeNode tierTreeNode = new TierTreeNode(tier);
                    if (this.activeTier != null && this.activeTier == tier) {
                        tierTreeNode.setActive(true);
                    }
                    if (!this.visibleTiers.contains(tier)) {
                        tierTreeNode.setVisible(false);
                    }
                    this.tierTreeNodeMap.put(tier.getName(), tierTreeNode);
                    nodes.put(tier, tierTreeNode);
                }
                for (i = 0; i < tierList.size(); ++i) {
                    tier = tierList.get(i);
                    if (tier.getParentTier() == null) {
                        this.sortedRootNode.add((MutableTreeNode)nodes.get(tier));
                        continue;
                    }
                    ((TierTreeNode)nodes.get(tier.getParentTier())).add((MutableTreeNode)nodes.get(tier));
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                void var6_12;
                TierImpl.ValueGetter getter = MultiTierControlPanel.getValueGetter(this.sortMode);
                HashMap keyMap = new HashMap();
                boolean bl = false;
                while (var6_12 < tierList.size()) {
                    String key;
                    TierImpl tier1 = tierList.get((int)var6_12);
                    TierTreeNode n1 = new TierTreeNode(tier1);
                    if (this.activeTier != null && this.activeTier == tier1) {
                        n1.setActive(true);
                    }
                    if (!this.visibleTiers.contains(tier1)) {
                        n1.setVisible(false);
                    }
                    if ((key = getter.getSortValue(tier1)).isEmpty()) {
                        key = "\uffff";
                    }
                    if (keyMap.get(key) == null) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(n1);
                        keyMap.put(key, list);
                    } else {
                        ((List)keyMap.get(key)).add(n1);
                    }
                    this.tierTreeNodeMap.put(tier1.getName(), n1);
                    ++var6_12;
                }
                if (keyMap.size() <= 0) break;
                Set set = keyMap.keySet();
                ArrayList names = new ArrayList(set);
                Collections.sort(names);
                for (String name : names) {
                    List pList = (List)keyMap.get(name);
                    for (TierTreeNode ttn : pList) {
                        this.sortedRootNode.add(ttn);
                    }
                }
                break;
            }
            default: {
                void var6_15;
                boolean bl = false;
                while (var6_15 < tierList.size()) {
                    TierImpl tier;
                    tier = tierList.get((int)var6_15);
                    TierTreeNode n = new TierTreeNode(tier);
                    if (this.activeTier != null && this.activeTier == tier) {
                        n.setActive(true);
                    }
                    if (!this.visibleTiers.contains(tier)) {
                        n.setVisible(false);
                    }
                    this.tierTreeNodeMap.put(tier.getName(), n);
                    this.sortedRootNode.add(n);
                    ++var6_15;
                }
                break block0;
            }
        }
        if (storeTierOrder) {
            this.storeTierOrder();
        }
        this.updateDisplayableTiers();
    }

    public static TierImpl.ValueGetter getValueGetter(int sortmode) {
        switch (sortmode) {
            case 4: {
                return new TierImpl.AnnotatorGetter();
            }
            case 2: {
                return new TierImpl.ParticipantGetter();
            }
            case 3: {
                return new TierImpl.LinguisticTypeNameGetter();
            }
            case 5: {
                return new TierImpl.LanguageGetter();
            }
            case 6: {
                return new TierImpl.NameGetter();
            }
        }
        return null;
    }

    private void updateDisplayableTiers() {
        ArrayList<TierImpl> dispTiers;
        block10: {
            dispTiers = new ArrayList<TierImpl>();
            this.displayableTierNodes.clear();
            this.displayableTiers.clear();
            if (this.sortMode == 1 && this.sortedRootNode.getChildCount() > 0) {
                int level = -1;
                TierTreeNode curNode = (TierTreeNode)this.sortedRootNode.getFirstChild();
                DefaultMutableTreeNode parent = null;
                block0: while (level != 0) {
                    if (curNode.isVisible()) {
                        this.displayableTierNodes.add(curNode);
                        dispTiers.add(curNode.getTier());
                        if (curNode.getChildCount() > 0 && curNode.isExpanded()) {
                            curNode = (TierTreeNode)curNode.getFirstChild();
                            level = curNode.getLevel();
                            continue;
                        }
                        parent = (DefaultMutableTreeNode)curNode.getParent();
                    } else {
                        parent = (DefaultMutableTreeNode)curNode.getParent();
                    }
                    while (true) {
                        if (parent.getChildAfter(curNode) != null) {
                            curNode = (TierTreeNode)parent.getChildAfter(curNode);
                            continue block0;
                        }
                        if (parent != this.sortedRootNode) {
                            curNode = (TierTreeNode)parent;
                            level = curNode.getLevel();
                            parent = (DefaultMutableTreeNode)curNode.getParent();
                            continue;
                        }
                        break block10;
                        break;
                    }
                }
            } else {
                Enumeration<TreeNode> nodeEnum = this.sortedRootNode.children();
                TierTreeNode cn = null;
                while (nodeEnum.hasMoreElements()) {
                    cn = (TierTreeNode)nodeEnum.nextElement();
                    if (!cn.isVisible()) continue;
                    this.displayableTierNodes.add(cn);
                    dispTiers.add(cn.getTier());
                }
            }
        }
        this.displayableTiers.addAll(dispTiers);
        this.updateVisibleTiersMenu(dispTiers);
        this.setVisibleTiers(dispTiers);
    }

    private void updatePopup(TierImpl tier) {
        if (this.timelineMI == null) {
            ButtonGroup multitierViewerGroup = new ButtonGroup();
            this.timelineMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.View.ShowTimeline"));
            this.interlinearMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.View.ShowInterlinear"));
            this.timelineMI.setSelected(true);
            multitierViewerGroup.add(this.timelineMI);
            multitierViewerGroup.add(this.interlinearMI);
            this.viewerMenu.add(this.timelineMI);
            this.viewerMenu.add(this.interlinearMI);
            if (this.viewer instanceof TimeLineViewer) {
                this.timelineMI.setSelected(true);
            } else if (this.viewer instanceof InterlinearViewer) {
                this.interlinearMI.setSelected(true);
            }
        }
        if (this.disableInterlinearMI) {
            this.interlinearMI.setEnabled(false);
            this.timelineMI.setSelected(this.disableInterlinearMI);
        }
        if (tier != null) {
            String name = tier.getName();
            if (name != null && name.length() > 0) {
                this.hideMI.setText("<html>" + ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Hide") + " <i>" + name + "</i></html>");
                this.changeMI.setText("<html>" + ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Change") + " <i>" + name + "</i></html>");
                this.applyMI.setText("<html>" + ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Apply") + " <i>" + name + "</i></html>");
                this.deleteMI.setText("<html>" + ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Delete") + " <i>" + name + "</i></html>");
                this.activateMI.setText("<html>" + ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Activate") + " <i>" + name + "</i></html>");
                this.activateMI.setSelected(this.activeTier != null && name.equals(this.activeTier.getName()));
                if (this.sortMode == 1) {
                    this.colOrExpMI.setText("<html>" + ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.CollapseExpand") + " <i>" + name + "</i></html>");
                    this.colOrExpMI.setEnabled(true);
                } else {
                    this.colOrExpMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.CollapseExpand"));
                    this.colOrExpMI.setEnabled(false);
                }
                this.hideMI.setEnabled(true);
                this.changeMI.setEnabled(true);
                this.applyMI.setEnabled(true);
                this.deleteMI.setEnabled(true);
                this.activateMI.setEnabled(true);
                this.showHierMI.setEnabled(true);
            }
        } else {
            this.hideMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Hide"));
            this.changeMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Change"));
            this.applyMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Apply"));
            this.deleteMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Delete"));
            this.activateMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Activate"));
            this.colOrExpMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.CollapseExpand"));
            this.hideMI.setEnabled(false);
            this.changeMI.setEnabled(false);
            this.applyMI.setEnabled(false);
            this.deleteMI.setEnabled(false);
            this.activateMI.setEnabled(false);
            this.colOrExpMI.setEnabled(false);
            this.showHierMI.setEnabled(false);
        }
        if (this.sortMode == 1) {
            this.expandAllMI.setEnabled(true);
            this.collapseAllMI.setEnabled(true);
        } else {
            this.expandAllMI.setEnabled(false);
            this.collapseAllMI.setEnabled(false);
        }
        this.updateTierSetMenu();
    }

    public void setTierPositions(int[] tierPositions) {
        this.tierPositions = tierPositions;
        if (tierPositions.length > 1) {
            this.tierHeight = tierPositions[1] - tierPositions[0];
            if (this.tierHeight > 0) {
                this.reducedTierHeight = this.tierHeight / 2 < this.getFont().getSize() / 2 + this.smallFont.getSize();
            }
        }
        this.paintBuffer();
    }

    private void updateAnnotationCounts() {
        if (this.transcription != null) {
            TierMenuStringFormatter.InitializeWithTierList(this.transcription.getTiers());
            for (int i = 0; i < this.visTiersMenu.getMenuComponentCount(); ++i) {
                Component c = this.visTiersMenu.getMenuComponent(i);
                if (!(c instanceof JCheckBoxMenuItem)) continue;
                String regExp = ".*\\[\\d*\\]";
                JCheckBoxMenuItem mi = (JCheckBoxMenuItem)c;
                String tierName = mi.getText().trim();
                if (Pattern.matches(regExp, tierName)) {
                    tierName = tierName.substring(0, tierName.lastIndexOf("[")).trim();
                } else if (tierName.startsWith("<html>")) {
                    int endIndex = tierName.indexOf("</td>");
                    int beginIndex = tierName.substring(0, endIndex).lastIndexOf(62);
                    tierName = tierName.substring(beginIndex + 1, endIndex);
                }
                TierImpl t = this.transcription.getTierWithId(tierName);
                if (t == null) continue;
                int size = t.getNumberOfAnnotations();
                mi.setText(TierMenuStringFormatter.GetFormattedString(tierName, "[" + size + "]"));
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
            if (e.isShiftDown()) {
                this.setActiveTier(null);
            } else {
                int index = this.getClosestTierIndexForMouseY(p.y);
                TierTreeNode node = this.displayableTierNodes.get(index);
                this.setActiveTier(node.getTier());
            }
        }
        this.paintBuffer();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            int y = e.getPoint().y;
            int tierIndex = this.getClosestTierIndexForMouseY(y);
            if (tierIndex < this.displayableTierNodes.size() && this.displayableTierNodes.size() > 0) {
                TierTreeNode node = this.displayableTierNodes.get(tierIndex);
                TierImpl tier = null;
                if (node != null) {
                    this.rightClickTier = tier = node.getTier();
                }
                this.updatePopup(tier);
            } else {
                this.rightClickTier = null;
                this.updatePopup(null);
            }
            this.popup.show(this, e.getPoint().x, y);
            return;
        }
        this.dragIndex = this.getClosestTierIndexForMouseY(e.getPoint().y);
        if (this.dragIndex == 0 && this.displayableTierNodes.size() == 0) {
            return;
        }
        this.dragLabel = this.tierNames.get(this.displayableTierNodes.get(this.dragIndex).getTier());
        this.dragging = true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragging) {
            this.dragX = e.getPoint().x - 40;
            this.dragY = e.getPoint().y;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragging) {
            if (this.displayableTierNodes.size() <= 1) {
                this.dragging = false;
                this.dragLabel = "";
                this.repaint();
                return;
            }
            int index = this.getInsertionIndexForMouseY(e.getPoint().y);
            if (index >= this.displayableTierNodes.size()) {
                index = this.displayableTierNodes.size() - 1;
            }
            if (index != this.dragIndex && index - 1 != this.dragIndex) {
                TierTreeNode node = this.displayableTierNodes.get(this.dragIndex);
                TierTreeNode insertBeforeNode = this.displayableTierNodes.get(index);
                TierTreeNode insertAfterNode = null;
                if (index - 1 >= 0) {
                    insertAfterNode = this.displayableTierNodes.get(index - 1);
                }
                if (index == this.displayableTierNodes.size() - 1) {
                    insertBeforeNode = null;
                    insertAfterNode = this.displayableTierNodes.get(index);
                }
                switch (this.sortMode) {
                    case 1: {
                        if (insertAfterNode != null && node.getParent() == insertAfterNode.getParent()) {
                            node.removeFromParent();
                            int afterIndex = insertAfterNode.getParent().getIndex(insertAfterNode);
                            ((DefaultMutableTreeNode)insertAfterNode.getParent()).insert(node, afterIndex + 1);
                            break;
                        }
                        if (insertBeforeNode != null && node.getParent() == insertBeforeNode.getParent()) {
                            int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                            ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert(node, beforeIndex);
                            break;
                        }
                        if (insertAfterNode == null || node.getParent() != insertAfterNode.getSharedAncestor(node)) break;
                        int curLevel = node.getLevel();
                        DefaultMutableTreeNode sameLevelNode = insertAfterNode;
                        while (sameLevelNode.getLevel() != curLevel) {
                            sameLevelNode = (DefaultMutableTreeNode)sameLevelNode.getParent();
                        }
                        node.removeFromParent();
                        int afterIndex = sameLevelNode.getParent().getIndex(sameLevelNode);
                        ((DefaultMutableTreeNode)sameLevelNode.getParent()).insert(node, afterIndex + 1);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        TierImpl.ValueGetter getter = MultiTierControlPanel.getValueGetter(this.sortMode);
                        if (insertAfterNode != null && insertBeforeNode != null) {
                            if (getter.getSortValue(insertAfterNode.getTier()).equals(getter.getSortValue(node.getTier()))) {
                                node.removeFromParent();
                                int afterIndex = insertAfterNode.getParent().getIndex(insertAfterNode);
                                ((DefaultMutableTreeNode)insertAfterNode.getParent()).insert(node, afterIndex + 1);
                                break;
                            }
                            if (getter.getSortValue(insertBeforeNode.getTier()).equals(getter.getSortValue(node.getTier()))) {
                                int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                                ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert(node, beforeIndex);
                                break;
                            }
                        }
                        if (insertAfterNode != null) {
                            if (getter.getSortValue(insertAfterNode.getTier()).equals(getter.getSortValue(node.getTier()))) {
                                node.removeFromParent();
                                int afterIndex = insertAfterNode.getParent().getIndex(insertAfterNode);
                                ((DefaultMutableTreeNode)insertAfterNode.getParent()).insert(node, afterIndex + 1);
                                break;
                            }
                            String afterKey = getter.getSortValue(insertAfterNode.getTier());
                            String dragKey = getter.getSortValue(node.getTier());
                            TierTreeNode lastNode = insertAfterNode;
                            while (lastNode.getNextNode() != null && getter.getSortValue(((TierTreeNode)lastNode.getNextNode()).getTier()).equals(afterKey)) {
                                lastNode = (TierTreeNode)lastNode.getNextNode();
                            }
                            ArrayList<TierTreeNode> moveGroup = new ArrayList<TierTreeNode>();
                            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
                            en.nextElement();
                            while (en.hasMoreElements()) {
                                TierTreeNode nn = (TierTreeNode)en.nextElement();
                                if (!getter.getSortValue(nn.getTier()).equals(dragKey)) continue;
                                moveGroup.add(nn);
                            }
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((TierTreeNode)moveGroup.get(i)).removeFromParent();
                            }
                            int afterIndex = lastNode.getParent().getIndex(lastNode);
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((DefaultMutableTreeNode)lastNode.getParent()).insert((MutableTreeNode)moveGroup.get(i), afterIndex + 1);
                            }
                        } else {
                            if (insertBeforeNode == null) break;
                            if (getter.getSortValue(insertBeforeNode.getTier()).equals(getter.getSortValue(node.getTier()))) {
                                int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                                ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert(node, beforeIndex);
                                break;
                            }
                            String dragPartName = getter.getSortValue(node.getTier());
                            ArrayList<TierTreeNode> moveGroup = new ArrayList<TierTreeNode>();
                            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
                            en.nextElement();
                            while (en.hasMoreElements()) {
                                TierTreeNode nn = (TierTreeNode)en.nextElement();
                                if (!getter.getSortValue(nn.getTier()).equals(dragPartName)) continue;
                                moveGroup.add(nn);
                            }
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((TierTreeNode)moveGroup.get(i)).removeFromParent();
                            }
                            int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert((MutableTreeNode)moveGroup.get(i), beforeIndex);
                            }
                        }
                        break;
                    }
                    case 0: {
                        if (insertAfterNode != null) {
                            node.removeFromParent();
                            int afterIndex = insertAfterNode.getParent().getIndex(insertAfterNode);
                            ((DefaultMutableTreeNode)insertAfterNode.getParent()).insert(node, afterIndex + 1);
                            break;
                        }
                        if (insertBeforeNode == null) break;
                        int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                        ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert(node, beforeIndex);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.updateDisplayableTiers();
            }
            if (this.sortAlphabetically) {
                this.setSorting(this.sortMode);
            }
            this.dragging = false;
            this.dragLabel = "";
            this.paintBuffer();
            this.storeTierOrder();
        }
    }

    private int getClosestTierIndexForMouseY(int y) {
        int index;
        if (this.tierPositions.length == 0 || this.displayableTierNodes.size() == 0) {
            return 0;
        }
        for (index = 0; index < this.displayableTierNodes.size() && y >= this.tierPositions[index]; ++index) {
        }
        if (index > 0 && --index == this.displayableTierNodes.size() && index != 0) {
            --index;
        }
        float d1 = Math.abs(y - this.tierPositions[index]);
        float d2 = Float.MAX_VALUE;
        if (index + 1 < this.displayableTierNodes.size()) {
            d2 = Math.abs(y - this.tierPositions[index + 1]);
        }
        if (d2 < d1) {
            ++index;
        }
        return index;
    }

    private int getInsertionIndexForMouseY(int y) {
        int index = 0;
        if (this.displayableTierNodes.size() > 0) {
            for (index = 0; index < this.displayableTierNodes.size() && y >= this.tierPositions[index]; ++index) {
            }
        }
        return index;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (e.getSource() == this.sortAlphabeticallyMI) {
            int sortMode = this.getSorting();
            this.sortAlphabetically = this.sortAlphabeticallyMI.isSelected();
            this.setPreference("MultiTierViewer.SortAlpabetically", this.sortAlphabetically, this.transcription);
            this.setSorting(sortMode);
        } else if (command.equals("hideAll")) {
            this.hideAllTiers();
        } else if (command.equals("showAll")) {
            this.showAllTiers();
        } else if (command.equals("showHideMore")) {
            ShowHideMoreTiersDlg dialog = new ShowHideMoreTiersDlg(this.transcription, this.visibleTiers, this);
            dialog.setVisible(true);
            if (dialog.isValueChanged()) {
                this.updateVisibleTiers(dialog.getVisibleTierNames());
            }
        } else if (command.equals("workWithTiersets")) {
            this.workWithTierSet = this.workWithTiersetsMI.isSelected();
            Preferences.set("WorkwithTierSets", this.workWithTierSet, null, true, true);
            this.paintBuffer();
        } else if (command.equals("unsorted")) {
            this.sortingChanged = true;
            this.setSorting(0);
        } else if (command.equals("sortHier")) {
            this.sortingChanged = true;
            this.setSorting(1);
        } else if (command.equals("sortPart")) {
            this.sortingChanged = true;
            this.setSorting(2);
        } else if (command.equals("sortType")) {
            this.sortingChanged = true;
            this.setSorting(3);
        } else if (command.equals("sortAnn")) {
            this.sortingChanged = true;
            this.setSorting(4);
        } else if (command.equals("sortLang")) {
            this.sortingChanged = true;
            this.setSorting(5);
        } else if (command.equals("sortName")) {
            this.sortingChanged = true;
            this.setSorting(6);
        } else if (command.equals("expandAll")) {
            this.expandAllNodes();
        } else if (command.equals("collapseAll")) {
            this.collapseAllNodes();
        } else if (command.equals("hideThis")) {
            this.hideTier(this.rightClickTier);
        } else if (command.equals("changeThis")) {
            this.changeTier(this.rightClickTier);
        } else if (command.equals("applyThis")) {
            this.applyTier(this.rightClickTier);
        } else if (command.equals("deleteThis")) {
            this.deleteTier(this.rightClickTier);
        } else if (command.equals("activateThis")) {
            this.activateTier(this.rightClickTier, this.activateMI.isSelected());
        } else if (command.equals("toggleExpandThis")) {
            this.toggleExpandedState(this.rightClickTier);
        } else if (command.equals("showThis")) {
            this.showInTierDependencyFrame(this.rightClickTier);
        } else if (command.equals("numAnnos")) {
            this.showNumberOfAnnotations = this.numAnnosMI.isSelected();
            this.setPreference("MultiTierViewer.ShowNumberOfAnnotations", this.showNumberOfAnnotations, this.transcription);
            this.paintBuffer();
        } else if (command.startsWith("@&@")) {
            String tierName = command.substring("@&@".length());
            boolean visible = ((JCheckBoxMenuItem)e.getSource()).isSelected();
            if (this.workWithTierSet) {
                this.updateVisibilityInTierSet(tierName, visible);
            }
            this.setTierVisible(tierName, visible);
            this.storeHiddenTiers();
        } else if (command.startsWith("@TS@")) {
            String tierSetName = command.substring("@TS@".length());
            boolean visible = ((JCheckBoxMenuItem)e.getSource()).isSelected();
            TierSet tierSet = this.tierSetUtil.getTierSet(tierSetName);
            tierSet.setVisible(visible);
            this.tierSetUtil.notifyAllListeners(tierSet);
        }
    }

    private void updateVisibilityInTierSet(String tierName, boolean isVisible) {
        List<String> tierSetList = this.tierSetUtil.getVisibleTierSets();
        for (String tierSetName : tierSetList) {
            TierSet tierSet = this.tierSetUtil.getTierSet(tierSetName);
            if (!tierSet.isVisible() || !tierSet.containsTier(tierName)) continue;
            tierSet.setTierVisiblity(tierName, isVisible);
        }
        this.tierSetUtil.removeTierSetListener(this.transcription, this);
        this.tierSetUtil.notifyAllListeners(tierName, isVisible);
        this.tierSetUtil.addTierSetListener(this.transcription, this);
    }

    private void showOrHideAllTiersInVisibleTierSet(boolean show) {
        List<String> tierSetList = this.tierSetUtil.getVisibleTierSets();
        for (String tierSetName : tierSetList) {
            TierSet tierSet = this.tierSetUtil.getTierSet(tierSetName);
            for (String tierName : tierSet.getTierList()) {
                if (this.transcription.getTierWithId(tierName) == null) continue;
                tierSet.setTierVisiblity(tierName, show);
            }
        }
        this.tierSetUtil.removeTierSetListener(this.transcription, this);
        this.tierSetUtil.notifyAllListeners();
        this.tierSetUtil.addTierSetListener(this.transcription, this);
    }

    private void setTierSetVisible(String tierSetName, boolean visible) {
        TierSet tierSet;
        ArrayList<String> visibleTiersInOtherTS = new ArrayList<String>();
        List<String> tierSetList = this.tierSetUtil.getVisibleTierSets();
        for (String tsName : tierSetList) {
            tierSet = this.tierSetUtil.getTierSet(tsName);
            if (tierSet.getName().equals(tierSetName)) continue;
            for (String tierName : tierSet.getVisibleTierList()) {
                if (visibleTiersInOtherTS.contains(tierName)) continue;
                visibleTiersInOtherTS.add(tierName);
            }
        }
        tierSet = this.tierSetUtil.getTierSet(tierSetName);
        List<String> tierList = tierSet.getTierList();
        List<String> visibleTierList = tierSet.getVisibleTierList();
        if (this.sortMode == 1) {
            TierSorter tierSorter = new TierSorter(this.transcription);
            List<TierImpl> tierImplList = tierSorter.sortTiers(tierSorter.BY_HIERARCHY, this.transcription.getTiers());
            ArrayList<String> newTierList = new ArrayList<String>();
            for (TierImpl tierImpl : tierImplList) {
                String tierImplName = tierImpl.getName();
                if (!tierList.contains(tierImplName)) continue;
                newTierList.add(tierImplName);
            }
            tierList = newTierList;
            if (!visible) {
                Collections.reverse(tierList);
            }
        }
        for (String tierName : tierList) {
            if (this.transcription.getTierWithId(tierName) == null) continue;
            if (visible) {
                if (visibleTiersInOtherTS.contains(tierName)) continue;
                if (visibleTierList.contains(tierName)) {
                    this.setTierVisible(tierName, true);
                    continue;
                }
                this.setTierVisible(tierName, false);
                continue;
            }
            if (visibleTiersInOtherTS.contains(tierName)) continue;
            this.setTierVisible(tierName, visible);
        }
    }

    private void setTierVisible(String tierName, boolean visible) {
        TierTreeNode node = this.tierTreeNodeMap.get(tierName);
        if (node != null) {
            node.setVisible(visible);
            if (visible) {
                if (!this.visibleTiers.contains(node.getTier())) {
                    this.visibleTiers.add(node.getTier());
                }
            } else {
                this.visibleTiers.remove(node.getTier());
            }
        }
        this.hideAllTiers = this.visibleTiers.size() == 0;
        int numberOfDisplayableTiers = this.displayableTiers.size();
        this.updateDisplayableTiers();
        if (visible) {
            if (!this.displayableTiers.contains(node.getTier())) {
                String message = ElanLocale.getString("MultiTierControlPanel.SelectedTier.SingleTier.Part1") + tierName + ElanLocale.getString("MultiTierControlPanel.SelectedTier.SingleTier.Part2") + " " + this.getSortModeDescription(this.sortMode);
                this.checkForNonDisplayableVisibleTiers(false, message, node.getTier());
            }
        } else if (numberOfDisplayableTiers - 1 > this.displayableTiers.size()) {
            JPanel panel = new JPanel(new GridLayout(2, 1));
            panel.add(new JLabel(ElanLocale.getString("MultiTierControlPanel.DeselectedTier.Message.Part1") + tierName + ElanLocale.getString("MultiTierControlPanel.DeselectedTier.Message.Part2") + this.getSortModeDescription(this.sortMode) + "."));
            panel.add(new JLabel(ElanLocale.getString("MultiTierControlPanel.DeselectedTier.MakeItVisible.Part1") + tierName + ElanLocale.getString("MultiTierControlPanel.DeselectedTier.MakeItVisible.Part2")));
            int selectedValue = JOptionPane.showConfirmDialog(null, panel, ElanLocale.getString("Message.Warning"), 0, 2);
            if (selectedValue == 0) {
                node.setVisible(true);
                this.visibleTiers.add(node.getTier());
                this.updateDisplayableTiers();
            } else {
                return;
            }
        }
    }

    private void setVisibleTiers(List<TierImpl> tiers) {
        for (int i = 0; i < this.viewers.size(); ++i) {
            this.viewers.get(i).setVisibleTiers(tiers);
        }
        this.paintBuffer();
    }

    public List<TierImpl> getVisibleTiers() {
        return this.visibleTiers;
    }

    public List<String> getTierOrder() {
        if (this.tierOrder != null) {
            return this.tierOrder.getTierOrder();
        }
        ArrayList<String> visibleTierNames = new ArrayList<String>();
        for (int i = 0; i < this.visibleTiers.size(); ++i) {
            visibleTierNames.add(this.visibleTiers.get(i).getName());
        }
        return visibleTierNames;
    }

    private void setTierOrder(List<String> tierNames) {
        this.sortMode = 0;
        if (!this.unsortedMI.isSelected()) {
            this.unsortedMI.setSelected(true);
        }
        this.updateVisibleTierMenu();
        this.createSortedTree(false);
    }

    public void setActiveTierForName(String name) {
        if (name == null) {
            return;
        }
        for (int i = 0; i < this.tiers.size(); ++i) {
            if (!name.equals(this.tiers.get(i).getName())) continue;
            this.setActiveTier(this.tiers.get(i));
        }
    }

    public String getActiveTierName() {
        if (this.activeTier == null) {
            return null;
        }
        return this.activeTier.getName();
    }

    public void setSorting(int mode) {
        if (this.sortAlphabetically) {
            this.sortAlphabeticallyMI.setSelected(true);
        } else {
            this.sortAlphabeticallyMI.setSelected(false);
        }
        this.oldSortMode = this.sortMode;
        this.sortMode = mode < 0 || mode > 6 ? 0 : mode;
        switch (this.sortMode) {
            case 0: {
                if (this.unsortedMI.isSelected()) break;
                this.unsortedMI.setSelected(true);
                break;
            }
            case 1: {
                if (this.sortByHierarchMI.isSelected()) break;
                this.sortByHierarchMI.setSelected(true);
                break;
            }
            case 3: {
                if (this.sortByTypeMI.isSelected()) break;
                this.sortByTypeMI.setSelected(true);
                break;
            }
            case 2: {
                if (this.sortByPartMI.isSelected()) break;
                this.sortByPartMI.setSelected(true);
                break;
            }
            case 4: {
                if (this.sortByAnnotMI.isSelected()) break;
                this.sortByAnnotMI.setSelected(true);
                break;
            }
            case 5: {
                if (this.sortByLanguageMI.isSelected()) break;
                this.sortByLanguageMI.setSelected(true);
                break;
            }
            case 6: {
                if (this.sortByNameMI.isSelected()) break;
                this.sortByNameMI.setSelected(true);
            }
        }
        this.setPreference("MultiTierViewer.TierSortingMode", this.sortMode, this.transcription);
        this.createSortedTree(true);
        if (this.preferenceChanged && this.sortingChanged) {
            Object message = this.displayableTierNodes.size() == 0 ? ElanLocale.getString("MultiTierControlPanel.SortingChanged.NoTierDisplayed") : ElanLocale.getString("MultiTierControlPanel.SortingChanged.FewTiersNotDisplayed");
            message = (String)message + " " + this.getSortModeDescription(this.sortMode);
            this.checkForNonDisplayableVisibleTiers(true, (String)message, null);
        }
        this.sortingChanged = false;
    }

    private void undoSorting() {
        if (this.oldSortMode == this.sortMode) {
            this.setSorting(0);
        } else {
            this.setSorting(this.oldSortMode);
        }
    }

    private String getSortModeDescription(int mode) {
        String sortMode = null;
        switch (mode) {
            case 0: {
                sortMode = ElanLocale.getString("MultiTierControlPanel.Menu.Unsorted");
                break;
            }
            case 1: {
                sortMode = ElanLocale.getString("MultiTierControlPanel.Menu.SortByHierarchy");
                break;
            }
            case 2: {
                sortMode = ElanLocale.getString("MultiTierControlPanel.Menu.SortByParticipant");
                break;
            }
            case 3: {
                sortMode = ElanLocale.getString("MultiTierControlPanel.Menu.SortByType");
                break;
            }
            case 4: {
                sortMode = ElanLocale.getString("MultiTierControlPanel.Menu.SortByAnnotator");
                break;
            }
            case 5: {
                sortMode = ElanLocale.getString("MultiTierControlPanel.Menu.SortByLanguage");
                break;
            }
            case 6: {
                sortMode = ElanLocale.getString("MultiTierControlPanel.Menu.SortByName");
            }
        }
        return sortMode;
    }

    public int getSorting() {
        return this.sortMode;
    }

    public void tierAdded(TierImpl tier) {
        String name = tier.getName();
        if (!this.tierNames.containsKey(tier)) {
            this.tierNames.put(tier, name);
            TierTreeNode node = new TierTreeNode(tier);
            if (tier.getParentTier() == null) {
                this.addToRootColors(tier);
            }
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(name);
            menuItem.setSelected(true);
            menuItem.addActionListener(this);
            menuItem.setActionCommand("@&@" + name);
            this.visTiersMenu.add(menuItem);
            this.tierTreeNodeMap.put(name, node);
            block0 : switch (this.sortMode) {
                case 0: {
                    this.sortedRootNode.add(node);
                    break;
                }
                case 1: {
                    if (tier.getParentTier() == null) {
                        this.sortedRootNode.add(node);
                        break;
                    }
                    Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
                    en.nextElement();
                    while (en.hasMoreElements()) {
                        TierTreeNode nextNode = (TierTreeNode)en.nextElement();
                        if (nextNode.getTier() != tier.getParentTier()) continue;
                        nextNode.add(node);
                        break block0;
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    TierImpl.ValueGetter getter = MultiTierControlPanel.getValueGetter(this.sortMode);
                    String key = getter.getSortValue(tier);
                    boolean groupFound = false;
                    Enumeration<TreeNode> partEnum = this.sortedRootNode.children();
                    TierTreeNode lastInGroupNode = null;
                    while (partEnum.hasMoreElements()) {
                        TierTreeNode nextNode = (TierTreeNode)partEnum.nextElement();
                        if (getter.getSortValue(nextNode.getTier()).equals(key)) {
                            groupFound = true;
                            lastInGroupNode = nextNode;
                            continue;
                        }
                        if (!groupFound) continue;
                    }
                    if (!groupFound) {
                        this.sortedRootNode.add(node);
                        break;
                    }
                    int index = this.sortedRootNode.getIndex(lastInGroupNode);
                    if (index < this.sortedRootNode.getChildCount() - 1) {
                        this.sortedRootNode.insert(node, index + 1);
                        break;
                    }
                    this.sortedRootNode.add(node);
                }
            }
            if (this.workWithTierSet) {
                node.setVisible(false);
            } else {
                this.visibleTiers.add(tier);
            }
            this.annotationsChanged();
            this.storeTierOrder();
            this.updateDisplayableTiers();
            if (this.sortAlphabetically) {
                this.setSorting(this.sortMode);
            }
            if (this.visibleTiers.size() == 1) {
                this.setActiveTier(tier);
            }
        }
    }

    public void tierRemoved(TierImpl tier) {
        if (this.tierNames.containsKey(tier)) {
            MenuElement[] items;
            String name = this.tierNames.get(tier);
            MenuElement menu = this.visTiersMenu.getSubElements()[0];
            for (MenuElement item : items = menu.getSubElements()) {
                JCheckBoxMenuItem cb;
                if (!(item instanceof JCheckBoxMenuItem) || !(cb = (JCheckBoxMenuItem)item).getText().equals(name)) continue;
                this.visTiersMenu.remove(cb);
                break;
            }
            this.tierNames.remove(tier);
            this.prefTierColors.remove(tier);
            this.numAnnosPerTier.remove(name);
            this.visibleTiers.remove(tier);
            TierTreeNode node = this.tierTreeNodeMap.get(tier.getName());
            ((DefaultMutableTreeNode)node.getParent()).remove(node);
            this.tierTreeNodeMap.remove(tier.getName());
            this.updateDisplayableTiers();
            this.storeTierOrder();
            this.storeHiddenTiers();
            if (this.sortAlphabetically) {
                this.setSorting(this.sortMode);
            }
            if (this.activeTier == tier) {
                if (this.visibleTiers.size() > 0) {
                    this.setActiveTier(this.visibleTiers.get(0));
                } else {
                    this.setActiveTier(null);
                }
            }
        }
    }

    public void tierChanged(TierImpl tier) {
        String name = tier.getName();
        String oldName = this.tierNames.get(tier);
        if (oldName == null) {
            return;
        }
        if (!name.equals(oldName)) {
            TierTreeNode node;
            MenuElement[] items;
            MenuElement menu = this.visTiersMenu.getSubElements()[0];
            for (MenuElement item : items = menu.getSubElements()) {
                JCheckBoxMenuItem cb;
                if (!(item instanceof JCheckBoxMenuItem) || !(cb = (JCheckBoxMenuItem)item).getText().equals(oldName)) continue;
                cb.setText(name);
                cb.setActionCommand("@&@" + name);
                break;
            }
            if ((node = this.tierTreeNodeMap.get(oldName)) != null) {
                node.setTierName(name);
            }
            this.tierTreeNodeMap.put(name, node);
            this.tierTreeNodeMap.remove(oldName);
            this.tierNames.put(tier, name);
            this.annotationsChanged();
            if (this.sortAlphabetically) {
                this.setSorting(this.sortMode);
            }
            this.paintBuffer();
            this.storeHiddenTiers();
            this.storeTierOrder();
        } else {
            this.createSortedTree(false);
        }
    }

    public void setActiveTier(Tier tier) {
        this.activeTier = tier;
        Enumeration<TreeNode> e = this.sortedRootNode.preorderEnumeration();
        e.nextElement();
        while (e.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)e.nextElement();
            if (node.getTier() == this.activeTier) {
                node.setActive(true);
                continue;
            }
            node.setActive(false);
        }
        for (int j = 0; j < this.viewers.size(); ++j) {
            this.viewers.get(j).setActiveTier(tier);
        }
        this.paintBuffer();
        if (this.activeTier != null) {
            this.setPreference("MultiTierViewer.ActiveTierName", this.activeTier.getName(), this.transcription);
        } else {
            this.setPreference("MultiTierViewer.ActiveTierName", null, this.transcription);
        }
    }

    public Tier getActiveTier() {
        return this.activeTier;
    }

    public void setNextActiveTier(boolean next) {
        if (this.displayableTierNodes.size() == 0) {
            return;
        }
        if (this.activeTier == null) {
            if (this.displayableTierNodes.size() > 0) {
                TierTreeNode node = this.displayableTierNodes.get(0);
                this.setActiveTier(node.getTier());
            }
        } else {
            TierTreeNode node = null;
            TierImpl tier = null;
            for (int i = 0; i < this.displayableTierNodes.size(); ++i) {
                node = this.displayableTierNodes.get(i);
                tier = node.getTier();
                if (tier != this.activeTier) continue;
                if (!next) {
                    if (i > 0) {
                        node = this.displayableTierNodes.get(i - 1);
                        this.setActiveTier(node.getTier());
                    }
                    return;
                }
                if (i < this.displayableTierNodes.size() - 1) {
                    node = this.displayableTierNodes.get(i + 1);
                    this.setActiveTier(node.getTier());
                }
                return;
            }
            Enumeration<TreeNode> e = this.sortedRootNode.preorderEnumeration();
            e.nextElement();
            while (e.hasMoreElements()) {
                node = (TierTreeNode)e.nextElement();
                if (node.getTier() != this.activeTier) continue;
                if (!next) {
                    while (node.getParent() != null && !((DefaultMutableTreeNode)node.getParent()).isRoot()) {
                        if (!this.displayableTierNodes.contains(node = (TierTreeNode)node.getParent())) continue;
                        this.setActiveTier(node.getTier());
                        return;
                    }
                } else {
                    while (e.hasMoreElements()) {
                        node = (TierTreeNode)e.nextElement();
                        if (!this.displayableTierNodes.contains(node)) continue;
                        this.setActiveTier(node.getTier());
                        return;
                    }
                }
                return;
            }
        }
    }

    private void activateTier(TierImpl tier, boolean active) {
        if (tier != null && active) {
            this.setActiveTier(tier);
        } else {
            this.setActiveTier(null);
        }
    }

    private void changeTier(Tier tier) {
        Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.EditTier");
        Object[] args = new Object[]{1, tier};
        c.execute(this.transcription, args);
    }

    private void applyTier(TierImpl tier) {
        AdvancedAttributeSettingOptionDialog dialog = new AdvancedAttributeSettingOptionDialog((Frame)ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("EditTierDialog.Title.Apply"), this.transcription, tier.getName());
        dialog.setVisible(true);
    }

    private void deleteTier(Tier tier) {
        Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.EditTier");
        Object[] args = new Object[]{2, tier};
        c.execute(this.transcription, args);
    }

    private void showInTierDependencyFrame(TierImpl tier) {
        JTree tree;
        CommandAction ca = ELANCommandFactory.getCommandAction(this.transcription, "Menu.View.Dependencies");
        ca.actionPerformed(null);
        String name = tier.getName();
        if (!this.visibleTiers.contains(tier)) {
            this.visibleTiers.add(tier);
        }
        if (ca instanceof TierDependenciesCA && (tree = ((TierDependenciesCA)ca).getTree()) != null) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
            Enumeration<TreeNode> en = root.preorderEnumeration();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode target = (DefaultMutableTreeNode)en.nextElement();
                if (target.getUserObject() == null || !target.getUserObject().equals(name)) continue;
                Object[] path = target.getPath();
                tree.setSelectionPath(new TreePath(path));
            }
        }
    }

    private void showAllTiers() {
        if (this.workWithTierSet) {
            MenuElement menu = this.visTiersMenu.getSubElements()[0];
            MenuElement[] items = menu.getSubElements();
            ArrayList<String> tierList = new ArrayList<String>();
            for (int i = 0; i < items.length; ++i) {
                if (!(items[i] instanceof JCheckBoxMenuItem)) continue;
                ((JCheckBoxMenuItem)items[i]).setSelected(true);
                tierList.add(((JCheckBoxMenuItem)items[i]).getText());
            }
            Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
            nodeEnum.nextElement();
            while (nodeEnum.hasMoreElements()) {
                TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
                if (!tierList.contains(node.getTierName())) continue;
                node.setVisible(true);
                if (this.visibleTiers.contains(node.getTier())) continue;
                this.visibleTiers.add(node.getTier());
            }
            this.showOrHideAllTiersInVisibleTierSet(true);
            this.hideAllTiers = false;
            this.updateDisplayableTiers();
            this.storeHiddenTiers();
        } else {
            MenuElement[] items;
            for (int i = 0; i < this.tiers.size(); ++i) {
                if (this.visibleTiers.contains(this.tiers.get(i))) continue;
                this.visibleTiers.add(this.tiers.get(i));
            }
            MenuElement menu = this.visTiersMenu.getSubElements()[0];
            for (MenuElement item : items = menu.getSubElements()) {
                if (!(item instanceof JCheckBoxMenuItem)) continue;
                ((JCheckBoxMenuItem)item).setSelected(true);
            }
            Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
            nodeEnum.nextElement();
            while (nodeEnum.hasMoreElements()) {
                TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
                node.setVisible(true);
            }
            this.hideAllTiers = false;
            this.updateDisplayableTiers();
            this.storeHiddenTiers();
        }
    }

    private void hideAllTiers() {
        MenuElement[] items;
        MenuElement menu = this.visTiersMenu.getSubElements()[0];
        for (MenuElement item : items = menu.getSubElements()) {
            if (!(item instanceof JCheckBoxMenuItem)) continue;
            ((JCheckBoxMenuItem)item).setSelected(false);
        }
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            node.setVisible(false);
        }
        this.visibleTiers.clear();
        this.hideAllTiers = true;
        this.updateDisplayableTiers();
        this.storeHiddenTiers();
        if (this.workWithTierSet) {
            this.showOrHideAllTiersInVisibleTierSet(false);
        }
    }

    private void storeHiddenTiers() {
        if (this.sortedRootNode != null) {
            ArrayList<String> tNames = new ArrayList<String>(this.tiers.size());
            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                TierTreeNode nn = (TierTreeNode)en.nextElement();
                if (nn.isVisible()) continue;
                tNames.add(nn.getTierName());
            }
            this.setPreference("MultiTierViewer.HiddenTiers", tNames, this.transcription);
        }
    }

    private void storeTierOrder() {
        if (this.sortedRootNode != null) {
            ArrayList<String> tNames = new ArrayList<String>(this.tiers.size());
            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                TierTreeNode nn = (TierTreeNode)en.nextElement();
                tNames.add(nn.getTierName());
            }
            this.setPreference("MultiTierViewer.TierOrder", tNames, this.transcription);
            if (this.tierOrder != null) {
                this.tierOrder.setTierOrder(tNames);
                this.updateVisibleTierMenu();
                this.sortedTiers.clear();
                for (int i = 0; i < tNames.size(); ++i) {
                    TierImpl tier = this.transcription.getTierWithId(tNames.get(i).toString());
                    if (tier == null) continue;
                    this.sortedTiers.add(tier);
                }
            }
        }
    }

    private void storeCollapsedTiers() {
        if (this.sortedRootNode != null) {
            ArrayList<String> tNames = new ArrayList<String>(this.tiers.size());
            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                TierTreeNode nn = (TierTreeNode)en.nextElement();
                if (nn.isLeaf() || nn.isExpanded()) continue;
                tNames.add(nn.getTierName());
            }
            this.setPreference("MultiTierViewer.CollapsedTiers", tNames, this.transcription);
        }
    }

    private void updateVisibleTierMenu() {
        block11: {
            List<String> tierOrderList;
            block10: {
                if (!this.workWithTierSet) break block10;
                MenuElement menu = this.visTiersMenu.getSubElements()[0];
                MenuElement[] items = menu.getSubElements();
                if (items != null) {
                    for (MenuElement item : items) {
                        String commandName = ((JMenuItem)item).getActionCommand();
                        if (!commandName.startsWith("@&@")) continue;
                        this.visTiersMenu.remove((JMenuItem)item);
                    }
                }
                List<String> tierList = this.tierSetUtil.getTierOrder(this.transcription);
                for (String tierName : tierList) {
                    JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(tierName);
                    if (this.visibleTiers.contains(this.transcription.getTierWithId(tierName))) {
                        menuItem.setSelected(true);
                    } else {
                        menuItem.setSelected(false);
                    }
                    menuItem.setActionCommand("@&@" + tierName);
                    menuItem.addActionListener(this);
                    this.visTiersMenu.add(menuItem);
                }
                break block11;
            }
            if (this.tierOrder == null || (tierOrderList = this.tierOrder.getTierOrder()) == null) break block11;
            MenuElement menu = this.visTiersMenu.getSubElements()[0];
            MenuElement[] items = menu.getSubElements();
            if (items != null) {
                for (MenuElement item : items) {
                    String commandName = ((JMenuItem)item).getActionCommand();
                    if (!commandName.startsWith("@&@")) continue;
                    this.visTiersMenu.remove((JMenuItem)item);
                }
            }
            for (int i = 0; i < tierOrderList.size(); ++i) {
                String tierName = tierOrderList.get(i);
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(tierName);
                if (this.visibleTiers.contains(this.transcription.getTierWithId(tierName))) {
                    menuItem.setSelected(true);
                } else {
                    menuItem.setSelected(false);
                }
                menuItem.setActionCommand("@&@" + tierName);
                menuItem.addActionListener(this);
                this.visTiersMenu.add(menuItem);
            }
        }
    }

    private void updateVisibleTiersMenu(List<TierImpl> visTiers) {
        MenuElement[] items;
        MenuElement menu = this.visTiersMenu.getSubElements()[0];
        for (MenuElement item : items = menu.getSubElements()) {
            if (!(item instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem checkBoxMI = (JCheckBoxMenuItem)item;
            String tierName = checkBoxMI.getText();
            if (visTiers.contains(this.transcription.getTierWithId(tierName))) {
                checkBoxMI.setSelected(true);
                checkBoxMI.setForeground(Color.BLACK);
                continue;
            }
            if (this.visibleTiers.contains(this.transcription.getTierWithId(tierName))) {
                checkBoxMI.setSelected(true);
                checkBoxMI.setForeground(Color.GRAY);
                checkBoxMI.setToolTipText(ElanLocale.getString("MultiTierControlPanel.NonDisplayableTiers.ToolTipText"));
                continue;
            }
            checkBoxMI.setSelected(false);
            checkBoxMI.setForeground(Color.BLACK);
        }
    }

    protected void updateVisibleTiers(List<String> visTierNames) {
        if (visTierNames == null) {
            return;
        }
        this.visibleTiers.clear();
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            if (visTierNames.contains(node.getTierName())) {
                node.setVisible(true);
                this.visibleTiers.add(node.getTier());
                continue;
            }
            node.setVisible(false);
        }
        this.hideAllTiers = this.visibleTiers.size() == 0;
        this.storeTierOrder();
        this.updateDisplayableTiers();
        this.storeHiddenTiers();
        Object message = this.displayableTierNodes.size() == 0 ? ElanLocale.getString("MultiTierControlPanel.SelectedTier.NoTierDisplayed") : ElanLocale.getString("MultiTierControlPanel.SelectedTier.FewTiersNotDisplayed");
        message = (String)message + " " + this.getSortModeDescription(this.sortMode);
        this.checkForNonDisplayableVisibleTiers(false, (String)message, null);
    }

    private void checkForNonDisplayableVisibleTiers(boolean isSortingChanged, String message, TierImpl tier) {
        if (this.visibleTiers.size() > this.displayableTiers.size()) {
            JRadioButton lastSortTypeRB = null;
            JRadioButton makeItVisibleRB = null;
            AbstractButton doNothingRB = null;
            JCheckBox makeItVisibleCB = null;
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 0, 2, 0);
            panel.add((Component)new JLabel(message), gbc);
            if (isSortingChanged) {
                int oldMode = this.oldSortMode;
                if (this.oldSortMode == this.sortMode) {
                    oldMode = 0;
                }
                lastSortTypeRB = new JRadioButton(ElanLocale.getString("MultiTierControlPanel.SortingChanged.SwitchToLastSortMode") + " " + this.getSortModeDescription(oldMode), true);
                gbc.gridy = -1;
                gbc.insets = new Insets(4, 6, 4, 2);
                panel.add((Component)lastSortTypeRB, gbc);
                makeItVisibleRB = new JRadioButton(ElanLocale.getString("MultiTierControlPanel.SortingChanged.MakeitVisible"), true);
                gbc.gridy = -1;
                panel.add((Component)makeItVisibleRB, gbc);
                makeItVisibleRB.setSelected(false);
                gbc.gridy = -1;
                gbc.insets = new Insets(0, 35, 0, 0);
                panel.add((Component)new JLabel(ElanLocale.getString("MultiTierControlPanel.MakeitVisible.part2")), gbc);
                doNothingRB = new JRadioButton(ElanLocale.getString("MultiTierControlPanel.SortingChanged.DoNothing"), true);
                gbc.gridy = -1;
                gbc.insets = new Insets(4, 6, 4, 2);
                panel.add((Component)doNothingRB, gbc);
                doNothingRB.setSelected(false);
                ButtonGroup group = new ButtonGroup();
                group.add(lastSortTypeRB);
                group.add(makeItVisibleRB);
                group.add(doNothingRB);
            } else {
                makeItVisibleCB = new JCheckBox(ElanLocale.getString("MultiTierControlPanel.SelectedTier.MakeitVisible"), true);
                gbc.gridy = -1;
                panel.add((Component)makeItVisibleCB, gbc);
                gbc.gridy = -1;
                gbc.insets = new Insets(0, 35, 0, 0);
                panel.add((Component)new JLabel(ElanLocale.getString("MultiTierControlPanel.MakeitVisible.part2")), gbc);
            }
            int selectedValue = JOptionPane.showConfirmDialog(null, panel, ElanLocale.getString("Message.Warning"), 2, 2);
            if (selectedValue != 0) {
                return;
            }
            if (isSortingChanged) {
                if (lastSortTypeRB.isSelected()) {
                    this.undoSorting();
                } else if (makeItVisibleRB.isSelected()) {
                    this.makeNonDisplayableTiersVisible(tier);
                } else if (doNothingRB.isSelected()) {
                    return;
                }
            } else if (makeItVisibleCB.isSelected()) {
                this.makeNonDisplayableTiersVisible(tier);
            }
        }
    }

    private void makeNonDisplayableTiersVisible(TierImpl tier) {
        ArrayList<TierImpl> nonDisplayableTiers = new ArrayList<TierImpl>();
        if (tier != null) {
            nonDisplayableTiers.add(tier);
        } else {
            for (int i = 0; i < this.visibleTiers.size(); ++i) {
                if (this.displayableTiers.contains(this.visibleTiers.get(i))) continue;
                nonDisplayableTiers.add(this.visibleTiers.get(i));
            }
        }
        for (int i = 0; i < nonDisplayableTiers.size(); ++i) {
            TierImpl t = (TierImpl)nonDisplayableTiers.get(i);
            while (t.hasParentTier()) {
                if (this.visibleTiers.contains(t = t.getParentTier())) continue;
                this.visibleTiers.add(t);
                this.tierTreeNodeMap.get(t.getName()).setVisible(true);
            }
        }
        this.updateDisplayableTiers();
        this.storeHiddenTiers();
    }

    private void hideTier(TierImpl tier) {
        TierTreeNode node;
        MenuElement[] items;
        if (tier == null) {
            return;
        }
        if (this.visibleTiers.contains(tier)) {
            this.visibleTiers.remove(tier);
        }
        String name = tier.getName();
        MenuElement menu = this.visTiersMenu.getSubElements()[0];
        for (MenuElement item : items = menu.getSubElements()) {
            if (!(item instanceof JCheckBoxMenuItem) || !((JCheckBoxMenuItem)item).getText().equals(name)) continue;
            ((JCheckBoxMenuItem)item).setSelected(false);
            break;
        }
        if ((node = this.tierTreeNodeMap.get(tier.getName())) != null) {
            node.setVisible(false);
        }
        if (this.visibleTiers.contains(tier)) {
            this.visibleTiers.remove(tier);
        }
        if (this.workWithTierSet) {
            this.updateVisibilityInTierSet(name, false);
        }
        this.updateDisplayableTiers();
        this.storeHiddenTiers();
    }

    private void expandAllNodes() {
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            node.setExpanded(true);
        }
        this.updateDisplayableTiers();
        this.storeCollapsedTiers();
    }

    private void collapseAllNodes() {
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            node.setExpanded(false);
        }
        this.updateDisplayableTiers();
        this.storeCollapsedTiers();
    }

    private void toggleExpandedState(Tier tier) {
        if (tier == null) {
            return;
        }
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            if (node.getTier() != tier) continue;
            node.setExpanded(!node.isExpanded());
            break;
        }
        this.updateDisplayableTiers();
        this.storeCollapsedTiers();
    }

    private void addToRootColors(TierImpl t) {
        int i = 0;
        if (this.prefTierColors.get(t) != null) {
            return;
        }
        Color c = this.getRandomColor();
        while (true) {
            if (c.getRed() == c.getGreen() && c.getRed() == c.getBlue()) {
                c = this.getRandomColor();
                ++i;
                continue;
            }
            if (!this.prefTierColors.values().contains(c)) {
                this.prefTierColors.put(t, c);
                this.storeColorPref(t.getName(), c);
                break;
            }
            if (i > 50) {
                this.prefTierColors.put(t, c);
                this.storeColorPref(t.getName(), c);
                break;
            }
            c = this.getRandomColor();
            ++i;
        }
    }

    private void storeColorPref(String tierName, Color c) {
        Map<String, Color> map = Preferences.getMapOfColor("TierColors", this.transcription);
        if (map == null) {
            map = new HashMap<String, Color>();
        }
        if (map.get(tierName) == null) {
            map.put(tierName, c);
            Preferences.set("TierColors", map, (Transcription)this.transcription);
        }
    }

    private String truncateString(String string, int width, FontMetrics fMetrics) {
        int stringWidth;
        Object line = string;
        if (fMetrics != null && (stringWidth = fMetrics.stringWidth((String)line)) > width - 4) {
            int i = 0;
            Object s = "";
            int size = ((String)line).length();
            while (i < size && fMetrics.stringWidth((String)s) <= width - 4) {
                s = (String)s + ((String)line).charAt(i++);
            }
            line = !((String)s).equals("") ? ((String)s).substring(0, ((String)s).length() - 1) : s;
        }
        return line;
    }

    public void annotationsChanged() {
        if (this.transcription != null) {
            TierImpl ti = null;
            List<TierImpl> tiers = this.transcription.getTiers();
            int numTiers = tiers.size();
            for (int i = 0; i < numTiers; ++i) {
                ti = tiers.get(i);
                this.numAnnosPerTier.put(ti.getName(), "[" + String.valueOf(ti.getAnnotations().size()) + "]");
            }
            this.updateAnnotationCounts();
            this.paintBuffer();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        this.dimension.setSize(120, ((JComponent)((Object)this.viewer)).getHeight());
        return this.dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        this.dimension.setSize(360, ((JComponent)((Object)this.viewer)).getHeight());
        return this.dimension;
    }

    private Color getRandomColor() {
        int r = this.colorValues[(int)(Math.random() * 3.0)];
        int g = this.colorValues[(int)(Math.random() * 3.0)];
        int b = this.colorValues[(int)(Math.random() * 3.0)];
        return new Color(r, g, b);
    }

    private void paintBuffer() {
        if (!this.useBufferedImage) {
            this.repaint();
            return;
        }
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.displayableTierNodes == null || this.tierPositions == null || this.displayableTierNodes.size() > this.tierPositions.length) {
            return;
        }
        if (this.bi == null || this.bi.getWidth() != this.getWidth() || this.bi.getHeight() != this.getHeight()) {
            this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        this.big2d = this.bi.createGraphics();
        if (SystemReporting.antiAliasedText) {
            this.big2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.paintToConfiguredContext(this.big2d, this.bi.getWidth(), this.bi.getHeight());
        this.repaint();
    }

    private void paintUnbuffered(Graphics2D g2d) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.displayableTierNodes == null || this.tierPositions == null || this.displayableTierNodes.size() > this.tierPositions.length) {
            return;
        }
        this.paintToConfiguredContext(g2d, this.getWidth(), this.getHeight());
    }

    private void paintToConfiguredContext(Graphics2D conG2d, int conWidth, int conHeight) {
        conG2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        conG2d.fillRect(0, 0, conWidth, conHeight);
        if (this.tierPositions.length > 1) {
            conG2d.setColor(this.demarcColor);
            int y = this.tierPositions[0] + this.tierHeight / 2;
            for (int tierPosition : this.tierPositions) {
                conG2d.drawLine(0, y, conWidth, y);
                y += this.tierHeight;
            }
        }
        int panelWidth = conWidth;
        int availableLabelWidth = panelWidth - 10;
        switch (this.sortMode) {
            case 1: {
                for (int i = 0; i < this.displayableTierNodes.size(); ++i) {
                    TierTreeNode node = this.displayableTierNodes.get(i);
                    this.paintLabelHierarchically(conG2d, node, i, availableLabelWidth);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                TierImpl.ValueGetter getter = MultiTierControlPanel.getValueGetter(this.sortMode);
                boolean startGroup = true;
                for (int i = 0; i < this.displayableTierNodes.size(); ++i) {
                    TierTreeNode node = this.displayableTierNodes.get(i);
                    if (i > 0) {
                        TierTreeNode prevNode = this.displayableTierNodes.get(i - 1);
                        startGroup = !getter.getSortValue(node.getTier()).equals(getter.getSortValue(prevNode.getTier()));
                    }
                    this.paintLabelInBlock(conG2d, node, i, availableLabelWidth, startGroup);
                }
                break;
            }
            default: {
                for (int i = 0; i < this.displayableTierNodes.size(); ++i) {
                    TierTreeNode node = this.displayableTierNodes.get(i);
                    this.paintLabelInBlock(conG2d, node, i, availableLabelWidth, false);
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (SystemReporting.antiAliasedText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (this.useBufferedImage && this.bi != null) {
            g2d.drawImage((Image)this.bi, 0, 0, this);
        } else {
            this.paintUnbuffered(g2d);
        }
        g2d.setColor(Constants.SELECTIONCOLOR);
        g2d.drawLine(0, 0, this.getWidth() - 1, 0);
        g2d.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
        if (this.dragging) {
            g2d.setFont(this.boldFont);
            g2d.setColor(Color.blue);
            g2d.drawString(this.dragLabel, this.dragX, this.dragY);
        }
        if (this.resizer != null) {
            this.resizer.repaint();
        }
    }

    private void paintLabelHierarchically(Graphics g, TierTreeNode node, int positionIndex, int availableLabelWidth) {
        int levelCount;
        int widthForLabel;
        int level = node.getLevel();
        boolean hasChildren = node.getChildCount() != 0;
        boolean atLeastOneChildVisible = false;
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> en = node.children();
            while (en.hasMoreElements()) {
                if (!((TierTreeNode)en.nextElement()).isVisible()) continue;
                atLeastOneChildVisible = true;
                break;
            }
        }
        boolean[] isParentLastChild = new boolean[level];
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        isParentLastChild[level - 1] = parent.getLastChild() == node;
        for (int i = level - 2; i >= 0; --i) {
            DefaultMutableTreeNode upNode = parent;
            isParentLastChild[i] = (parent = (DefaultMutableTreeNode)upNode.getParent()).getLastChild() == upNode;
        }
        int actualLabelWidth = widthForLabel = availableLabelWidth - (level * 10 + 5);
        String label = "";
        if (node.isActive()) {
            label = this.truncateString(node.getTierName(), widthForLabel, this.boldMetrics);
            actualLabelWidth = SwingUtilities.computeStringWidth(this.boldMetrics, label);
        } else {
            label = this.truncateString(node.getTierName(), widthForLabel, this.fontMetrics);
            actualLabelWidth = SwingUtilities.computeStringWidth(this.fontMetrics, label);
        }
        g.setColor(Color.DARK_GRAY);
        int y = this.tierPositions[positionIndex];
        int minY = y - this.tierHeight / 2;
        int minX = 10;
        for (int i = levelCount = 1; i < level; ++i) {
            if (!isParentLastChild[i - 1]) {
                g.drawLine(minX, minY, minX, minY + this.tierHeight);
            }
            minX += 10;
        }
        int x = 5 + level * 10 - 5;
        if (isParentLastChild[level - 1]) {
            g.drawLine(x, minY, x, y);
        } else {
            g.drawLine(x, minY, x, minY + this.tierHeight);
        }
        g.drawLine(x, y, x + 10, y);
        if (hasChildren && node.isExpanded()) {
            if (atLeastOneChildVisible) {
                g.drawLine(x + 10, y, x + 10, y + this.tierHeight / 2);
            }
            g.drawRect(x - 3, y - 3, 6, 6);
        } else if (hasChildren && !node.isExpanded()) {
            g.fillRect(x - 3, y - 3, 6, 6);
        }
        x += 15;
        y += this.boldFont.getSize() / 2;
        if (node.isActive()) {
            g.setColor(Constants.CROSSHAIRCOLOR);
            g.setFont(this.boldFont);
            g.drawLine(x, y + 3, x + actualLabelWidth, y + 3);
            g.drawString(label, x, y);
            if (this.showNumberOfAnnotations) {
                if (!this.reducedTierHeight) {
                    g.setFont(this.smallFont);
                    g.drawString(this.numAnnosPerTier.get(node.getTierName()), x, minY + this.tierHeight - 1);
                } else {
                    int numW = this.smallMetrics.stringWidth(this.numAnnosPerTier.get(node.getTierName()));
                    if (actualLabelWidth + numW < widthForLabel - 3) {
                        g.setFont(this.smallFont);
                        g.drawString(this.numAnnosPerTier.get(node.getTierName()), x + actualLabelWidth + 3, y);
                    }
                }
            }
        } else {
            Color col = this.prefTierColors.get(node.getTier());
            if (col == null) {
                TierImpl root = node.getTier().getRootTier();
                if (root != null) {
                    col = this.prefTierColors.get(root);
                    if (col == null) {
                        this.addToRootColors(node.getTier());
                        col = this.prefTierColors.get(node.getTier());
                    }
                    g.setColor(col);
                }
            } else {
                g.setColor(col);
            }
            g.setFont(this.getFont());
            g.drawString(label, x, y);
            if (this.showNumberOfAnnotations) {
                if (!this.reducedTierHeight) {
                    g.setFont(this.smallFont);
                    g.drawString(this.numAnnosPerTier.get(node.getTierName()), x, minY + this.tierHeight - 2);
                } else {
                    int numW = this.smallMetrics.stringWidth(this.numAnnosPerTier.get(node.getTierName()));
                    if (actualLabelWidth + numW < widthForLabel - 3) {
                        g.setFont(this.smallFont);
                        g.drawString(this.numAnnosPerTier.get(node.getTierName()), x + actualLabelWidth + 3, y);
                    }
                }
            }
        }
    }

    private void paintLabelInBlock(Graphics g, TierTreeNode node, int positionIndex, int availableLabelWidth, boolean startNewGroup) {
        int y = this.tierPositions[positionIndex];
        int minY = y - this.tierHeight / 2;
        if (this.sortMode != 0 && (positionIndex == 0 || startNewGroup)) {
            g.setColor(Color.DARK_GRAY);
            g.drawLine(5, minY, 5 + availableLabelWidth, minY);
        }
        if (this.sortMode != 0 && positionIndex == this.displayableTierNodes.size() - 1) {
            g.setColor(Color.DARK_GRAY);
            g.drawLine(5, minY + this.tierHeight, 5 + availableLabelWidth, minY + this.tierHeight);
        }
        int actualLabelWidth = availableLabelWidth;
        String label = "";
        if (node.isActive()) {
            label = this.truncateString(node.getTierName(), availableLabelWidth, this.boldMetrics);
            actualLabelWidth = SwingUtilities.computeStringWidth(this.boldMetrics, label);
            int x = 5 + availableLabelWidth - actualLabelWidth;
            y += this.getFont().getSize() / 2;
            g.setColor(Constants.CROSSHAIRCOLOR);
            if (this.showNumberOfAnnotations) {
                g.setFont(this.smallFont);
                int numW = this.smallMetrics.stringWidth(this.numAnnosPerTier.get(node.getTierName()));
                if (!this.reducedTierHeight) {
                    g.drawString(this.numAnnosPerTier.get(node.getTierName()), this.getWidth() - 5 - numW, minY + this.tierHeight - 1);
                } else {
                    int xx = x - 3 - numW;
                    if (xx >= 5) {
                        x = xx;
                        g.drawString(this.numAnnosPerTier.get(node.getTierName()), this.getWidth() - 5 - numW, y);
                    }
                }
            }
            g.setFont(this.boldFont);
            g.drawLine(x, y + 3, x + actualLabelWidth, y + 3);
            g.drawString(label, x, y);
        } else {
            label = this.truncateString(node.getTierName(), availableLabelWidth, this.fontMetrics);
            actualLabelWidth = SwingUtilities.computeStringWidth(this.fontMetrics, label);
            int x = 5 + availableLabelWidth - actualLabelWidth;
            y += this.getFont().getSize() / 2;
            Color col = this.prefTierColors.get(node.getTier());
            if (col == null) {
                TierImpl root = node.getTier().getRootTier();
                if (root != null) {
                    col = this.prefTierColors.get(root);
                    if (col == null) {
                        this.addToRootColors(node.getTier());
                        col = this.prefTierColors.get(node.getTier());
                    }
                    g.setColor(col);
                }
            } else {
                g.setColor(col);
            }
            if (this.showNumberOfAnnotations) {
                g.setFont(this.smallFont);
                int numW = this.smallMetrics.stringWidth(this.numAnnosPerTier.get(node.getTierName()));
                if (!this.reducedTierHeight) {
                    g.drawString(this.numAnnosPerTier.get(node.getTierName()), this.getWidth() - 5 - numW, minY + this.tierHeight - 2);
                } else {
                    int xx = x - 3 - numW;
                    if (xx >= 5) {
                        x = xx;
                        g.drawString(this.numAnnosPerTier.get(node.getTierName()), this.getWidth() - 5 - numW, y);
                    }
                }
            }
            g.setFont(this.getFont());
            g.drawString(label, x, y);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        int tierIndex = this.getClosestTierIndexForMouseY(p.y);
        if (tierIndex >= this.displayableTierNodes.size()) {
            return;
        }
        TierTreeNode tierNode = this.displayableTierNodes.get(tierIndex);
        TierImpl tier = tierNode.getTier();
        if (tier == null) {
            return;
        }
        StringBuilder tooltip = new StringBuilder("<html><table>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.TierName"));
        tooltip.append("</b></td><td>");
        tooltip.append(tier.getName());
        tooltip.append("</td></tr>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.Parent"));
        tooltip.append("</b></td><td>");
        if (tier.hasParentTier()) {
            tooltip.append(tier.getParentTier().getName());
        } else {
            tooltip.append("-");
        }
        tooltip.append("</td></tr>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.Participant"));
        tooltip.append("</b></td><td>");
        tooltip.append(tier.getParticipant());
        tooltip.append("</td></tr>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.Annotator"));
        tooltip.append("</b></td><td>");
        tooltip.append(tier.getAnnotator());
        tooltip.append("</td></tr>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.LinguisticType"));
        tooltip.append("</b></td><td>");
        if (tier.getLinguisticType() != null) {
            tooltip.append(tier.getLinguisticType().getLinguisticTypeName());
        }
        tooltip.append("</td></tr>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.ContentLanguage"));
        tooltip.append("</b></td><td>");
        String langRef = tier.getLangRef();
        if (langRef != null) {
            tooltip.append(langRef);
        }
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.Language"));
        tooltip.append("</b></td><td>");
        Locale defLoc = tier.getDefaultLocale();
        if (defLoc != null) {
            tooltip.append(defLoc.getDisplayName());
        }
        tooltip.append("</td></tr>");
        tooltip.append("</table></html>");
        this.setToolTipText(tooltip.toString());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.viewer instanceof MouseWheelListener) {
            ((MouseWheelListener)((Object)this.viewer)).mouseWheelMoved(e);
        }
    }

    @Override
    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void preferencesChanged() {
        Boolean numAnn;
        Map<String, Color> colors;
        Integer n;
        String atName;
        List<String> hiddenTiers = Preferences.getListOfString("MultiTierViewer.HiddenTiers", this.transcription);
        List<String> collTiers = Preferences.getListOfString("MultiTierViewer.CollapsedTiers", this.transcription);
        Boolean useTyp = Preferences.getBool("MultiTierViewer.SortAlpabetically", this.transcription);
        if (useTyp != null) {
            this.sortAlphabetically = useTyp;
        }
        List<String> tierOrderList = this.tierOrder.getTierOrder();
        this.sortedTiers.clear();
        this.visibleTiers.clear();
        Boolean workWithTierSetsPref = Preferences.getBool("WorkwithTierSets", null);
        if (workWithTierSetsPref != null && workWithTierSetsPref.booleanValue()) {
            void var7_13;
            this.workWithTierSet = workWithTierSetsPref;
            this.workWithTiersetsMI.setSelected(true);
            for (String string : this.tierSetUtil.getVisibleTierSets()) {
                TierSet tierSet = this.tierSetUtil.getTierSet(string);
                for (String tierName : tierSet.getVisibleTierList()) {
                    TierImpl tier = this.transcription.getTierWithId(tierName);
                    if (tier == null) continue;
                    this.visibleTiers.add(tier);
                }
            }
            this.updateVisibleTierMenu();
            List<String> tierList = this.tierSetUtil.getTierOrder(this.transcription);
            for (String tierName : tierOrderList) {
                if (tierList.contains(tierName)) continue;
                tierList.add(tierName);
            }
            boolean bl = false;
            while (var7_13 < tierList.size()) {
                TierImpl tier = this.transcription.getTierWithId(tierList.get((int)var7_13));
                if (tier != null) {
                    this.sortedTiers.add(tier);
                }
                ++var7_13;
            }
        } else {
            this.workWithTierSet = false;
            this.workWithTiersetsMI.setSelected(false);
            for (int i = 0; i < tierOrderList.size(); ++i) {
                TierImpl tierImpl = this.transcription.getTierWithId(tierOrderList.get(i).toString());
                if (tierImpl == null) continue;
                this.sortedTiers.add(tierImpl);
            }
            this.visibleTiers.addAll(this.sortedTiers);
            if (hiddenTiers != null && hiddenTiers.size() > 0) {
                void var7_16;
                int n2 = this.visibleTiers.size() - 1;
                while (var7_16 >= 0) {
                    Tier tier = this.visibleTiers.get((int)var7_16);
                    if (hiddenTiers.contains(tier.getName())) {
                        this.visibleTiers.remove((int)var7_16);
                    }
                    --var7_16;
                }
            }
            this.updateVisibleTierMenu();
        }
        this.visTiersMenu.setEnabled(!this.workWithTierSet);
        this.showHideMoreMI.setEnabled(!this.workWithTierSet);
        if (this.visibleTiers.size() == 0) {
            this.hideAllTiers = true;
        }
        if ((atName = Preferences.getString("MultiTierViewer.ActiveTierName", this.transcription)) != null) {
            this.setActiveTierForName(atName);
        }
        if ((n = Preferences.getInt("MultiTierViewer.TierSortingMode", this.transcription)) != null) {
            this.setSorting(n);
        } else {
            this.createSortedTree(true);
        }
        if (collTiers != null && collTiers.size() > 0) {
            if (this.sortedRootNode != null) {
                Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
                en.nextElement();
                while (en.hasMoreElements()) {
                    TierTreeNode nn = (TierTreeNode)en.nextElement();
                    if (!collTiers.contains(nn.getTierName())) continue;
                    nn.setExpanded(false);
                }
            }
            this.updateDisplayableTiers();
        }
        if ((colors = Preferences.getMapOfColor("TierColors", this.transcription)) != null) {
            for (Map.Entry<String, Color> e : colors.entrySet()) {
                String name = e.getKey();
                Color col = e.getValue();
                TierImpl t = this.transcription.getTierWithId(name);
                if (t == null) continue;
                this.prefTierColors.put(t, col);
            }
            Iterator<TierImpl> tierIter = this.prefTierColors.keySet().iterator();
            while (tierIter.hasNext()) {
                TierImpl t = tierIter.next();
                if (colors.containsKey(t.getName())) continue;
                tierIter.remove();
            }
        }
        if ((numAnn = Preferences.getBool("MultiTierViewer.ShowNumberOfAnnotations", this.transcription)) != null) {
            this.showNumberOfAnnotations = numAnn;
            this.numAnnosMI.setSelected(this.showNumberOfAnnotations);
        }
        if (this.displayableTierNodes.size() == 0) {
            this.sortingChanged = true;
        }
        this.preferenceChanged = true;
        Boolean val = Preferences.getBool("UI.UseBufferedPainting", null);
        if (!SystemReporting.isBufferedPaintingPropertySet && val != null) {
            this.useBufferedImage = val;
        }
        this.updateAnnotationCounts();
    }

    public void isClosing() {
        HashMap<String, Color> prefMap = new HashMap<String, Color>();
        for (TierImpl t : this.prefTierColors.keySet()) {
            Color col = this.prefTierColors.get(t);
            prefMap.put(t.getName(), col);
        }
        Preferences.set("TierColors", prefMap, this.transcription, false, true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.resizer != null) {
            this.resizer.setBounds(this.getWidth() - this.resizer.getWidth(), 1, this.resizer.getWidth(), this.resizer.getHeight());
        }
        this.paintBuffer();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tierSetChanged() {
        void var4_8;
        Boolean workWithTierSets = Preferences.getBool("WorkwithTierSets", this.transcription);
        if (workWithTierSets == null || !workWithTierSets.booleanValue()) {
            return;
        }
        this.visibleTiers.clear();
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.addAll(this.tierSetUtil.getTierOrder(this.transcription));
        for (String string : this.tierSetUtil.getVisibleTierSets()) {
            TierSet tierSet = this.tierSetUtil.getTierSet(string);
            for (String tierName : tierSet.getVisibleTierList()) {
                TierImpl tier = this.transcription.getTierWithId(tierName);
                if (tier == null || this.visibleTiers.contains(tier)) continue;
                this.visibleTiers.add(tier);
            }
        }
        this.updateTierSetMenu();
        this.updateVisibleTierMenu();
        List<String> tierSetList = this.tierSetUtil.getTierSetList();
        for (String tiersetName : tierSetList) {
            for (String tierName : this.tierSetUtil.getTierSet(tiersetName).getTierList()) {
                if (tierList.contains(tierName)) continue;
                tierList.add(tierName);
            }
        }
        for (String tierName : this.getTierOrder()) {
            if (tierList.contains(tierName)) continue;
            tierList.add(tierName);
        }
        this.sortedTiers.clear();
        boolean bl = false;
        while (var4_8 < tierList.size()) {
            TierImpl tier = this.transcription.getTierWithId((String)tierList.get((int)var4_8));
            if (tier != null) {
                this.sortedTiers.add(tier);
            }
            ++var4_8;
        }
        this.createSortedTree(true);
    }

    @Override
    public void tierVisibilityChanged(String tierName, boolean isVisible) {
        Component[] menuComponents = this.visTiersMenu.getMenuComponents();
        for (int i = 0; i < menuComponents.length; ++i) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menuComponents[i];
            if (!menuItem.getText().equals(tierName)) continue;
            menuItem.setSelected(isVisible);
            this.setTierVisible(tierName, isVisible);
        }
    }

    @Override
    public void tierSetVisibilityChanged(TierSet tierSet) {
        Component[] menuComponents = this.tiersetMenu.getMenuComponents();
        for (int i = 2; i < menuComponents.length; ++i) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menuComponents[i];
            if (!menuItem.getText().equals(tierSet.getName())) continue;
            menuItem.setSelected(tierSet.isVisible());
            this.setTierSetVisible(tierSet.getName(), tierSet.isVisible());
        }
        this.storeTierOrder();
    }

    public void cycleTierSets() {
        if (this.workWithTierSet) {
            List<String> visibleTierSets = this.tierSetUtil.getVisibleTierSets();
            List<String> tierSetNames = this.tierSetUtil.getTierSetList();
            if (tierSetNames.size() != 1) {
                if (visibleTierSets.size() == 1) {
                    String selectedTierSet = visibleTierSets.get(0);
                    TierSet tierSetToDisable = this.tierSetUtil.getTierSet(selectedTierSet);
                    tierSetToDisable.setVisible(false);
                    int selectedTierIndex = tierSetNames.indexOf(selectedTierSet);
                    if (selectedTierIndex == tierSetNames.size() - 1) {
                        TierSet tierSet = this.tierSetUtil.getTierSet(tierSetNames.get(0));
                        tierSet.setVisible(true);
                    } else {
                        TierSet tierSet = this.tierSetUtil.getTierSet(tierSetNames.get(selectedTierIndex + 1));
                        tierSet.setVisible(true);
                    }
                } else {
                    for (String name : visibleTierSets) {
                        TierSet tierSet = this.tierSetUtil.getTierSet(name);
                        tierSet.setVisible(false);
                    }
                    if (tierSetNames.size() != 0) {
                        TierSet tierSet = this.tierSetUtil.getTierSet(tierSetNames.get(0));
                        tierSet.setVisible(true);
                    }
                }
                this.tierSetUtil.notifyAllListeners();
            }
        }
    }

    public class TierComparer
    implements Comparator<TierImpl> {
        @Override
        public int compare(TierImpl o1, TierImpl o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    public class TierTreeNode
    extends DefaultMutableTreeNode {
        private TierImpl tier;
        private String tierName;
        private String label;
        private boolean visible = true;
        private boolean active = false;
        private boolean expanded = true;

        public TierTreeNode(TierImpl tier) {
            this.tier = tier;
            this.label = this.tierName = tier.getName();
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }

        public TierImpl getTier() {
            return this.tier;
        }

        public void setTier(TierImpl tier) {
            this.tier = tier;
        }

        public String getTierName() {
            return this.tierName;
        }

        public void setTierName(String tierName) {
            this.tierName = tierName;
        }

        @Override
        public String toString() {
            return this.tierName;
        }
    }
}

