/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ClipWaveCommand;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.recognizer.data.Boundary;
import mpi.eudico.client.annotator.recognizer.data.BoundarySegmentation;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.GesturesListener;
import mpi.eudico.client.annotator.viewer.PraatConnection;
import mpi.eudico.client.annotator.viewer.TimeRuler;
import mpi.eudico.client.annotator.viewer.TimeScaleBasedViewer;
import mpi.eudico.client.annotator.viewer.WavePart;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.client.util.WAVCuePoint;
import mpi.eudico.client.util.WAVSampler;
import mpi.eudico.util.TimeFormatter;

public class SignalViewer
extends TimeScaleBasedViewer
implements ComponentListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ActionListener,
GesturesListener,
Scrollable {
    public static final int MONO = 0;
    public static final int STEREO_SEPARATE = 1;
    public static final int STEREO_MERGED = 2;
    public static final int STEREO_BLENDED = 3;
    static final int PIXELS_FOR_SECOND = 100;
    private int channelMode;
    public final int[] VERT_ZOOM = new int[]{100, 150, 200, 300, 500, 1000, 2000, 3000};
    private final int GAP = 4;
    private int rulerHeight;
    private BufferedImage bi;
    private Graphics2D big2d;
    private AlphaComposite alpha04;
    private AlphaComposite alpha07;
    private WavePart currentPart;
    private final int SCREEN_BUFFER = 1;
    private WAVSampler samp;
    public final int DEFAULT_MS_PER_PIXEL = 10;
    private float msPerPixel;
    private float samplesPerPixel;
    private TimeRuler ruler;
    private int maxAmplitude;
    private int imageWidth;
    private int imageHeight;
    private long crossHairTime;
    private int crossHairPos;
    private long intervalBeginTime;
    private long intervalEndTime;
    private long dragStartTime;
    private long selectionBeginTime;
    private long selectionEndTime;
    private int selectionBeginPos;
    private int selectionEndPos;
    private Point dragStartPoint;
    private Point dragEndPoint;
    public final int SCROLL_OFFSET = 16;
    private DragScroller scroller;
    private JPopupMenu popup;
    private JMenuItem praatSelMI;
    private JMenuItem clipSelPraatMI;
    private JMenuItem clipSelJavaSoundMI;
    private JMenuItem infoItem;
    private ButtonGroup zoomBG;
    private JRadioButtonMenuItem customZoomMI;
    private JMenuItem zoomSelectionMI;
    private JMenuItem zoomToEntireMediaMI;
    private ButtonGroup vertZoomGroup;
    private JMenu channelMI;
    private JRadioButtonMenuItem separateMI;
    private JRadioButtonMenuItem mergedMI;
    private JRadioButtonMenuItem blendMI;
    private JCheckBoxMenuItem timeRulerVisMI;
    private JCheckBoxMenuItem timeScaleConMI;
    private JMenuItem copyOrigTimeItem;
    private boolean timeScaleConnected;
    private boolean panMode;
    private boolean timeRulerVisible;
    private boolean clearSelOnSingleClick = true;
    private int vertZoom = 100;
    private final ReentrantLock paintLock = new ReentrantLock();
    private int paintLockTimeOut = 20;
    private long mediaOffset;
    private String mediaFilePath;
    boolean stopScrolling = true;
    boolean allowConnecting = true;
    private Color selectionColor = Constants.SELECTIONCOLOR;
    JMenu segmentationMenu;
    BoundarySegmentation segmentationChannel1;
    boolean showSegmentationChannel1;
    JCheckBoxMenuItem segmentationChannel1Item;
    BoundarySegmentation segmentationChannel2;
    boolean showSegmentationChannel2;
    JCheckBoxMenuItem segmentationChannel2Item;
    private String errorKey = null;
    private boolean recalculateInterval = true;
    private int horScrollSpeed = 10;
    private boolean useBufferedImage = false;
    private AffineTransform identityTransform = new AffineTransform();
    private boolean viewPortMode = false;
    private JViewport viewPort = null;
    private ViewPortChangeListener viewPortListener = null;
    private final int MAX_READ_NUM_SAMPLES = (int)Math.pow(2.0, 22.0);
    private final BasicStroke waveStroke = new BasicStroke(1.05f);

    public SignalViewer() {
        this.initViewer();
        this.useBufferedImage = SystemReporting.useBufferedPainting;
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setDoubleBuffered(false);
        this.setOpaque(true);
    }

    public SignalViewer(URL mediaURL, boolean allowConnecting) {
        this(mediaURL);
        this.allowConnecting = allowConnecting;
        this.removeMouseMotionListener(this);
    }

    public SignalViewer(URL mediaUrl) {
        this(mediaUrl.toExternalForm());
    }

    public SignalViewer(String mediaPath) {
        this();
        this.setMedia(mediaPath);
        this.paintBuffer();
        System.out.println("MediaUrl SignalViewer: " + mediaPath);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return false;
    }

    private void initViewer() {
        this.ruler = Constants.DEFAULT_LF_LABEL_FONT != null ? new TimeRuler(Constants.deriveSmallFont(Constants.DEFAULT_LF_LABEL_FONT), TimeFormatter.toString(0L)) : new TimeRuler(Constants.DEFAULTFONT, TimeFormatter.toString(0L));
        this.rulerHeight = this.ruler.getHeight();
        this.timeRulerVisible = true;
        this.channelMode = 2;
        this.msPerPixel = 10.0f;
        this.samplesPerPixel = this.msPerPixel * 44100.0f / 1000.0f;
        this.maxAmplitude = Short.MAX_VALUE;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.crossHairTime = 0L;
        this.crossHairPos = 0;
        this.intervalBeginTime = 0L;
        this.intervalEndTime = 0L;
        this.dragStartTime = 0L;
        this.selectionBeginTime = 0L;
        this.selectionEndTime = 0L;
        this.selectionBeginPos = 0;
        this.selectionEndPos = 0;
        this.alpha04 = AlphaComposite.getInstance(3, 0.4f);
        this.alpha07 = AlphaComposite.getInstance(3, 0.7f);
        this.currentPart = new WavePart(1);
        this.timeScaleConnected = true;
        this.mediaOffset = 0L;
    }

    public synchronized void setMedia(String mediaPath) {
        if (!((String)mediaPath).endsWith("wav")) {
            int i = ((String)mediaPath).lastIndexOf(46);
            mediaPath = i > 0 ? ((String)mediaPath).substring(0, i) + ".wav" : (String)mediaPath + ".wav";
        }
        if (((String)mediaPath).startsWith("file:")) {
            mediaPath = ((String)mediaPath).substring(5);
        }
        this.mediaFilePath = mediaPath;
        this.initLoad((String)mediaPath);
        this.paintBuffer();
    }

    public String getMediaPath() {
        return this.mediaFilePath;
    }

    private void openInPraat(long begin, long end) {
        PraatConnection.openInPraat(this.mediaFilePath, begin, end);
    }

    private void openSelectionInPraat() {
        if (this.getSelectionBeginTime() == this.getSelectionEndTime()) {
            this.openInPraat(0L, 0L);
        } else {
            this.openInPraat(this.getSelectionBeginTime() + this.mediaOffset, this.getSelectionEndTime() + this.mediaOffset);
        }
    }

    private void clipSelectionWithPraat() {
        if (this.getSelectionBeginTime() == this.getSelectionEndTime()) {
            return;
        }
        PraatConnection.clipWithPraat(this.mediaFilePath, this.getSelectionBeginTime() + this.mediaOffset, this.getSelectionEndTime() + this.mediaOffset);
    }

    private void clipSelectionWithJavaSound() {
        if (this.getSelectionBeginTime() == this.getSelectionEndTime()) {
            return;
        }
        ClipWaveCommand command = new ClipWaveCommand("ClipWave");
        command.execute(this.getViewerManager().getTranscription(), new Object[]{this.mediaFilePath, this.getSelectionBeginTime() + this.mediaOffset, this.getSelectionEndTime() + this.mediaOffset});
    }

    private void showMediaInfo() {
        String[][] info = new String[3][2];
        info[0][0] = ElanLocale.getString("LinkedFilesDialog.Label.MediaURL");
        info[0][1] = this.mediaFilePath;
        info[1][0] = ElanLocale.getString("LinkedFilesDialog.Label.MediaOffset");
        info[1][1] = String.valueOf(this.mediaOffset);
        info[2][0] = ElanLocale.getString("Player.duration");
        info[2][1] = TimeFormatter.toString((long)this.samp.getDuration());
        new FormattedMessageDlg(info);
    }

    public long getSignalDuration() {
        return (long)this.samp.getDuration();
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    private void initLoad(String sourcePath) {
        this.samp = null;
        this.errorKey = null;
        try {
            this.samp = new WAVSampler(sourcePath);
        }
        catch (IOException ioe) {
            System.out.println("Failed to create a WAVSampler");
            this.errorKey = ElanLocale.getString("SignalViewer.Message.NoReader") + ": " + ioe.getMessage();
        }
        if (this.samp != null) {
            this.samplesPerPixel = this.msPerPixel * (float)this.samp.getSampleFrequency() / 1000.0f;
            this.maxAmplitude = Math.max(this.samp.getPossibleMaxSample(), Math.abs(this.samp.getPossibleMinSample()));
            if (this.samp.getWavHeader().getNumberOfChannels() == 1) {
                this.channelMode = 0;
            } else if (this.samp.getWavHeader().getNumberOfChannels() == 2) {
                this.channelMode = 1;
            }
            this.updateChannelModePopUpMenu();
            short compr = this.samp.getWavHeader().getCompressionCode();
            if (compr != 0 && compr != 1 && compr != 6) {
                this.errorKey = ElanLocale.getString("SignalViewer.Message.Compression") + ": " + this.samp.getWavHeader().getCompressionString(compr);
                if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                    StringBuilder sb = new StringBuilder("Unsupported WAVE file, information from the Header:\n");
                    sb.append("\tWAVE Format:\t" + this.samp.getWavHeader().getCompressionString(compr) + "\n");
                    sb.append("\tNo. Channels:\t" + this.samp.getWavHeader().getNumberOfChannels() + "\n");
                    sb.append("\tSample Rate:\t" + this.samp.getSampleFrequency());
                    ClientLogger.LOG.info(sb.toString());
                }
            }
        }
        int w = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.loadData(0L, (long)this.msPerPixel, w);
    }

    private boolean loadData(long fromTime, long toTime, int width) {
        if (this.samp == null) {
            return false;
        }
        if ((float)(fromTime += this.mediaOffset) > this.samp.getDuration() || fromTime > (toTime += this.mediaOffset) || toTime < 0L) {
            return false;
        }
        long to = toTime > (long)this.samp.getDuration() ? (long)this.samp.getDuration() : toTime;
        long from = fromTime < this.mediaOffset ? this.mediaOffset : fromTime;
        int startPixel = (int)((float)from / this.msPerPixel);
        int stopPixel = (int)((float)to / this.msPerPixel);
        int extent = stopPixel - startPixel + 1;
        int size = extent > width ? extent : width;
        boolean roundProb = this.samplesPerPixel * 10.0f % 10.0f != 0.0f;
        int numChannelsToLoad = 1;
        if (this.channelMode == 3 || this.channelMode == 1) {
            numChannelsToLoad = 2;
        }
        this.currentPart.reset();
        this.currentPart.setInterval(from, to, startPixel, size, extent);
        this.loadSamples(startPixel, extent, size, numChannelsToLoad, roundProb);
        return true;
    }

    private boolean shiftAndLoadData(long fromTime, long toTime) {
        int extent;
        if (this.samp == null) {
            return false;
        }
        if ((float)fromTime > this.samp.getDuration() || fromTime > toTime || toTime < 0L) {
            return false;
        }
        if ((float)toTime > this.samp.getDuration()) {
            toTime = (long)this.samp.getDuration();
        }
        long oldStop = this.currentPart.getStopTime();
        long oldStart = this.currentPart.getStartTime();
        int startPixel = (int)((float)fromTime / this.msPerPixel);
        int stopPixel = (int)((float)toTime / this.msPerPixel);
        int size = extent = stopPixel - startPixel + 1;
        boolean roundProb = this.samplesPerPixel * 10.0f % 10.0f != 0.0f;
        int oldStartPixel = (int)((float)oldStart / this.msPerPixel);
        int newStartPixel = startPixel;
        int distance = oldStartPixel - newStartPixel;
        if (distance == 0) {
            return true;
        }
        if (this.currentPart.rightOverlap(fromTime, toTime)) {
            this.currentPart.shiftInterval(distance);
            this.currentPart.setInterval(fromTime, toTime, startPixel, size, extent);
            startPixel = (int)((float)oldStop / this.msPerPixel);
            size = extent = stopPixel - startPixel + 1;
        } else if (this.currentPart.leftOverlap(fromTime, toTime)) {
            this.currentPart.shiftInterval(distance);
            this.currentPart.setInterval(fromTime, toTime, (int)((float)fromTime / this.msPerPixel), size, extent);
            stopPixel = (int)((float)oldStart / this.msPerPixel);
            size = extent = stopPixel - startPixel + 1;
        } else {
            return false;
        }
        int numChannelsToLoad = 1;
        if (this.channelMode == 3 || this.channelMode == 1) {
            numChannelsToLoad = 2;
        }
        this.loadSamples(startPixel, extent, size, numChannelsToLoad, roundProb);
        return true;
    }

    private void loadSamples(int startPixel, int numberOfPixels, int imageWidthInPixels, int numberOfChannels, boolean roundingErrors) {
        long startSample = (long)((float)startPixel * this.samplesPerPixel);
        int samplesPerPixelInt = (int)this.samplesPerPixel;
        int pixelCounter = startPixel;
        if (roundingErrors) {
            this.samp.seekSample(startSample);
            int totalNumSamplesToRead = (int)Math.min(this.samp.getNrOfSamples(), (long)((int)((float)numberOfPixels * this.samplesPerPixel)));
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine(String.format("Rounded: Samples per pixel: %d  Number of pixels: %d  Total samples to read: %d", samplesPerPixelInt, imageWidthInPixels, totalNumSamplesToRead));
            }
            int i = 0;
            while (totalNumSamplesToRead > 0) {
                int cp;
                int nextSamplesToRead = Math.min(totalNumSamplesToRead, this.MAX_READ_NUM_SAMPLES);
                nextSamplesToRead = Math.max(nextSamplesToRead, this.samp.getSampleFrequency());
                int samplesRead = this.samp.readInterval(nextSamplesToRead, numberOfChannels);
                int numPixelsInSamples = (int)((float)samplesRead / this.samplesPerPixel);
                for (cp = 0; i < imageWidthInPixels && cp < numPixelsInSamples; ++i, ++cp) {
                    int min = 0;
                    int max = 0;
                    int min2 = 0;
                    int max2 = 0;
                    int index = 0;
                    if (cp > 0) {
                        long sm = (long)((float)(startPixel + cp) * this.samplesPerPixel);
                        index = (int)(sm - startSample);
                    }
                    int j = 0;
                    while ((float)j <= this.samplesPerPixel && j + index < this.samp.getFirstChannelArray().length) {
                        int sample = this.samp.getFirstChannelArray()[j + index];
                        if (sample < min) {
                            min = sample;
                        } else if (sample > max) {
                            max = sample;
                        }
                        if (numberOfChannels == 2) {
                            int sample2 = this.samp.getSecondChannelArray()[j + index];
                            if (sample2 < min2) {
                                min2 = sample2;
                            } else if (sample2 > max2) {
                                max2 = sample2;
                            }
                        }
                        ++j;
                    }
                    this.currentPart.addLineToFirstChannel(pixelCounter + i, -max, -min);
                    if (numberOfChannels != 2) continue;
                    this.currentPart.addLineToRightChannel(pixelCounter + i, -max2, -min2);
                }
                long samplesInCurPixels = (long)((float)cp * this.samplesPerPixel);
                startSample = (long)((float)(startPixel += cp) * this.samplesPerPixel);
                if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                    ClientLogger.LOG.fine(String.format("Samples used: %d  Next start sample: %d  Current position: %d", samplesInCurPixels, startSample, this.samp.getSamplePointer()));
                }
                if (cp != 0) {
                    if ((totalNumSamplesToRead = (int)((long)totalNumSamplesToRead - samplesInCurPixels)) <= 0) continue;
                    this.samp.seekSample(startSample);
                    continue;
                }
                break;
            }
        } else {
            this.samp.seekSample(startSample);
            int totalNumSamplesToRead = (int)Math.min(this.samp.getNrOfSamples(), (long)((int)((float)numberOfPixels * this.samplesPerPixel)));
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine(String.format("Samples per Pixel: %d  Number of Pixels: %d  Total samples to read: %d", samplesPerPixelInt, imageWidthInPixels, totalNumSamplesToRead));
            }
            while (totalNumSamplesToRead > 0) {
                int nextSamplesToRead = Math.min(totalNumSamplesToRead, this.MAX_READ_NUM_SAMPLES);
                nextSamplesToRead = Math.max(nextSamplesToRead, this.samp.getSampleFrequency());
                int samplesRead = this.samp.readInterval(nextSamplesToRead, numberOfChannels);
                int p = pixelCounter;
                for (int i = 0; i < samplesRead - samplesPerPixelInt && p < pixelCounter + imageWidthInPixels; i += samplesPerPixelInt, ++p) {
                    int min = 0;
                    int max = 0;
                    int min2 = 0;
                    int max2 = 0;
                    for (int j = 0; j < samplesPerPixelInt; ++j) {
                        int sample = this.samp.getFirstChannelArray()[i + j];
                        if (sample < min) {
                            min = sample;
                        } else if (sample > max) {
                            max = sample;
                        }
                        if (numberOfChannels != 2) continue;
                        int sample2 = this.samp.getSecondChannelArray()[i + j];
                        if (sample2 < min2) {
                            min2 = sample2;
                            continue;
                        }
                        if (sample2 <= max2) continue;
                        max2 = sample2;
                    }
                    this.currentPart.addLineToFirstChannel(p, -max, -min);
                    if (numberOfChannels != 2) continue;
                    this.currentPart.addLineToRightChannel(p, -max2, -min2);
                }
                long samplesInCurPixels = (long)((float)(p - pixelCounter) * this.samplesPerPixel);
                if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                    ClientLogger.LOG.fine(String.format("Samples read: %d  Samples used from current: ", samplesRead, samplesInCurPixels));
                }
                if (p != pixelCounter) {
                    pixelCounter = p;
                    long nextStartSample = (long)((float)pixelCounter * this.samplesPerPixel);
                    if ((totalNumSamplesToRead = (int)((long)totalNumSamplesToRead - samplesInCurPixels)) <= 0) continue;
                    this.samp.seekSample(nextStartSample);
                    continue;
                }
                break;
            }
        }
    }

    private void paintBuffer() {
        int curWidth = this.getViewWidth();
        int curHeight = this.getViewHeight();
        if (curWidth <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (curWidth != this.imageWidth || curHeight != this.imageHeight) {
            this.imageWidth = curWidth;
            this.imageHeight = curHeight;
            if (this.intervalEndTime == 0L) {
                this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
                if (this.timeScaleConnected) {
                    this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
                }
            }
        }
        if (!this.useBufferedImage) {
            this.repaint();
            return;
        }
        this.paintLock.lock();
        try {
            if (this.bi == null || this.bi.getWidth() < this.imageWidth || this.bi.getHeight() < this.imageHeight) {
                this.bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
                this.big2d = this.bi.createGraphics();
            }
            if (SystemReporting.antiAliasedText) {
                this.big2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.paintToConfiguredContext(this.big2d, this.imageWidth, this.imageHeight);
            this.big2d.setTransform(this.identityTransform);
            if (this.timeRulerVisible) {
                this.big2d.setColor(Constants.SELECTIONCOLOR);
                this.big2d.drawLine(0, this.rulerHeight, this.imageWidth, this.rulerHeight);
            }
        }
        finally {
            this.paintLock.unlock();
        }
        this.repaint();
    }

    private void drawSegmentation(Graphics2D big2g, int imageTopLeft, int imageBottomLeft, int imageTopRight, int imageBottomRight, int translateX) {
        Rectangle2D rect;
        int x;
        String label;
        Boundary boundary;
        long to;
        long from;
        int i;
        FontRenderContext frc;
        int mediaOffsetX = (int)((float)this.mediaOffset / this.msPerPixel);
        if (this.segmentationChannel1 != null && this.showSegmentationChannel1) {
            frc = big2g.getFontRenderContext();
            for (i = mediaOffsetX; i < this.imageWidth + mediaOffsetX; ++i) {
                from = this.intervalBeginTime + (long)((int)((float)i * this.msPerPixel));
                to = (long)((float)from + this.msPerPixel);
                boundary = this.segmentationChannel1.boundaryBetween(from, to);
                if (boundary == null) continue;
                label = null;
                if (boundary != null) {
                    label = boundary.label;
                }
                x = i + translateX;
                if (label == null) continue;
                big2g.setColor(Constants.SEGMENTATIONCOLOR);
                big2g.drawLine(x, imageTopLeft, x, imageBottomLeft);
                if (label.equals("")) continue;
                rect = big2g.getFont().getStringBounds(label, frc);
                big2g.setColor(Color.white);
                big2g.fill3DRect(x + 3, imageBottomLeft - (int)rect.getHeight() - 2, (int)rect.getWidth() + 6, (int)rect.getHeight() + 2, true);
                big2g.setColor(Color.black);
                big2g.drawString(label, x + 5, imageBottomLeft - 3);
            }
        }
        if (this.segmentationChannel2 != null && this.showSegmentationChannel2) {
            frc = big2g.getFontRenderContext();
            for (i = 0; i < this.imageWidth; ++i) {
                from = this.intervalBeginTime + (long)((int)((float)i * this.msPerPixel));
                to = (long)((float)from + this.msPerPixel);
                boundary = this.segmentationChannel2.boundaryBetween(from, to);
                label = null;
                if (boundary != null) {
                    label = boundary.label;
                }
                x = i + translateX;
                if (label == null) continue;
                big2g.setColor(Constants.SEGMENTATIONCOLOR);
                big2g.drawLine(x, imageTopRight, x, imageBottomRight);
                if (label.equals("")) continue;
                rect = big2g.getFont().getStringBounds(label, frc);
                big2g.setColor(Color.white);
                big2g.fill3DRect(x + 3, imageBottomRight - (int)rect.getHeight() - 2, (int)rect.getWidth() + 6, (int)rect.getHeight() + 2, true);
                big2g.setColor(Color.black);
                big2g.drawString(label, x + 5, imageBottomRight - 3);
            }
        }
    }

    public void setSegmentation(BoundarySegmentation segmentation) {
        this.segmentationChannel1 = segmentation;
        if (segmentation != null) {
            this.segmentationChannel2 = null;
            this.segmentationChannel1Item.setSelected(true);
            this.showSegmentationChannel1 = true;
        } else {
            this.segmentationChannel1Item.setSelected(false);
            this.showSegmentationChannel1 = false;
        }
        this.enableSegmentationMenu();
        this.paintBuffer();
    }

    public void setSegmentationChannel1(BoundarySegmentation segmentation) {
        this.segmentationChannel1 = segmentation;
        if (this.segmentationChannel1 != null) {
            this.segmentationChannel1Item.setSelected(true);
            this.showSegmentationChannel1 = true;
        } else {
            this.segmentationChannel1Item.setSelected(false);
            this.showSegmentationChannel1 = false;
        }
        this.enableSegmentationMenu();
        this.paintBuffer();
    }

    public void setSegmentationChannel2(BoundarySegmentation segmentation) {
        this.segmentationChannel2 = segmentation;
        if (this.segmentationChannel2 != null && this.segmentationChannel2Item != null) {
            this.segmentationChannel2Item.setSelected(true);
            this.showSegmentationChannel2 = true;
        } else if (this.segmentationChannel2Item != null) {
            this.segmentationChannel2Item.setSelected(false);
            this.showSegmentationChannel2 = false;
        }
        this.enableSegmentationMenu();
        this.paintBuffer();
    }

    public void enableSegmentationMenu() {
        if (this.segmentationChannel1 != null) {
            this.segmentationMenu.setEnabled(true);
            this.segmentationChannel1Item.setEnabled(true);
        } else {
            this.segmentationChannel1Item.setEnabled(false);
        }
        if (this.segmentationChannel2 != null) {
            this.segmentationMenu.setEnabled(true);
            this.segmentationChannel2Item.setEnabled(true);
        } else if (this.getChannelMode() != 0) {
            this.segmentationChannel2Item.setEnabled(false);
        }
        if (this.segmentationChannel1 == null && this.segmentationChannel2 == null) {
            this.segmentationMenu.setEnabled(false);
        }
    }

    private void drawCuePoints(Graphics2D big2g) {
        if (this.samp == null) {
            return;
        }
        WAVCuePoint[] cuePoints = this.samp.getWavHeader().getCuePoints();
        if (cuePoints.length > 0) {
            big2g.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{4.0f}, 0.0f));
            big2g.setColor(Color.darkGray);
            for (int i = 0; i < cuePoints.length; ++i) {
                int time = (int)this.samp.getTimeAtSample(cuePoints[i].getSampleOffset());
                int x = (int)((float)time / this.msPerPixel);
                if (this.intervalBeginTime > (long)time || (long)time >= this.intervalEndTime) continue;
                big2g.drawLine(x, this.rulerHeight, x, this.imageHeight);
                Object label = cuePoints[i].getLabel();
                String note = cuePoints[i].getNote();
                if (label != null && note != null) {
                    label = (String)label + " : ";
                }
                big2g.drawString((String)(label != null ? label : Integer.toString(i)) + (note != null ? note : ""), x + 1, this.imageHeight - 1);
            }
            big2g.setStroke(new BasicStroke());
        }
    }

    private void paintUnbuffered(Graphics2D g2d) {
        int intervalX1;
        if (this.getViewWidth() <= 0 || this.getViewHeight() <= 0) {
            return;
        }
        this.paintToConfiguredContext(g2d, this.getViewWidth(), this.getViewHeight());
        int n = intervalX1 = this.viewPortMode ? 0 : (int)((float)this.intervalBeginTime / this.msPerPixel);
        if (this.timeRulerVisible) {
            g2d.setColor(Constants.SELECTIONCOLOR);
            g2d.drawLine(intervalX1, this.rulerHeight, intervalX1 + this.getViewWidth(), this.rulerHeight);
        }
        if (this.selectionBeginPos != this.selectionEndPos) {
            g2d.setColor(this.selectionColor);
            g2d.setComposite(this.alpha04);
            g2d.fillRect(this.selectionBeginPos + intervalX1, 0, this.selectionEndPos - this.selectionBeginPos, this.rulerHeight);
            g2d.setComposite(this.alpha07);
            g2d.fillRect(this.selectionBeginPos + intervalX1, this.rulerHeight, this.selectionEndPos - this.selectionBeginPos, this.getViewHeight() - this.rulerHeight);
            g2d.setComposite(AlphaComposite.Src);
        }
        g2d.setColor(Constants.CROSSHAIRCOLOR);
        g2d.drawLine(this.crossHairPos + intervalX1, 0, this.crossHairPos + intervalX1, this.getViewHeight());
    }

    private void paintToConfiguredContext(Graphics2D conG2d, int contextWidth, int contextHeight) {
        int intervalX1;
        int scrollViewBX = 0;
        if (this.viewPortMode && !this.useBufferedImage) {
            scrollViewBX = (int)((float)this.intervalBeginTime / this.msPerPixel);
        }
        if (this.samp == null) {
            conG2d.setComposite(AlphaComposite.Src);
            conG2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
            conG2d.fillRect(scrollViewBX, 0, contextWidth, contextHeight);
            return;
        }
        long mediaBT = this.intervalBeginTime + this.mediaOffset;
        long mediaET = this.intervalEndTime + this.mediaOffset;
        if ((float)mediaET > this.samp.getDuration()) {
            mediaET = (long)this.samp.getDuration();
        }
        if (!this.currentPart.contains(mediaBT, mediaET)) {
            boolean loaded = false;
            if (this.currentPart.amountOfOverlap(mediaBT, mediaET) > 0.8f && this.currentPart.sameIntervalLength(mediaBT, mediaET)) {
                loaded = this.shiftAndLoadData(mediaBT, mediaET);
            }
            if (!loaded) {
                loaded = this.loadData(this.intervalBeginTime, this.intervalBeginTime + (long)((int)((float)(1 * contextWidth) * this.msPerPixel)), contextWidth);
            }
        }
        int segmentationX1 = intervalX1 = (int)((float)this.intervalBeginTime / this.msPerPixel);
        int waveIntervalX1 = (int)((float)(this.intervalBeginTime + this.mediaOffset) / this.msPerPixel);
        int waveIntervalX2 = (int)((float)mediaET / this.msPerPixel);
        int mediaOffsetX = (int)((float)this.mediaOffset / this.msPerPixel);
        if (this.viewPortMode && !this.useBufferedImage) {
            intervalX1 = 0;
            waveIntervalX1 = mediaOffsetX;
        }
        AffineTransform at = new AffineTransform();
        conG2d.setComposite(AlphaComposite.Src);
        conG2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        conG2d.fillRect(scrollViewBX, 0, contextWidth, contextHeight);
        if (this.intervalEndTime > this.getMediaDuration()) {
            int xx = this.xAt(this.getMediaDuration());
            if (!SystemReporting.isMacOS()) {
                conG2d.setColor(UIManager.getColor("Panel.background"));
            } else {
                conG2d.setColor(Color.LIGHT_GRAY);
            }
            conG2d.fillRect(xx, 0, contextWidth - xx, contextHeight);
        }
        if (this.timeRulerVisible) {
            conG2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
            conG2d.translate((double)(-intervalX1), 0.0);
            this.ruler.paint(conG2d, this.intervalBeginTime, contextWidth, this.msPerPixel, 1);
            conG2d.translate((double)(intervalX1 - waveIntervalX1), 0.0);
        } else {
            conG2d.translate((double)(-waveIntervalX1), 0.0);
        }
        switch (this.channelMode) {
            case 0: 
            case 2: {
                int channelHeight = contextHeight - this.rulerHeight;
                int channelMid = this.rulerHeight + Math.round((float)channelHeight / 2.0f);
                conG2d.translate(0.0, (double)channelMid);
                conG2d.setColor(Color.DARK_GRAY);
                conG2d.drawLine(waveIntervalX1, 0, waveIntervalX2, 0);
                conG2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                at.setToScale(1.0, (float)channelHeight / (float)this.maxAmplitude / 2.0f * ((float)this.vertZoom / 100.0f));
                this.currentPart.paintLeftChannelLimit(conG2d, at, channelHeight / 2);
                conG2d.translate(0.0, (double)(-channelMid));
                int leftTop = this.rulerHeight;
                int rightTop = this.rulerHeight;
                this.drawSegmentation(conG2d, leftTop, leftTop + channelHeight, rightTop, rightTop + channelHeight, segmentationX1);
                break;
            }
            case 1: {
                int channelHeight = (contextHeight - this.rulerHeight - 4) / 2;
                int leftChannelMid = this.rulerHeight + (int)Math.ceil((float)channelHeight / 2.0f);
                int rightChannelMid = contextHeight - (int)Math.ceil((float)channelHeight / 2.0f);
                conG2d.setColor(Constants.SIGNALCHANNELCOLOR);
                conG2d.fillRect(waveIntervalX1, this.rulerHeight, contextWidth + 2, channelHeight);
                conG2d.fillRect(waveIntervalX1, contextHeight - channelHeight, contextWidth + 2, channelHeight);
                conG2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                conG2d.translate(0.0, (double)leftChannelMid);
                conG2d.setColor(Color.DARK_GRAY);
                conG2d.drawLine(waveIntervalX1, 0, waveIntervalX2, 0);
                conG2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                at.setToScale(1.0, (float)channelHeight / (float)this.maxAmplitude / 2.0f * ((float)this.vertZoom / 100.0f));
                this.currentPart.paintLeftChannelLimit(conG2d, at, channelHeight / 2);
                conG2d.translate(0.0, (double)(rightChannelMid - leftChannelMid));
                conG2d.setColor(Color.DARK_GRAY);
                conG2d.drawLine(waveIntervalX1, 0, waveIntervalX2, 0);
                conG2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                this.currentPart.paintRightChannelLimit(conG2d, at, channelHeight / 2);
                conG2d.translate(0.0, (double)(-rightChannelMid));
                int leftTop = this.rulerHeight;
                int rightTop = leftTop + channelHeight + 4;
                this.drawSegmentation(conG2d, leftTop, leftTop + channelHeight, rightTop, rightTop + channelHeight, segmentationX1);
                break;
            }
            case 3: {
                int channelHeight = contextHeight - this.rulerHeight;
                int chMid = this.rulerHeight + Math.round((float)channelHeight / 2.0f);
                conG2d.translate(0.0, (double)chMid);
                conG2d.drawLine(waveIntervalX1, 0, waveIntervalX2, 0);
                at.setToScale(1.0, (float)channelHeight / (float)this.maxAmplitude / 2.0f * ((float)this.vertZoom / 100.0f));
                conG2d.setColor(Constants.SIGNALSTEREOBLENDEDCOLOR1);
                this.currentPart.paintLeftChannelLimit(conG2d, at, channelHeight / 2);
                conG2d.setColor(Constants.SIGNALSTEREOBLENDEDCOLOR2);
                conG2d.setComposite(this.alpha04);
                this.currentPart.paintRightChannelLimit(conG2d, at, channelHeight / 2);
                conG2d.setComposite(AlphaComposite.Src);
                conG2d.translate(0.0, (double)(-chMid));
                int leftTop = this.rulerHeight;
                int rightTop = this.rulerHeight;
                this.drawSegmentation(conG2d, leftTop, leftTop + channelHeight, rightTop, rightTop + channelHeight, segmentationX1);
                break;
            }
        }
        this.drawCuePoints(conG2d);
        conG2d.translate((double)mediaOffsetX, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        try {
            if (!this.paintLock.tryLock(this.paintLockTimeOut, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            if (SystemReporting.antiAliasedText) {
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (g2d.getStroke() instanceof BasicStroke && (double)((BasicStroke)g2d.getStroke()).getLineWidth() == 1.0) {
                g2d.setStroke(this.waveStroke);
            }
            int h = this.getViewHeight();
            if (this.useBufferedImage && this.bi != null) {
                int scrollViewBX = 0;
                if (this.viewPortMode) {
                    scrollViewBX = (int)((float)this.intervalBeginTime / this.msPerPixel);
                }
                g2d.drawImage((Image)this.bi, scrollViewBX, 0, this);
                int intervalX1 = (int)((float)this.mediaOffset / this.msPerPixel);
                intervalX1 = 0;
                if (this.selectionBeginPos != this.selectionEndPos) {
                    g2d.setColor(this.selectionColor);
                    g2d.setComposite(this.alpha04);
                    g2d.fillRect(this.selectionBeginPos - intervalX1, 0, this.selectionEndPos - this.selectionBeginPos, this.rulerHeight);
                    g2d.setComposite(this.alpha07);
                    g2d.fillRect(this.selectionBeginPos - intervalX1, this.rulerHeight, this.selectionEndPos - this.selectionBeginPos, h - this.rulerHeight);
                    g2d.setComposite(AlphaComposite.Src);
                }
                g2d.setColor(Constants.CROSSHAIRCOLOR);
                g2d.drawLine(this.crossHairPos - intervalX1, 0, this.crossHairPos - intervalX1, h);
            } else {
                this.paintUnbuffered(g2d);
                g2d.setTransform(this.identityTransform);
            }
            if (this.errorKey != null) {
                g2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                g2d.drawString(this.errorKey, 10, 20 + this.rulerHeight);
            }
        }
        finally {
            this.paintLock.unlock();
        }
    }

    @Override
    public synchronized void updateTimeScale() {
        if (this.timeScaleConnected) {
            if (this.getGlobalTimeScaleMsPerPixel() != this.msPerPixel) {
                this.setLocalTimeScaleMsPerPixel(this.getGlobalTimeScaleMsPerPixel());
            } else if (this.getGlobalTimeScaleIntervalBeginTime() != this.intervalBeginTime) {
                this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
            }
        }
    }

    public void setTimeScaleConnected(boolean connected) {
        this.timeScaleConnected = connected;
        if (this.timeScaleConnected) {
            if (this.msPerPixel != this.getGlobalTimeScaleMsPerPixel()) {
                this.setLocalTimeScaleMsPerPixel(this.getGlobalTimeScaleMsPerPixel());
            }
            if (this.intervalBeginTime != this.getGlobalTimeScaleIntervalBeginTime()) {
                this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
            }
        }
    }

    public boolean getTimeScaleConnected() {
        return this.timeScaleConnected;
    }

    public void setMsPerPixel(float mspp) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleMsPerPixel(mspp);
            this.setGlobalTimeScaleIntervalBeginTime(this.intervalBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        } else {
            this.setLocalTimeScaleMsPerPixel(mspp);
        }
    }

    private void setLocalTimeScaleMsPerPixel(float step) {
        boolean playing;
        if (this.msPerPixel == step) {
            return;
        }
        this.msPerPixel = step >= 0.025f ? step : 0.025f;
        if (this.currentPart != null) {
            this.currentPart.setDrawExtremesContour(this.msPerPixel <= 0.5f);
        }
        if (playing = this.playerIsPlaying()) {
            this.stopPlayer();
        }
        long mediaTime = this.getMediaTime();
        int oldScreenPos = this.crossHairPos;
        int newMediaX = (int)((float)mediaTime / this.msPerPixel);
        int numScreens = (int)((float)mediaTime / ((float)this.imageWidth * this.msPerPixel));
        int newScreenPos = newMediaX - numScreens * this.imageWidth;
        int diff = oldScreenPos - newScreenPos;
        this.intervalBeginTime = (long)((float)(numScreens * this.imageWidth - diff) * this.msPerPixel);
        if (this.intervalBeginTime < 0L) {
            this.intervalBeginTime = 0L;
        }
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
        this.crossHairPos = this.xAt(mediaTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        if (this.viewPortMode) {
            this.revalidate();
            this.viewPortListener.setEnabled(false);
            this.scrollRectToVisible(new Rectangle(this.xAt(this.intervalBeginTime), 0, this.getViewWidth(), this.getViewHeight()));
            this.viewPortListener.setEnabled(true);
        }
        if (this.samp != null) {
            this.samplesPerPixel = this.msPerPixel * (float)this.samp.getSampleFrequency() / 1000.0f;
        }
        this.currentPart.setStartTime(0L);
        this.currentPart.setStopTime(0L);
        this.paintBuffer();
        if (playing) {
            this.startPlayer();
        }
        float zoomFl = 100.0f * (10.0f / this.msPerPixel);
        this.updateZoomPopup(zoomFl);
        if (this.getViewerManager() != null) {
            this.setPreference("SignalViewer.ZoomLevel", new Float(zoomFl), this.getViewerManager().getTranscription());
        }
    }

    public float getMsPerPixel() {
        return this.msPerPixel;
    }

    public int getChannelMode() {
        return this.channelMode;
    }

    public void setChannelMode(int mode, boolean storePref) {
        if (mode == this.channelMode) {
            return;
        }
        if (mode <= 0 || mode > 3) {
            this.channelMode = 0;
        } else {
            if (this.samp != null && this.samp.getWavHeader().getNumberOfChannels() != 2) {
                this.channelMode = 0;
                return;
            }
            this.channelMode = mode;
        }
        if (storePref) {
            this.setPreference("SignalViewer.StereoMode", this.channelMode, this.getViewerManager().getTranscription());
        }
        this.paintBuffer();
    }

    public boolean isTimeRulerVisible() {
        return this.timeRulerVisible;
    }

    public void setTimeRulerVisible(boolean timeRulerVisible) {
        this.timeRulerVisible = timeRulerVisible;
        if (this.timeRulerVisMI != null && this.timeRulerVisMI.isSelected() != timeRulerVisible) {
            this.timeRulerVisMI.setSelected(timeRulerVisible);
        }
        this.rulerHeight = timeRulerVisible ? this.ruler.getHeight() : 0;
        this.paintBuffer();
    }

    public int xAt(long t) {
        if (!this.viewPortMode) {
            return (int)((float)(t - this.intervalBeginTime) / this.msPerPixel);
        }
        return (int)((float)t / this.msPerPixel);
    }

    public int xAtMediaTime(long t) {
        if (!this.viewPortMode) {
            return (int)((float)(t + this.mediaOffset) / this.msPerPixel - (float)this.intervalBeginTime / this.msPerPixel);
        }
        return (int)((float)(t + this.mediaOffset) / this.msPerPixel);
    }

    public long timeAt(int x) {
        if (!this.viewPortMode) {
            return this.intervalBeginTime + (long)((float)x * this.msPerPixel);
        }
        return (long)((float)x * this.msPerPixel);
    }

    public long mediaTimeAt(int x) {
        if (!this.viewPortMode) {
            return this.intervalBeginTime + this.mediaOffset + (long)((float)x * this.msPerPixel);
        }
        return (long)((float)x * this.msPerPixel) + this.mediaOffset;
    }

    public long getIntervalBeginTime() {
        return this.intervalBeginTime;
    }

    public long getIntervalEndTime() {
        return this.intervalEndTime;
    }

    public void setIntervalBeginTime(long begin) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(begin);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        } else {
            this.setLocalTimeScaleIntervalBeginTime(begin);
        }
    }

    public void setRecalculateInterval(boolean recalculate) {
        this.recalculateInterval = recalculate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recalculateInterval(long mediaTime) {
        if (!this.recalculateInterval) {
            return;
        }
        long newBeginTime = this.intervalBeginTime;
        long newEndTime = this.intervalEndTime;
        if (this.playerIsPlaying()) {
            if (mediaTime > this.intervalEndTime) {
                newBeginTime = this.intervalEndTime;
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
                while ((newEndTime = (long)((float)newEndTime + ((float)this.imageWidth + this.msPerPixel))) < mediaTime) {
                    newBeginTime = (long)((float)newBeginTime + (float)this.imageWidth * this.msPerPixel);
                }
            } else {
                if (mediaTime >= this.intervalBeginTime) return;
                newEndTime = this.intervalBeginTime;
                newBeginTime = newEndTime - (long)((int)((float)this.imageWidth * this.msPerPixel));
                while ((newEndTime = (long)((float)newEndTime - (float)this.imageWidth * this.msPerPixel)) > mediaTime) {
                    newBeginTime = (long)((float)newBeginTime - (float)this.imageWidth * this.msPerPixel);
                }
                if (newBeginTime < 0L) {
                    newBeginTime = 0L;
                    newEndTime = (long)((float)this.imageWidth * this.msPerPixel);
                }
            }
        } else {
            if (mediaTime < this.intervalBeginTime) {
                newBeginTime = mediaTime - (long)((int)(16.0f * this.msPerPixel));
                if (newBeginTime < 0L) {
                    newBeginTime = 0L;
                }
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            } else if (mediaTime > this.intervalEndTime && (newBeginTime = (newEndTime = mediaTime + (long)((int)(16.0f * this.msPerPixel))) - (long)((int)((float)this.imageWidth * this.msPerPixel))) < 0L) {
                newBeginTime = 0L;
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            }
            if (newBeginTime == this.getSelectionBeginTime() && (float)newBeginTime > 16.0f * this.msPerPixel) {
                newBeginTime = (long)((float)newBeginTime - 16.0f * this.msPerPixel);
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            }
            if (newEndTime == this.getSelectionEndTime() && (newBeginTime = (newEndTime = (long)((float)newEndTime + 16.0f * this.msPerPixel)) - (long)((int)((float)this.imageWidth * this.msPerPixel))) < 0L) {
                newBeginTime = 0L;
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            }
        }
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(newBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(newEndTime);
            return;
        } else {
            this.setLocalTimeScaleIntervalBeginTime(newBeginTime);
        }
    }

    private void setLocalTimeScaleIntervalBeginTime(long begin) {
        if (begin == this.intervalBeginTime) {
            return;
        }
        this.paintLock.lock();
        try {
            this.intervalBeginTime = begin;
            this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.getViewWidth() * this.msPerPixel));
            this.crossHairPos = this.xAt(this.crossHairTime);
            this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
            this.selectionEndPos = this.xAt(this.getSelectionEndTime());
            if (this.viewPortMode) {
                this.scrollRectToVisible(new Rectangle(this.xAt(this.intervalBeginTime), 0, this.getViewWidth(), this.getViewHeight()));
            }
        }
        finally {
            this.paintLock.unlock();
        }
        this.paintBuffer();
    }

    private void createPopupMenu() {
        JRadioButtonMenuItem zoomRB;
        this.popup = new JPopupMenu("Signal Viewer");
        JMenu zoomMI = new JMenu(ElanLocale.getString("TimeScaleBasedViewer.Zoom"));
        this.zoomBG = new ButtonGroup();
        this.zoomSelectionMI = new JMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Selection"));
        this.zoomSelectionMI.addActionListener(this);
        zoomMI.add(this.zoomSelectionMI);
        this.zoomToEntireMediaMI = new JMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.EntireMedia"));
        this.zoomToEntireMediaMI.addActionListener(this);
        zoomMI.add(this.zoomToEntireMediaMI);
        this.customZoomMI = new JRadioButtonMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom"));
        this.customZoomMI.setEnabled(false);
        this.zoomBG.add(this.customZoomMI);
        zoomMI.add(this.customZoomMI);
        zoomMI.addSeparator();
        for (int element : this.ZOOMLEVELS) {
            zoomRB = new JRadioButtonMenuItem(element + "%");
            zoomRB.setActionCommand(String.valueOf(element));
            zoomRB.addActionListener(this);
            this.zoomBG.add(zoomRB);
            zoomMI.add(zoomRB);
            if (element != 100) continue;
            zoomRB.setSelected(true);
        }
        this.popup.add(zoomMI);
        JMenu vertZoomMenu = new JMenu(ElanLocale.getString("SignalViewer.VertZoom"));
        this.vertZoomGroup = new ButtonGroup();
        for (int element : this.VERT_ZOOM) {
            zoomRB = new JRadioButtonMenuItem(element + "%");
            zoomRB.setActionCommand("vz-" + element);
            zoomRB.addActionListener(this);
            this.vertZoomGroup.add(zoomRB);
            vertZoomMenu.add(zoomRB);
            if (this.vertZoom != element) continue;
            zoomRB.setSelected(true);
        }
        this.popup.add(vertZoomMenu);
        ButtonGroup chanGroup = new ButtonGroup();
        this.channelMI = new JMenu(ElanLocale.getString("SignalViewer.Stereo"));
        this.separateMI = new JRadioButtonMenuItem(ElanLocale.getString("SignalViewer.Stereo.Separate"));
        this.separateMI.setActionCommand("sep");
        this.separateMI.addActionListener(this);
        chanGroup.add(this.separateMI);
        this.channelMI.add(this.separateMI);
        this.mergedMI = new JRadioButtonMenuItem(ElanLocale.getString("SignalViewer.Stereo.Merged"));
        this.mergedMI.setActionCommand("merge");
        this.mergedMI.addActionListener(this);
        chanGroup.add(this.mergedMI);
        this.channelMI.add(this.mergedMI);
        this.blendMI = new JRadioButtonMenuItem(ElanLocale.getString("SignalViewer.Stereo.Blended"));
        this.blendMI.setActionCommand("blend");
        this.blendMI.addActionListener(this);
        chanGroup.add(this.blendMI);
        this.channelMI.add(this.blendMI);
        this.popup.add(this.channelMI);
        this.updateChannelModePopUpMenu();
        this.timeRulerVisMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.TimeRuler.Visible"));
        this.timeRulerVisMI.setSelected(this.timeRulerVisible);
        this.timeRulerVisMI.addActionListener(this);
        this.popup.add(this.timeRulerVisMI);
        if (this.allowConnecting) {
            this.timeScaleConMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Connected"), this.timeScaleConnected);
            this.timeScaleConMI.setActionCommand("connect");
            this.timeScaleConMI.addActionListener(this);
            this.popup.add(this.timeScaleConMI);
        }
        this.popup.addSeparator();
        JMenuItem praatMI = new JMenuItem(ElanLocale.getString("SignalViewer.Praat.File"));
        praatMI.setActionCommand("praat");
        praatMI.addActionListener(this);
        this.popup.add(praatMI);
        this.praatSelMI = new JMenuItem(ElanLocale.getString("SignalViewer.Praat.Selection"));
        this.praatSelMI.setActionCommand("praatSel");
        this.praatSelMI.addActionListener(this);
        this.popup.add(this.praatSelMI);
        this.clipSelPraatMI = new JMenuItem(ElanLocale.getString("SignalViewer.Praat.Clip"));
        this.clipSelPraatMI.setActionCommand("clipSel");
        this.clipSelPraatMI.addActionListener(this);
        this.popup.add(this.clipSelPraatMI);
        this.clipSelJavaSoundMI = new JMenuItem(ElanLocale.getString("SignalViewer.JavaSound.Clip"));
        this.clipSelJavaSoundMI.setActionCommand("clipSelJS");
        this.clipSelJavaSoundMI.addActionListener(this);
        this.popup.add(this.clipSelJavaSoundMI);
        if (this.samp != null) {
            this.popup.addSeparator();
            this.segmentationMenu = new JMenu(ElanLocale.getString("SignalViewer.Segmentation"));
            if (this.samp.getWavHeader().getNumberOfChannels() >= 2) {
                this.segmentationChannel1Item = new JCheckBoxMenuItem(ElanLocale.getString("SignalViewer.Segmentation.LeftVisible"), this.showSegmentationChannel1);
                this.segmentationChannel1Item.addActionListener(this);
                this.segmentationMenu.add(this.segmentationChannel1Item);
                this.segmentationChannel2Item = new JCheckBoxMenuItem(ElanLocale.getString("SignalViewer.Segmentation.RightVisible"), this.showSegmentationChannel2);
                this.segmentationChannel2Item.addActionListener(this);
                this.segmentationMenu.add(this.segmentationChannel2Item);
                this.popup.add(this.segmentationMenu);
                this.segmentationMenu.setEnabled(false);
                this.segmentationChannel1Item.setEnabled(false);
                this.segmentationChannel2Item.setEnabled(false);
            } else {
                this.segmentationChannel1Item = new JCheckBoxMenuItem(ElanLocale.getString("SignalViewer.Segmentation.Visible"), this.showSegmentationChannel1);
                this.segmentationChannel1Item.addActionListener(this);
                this.segmentationMenu.add(this.segmentationChannel1Item);
                this.popup.add(this.segmentationMenu);
                this.segmentationMenu.setEnabled(false);
                this.segmentationChannel1Item.setEnabled(false);
            }
        }
        if (this.allowConnecting) {
            this.popup.addSeparator();
            this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
            this.infoItem.setActionCommand("info");
            this.infoItem.addActionListener(this);
            this.popup.add(this.infoItem);
        }
        this.copyOrigTimeItem = new JMenuItem(ElanLocale.getString("Player.CopyTimeIgnoringOffset"));
        this.copyOrigTimeItem.addActionListener(this);
        this.popup.add(this.copyOrigTimeItem);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        float zoomFl = 100.0f * (10.0f / this.msPerPixel);
        this.updateZoomPopup(zoomFl);
    }

    private void updatePopupMenu() {
        if (this.popup != null) {
            boolean enable = this.getSelectionBeginTime() != this.getSelectionEndTime();
            this.praatSelMI.setEnabled(enable);
            this.clipSelPraatMI.setEnabled(enable);
            this.zoomSelectionMI.setEnabled(enable);
            this.clipSelJavaSoundMI.setEnabled(enable);
        }
    }

    private void updateChannelModePopUpMenu() {
        if (this.popup == null) {
            this.createPopupMenu();
        } else if (this.channelMode == 0) {
            this.channelMI.setEnabled(false);
        } else {
            Integer stereoMode;
            this.channelMI.setEnabled(true);
            if (this.getViewerManager() != null && this.getViewerManager().getTranscription() != null && (stereoMode = Preferences.getInt("SignalViewer.StereoMode", this.getViewerManager().getTranscription())) != null && stereoMode > 0 && stereoMode <= 3) {
                this.channelMode = stereoMode;
            }
            switch (this.channelMode) {
                case 2: {
                    this.mergedMI.setSelected(true);
                    break;
                }
                case 3: {
                    this.blendMI.setSelected(true);
                    break;
                }
                case 1: {
                    this.separateMI.setSelected(true);
                }
            }
        }
    }

    private void updateZoomPopup(float zoom) {
        if (this.popup == null) {
            return;
        }
        if (zoom > 74.99f && zoom < 75.0f) {
            zoom = 75.0f;
        } else if ((double)zoom > 149.99 && zoom < 150.0f) {
            zoom = 150.0f;
        }
        int zoomMenuIndex = -1;
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            if (zoom != (float)this.ZOOMLEVELS[i]) continue;
            zoomMenuIndex = i;
            break;
        }
        Enumeration<AbstractButton> en = this.zoomBG.getElements();
        int counter = 0;
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbmi = (JRadioButtonMenuItem)en.nextElement();
            if (counter == zoomMenuIndex + 1) {
                rbmi.setSelected(true);
                break;
            }
            rbmi.setSelected(false);
            ++counter;
        }
        if (zoomMenuIndex == -1) {
            this.customZoomMI.setSelected(true);
            this.customZoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom") + " - " + zoom + "%");
        } else {
            this.customZoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom"));
        }
    }

    private void zoomIn() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        float nz = zoom + 10.0f;
        float nm = 100.0f / nz * 10.0f;
        this.setMsPerPixel(nm);
    }

    private void zoomOut() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        float nz = zoom - 10.0f;
        if (nz < (float)this.ZOOMLEVELS[0]) {
            nz = this.ZOOMLEVELS[0];
        }
        float nm = 100.0f / nz * 10.0f;
        this.setMsPerPixel(nm);
    }

    private void zoomToSelection() {
        long selInterval = this.getSelectionEndTime() - this.getSelectionBeginTime();
        if (selInterval == 0L) {
            return;
        }
        int sw = this.imageWidth != 0 ? this.imageWidth - 32 : this.getViewWidth() - 32;
        float nextMsPP = (float)selInterval / (float)sw;
        if (nextMsPP < 0.025f) {
            nextMsPP = 0.025f;
        }
        this.setMsPerPixel(nextMsPP);
        if (!this.playerIsPlaying()) {
            long ibt = this.getSelectionBeginTime() - (long)(16.0f * this.msPerPixel);
            if (ibt < 0L) {
                ibt = 0L;
            }
            this.setIntervalBeginTime(ibt);
        }
        if (this.getViewerManager() != null) {
            this.setPreference("SignalViewer.ZoomLevel", new Float(100.0f * (10.0f / this.msPerPixel)), this.getViewerManager().getTranscription());
        }
    }

    private void zoomToShowEntireMedia() {
        int areaWidth = this.getViewWidth() - 16;
        float nextMsPP = this.samp.getDuration() / (float)areaWidth;
        if (nextMsPP != this.msPerPixel) {
            this.setMsPerPixel(nextMsPP);
            this.setIntervalBeginTime(0L);
            if (this.getViewerManager() != null) {
                this.setPreference("SignalViewer.ZoomLevel", new Float(100.0f * (10.0f / this.msPerPixel)), this.getViewerManager().getTranscription());
            }
        }
    }

    private void updateVertZoomPopup(int vertZoom) {
        if (this.popup != null) {
            Enumeration<AbstractButton> en = this.vertZoomGroup.getElements();
            while (en.hasMoreElements()) {
                JRadioButtonMenuItem rbmi = (JRadioButtonMenuItem)en.nextElement();
                if (rbmi.getText().indexOf("" + vertZoom) > -1) {
                    rbmi.setSelected(true);
                    break;
                }
                rbmi.setSelected(false);
            }
        }
    }

    public void setOffset(long offset) {
        if (offset != this.mediaOffset) {
            this.mediaOffset = offset;
            this.currentPart.setStartTime(0L);
            this.currentPart.setStopTime(0L);
            this.crossHairPos = this.xAt(this.crossHairTime);
            this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
            this.selectionEndPos = this.xAt(this.getSelectionEndTime());
            this.paintBuffer();
        }
    }

    @Override
    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent || event instanceof StopEvent) {
            this.crossHairTime = this.getMediaTime();
            if (this.crossHairTime == this.intervalEndTime && !this.playerIsPlaying()) {
                this.recalculateInterval(this.crossHairTime);
            } else if (this.crossHairTime < this.intervalBeginTime || this.crossHairTime > this.intervalEndTime) {
                this.recalculateInterval(this.crossHairTime);
            } else {
                int oldCrossHairPos = this.crossHairPos;
                this.crossHairPos = this.xAt(this.crossHairTime);
                if (!this.useBufferedImage) {
                    this.repaint();
                } else if (this.crossHairPos >= oldCrossHairPos) {
                    this.repaint(oldCrossHairPos - 1, 0, this.crossHairPos - oldCrossHairPos + 2, this.getViewHeight());
                } else {
                    this.repaint(this.crossHairPos - 1, 0, oldCrossHairPos - this.crossHairPos + 2, this.getViewHeight());
                }
            }
        }
    }

    @Override
    public void updateSelection() {
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.repaint();
    }

    public void updateInterval(long begin, long end) {
        long selInterval = end - begin;
        int sw = this.imageWidth != 0 ? this.imageWidth - 32 : this.getViewWidth() - 32;
        float nextMsPP = (float)selInterval / (float)sw;
        if (nextMsPP > 200.0f) {
            nextMsPP = 200.0f;
        }
        if (nextMsPP < 0.025f) {
            nextMsPP = 0.025f;
        }
        this.setMsPerPixel(nextMsPP);
        if (!this.playerIsPlaying()) {
            long ibt = begin - (long)(16.0f * this.msPerPixel);
            if (ibt < 0L) {
                ibt = 0L;
            }
            this.setIntervalBeginTime(ibt);
        }
        this.repaint();
    }

    @Override
    public void updateActiveAnnotation() {
    }

    @Override
    public void updateLocale() {
        if (this.popup != null) {
            this.createPopupMenu();
        }
    }

    public int getLeftMargin() {
        return 0;
    }

    public int getRightMargin() {
        return 0;
    }

    protected int getViewWidth() {
        if (this.viewPortMode) {
            return this.viewPort.getExtentSize().width;
        }
        return super.getWidth();
    }

    protected int getViewHeight() {
        if (this.viewPortMode) {
            return this.viewPort.getExtentSize().height;
        }
        return super.getHeight();
    }

    private Point toPixelCoordinates(Point p) {
        if (this.viewPortMode) {
            return new Point(p.x - this.viewPort.getViewPosition().x, p.y - this.viewPort.getViewPosition().y);
        }
        return p;
    }

    private void printMem(String message) {
        System.out.println(message);
        Runtime r = Runtime.getRuntime();
        System.out.println("Total memory: " + r.totalMemory() / 1024L + " Kb");
        System.out.println("Free memory: " + r.freeMemory() / 1024L + " Kb");
    }

    private void copyToClipboard(String text) {
        if (text == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkPermission(new AWTPermission("accessClipboard"));
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (SecurityException ssVal) {
            }
            catch (IllegalStateException ssVal) {}
        } else {
            try {
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        long curEndTime = this.intervalEndTime;
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.getViewWidth() * this.msPerPixel));
        if (this.timeScaleConnected && curEndTime != this.intervalEndTime) {
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        }
        this.paintBuffer();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Point pp = e.getPoint();
        if (e.getClickCount() == 2) {
            long clickTime = this.timeAt(pp.x) + this.mediaOffset;
            switch (this.channelMode) {
                case 0: {
                    if (this.segmentationChannel1 == null || !this.showSegmentationChannel1) break;
                    long beforeTime = this.segmentationChannel1.boundaryTimeBefore(clickTime) - this.mediaOffset;
                    long afterTime = this.segmentationChannel1.boundaryTimeAfter(clickTime) - this.mediaOffset;
                    this.setSelection(beforeTime, afterTime);
                    this.setMediaTime(beforeTime);
                    break;
                }
                case 1: {
                    if (pp.y < ((SignalViewer)e.getSource()).getViewHeight() / 2) {
                        if (this.segmentationChannel1 == null || !this.showSegmentationChannel1) break;
                        long beforeTime = this.segmentationChannel1.boundaryTimeBefore(clickTime) - this.mediaOffset;
                        long afterTime = this.segmentationChannel1.boundaryTimeAfter(clickTime) - this.mediaOffset;
                        this.setSelection(beforeTime, afterTime);
                        this.setMediaTime(beforeTime);
                        break;
                    }
                    if (this.segmentationChannel2 == null || !this.showSegmentationChannel2) break;
                    long beforeTime = this.segmentationChannel2.boundaryTimeBefore(clickTime) - this.mediaOffset;
                    long afterTime = this.segmentationChannel2.boundaryTimeAfter(clickTime) - this.mediaOffset;
                    this.setSelection(beforeTime, afterTime);
                    this.setMediaTime(beforeTime);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.segmentationChannel1 != null && this.showSegmentationChannel1 && !this.showSegmentationChannel2) {
                        long beforeTime = this.segmentationChannel1.boundaryTimeBefore(clickTime) - this.mediaOffset;
                        long afterTime = this.segmentationChannel1.boundaryTimeAfter(clickTime) - this.mediaOffset;
                        this.setSelection(beforeTime, afterTime);
                        this.setMediaTime(beforeTime);
                        break;
                    }
                    if (this.segmentationChannel2 == null || !this.showSegmentationChannel2 || this.showSegmentationChannel1) break;
                    long beforeTime = this.segmentationChannel2.boundaryTimeBefore(clickTime) - this.mediaOffset;
                    long afterTime = this.segmentationChannel2.boundaryTimeAfter(clickTime) - this.mediaOffset;
                    this.setSelection(beforeTime, afterTime);
                    this.setMediaTime(beforeTime);
                }
            }
        } else if (e.getClickCount() == 1 && e.isShiftDown()) {
            if (this.getSelectionBeginTime() != this.getSelectionEndTime()) {
                long clickTime = this.timeAt(pp.x);
                if (clickTime > this.getSelectionEndTime()) {
                    this.setSelection(this.getSelectionBeginTime(), clickTime);
                } else if (clickTime < this.getSelectionBeginTime()) {
                    this.setSelection(clickTime, this.getSelectionEndTime());
                } else if (clickTime - this.getSelectionBeginTime() < this.getSelectionEndTime() - clickTime) {
                    this.setSelection(clickTime, this.getSelectionEndTime());
                } else {
                    this.setSelection(this.getSelectionBeginTime(), clickTime);
                }
            } else {
                long medTime;
                long clickTime = this.timeAt(pp.x);
                if (clickTime > (medTime = this.getMediaTime())) {
                    this.setSelection(medTime, clickTime);
                } else if (clickTime < medTime) {
                    this.setSelection(clickTime, medTime);
                }
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            this.setMediaTime(this.timeAt(pp.x));
        }
        if (this.clearSelOnSingleClick && e.getClickCount() == 1 && !e.isShiftDown() && !this.popup.isShowing() && !this.getViewerManager().getMediaPlayerController().getSelectionMode()) {
            this.setSelection(0L, 0L);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            Point pp = e.getPoint();
            if (this.popup == null) {
                this.createPopupMenu();
            }
            this.updatePopupMenu();
            if (this.popup.getWidth() == 0 || this.popup.getHeight() == 0) {
                this.popup.show(this, pp.x, pp.y);
            } else {
                this.popup.show(this, pp.x, pp.y);
                SwingUtilities.convertPointToScreen(pp, this);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                Window w = SwingUtilities.windowForComponent(this);
                if (pp.x + this.popup.getWidth() > d.width) {
                    pp.x -= this.popup.getWidth();
                }
                if (pp.y + this.popup.getHeight() > d.height) {
                    pp.y -= this.popup.getHeight();
                }
                if (pp.y + this.popup.getHeight() > w.getLocationOnScreen().y + w.getHeight()) {
                    pp.y -= this.popup.getHeight();
                }
                this.popup.setLocation(pp);
            }
            return;
        }
        if (this.playerIsPlaying()) {
            this.stopPlayer();
        }
        this.dragStartPoint = e.getPoint();
        this.dragStartTime = this.timeAt(this.dragStartPoint.x);
        if (e.isAltDown() && this.dragStartPoint.y < this.rulerHeight) {
            this.panMode = true;
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.panMode = false;
            this.stopScroll();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.stopScroll();
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(this.intervalBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        }
        if (this.panMode) {
            this.panMode = false;
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.stopScroll();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.dragEndPoint = e.getPoint();
        if (this.panMode) {
            int scrolldiff = this.dragEndPoint.x - this.dragStartPoint.x;
            long newTime = this.intervalBeginTime - (long)((int)((float)scrolldiff * this.msPerPixel));
            this.setIntervalBeginTime(newTime < -this.mediaOffset ? -this.mediaOffset : newTime);
            this.dragStartPoint = this.dragEndPoint;
            return;
        }
        Point viewDragEndPoint = this.dragEndPoint;
        if (this.viewPortMode) {
            viewDragEndPoint = this.toPixelCoordinates(this.dragEndPoint);
        }
        if (viewDragEndPoint.x <= 0 || viewDragEndPoint.x >= this.getViewWidth()) {
            this.stopScroll();
            return;
        }
        if (viewDragEndPoint.x < 16 && viewDragEndPoint.x > 0) {
            if (this.scroller == null) {
                if (viewDragEndPoint.x < 16 && viewDragEndPoint.x > 0 && this.getSelectionBeginTime() == this.getSelectionEndTime()) {
                    this.setSelection(this.dragStartTime, this.dragStartTime);
                }
                this.stopScrolling = false;
                this.scroller = new DragScroller(-4, this.dragScrollSleepTime);
                this.scroller.start();
            }
            return;
        }
        if (viewDragEndPoint.x > this.getViewWidth() - 16 && viewDragEndPoint.x < this.getViewWidth()) {
            if (this.scroller == null) {
                if (viewDragEndPoint.x > this.getViewWidth() - 16 && viewDragEndPoint.x < this.getViewWidth() && this.getSelectionBeginTime() == this.getSelectionEndTime()) {
                    this.setSelection(this.dragStartTime, this.dragStartTime);
                }
                this.stopScrolling = false;
                this.scroller = new DragScroller(4, this.dragScrollSleepTime);
                this.scroller.start();
            }
            return;
        }
        this.stopScroll();
        if (this.timeAt(this.dragEndPoint.x) > this.dragStartTime) {
            this.selectionEndTime = this.timeAt(this.dragEndPoint.x);
            if (this.samp != null && (float)this.selectionEndTime > this.samp.getDuration()) {
                this.selectionEndTime = (long)this.samp.getDuration();
            }
            this.selectionBeginTime = this.dragStartTime;
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            if (this.selectionEndTime < 0L) {
                this.selectionEndTime = 0L;
            }
            this.setMediaTime(this.selectionEndTime);
        } else {
            this.selectionBeginTime = this.timeAt(this.dragEndPoint.x);
            if (this.samp != null && (float)this.selectionBeginTime > this.samp.getDuration()) {
                this.selectionBeginTime = (long)this.samp.getDuration();
            }
            this.selectionEndTime = this.dragStartTime;
            if (this.samp != null && (float)this.selectionEndTime > this.samp.getDuration()) {
                this.selectionEndTime = (long)this.samp.getDuration();
            }
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            if (this.selectionEndTime < 0L) {
                this.selectionEndTime = 0L;
            }
            this.setMediaTime(this.selectionBeginTime);
        }
        this.setSelection(this.selectionBeginTime, this.selectionEndTime);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getPoint().y <= this.rulerHeight) {
            this.setToolTipText(TimeFormatter.toString(this.timeAt(e.getPoint().x)));
        } else if (e.getPoint().x >= this.selectionBeginPos && e.getPoint().x <= this.selectionEndPos) {
            StringBuilder sb = new StringBuilder("<html><table><tr><td>");
            sb.append(ElanLocale.getString("MediaPlayerControlPanel.Selectionpanel.Name"));
            sb.append(":</td><td>").append(TimeFormatter.toString(this.getSelectionBeginTime())).append(" - ");
            sb.append(TimeFormatter.toString(this.getSelectionEndTime())).append("</td></tr><tr><td>");
            sb.append(ElanLocale.getString("Frame.GridFrame.ColumnDuration")).append(":</td><td>");
            sb.append(TimeFormatter.toString(this.getSelectionEndTime() - this.getSelectionBeginTime()));
            sb.append("</td></tr></table></html>");
            this.setToolTipText(sb.toString());
        } else {
            this.setToolTipText(null);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() == 0) {
            return;
        }
        if (e.isControlDown()) {
            if (e.getUnitsToScroll() > 0) {
                this.zoomOut();
            } else {
                this.zoomIn();
            }
            return;
        }
        if (e.isShiftDown()) {
            int timeDiff;
            long newTime;
            if (e.getWheelRotation() != 0 && (newTime = this.intervalBeginTime + (long)(timeDiff = (int)((float)(this.horScrollSpeed * e.getWheelRotation()) * this.msPerPixel))) != this.intervalBeginTime && (this.intervalBeginTime >= 0L || newTime >= this.intervalBeginTime)) {
                this.setIntervalBeginTime(newTime);
            }
            return;
        }
    }

    @Override
    public void magnify(double zoom) {
        if (zoom > 0.0) {
            this.zoomIn();
        } else if (zoom < 0.0) {
            this.zoomOut();
        }
    }

    @Override
    public void swipe(int x, int y) {
        long newTime;
        if (x != 0 && (newTime = this.intervalBeginTime + (long)((float)x * this.msPerPixel)) != this.intervalBeginTime && (newTime >= 0L || newTime >= this.intervalBeginTime)) {
            this.setIntervalBeginTime(newTime);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.timeRulerVisMI) {
            this.timeRulerVisible = this.timeRulerVisMI.isSelected();
            this.rulerHeight = this.timeRulerVisible ? this.ruler.getHeight() : 0;
            this.paintBuffer();
            if (this.getViewerManager() != null) {
                this.setPreference("SignalViewer.TimeRulerVisible", this.timeRulerVisible, this.getViewerManager().getTranscription());
            }
        } else if (e.getActionCommand().equals("connect")) {
            boolean connected = ((JCheckBoxMenuItem)e.getSource()).getState();
            this.setTimeScaleConnected(connected);
            if (this.getViewerManager() != null) {
                this.setPreference("SignalViewer.TimeScaleConnected", connected, this.getViewerManager().getTranscription());
            }
        } else if (e.getActionCommand().equals("sep")) {
            this.setChannelMode(1, true);
        } else if (e.getActionCommand().equals("merge")) {
            this.setChannelMode(2, true);
        } else if (e.getActionCommand().equals("blend")) {
            this.setChannelMode(3, true);
        } else if (e.getActionCommand().equals("praat")) {
            this.openInPraat(0L, 0L);
        } else if (e.getActionCommand().equals("praatSel")) {
            this.openSelectionInPraat();
        } else if (e.getActionCommand().equals("clipSel")) {
            this.clipSelectionWithPraat();
        } else if (e.getActionCommand().equals("clipSelJS")) {
            this.clipSelectionWithJavaSound();
        } else if (e.getActionCommand().equals("info")) {
            this.showMediaInfo();
        } else if (e.getActionCommand().startsWith("vz-")) {
            int nvz = 100;
            String vzVal = e.getActionCommand().substring(3);
            try {
                nvz = Integer.parseInt(vzVal);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Error parsing the vertical zoom level");
            }
            this.vertZoom = nvz;
            this.paintBuffer();
            if (this.getViewerManager() != null) {
                this.setPreference("SignalViewer.VerticalZoomLevel", this.vertZoom, this.getViewerManager().getTranscription());
            }
        } else if (e.getSource() == this.zoomSelectionMI) {
            this.zoomToSelection();
        } else if (e.getSource() == this.zoomToEntireMediaMI) {
            this.zoomToShowEntireMedia();
        } else if (e.getSource() == this.segmentationChannel1Item) {
            this.showSegmentationChannel1 = this.segmentationChannel1Item.getState();
            this.paintBuffer();
        } else if (e.getSource() == this.segmentationChannel2Item) {
            this.showSegmentationChannel2 = this.segmentationChannel2Item.getState();
            this.paintBuffer();
        } else if (e.getSource() == this.copyOrigTimeItem) {
            long t = this.getMediaTime() + this.mediaOffset;
            String timeFormat = Preferences.getString("CurrentTime.Copy.TimeFormat", null);
            String currentTime = null;
            currentTime = timeFormat != null ? (timeFormat.equals("hh:mm:ss.ms") ? TimeFormatter.toString(t) : (timeFormat.equals("ss.ms") ? TimeFormatter.toSSMSString(t) : (timeFormat.equals("NTSC") ? TimeFormatter.toTimecodeNTSC(t) : (timeFormat.equals("PAL") ? TimeFormatter.toTimecodePAL(t) : (timeFormat.equals("PAL-50fps") ? TimeFormatter.toTimecodePAL50(t) : Long.toString(t)))))) : Long.toString(t);
            this.copyToClipboard(currentTime);
        } else {
            String zoomString = e.getActionCommand();
            int zoom = 100;
            try {
                zoom = Integer.parseInt(zoomString);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing the zoom level");
            }
            float newMsPerPixel = 100.0f / (float)zoom * 10.0f;
            this.setMsPerPixel(newMsPerPixel);
        }
    }

    @Override
    public void preferencesChanged() {
        Integer intPref;
        Boolean boolPref;
        Boolean rulerVis;
        Boolean tsConnect;
        Float zoomLevel = Preferences.getFloat("SignalViewer.ZoomLevel", this.getViewerManager().getTranscription());
        if (zoomLevel != null) {
            float zl = zoomLevel.floatValue();
            if ((double)zl > 5000.0) {
                zl = 5000.0f;
            }
            float newMsPerPixel = 100.0f / zl * 10.0f;
            this.setMsPerPixel(newMsPerPixel);
        }
        if ((tsConnect = Preferences.getBool("SignalViewer.TimeScaleConnected", this.getViewerManager().getTranscription())) != null) {
            if (this.timeScaleConMI != null) {
                this.timeScaleConMI.setSelected(tsConnect);
            }
            this.setTimeScaleConnected(tsConnect);
        }
        this.updateChannelModePopUpMenu();
        Integer vzLevel = Preferences.getInt("SignalViewer.VerticalZoomLevel", this.getViewerManager().getTranscription());
        if (vzLevel != null) {
            this.vertZoom = vzLevel;
            this.updateVertZoomPopup(this.vertZoom);
        }
        if ((rulerVis = Preferences.getBool("SignalViewer.TimeRulerVisible", this.getViewerManager().getTranscription())) != null) {
            this.timeRulerVisible = rulerVis;
            if (this.timeRulerVisMI != null) {
                this.timeRulerVisMI.setSelected(this.timeRulerVisible);
            }
            this.rulerHeight = this.timeRulerVisible ? this.ruler.getHeight() : 0;
        }
        if ((boolPref = Preferences.getBool("ClearSelectionOnSingleClick", null)) != null) {
            this.clearSelOnSingleClick = boolPref;
        }
        if ((intPref = Preferences.getInt("Preferences.TimeLine.HorScrollSpeed", null)) != null) {
            this.horScrollSpeed = intPref;
        }
        boolPref = Preferences.getBool("UI.UseBufferedPainting", null);
        if (!SystemReporting.isBufferedPaintingPropertySet && boolPref != null) {
            this.useBufferedImage = boolPref;
        }
        this.paintBuffer();
    }

    @Override
    public void zoomInStep() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        if (zoom >= (float)this.ZOOMLEVELS[this.ZOOMLEVELS.length - 1]) {
            return;
        }
        int zoomMenuIndex = -1;
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            if (zoom < (float)this.ZOOMLEVELS[i]) {
                zoomMenuIndex = i;
                break;
            }
            if (zoom != (float)this.ZOOMLEVELS[i]) continue;
            zoomMenuIndex = i + 1;
        }
        if (zoomMenuIndex >= 0 && zoomMenuIndex < this.ZOOMLEVELS.length) {
            int nextZoom = this.ZOOMLEVELS[zoomMenuIndex];
            float nextMsPerPixel = 100.0f / (float)nextZoom * 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }

    @Override
    public void zoomOutStep() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        if (zoom <= (float)this.ZOOMLEVELS[0]) {
            return;
        }
        int zoomMenuIndex = -1;
        for (int i = this.ZOOMLEVELS.length - 1; i >= 0; --i) {
            if (zoom > (float)this.ZOOMLEVELS[i]) {
                zoomMenuIndex = i;
                break;
            }
            if (zoom != (float)this.ZOOMLEVELS[i]) continue;
            zoomMenuIndex = i - 1;
        }
        if (zoomMenuIndex >= 0 && zoomMenuIndex < this.ZOOMLEVELS.length) {
            int nextZoom = this.ZOOMLEVELS[zoomMenuIndex];
            float nextMsPerPixel = 100.0f / (float)nextZoom * 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }

    @Override
    public void zoomToDefault() {
        if ((int)this.msPerPixel != 10) {
            int nextZoom = 100;
            float nextMsPerPixel = 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.viewPortMode) {
            return new Dimension((int)((float)(this.getMediaDuration() - this.mediaOffset) / this.msPerPixel) + this.getViewWidth() / 2, this.getViewHeight());
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return 0;
        }
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return 0;
        }
        if (this.viewPort != null) {
            return this.viewPort.getExtentSize().width;
        }
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getParent() instanceof JViewport) {
            this.viewPort = (JViewport)this.getParent();
            this.viewPortListener = new ViewPortChangeListener();
            this.viewPort.addChangeListener(this.viewPortListener);
            this.viewPortMode = true;
            this.revalidate();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.viewPort != null) {
            this.viewPort.removeChangeListener(this.viewPortListener);
        }
    }

    public void finalize() {
        if (this.samp != null) {
            this.samp.close();
        }
    }

    synchronized void scroll(int numPixels) {
        long begin = this.intervalBeginTime + (long)((int)((float)numPixels * this.msPerPixel));
        if (numPixels > 0) {
            this.setIntervalBeginTime(begin);
            this.selectionEndTime = this.getSelectionEndTime() + (long)((int)((float)numPixels * this.msPerPixel));
            if (this.samp != null && (float)this.selectionEndTime > this.samp.getDuration()) {
                this.selectionEndTime = (long)this.samp.getDuration();
            }
            this.setMediaTime(this.selectionEndTime);
            this.setSelection(this.getSelectionBeginTime(), this.selectionEndTime);
        } else {
            if (begin < 0L) {
                begin = 0L;
            }
            this.setIntervalBeginTime(begin);
            this.selectionBeginTime = this.getSelectionBeginTime() + (long)((int)((float)numPixels * this.msPerPixel));
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            this.setMediaTime(this.selectionBeginTime);
            this.setSelection(this.selectionBeginTime, this.getSelectionEndTime());
        }
    }

    void stopScroll() {
        this.stopScrolling = true;
        this.scroller = null;
    }

    class DragScroller
    extends Thread {
        int numPixels;
        long sleepTime;

        DragScroller(int numPixels, long sleepTime) {
            this.numPixels = numPixels;
            this.sleepTime = sleepTime;
        }

        @Override
        public void run() {
            while (!SignalViewer.this.stopScrolling) {
                SignalViewer.this.scroll(this.numPixels);
                try {
                    DragScroller.sleep(this.sleepTime);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    private class ViewPortChangeListener
    implements ChangeListener {
        private boolean enabled = true;

        private ViewPortChangeListener() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!this.enabled) {
                return;
            }
            if (e.getSource() == SignalViewer.this.viewPort) {
                SignalViewer.this.imageWidth = ((SignalViewer)SignalViewer.this).viewPort.getExtentSize().width;
                SignalViewer.this.imageHeight = ((SignalViewer)SignalViewer.this).viewPort.getExtentSize().height;
                this.enabled = false;
                SignalViewer.this.setIntervalBeginTime(SignalViewer.this.timeAt(((SignalViewer)SignalViewer.this).viewPort.getViewPosition().x));
                this.enabled = true;
                SignalViewer.this.repaint();
            }
        }
    }
}

