/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.InlineEditBox;
import mpi.eudico.client.annotator.spellcheck.SpellChecker;
import mpi.eudico.client.annotator.spellcheck.SpellCheckerRegistry;
import mpi.eudico.client.annotator.spellcheck.SpellCheckerUtil;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.client.annotator.viewer.StyledHighlightPainter;
import mpi.eudico.client.annotator.viewer.ValueHighlightPainter;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.Pair;

public class TextViewer
extends AbstractViewer
implements SingleTierViewer,
ACMEditListener,
ActionListener {
    private JMenu fontMenu;
    private ButtonGroup fontSizeBG;
    private int fontSize;
    private JPopupMenu popup;
    private JMenuItem centerMI;
    private JTextArea taText;
    private JScrollPane jspText;
    private TierImpl tier;
    private List<? extends Annotation> annotations = new ArrayList<Annotation>();
    private long begintime = 0L;
    private long endtime = 0L;
    private long[] arrTagTimes;
    private int[] arrTagPositions;
    private String tierText = "";
    private Highlighter highlighter;
    private StyledHighlightPainter selectionPainter;
    private StyledHighlightPainter currentPainter;
    private StyledHighlightPainter activeAnnotationPainter;
    private StyledHighlightPainter spellingErrorPainter;
    private ValueHighlightPainter valuePainter;
    private Object selectionHighLightInfo;
    private Object currentHighLightInfo;
    private List<Object> spellingErrorHighLightInfos;
    private Object activeHighLightInfo;
    private List<Object> valueHighLightInfos;
    private int indexActiveAnnotationBegin = 0;
    private int indexActiveAnnotationEnd = 0;
    private int indexSelectionBegin = 0;
    private int indexSelectionEnd = 0;
    private int indexMediaTime = 0;
    private boolean bVisDotted = true;
    private int extraLength = 4;
    private boolean centerVertically = true;
    private final Color transparent = new Color(Constants.SELECTIONCOLOR.getRed(), Constants.SELECTIONCOLOR.getGreen(), Constants.SELECTIONCOLOR.getBlue(), 0);
    private boolean enterCommits = true;
    private final String DOTS = "  \u00b7  ";
    private String tierLanguageRef;
    private SwingWorker<Void, Void> worker = null;

    public TextViewer() {
        try {
            this.setLayout(new BorderLayout());
            this.taText = new JTextArea(4, 10){

                @Override
                protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                    return false;
                }
            };
            this.taText.setFont(Constants.DEFAULTFONT);
            this.fontSize = 12;
            this.taText.setLineWrap(true);
            this.taText.setWrapStyleWord(true);
            this.taText.setForeground(Constants.DEFAULTFOREGROUNDCOLOR);
            this.taText.setEditable(false);
            this.taText.addMouseListener(new TextViewerMouseListener(this.taText));
            this.taText.addMouseMotionListener(new TextViewerMouseMotionListener());
            this.taText.getCaret().setSelectionVisible(false);
            this.taText.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.taText.setSelectionColor(this.taText.getBackground());
            this.highlighter = this.taText.getHighlighter();
            this.selectionPainter = new StyledHighlightPainter(Constants.SELECTIONCOLOR, 1, 1);
            this.selectionPainter.setVisible(false);
            this.currentPainter = new StyledHighlightPainter(Constants.CROSSHAIRCOLOR, 0);
            this.currentPainter.setVisible(false);
            this.spellingErrorPainter = new StyledHighlightPainter(Color.RED, 0, 2);
            this.spellingErrorPainter.setVisible(false);
            this.activeAnnotationPainter = new StyledHighlightPainter(Constants.ACTIVEANNOTATIONCOLOR, 1);
            this.activeAnnotationPainter.setVisible(false);
            this.valuePainter = new ValueHighlightPainter(null, 0);
            this.valuePainter.setVisible(false);
            this.valueHighLightInfos = new ArrayList<Object>();
            this.currentHighLightInfo = this.highlighter.addHighlight(0, 0, this.currentPainter);
            this.spellingErrorHighLightInfos = new ArrayList<Object>();
            this.activeHighLightInfo = this.highlighter.addHighlight(0, 0, this.activeAnnotationPainter);
            this.selectionHighLightInfo = this.highlighter.addHighlight(0, 0, this.selectionPainter);
            this.highlighter.addHighlight(0, 0, this.valuePainter);
            this.jspText = new JScrollPane(this.taText);
            this.jspText.setHorizontalScrollBarPolicy(31);
            this.jspText.setVerticalScrollBarPolicy(20);
            this.add((Component)this.jspText, "Center");
            this.addComponentListener(new TextViewerComponentListener());
            this.setVisible(true);
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Exception while setting up the TextViewer: " + ex.getMessage());
        }
    }

    @Override
    public void updateSelection() {
        this.doUpdate();
    }

    @Override
    public void updateActiveAnnotation() {
        this.doUpdate();
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        if (this.tier == null) {
            return;
        }
        switch (e.getOperation()) {
            case 3: 
            case 4: 
            case 5: {
                Tier t;
                if (!(e.getInvalidatedObject() instanceof TierImpl) || (t = (Tier)e.getInvalidatedObject()) != this.tier && !this.tier.hasAncestor(t)) break;
                this.updateAnnotations();
                break;
            }
            case 8: {
                Tier invTier;
                if (!(e.getInvalidatedObject() instanceof Annotation) || (invTier = ((Annotation)e.getInvalidatedObject()).getTier()) != this.tier) break;
                this.updateAnnotations();
                break;
            }
            case 6: 
            case 7: 
            case 14: {
                this.setTier(this.getTier());
                if (this.tier == null) break;
                this.doUpdate();
            }
        }
    }

    @Override
    public void updateLocale() {
        this.createPopup();
    }

    private void createPopup() {
        this.popup = new JPopupMenu("");
        this.fontSizeBG = new ButtonGroup();
        this.fontMenu = new JMenu(ElanLocale.getString("Menu.View.FontSize"));
        for (int element : Constants.FONT_SIZES) {
            JRadioButtonMenuItem fontRB = new JRadioButtonMenuItem(String.valueOf(element));
            fontRB.setActionCommand("font" + element);
            if (this.fontSize == element) {
                fontRB.setSelected(true);
            }
            fontRB.addActionListener(this);
            this.fontSizeBG.add(fontRB);
            this.fontMenu.add(fontRB);
        }
        this.popup.add(this.fontMenu);
        this.popup.addSeparator();
        JMenuItem menuItem = new JMenuItem(ElanLocale.getString("TextViewer.ToggleVisualization"));
        menuItem.setActionCommand("TOGGLEVISUALIZATION");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.centerMI = new JCheckBoxMenuItem(ElanLocale.getString("TextViewer.CenterVertical"));
        this.centerMI.setSelected(this.centerVertically);
        this.centerMI.setActionCommand("centerVert");
        this.centerMI.addActionListener(this);
        this.popup.add(this.centerMI);
        this.popup.addSeparator();
        JMenuItem copyItem = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        copyItem.setActionCommand("copy");
        copyItem.addActionListener(this);
        this.popup.add(copyItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String strAction = e.getActionCommand();
        if (strAction.indexOf("font") != -1) {
            int index = strAction.indexOf("font") + 4;
            try {
                this.fontSize = Integer.parseInt(strAction.substring(index));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.taText.setFont(this.taText.getFont().deriveFont((float)this.fontSize));
            this.setPreference("TextViewer.FontSize", this.fontSize, this.getViewerManager().getTranscription());
        } else if (strAction.equals("TOGGLEVISUALIZATION")) {
            this.bVisDotted = !this.bVisDotted;
            this.extraLength = this.bVisDotted ? 4 : 0;
            this.setPreference("TextViewer.DotSeparated", this.bVisDotted, this.getViewerManager().getTranscription());
            this.setTier(this.getTier());
        } else if (strAction == "centerVert") {
            this.setCenteredVertically(this.centerMI.isSelected());
            this.setPreference("TextViewer.CenterVertical", this.centerVertically, this.getViewerManager().getTranscription());
        } else if (strAction.equals("copy")) {
            this.taText.copy();
        }
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextViewer.this.doUpdate();
            }
        });
    }

    @Override
    public void preferencesChanged() {
        Object cvPrefs;
        Boolean vertCent;
        Boolean dotSep;
        Integer fontSi = Preferences.getInt("TextViewer.FontSize", this.getViewerManager().getTranscription());
        if (fontSi != null) {
            this.setFontSize(fontSi);
        }
        if ((dotSep = Preferences.getBool("TextViewer.DotSeparated", this.getViewerManager().getTranscription())) != null) {
            this.setDotSeparated(dotSep);
        }
        if ((vertCent = Preferences.getBool("TextViewer.CenterVertical", this.getViewerManager().getTranscription())) != null) {
            this.setCenteredVertically(vertCent);
        }
        this.loadFont(this.tier);
        Boolean boolPref = Preferences.getBool("InlineEdit.EnterCommits", null);
        if (boolPref != null) {
            this.enterCommits = boolPref;
        }
        if (this.tier != null && (cvPrefs = Preferences.get("CV.ML.Prefs", this.tier.getTranscription())) != null && this.tier.getLinguisticType().getControlledVocabularyName() != null) {
            this.setTier(this.tier);
        }
        this.paintSpellErrorUnderline();
    }

    private void loadFont(Tier tier) {
        if (tier != null) {
            Map<String, Font> fonts = Preferences.getMapOfFont("TierFonts", this.getViewerManager().getTranscription());
            if (fonts != null) {
                Font tf = fonts.get(tier.getName());
                if (tf != null) {
                    this.taText.setFont(new Font(tf.getName(), 0, this.fontSize));
                } else {
                    this.taText.setFont(Constants.DEFAULTFONT.deriveFont((float)this.fontSize));
                }
            }
        } else {
            this.taText.setFont(Constants.DEFAULTFONT.deriveFont((float)this.fontSize));
        }
    }

    private void scrollIfNeeded() {
        try {
            Highlighter.Highlight[] h_arr;
            for (Highlighter.Highlight element : h_arr = this.highlighter.getHighlights()) {
                if (element.getPainter() != this.currentPainter) continue;
                int idx = element.getStartOffset();
                int ide = element.getEndOffset();
                Rectangle rect = this.taText.modelToView(idx);
                Rectangle endRect = this.taText.modelToView(ide);
                if (rect == null || endRect == null) {
                    return;
                }
                Rectangle union = rect.union(endRect);
                if (this.centerVertically) {
                    int restY = this.jspText.getViewport().getHeight() - union.height;
                    union.y -= restY / 2;
                    if (union.y < 0) {
                        union.y = 0;
                    }
                    union.height = union.height + restY + 1;
                    this.taText.scrollRectToVisible(union);
                } else {
                    this.taText.scrollRectToVisible(union);
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int getIndexBegin(int index, long beginTime) {
        int retIndex = -1;
        for (int j = -2; j <= 2; ++j) {
            int indexj = index + j;
            if (indexj < 0 || indexj >= this.arrTagTimes.length || this.arrTagTimes[indexj] > beginTime) continue;
            retIndex = indexj;
        }
        if (retIndex == -1) {
            return index;
        }
        return retIndex;
    }

    private int getIndexEnd(int index, long endTime) {
        int retIndex = -1;
        for (int j = 2; j >= -2; --j) {
            int indexj = index + j;
            if (indexj < 0 || indexj >= this.arrTagTimes.length || this.arrTagTimes[indexj] < endTime) continue;
            retIndex = indexj;
        }
        if (retIndex == -1) {
            return index;
        }
        return retIndex;
    }

    public void doUpdate() {
        block37: {
            Dimension dim = this.getSize();
            if (dim.height <= 0 || dim.width <= 0) {
                return;
            }
            if (this.arrTagTimes == null) {
                return;
            }
            if (this.arrTagTimes.length == 0) {
                this.repaint();
                return;
            }
            long mediatime = this.getMediaTime();
            int indexj = 0;
            int index = 0;
            long activeAnnotationBeginTime = 0L;
            long activeAnnotationEndTime = 0L;
            this.indexActiveAnnotationBegin = 0;
            this.indexActiveAnnotationEnd = 0;
            long selectionBeginTime = this.getSelectionBeginTime();
            long selectionEndTime = this.getSelectionEndTime();
            boolean selBTBetween = false;
            boolean selETBetween = false;
            Annotation activeAnnotation = this.getActiveAnnotation();
            if (activeAnnotation != null && activeAnnotation.getTier() == this.tier) {
                activeAnnotationBeginTime = activeAnnotation.getBeginTimeBoundary();
                activeAnnotationEndTime = activeAnnotation.getEndTimeBoundary();
            }
            try {
                if (activeAnnotation != null && activeAnnotation.getTier() == this.tier) {
                    index = Math.abs(Arrays.binarySearch(this.arrTagTimes, activeAnnotationBeginTime));
                    this.indexActiveAnnotationBegin = this.getIndexBegin(index, activeAnnotationBeginTime);
                    index = Math.abs(Arrays.binarySearch(this.arrTagTimes, activeAnnotationEndTime));
                    this.indexActiveAnnotationEnd = this.getIndexEnd(index, activeAnnotationEndTime);
                }
                if (selectionBeginTime == 0L && selectionEndTime == 0L) {
                    this.indexSelectionBegin = 0;
                    this.indexSelectionEnd = 0;
                } else {
                    int bindex = Arrays.binarySearch(this.arrTagTimes, selectionBeginTime);
                    selBTBetween = bindex < 0 && bindex % 2 != 0;
                    index = bindex == -1 ? 0 : Math.abs(bindex);
                    this.indexSelectionBegin = this.getIndexBegin(index, selectionBeginTime);
                    int eindex = Arrays.binarySearch(this.arrTagTimes, selectionEndTime);
                    selETBetween = eindex < 0 && eindex % 2 != 0;
                    index = Math.abs(eindex);
                    this.indexSelectionEnd = this.getIndexEnd(index, selectionEndTime);
                    if (this.indexSelectionEnd >= this.arrTagPositions.length) {
                        this.indexSelectionEnd = this.arrTagPositions.length - 1;
                    }
                }
                int insIndex = Arrays.binarySearch(this.arrTagTimes, mediatime);
                boolean cursBetweenAnn = insIndex < 0 && insIndex % 2 != 0;
                index = Math.abs(insIndex);
                for (int j = -2; j <= 2; ++j) {
                    indexj = index + j;
                    if (indexj < 0 && index != 0) {
                        this.indexMediaTime = -1;
                        break;
                    }
                    if (indexj < 0 || indexj >= this.arrTagTimes.length || this.arrTagTimes[indexj] > mediatime) continue;
                    this.indexMediaTime = indexj;
                }
                try {
                    if (this.indexMediaTime >= 0 && this.indexMediaTime + 1 < this.arrTagPositions.length) {
                        this.currentPainter.setVisible(true);
                        if (!this.bVisDotted) {
                            this.highlighter.changeHighlight(this.currentHighLightInfo, this.arrTagPositions[this.indexMediaTime], this.arrTagPositions[this.indexMediaTime + 1]);
                        } else if (!cursBetweenAnn && this.indexMediaTime % 2 == 0) {
                            this.highlighter.changeHighlight(this.currentHighLightInfo, this.arrTagPositions[this.indexMediaTime], this.arrTagPositions[this.indexMediaTime + 1] - this.extraLength);
                        } else {
                            this.highlighter.changeHighlight(this.currentHighLightInfo, this.arrTagPositions[this.indexMediaTime] - (this.extraLength / 2 + 1), this.arrTagPositions[this.indexMediaTime + 1] - 2);
                        }
                    } else if (this.indexMediaTime == this.arrTagPositions.length - 1 && this.bVisDotted) {
                        this.currentPainter.setVisible(true);
                        this.highlighter.changeHighlight(this.currentHighLightInfo, this.arrTagPositions[this.indexMediaTime] - (this.extraLength / 2 + 1), this.arrTagPositions[this.indexMediaTime] - 1);
                    } else {
                        this.currentPainter.setVisible(false);
                        if (this.indexMediaTime < 0 && this.arrTagPositions.length > 1) {
                            this.highlighter.changeHighlight(this.currentHighLightInfo, this.arrTagPositions[0], this.arrTagPositions[1]);
                        } else if (this.indexMediaTime + 1 >= this.arrTagPositions.length && this.arrTagPositions.length > 1) {
                            this.highlighter.changeHighlight(this.currentHighLightInfo, this.arrTagPositions[this.arrTagPositions.length - 2], this.arrTagPositions[this.arrTagPositions.length - 1]);
                        }
                    }
                }
                catch (BadLocationException ble) {
                    ClientLogger.LOG.warning("Error media position highlight: " + ble.getMessage());
                    this.currentPainter.setVisible(false);
                }
                try {
                    if (this.indexActiveAnnotationBegin >= 0 && this.indexActiveAnnotationBegin < this.arrTagPositions.length && this.indexActiveAnnotationEnd >= 0 && this.indexActiveAnnotationEnd < this.arrTagPositions.length) {
                        if (activeAnnotation != null && activeAnnotation.getTier() == this.tier) {
                            this.activeAnnotationPainter.setVisible(true);
                            this.highlighter.changeHighlight(this.activeHighLightInfo, this.arrTagPositions[this.indexActiveAnnotationBegin], this.arrTagPositions[this.indexActiveAnnotationEnd] - this.extraLength);
                        } else {
                            this.activeAnnotationPainter.setVisible(false);
                        }
                    } else {
                        this.activeAnnotationPainter.setVisible(false);
                    }
                }
                catch (BadLocationException ble) {
                    ClientLogger.LOG.warning("Error active annotation highlight: " + ble.getMessage());
                    this.activeAnnotationPainter.setVisible(false);
                }
                try {
                    if (this.indexSelectionBegin >= 0 && this.indexSelectionBegin < this.arrTagPositions.length && this.indexSelectionEnd > 0 && this.indexSelectionEnd < this.arrTagPositions.length) {
                        this.selectionPainter.setVisible(true);
                        if (this.bVisDotted) {
                            int btPos = this.arrTagPositions[this.indexSelectionBegin];
                            if (selBTBetween && btPos > this.extraLength / 2) {
                                btPos = btPos - this.extraLength / 2 - 1;
                            }
                            int etPos = this.arrTagPositions[this.indexSelectionEnd];
                            etPos = selETBetween ? etPos - this.extraLength / 2 + 1 : (etPos -= this.extraLength);
                            etPos = etPos > btPos ? etPos : btPos + 1;
                            this.highlighter.changeHighlight(this.selectionHighLightInfo, btPos, etPos);
                        } else {
                            this.highlighter.changeHighlight(this.selectionHighLightInfo, this.arrTagPositions[this.indexSelectionBegin], Math.max(this.arrTagPositions[this.indexSelectionBegin] + 1, this.arrTagPositions[this.indexSelectionEnd]));
                        }
                        break block37;
                    }
                    this.selectionPainter.setVisible(false);
                }
                catch (BadLocationException ble) {
                    ClientLogger.LOG.warning("Error interval selection highlight: " + ble.getMessage());
                    this.selectionPainter.setVisible(false);
                }
            }
            catch (Exception ex) {
                ClientLogger.LOG.warning("Update error: " + ex.getMessage());
            }
        }
        this.scrollIfNeeded();
        this.repaint();
    }

    private void updateAnnotations() {
        Map<Integer, Color> cm;
        this.annotations = this.tier.getAnnotations();
        for (Object obj : this.valueHighLightInfos) {
            this.highlighter.removeHighlight(obj);
        }
        this.valueHighLightInfos.clear();
        this.buildArrayAndText();
        this.taText.setText(this.tierText);
        if (this.valueHighLightInfos.size() > 0 && (cm = this.valuePainter.getColors()) != null) {
            ArrayList<Integer> kl = new ArrayList<Integer>(cm.keySet());
            Collections.sort(kl);
            if (kl.size() == this.valueHighLightInfos.size()) {
                int j = 0;
                int pos = 0;
                block3: for (int i = 0; i < kl.size(); ++i) {
                    pos = kl.get(i);
                    while (j < this.arrTagPositions.length - 1) {
                        if (this.arrTagPositions[j] == pos) {
                            try {
                                this.highlighter.changeHighlight(this.valueHighLightInfos.get(i), pos, this.arrTagPositions[j + 1] - this.extraLength);
                                ++j;
                            }
                            catch (BadLocationException ble) {
                                ClientLogger.LOG.warning("Error CV values highlight: " + ble.getMessage());
                            }
                            continue block3;
                        }
                        ++j;
                    }
                }
            }
        }
        this.paintSpellErrorUnderline();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextViewer.this.doUpdate();
            }
        });
    }

    private void paintSpellErrorUnderline() {
        if (this.worker != null && !this.worker.isDone()) {
            return;
        }
        this.worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                for (Object obj : TextViewer.this.spellingErrorHighLightInfos) {
                    TextViewer.this.highlighter.removeHighlight(obj);
                }
                TextViewer.this.spellingErrorHighLightInfos.clear();
                if (!SpellCheckerRegistry.getInstance().hasSpellCheckerLoaded(TextViewer.this.tierLanguageRef).booleanValue()) {
                    return null;
                }
                SpellChecker checker = SpellCheckerRegistry.getInstance().getSpellChecker(TextViewer.this.tierLanguageRef);
                for (int annIndex = 0; annIndex < TextViewer.this.annotations.size(); ++annIndex) {
                    Annotation ann = (Annotation)TextViewer.this.annotations.get(annIndex);
                    String annValue = ann.getValue();
                    List<Pair<String, List<String>>> suggestions = checker.getSuggestions(ann.getValue());
                    if (!SpellCheckerUtil.hasSuggestions(suggestions).booleanValue()) continue;
                    String[] annElements = annValue.split("\\b");
                    long annotationBeginTime = ann.getBeginTimeBoundary();
                    int indexAnnBegin = Math.abs(Arrays.binarySearch(TextViewer.this.arrTagTimes, annotationBeginTime));
                    if (TextViewer.this.arrTagTimes[indexAnnBegin + 1] == TextViewer.this.arrTagTimes[indexAnnBegin]) {
                        ++indexAnnBegin;
                    }
                    int indexWordBegin = 0;
                    int wordIndex = 0;
                    for (int elementIndex = 0; elementIndex < annElements.length; ++elementIndex) {
                        int elementLength = annElements[elementIndex].length();
                        if (annElements[elementIndex].matches(".*\\p{L}.*")) {
                            if (SpellCheckerUtil.isSuggestion(suggestions.get(wordIndex)).booleanValue()) {
                                int start = TextViewer.this.arrTagPositions[indexAnnBegin] + indexWordBegin;
                                int end = start + elementLength;
                                Object hl = TextViewer.this.highlighter.addHighlight(start, end, TextViewer.this.spellingErrorPainter);
                                TextViewer.this.spellingErrorHighLightInfos.add(hl);
                            }
                            ++wordIndex;
                        }
                        indexWordBegin += elementLength;
                    }
                }
                TextViewer.this.spellingErrorPainter.setVisible(true);
                return null;
            }

            @Override
            public void done() {
                TextViewer.this.repaint();
                TextViewer.this.validate();
            }
        };
        this.worker.execute();
    }

    @Override
    public void setTier(Tier tier) {
        Map<Integer, Color> cm;
        if (tier == null) {
            this.tier = null;
            this.annotations = new ArrayList<Annotation>();
            this.setPreference("TextViewer.TierName", tier, this.getViewerManager().getTranscription());
            this.taText.setFont(Constants.DEFAULTFONT.deriveFont((float)this.fontSize));
        } else {
            this.tier = (TierImpl)tier;
            try {
                this.annotations = this.tier.getAnnotations();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setPreference("TextViewer.TierName", tier.getName(), this.getViewerManager().getTranscription());
            this.loadFont(this.tier);
            this.tierLanguageRef = tier.getLangRef();
        }
        for (Object obj : this.valueHighLightInfos) {
            this.highlighter.removeHighlight(obj);
        }
        this.valueHighLightInfos.clear();
        this.buildArrayAndText();
        this.taText.setText(this.tierText);
        if (this.valueHighLightInfos.size() > 0 && (cm = this.valuePainter.getColors()) != null) {
            ArrayList<Integer> kl = new ArrayList<Integer>(cm.keySet());
            Collections.sort(kl);
            if (kl.size() == this.valueHighLightInfos.size()) {
                int j = 0;
                int pos = 0;
                block5: for (int i = 0; i < kl.size(); ++i) {
                    pos = kl.get(i);
                    while (j < this.arrTagPositions.length - 1) {
                        if (this.arrTagPositions[j] == pos) {
                            try {
                                this.highlighter.changeHighlight(this.valueHighLightInfos.get(i), pos, this.arrTagPositions[j + 1] - this.extraLength);
                                ++j;
                            }
                            catch (BadLocationException ble) {
                                ClientLogger.LOG.warning("Error CV values highlight after changing the tier: " + ble.getMessage());
                            }
                            continue block5;
                        }
                        ++j;
                    }
                }
            }
        }
        this.paintSpellErrorUnderline();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextViewer.this.doUpdate();
            }
        });
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        if (this.fontSizeBG != null) {
            Enumeration<AbstractButton> en = this.fontSizeBG.getElements();
            while (en.hasMoreElements()) {
                JMenuItem item = (JMenuItem)en.nextElement();
                String value = item.getText();
                try {
                    int v = Integer.parseInt(value);
                    if (v != this.fontSize) continue;
                    item.setSelected(true);
                    this.taText.setFont(this.taText.getFont().deriveFont((float)this.fontSize));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        } else {
            this.createPopup();
            this.taText.setFont(this.taText.getFont().deriveFont((float)this.fontSize));
        }
    }

    public boolean isDotSeparated() {
        return this.bVisDotted;
    }

    public void setDotSeparated(boolean dotted) {
        if (dotted != this.bVisDotted) {
            this.bVisDotted = dotted;
            this.extraLength = this.bVisDotted ? 4 : 0;
            this.setTier(this.getTier());
        }
    }

    public void setCenteredVertically(boolean centered) {
        this.centerVertically = centered;
        if (this.centerMI.isSelected() != this.centerVertically) {
            this.centerMI.setSelected(this.centerVertically);
        }
        this.scrollIfNeeded();
        this.repaint();
    }

    public boolean isCenteredVertically() {
        return this.centerVertically;
    }

    private void buildArrayAndText() {
        Object cvName;
        this.tierText = "";
        StringBuilder builder = new StringBuilder(256);
        int annotations_size = this.annotations.size();
        this.arrTagTimes = new long[2 * annotations_size];
        this.arrTagPositions = new int[2 * annotations_size];
        int arrIndexTimes = 0;
        int arrIndexPositions = 0;
        Color c = null;
        ControlledVocabulary cv = null;
        HashMap<Integer, Color> colors = null;
        if (this.tier != null && (cvName = this.tier.getLinguisticType().getControlledVocabularyName()) != null && (cv = this.tier.getTranscription().getControlledVocabulary((String)cvName)) != null) {
            colors = new HashMap<Integer, Color>();
        }
        try {
            for (Annotation annotation : this.annotations) {
                String id;
                CVEntry cve;
                String strTagValue = annotation.getValue();
                c = null;
                if (cv != null && (cve = cv.getEntrybyId(id = annotation.getCVEntryId())) != null) {
                    c = cve.getPrefColor();
                }
                strTagValue = strTagValue.replace('\n', ' ');
                if (this.bVisDotted) {
                    builder.append(strTagValue).append("  \u00b7  ");
                } else {
                    builder.append(strTagValue).append(' ');
                }
                this.begintime = annotation.getBeginTimeBoundary();
                this.endtime = annotation.getEndTimeBoundary();
                this.arrTagTimes[arrIndexTimes++] = this.begintime;
                this.arrTagTimes[arrIndexTimes++] = this.endtime;
                int taglength = strTagValue.length() + this.extraLength;
                if (arrIndexPositions == 0 || arrIndexPositions == 1) {
                    this.arrTagPositions[arrIndexPositions++] = 0;
                    this.arrTagPositions[arrIndexPositions++] = taglength;
                } else {
                    this.arrTagPositions[arrIndexPositions] = this.arrTagPositions[arrIndexPositions - 1] + 1;
                    this.arrTagPositions[++arrIndexPositions] = this.arrTagPositions[arrIndexPositions - 1] + taglength;
                    ++arrIndexPositions;
                }
                if (c == null) continue;
                colors.put(this.arrTagPositions[arrIndexPositions - 2], c);
                Object hl = this.highlighter.addHighlight(this.arrTagPositions[arrIndexPositions - 2], this.arrTagPositions[arrIndexPositions - 1] - this.extraLength, this.valuePainter);
                this.valueHighLightInfos.add(hl);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.valuePainter.setColors(colors);
        this.valuePainter.setVisible(colors != null && colors.size() > 0);
        this.tierText = builder.toString();
    }

    private class TextViewerComponentListener
    extends ComponentAdapter {
        private TextViewerComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            TextViewer.this.doUpdate();
        }
    }

    private class TextViewerMouseMotionListener
    extends MouseMotionAdapter {
        private TextViewerMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TextViewer.this.taText.setSelectionColor(Constants.SELECTIONCOLOR);
        }
    }

    private class TextViewerMouseListener
    extends MouseAdapter {
        private InlineEditBox inlineEditBox = null;
        private JComponent comp;

        public TextViewerMouseListener(JComponent c) {
            this.comp = c;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TextViewer.this.stopPlayer();
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                Point p = e.getPoint();
                SwingUtilities.convertPointToScreen(p, this.comp);
                int x = e.getPoint().x;
                int y = e.getPoint().y;
                TextViewer.this.popup.show(this.comp, x, y);
            }
        }

        private int getArrayIndex() {
            int index = -1;
            int annotations_size = TextViewer.this.annotations.size();
            for (int i = 0; i < annotations_size; ++i) {
                Annotation ann = (Annotation)TextViewer.this.annotations.get(i);
                if (TextViewer.this.getActiveAnnotation() == null || TextViewer.this.getActiveAnnotation().getBeginTimeBoundary() != ann.getBeginTimeBoundary()) continue;
                index = i;
                break;
            }
            return index;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                return;
            }
            int annotations_size = TextViewer.this.annotations.size();
            if (e.getClickCount() == 2) {
                if (this.inlineEditBox == null) {
                    this.inlineEditBox = new InlineEditBox(false);
                    this.inlineEditBox.setLocale(ElanLocale.getLocale());
                } else {
                    this.inlineEditBox.setEnterCommits(TextViewer.this.enterCommits);
                }
                int index = this.getArrayIndex();
                if (index >= 0 && index < annotations_size) {
                    Annotation annotation = (Annotation)TextViewer.this.annotations.get(index);
                    if (e.isShiftDown()) {
                        this.inlineEditBox.setAnnotation(annotation, true);
                    } else {
                        this.inlineEditBox.setAnnotation(annotation);
                    }
                    this.inlineEditBox.setFont(TextViewer.this.taText.getFont());
                    this.inlineEditBox.detachEditor();
                }
                return;
            }
            TextViewer.this.taText.setSelectionColor(TextViewer.this.transparent);
            if (!TextViewer.this.taText.getText().equals("")) {
                int j;
                int selectionStartPosition = TextViewer.this.taText.getSelectionStart();
                int selectionEndPosition = TextViewer.this.taText.getSelectionEnd();
                int indexSelectionStart = 0;
                int indexSelectionEnd = 0;
                int indexj = 0;
                int index = Math.abs(Arrays.binarySearch(TextViewer.this.arrTagPositions, selectionStartPosition));
                for (j = -2; j <= 2; ++j) {
                    indexj = index + j;
                    if (indexj < 0 || indexj >= TextViewer.this.arrTagPositions.length || TextViewer.this.arrTagPositions[indexj] > selectionStartPosition) continue;
                    indexSelectionStart = indexj;
                }
                if (selectionStartPosition == selectionEndPosition && indexSelectionStart + 1 < TextViewer.this.arrTagTimes.length) {
                    index = (int)Math.ceil(indexSelectionStart / 2);
                    if (index < annotations_size) {
                        Annotation ann = (Annotation)TextViewer.this.annotations.get(index);
                        TextViewer.this.setActiveAnnotation(ann);
                    } else {
                        TextViewer.this.setMediaTime(TextViewer.this.arrTagTimes[indexSelectionStart]);
                    }
                    return;
                }
                index = Math.abs(Arrays.binarySearch(TextViewer.this.arrTagPositions, selectionEndPosition));
                for (j = 2; j >= -2; --j) {
                    indexj = index + j;
                    if (indexj < 0 || indexj >= TextViewer.this.arrTagTimes.length || TextViewer.this.arrTagPositions[indexj] < selectionEndPosition) continue;
                    indexSelectionEnd = indexj;
                }
                int indexNewJ = indexj + 2 < TextViewer.this.arrTagTimes.length ? indexj + 2 : (indexj + 1 < TextViewer.this.arrTagTimes.length ? indexj + 1 : indexj);
                if (indexSelectionEnd == 0) {
                    indexSelectionEnd = indexNewJ;
                }
                if (indexSelectionStart < indexSelectionEnd && indexSelectionEnd < TextViewer.this.arrTagTimes.length) {
                    TextViewer.this.setSelection(TextViewer.this.arrTagTimes[indexSelectionStart], TextViewer.this.arrTagTimes[indexSelectionEnd]);
                    TextViewer.this.setMediaTime(TextViewer.this.arrTagTimes[indexSelectionStart]);
                }
            }
        }
    }
}

