/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class WavePart {
    public static final int GENERAL_PATH_MODE = 0;
    public static final int INT_ARRAY_MODE = 1;
    private long startTime;
    private long stopTime;
    private boolean useTwoChannels;
    private boolean drawExtremesContour = false;
    private GeneralPath firstPath;
    private GeneralPath secondPath;
    int startSample;
    int extent;
    private int[] leftTops;
    private int[] leftBottoms;
    private int[] rightTops;
    private int[] rightBottoms;
    private int mode = 0;

    public WavePart() {
        this(0L, 0L, true);
    }

    public WavePart(int mode) {
        this(0L, 0L, true, mode);
    }

    public WavePart(long startTime, long stopTime) {
        this(startTime, stopTime, true);
    }

    public WavePart(long startTime, long stopTime, boolean useTwoChannels) {
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.firstPath = new GeneralPath();
        this.setUseTwoChannels(useTwoChannels);
    }

    public WavePart(long startTime, long stopTime, boolean useTwoChannels, int mode) {
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.setMode(mode);
        this.setUseTwoChannels(useTwoChannels);
    }

    public GeneralPath getFirstPath() {
        return this.firstPath;
    }

    public GeneralPath getSecondPath() {
        return this.secondPath;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode == 1) {
            this.mode = mode;
        } else {
            this.mode = 0;
            if (this.firstPath == null) {
                this.firstPath = new GeneralPath();
            }
        }
    }

    public boolean isDrawExtremesContour() {
        return this.drawExtremesContour;
    }

    public void setDrawExtremesContour(boolean drawExtremesContour) {
        this.drawExtremesContour = drawExtremesContour;
    }

    public boolean isUseTwoChannels() {
        return this.useTwoChannels;
    }

    public void setUseTwoChannels(boolean useTwoChannels) {
        this.useTwoChannels = useTwoChannels;
        if (!useTwoChannels) {
            this.secondPath = null;
            this.rightTops = null;
            this.rightBottoms = null;
        } else if (this.mode == 0 && this.secondPath == null) {
            this.secondPath = new GeneralPath();
        }
    }

    public void setInterval(long startTime, long stopTime, int startSample, int size, int extent) {
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.startSample = startSample;
        this.extent = extent;
        if (this.mode == 1) {
            if (this.leftTops == null || this.leftTops.length < size) {
                this.leftTops = new int[size];
                this.leftBottoms = new int[size];
            }
            if (this.useTwoChannels && (this.rightTops == null || this.rightTops.length < size)) {
                this.rightTops = new int[size];
                this.rightBottoms = new int[size];
            }
        }
    }

    public void addLineToFirstChannel(int x, int top, int bottom) {
        if (this.mode == 0) {
            this.firstPath.moveTo(x, top);
            this.firstPath.lineTo(x, bottom);
        } else if (x - this.startSample >= 0 && x - this.startSample < this.leftTops.length) {
            this.leftTops[x - this.startSample] = top;
            this.leftBottoms[x - this.startSample] = bottom;
        }
    }

    public void addLineToRightChannel(int x, int top, int bottom) {
        if (this.mode == 0) {
            this.secondPath.moveTo(x, top);
            this.secondPath.lineTo(x, bottom);
        } else if (x - this.startSample >= 0 && x - this.startSample < this.rightTops.length) {
            this.rightTops[x - this.startSample] = top;
            this.rightBottoms[x - this.startSample] = bottom;
        }
    }

    public void paintLeftChannel(Graphics2D g2d, AffineTransform at) {
        block8: {
            block7: {
                if (this.mode != 0) break block7;
                if (!this.drawExtremesContour) {
                    g2d.draw(this.firstPath.createTransformedShape(at));
                } else {
                    this.paintLeftChannelLimit(g2d, at, Integer.MAX_VALUE);
                }
                break block8;
            }
            float scale = (float)at.getScaleY();
            if (this.leftTops == null) break block8;
            if (!this.drawExtremesContour) {
                for (int i = 0; i < this.leftTops.length && i < this.extent - 1; ++i) {
                    g2d.drawLine(i + this.startSample, (int)((float)this.leftTops[i] * scale), i + this.startSample, (int)((float)this.leftBottoms[i] * scale));
                }
            } else {
                float y1 = 0.0f;
                for (int i = 0; i < this.leftTops.length && i < this.extent - 1; ++i) {
                    float y2;
                    float f = y2 = Math.abs(this.leftTops[i]) >= Math.abs(this.leftBottoms[i]) ? (float)this.leftTops[i] * scale : (float)this.leftBottoms[i] * scale;
                    if (i == 0) {
                        y1 = y2;
                        continue;
                    }
                    g2d.drawLine(i + this.startSample - 1, (int)y1, i + this.startSample, (int)y2);
                    y1 = y2;
                }
            }
        }
    }

    public void paintLeftChannelLimit(Graphics2D g2d, AffineTransform at, int limit) {
        block11: {
            block10: {
                if (this.mode != 1) break block10;
                float scale = (float)at.getScaleY();
                if (this.leftTops == null) break block11;
                if (!this.drawExtremesContour) {
                    for (int i = 0; i < this.leftTops.length && i < this.extent - 1; ++i) {
                        g2d.drawLine(i + this.startSample, Math.max((int)((float)this.leftTops[i] * scale), -limit), i + this.startSample, Math.min((int)((float)this.leftBottoms[i] * scale), limit));
                    }
                } else {
                    float y1 = 0.0f;
                    for (int i = 0; i < this.leftTops.length && i < this.extent - 1; ++i) {
                        float y2;
                        float f = y2 = Math.abs(this.leftTops[i]) >= Math.abs(this.leftBottoms[i]) ? Math.max((float)this.leftTops[i] * scale, (float)(-limit)) : Math.min((float)this.leftBottoms[i] * scale, (float)limit);
                        if (i == 0) {
                            y1 = y2;
                            continue;
                        }
                        g2d.drawLine(i + this.startSample - 1, (int)y1, i + this.startSample, (int)y2);
                        y1 = y2;
                    }
                }
                break block11;
            }
            float[] segm = new float[2];
            float[] segm2 = new float[2];
            PathIterator pathIt = this.firstPath.getPathIterator(at);
            int i = 0;
            if (!this.drawExtremesContour) {
                while (!pathIt.isDone() && i < this.extent) {
                    pathIt.currentSegment(segm);
                    if (pathIt.isDone()) continue;
                    pathIt.next();
                    pathIt.currentSegment(segm2);
                    g2d.drawLine(i + this.startSample, Math.max((int)segm[1], -limit), i + this.startSample, Math.min((int)segm2[1], limit));
                    pathIt.next();
                    ++i;
                }
            } else {
                float y1 = 0.0f;
                while (!pathIt.isDone() && i < this.extent) {
                    float y2;
                    pathIt.currentSegment(segm);
                    if (pathIt.isDone()) continue;
                    pathIt.next();
                    pathIt.currentSegment(segm2);
                    float f = y2 = Math.abs(segm[1]) >= Math.abs(segm2[1]) ? (float)Math.max((int)segm[1], -limit) : (float)Math.min((int)segm2[1], limit);
                    if (i == 0) {
                        y1 = y2;
                        ++i;
                        continue;
                    }
                    g2d.drawLine(i + this.startSample - 1, (int)y1, i + this.startSample, (int)y2);
                    y1 = y2;
                    pathIt.next();
                    ++i;
                }
            }
        }
    }

    public void paintRightChannel(Graphics2D g2d, AffineTransform at) {
        block8: {
            block7: {
                if (this.mode != 0) break block7;
                if (!this.drawExtremesContour) {
                    g2d.draw(this.secondPath.createTransformedShape(at));
                } else {
                    this.paintRightChannelLimit(g2d, at, Integer.MAX_VALUE);
                }
                break block8;
            }
            float scale = (float)at.getScaleY();
            if (this.rightTops == null) break block8;
            if (!this.drawExtremesContour) {
                for (int i = 0; i < this.rightTops.length && i < this.extent - 1; ++i) {
                    g2d.drawLine(i + this.startSample, (int)((float)this.rightTops[i] * scale), i + this.startSample, (int)((float)this.rightBottoms[i] * scale));
                }
            } else {
                float y1 = 0.0f;
                for (int i = 0; i < this.rightTops.length && i < this.extent - 1; ++i) {
                    float y2;
                    float f = y2 = Math.abs(this.rightTops[i]) >= Math.abs(this.rightBottoms[i]) ? (float)this.rightTops[i] * scale : (float)this.rightBottoms[i] * scale;
                    if (i == 0) {
                        y1 = y2;
                        continue;
                    }
                    g2d.drawLine(i + this.startSample - 1, (int)y1, i + this.startSample, (int)y2);
                    y1 = y2;
                }
            }
        }
    }

    public void paintRightChannelLimit(Graphics2D g2d, AffineTransform at, int limit) {
        block11: {
            block10: {
                if (this.mode != 1) break block10;
                float scale = (float)at.getScaleY();
                if (this.rightTops == null) break block11;
                if (!this.drawExtremesContour) {
                    for (int i = 0; i < this.rightTops.length && i < this.extent - 1; ++i) {
                        g2d.drawLine(i + this.startSample, Math.max((int)((float)this.rightTops[i] * scale), -limit), i + this.startSample, Math.min((int)((float)this.rightBottoms[i] * scale), limit));
                    }
                } else {
                    float y1 = 0.0f;
                    for (int i = 0; i < this.rightTops.length && i < this.extent - 1; ++i) {
                        float y2;
                        float f = y2 = Math.abs(this.rightTops[i]) >= Math.abs(this.rightBottoms[i]) ? Math.max((float)this.rightTops[i] * scale, (float)(-limit)) : Math.min((float)this.rightBottoms[i] * scale, (float)limit);
                        if (i == 0) {
                            y1 = y2;
                            continue;
                        }
                        g2d.drawLine(i + this.startSample - 1, (int)y1, i + this.startSample, (int)y2);
                        y1 = y2;
                    }
                }
                break block11;
            }
            float[] segm = new float[2];
            float[] segm2 = new float[2];
            PathIterator pathIt = this.secondPath.getPathIterator(at);
            int i = 0;
            if (!this.drawExtremesContour) {
                while (!pathIt.isDone() && i < this.extent) {
                    pathIt.currentSegment(segm);
                    if (pathIt.isDone()) continue;
                    pathIt.next();
                    pathIt.currentSegment(segm2);
                    g2d.drawLine(i + this.startSample, Math.max((int)segm[1], -limit), i + this.startSample, Math.min((int)segm2[1], limit));
                    pathIt.next();
                    ++i;
                }
            } else {
                float y1 = 0.0f;
                while (!pathIt.isDone() && i < this.extent) {
                    float y2;
                    pathIt.currentSegment(segm);
                    if (pathIt.isDone()) continue;
                    pathIt.next();
                    pathIt.currentSegment(segm2);
                    float f = y2 = Math.abs(segm[1]) >= Math.abs(segm2[1]) ? (float)Math.max((int)segm[1], -limit) : (float)Math.min((int)segm2[1], limit);
                    if (i == 0) {
                        y1 = y2;
                        ++i;
                        continue;
                    }
                    g2d.drawLine(i + this.startSample - 1, (int)y1, i + this.startSample, (int)y2);
                    y1 = y2;
                    pathIt.next();
                    ++i;
                }
            }
        }
    }

    public boolean contains(long time) {
        return time >= this.startTime && time <= this.stopTime;
    }

    public boolean contains(long fromTime, long toTime) {
        return fromTime >= this.startTime && toTime <= this.stopTime;
    }

    public float amountOfOverlap(long nextFrom, long nextTo) {
        if (nextFrom >= this.stopTime || nextTo <= this.startTime) {
            return 0.0f;
        }
        if (nextFrom < this.startTime) {
            return (float)(nextTo - this.startTime) / (float)(this.stopTime - this.startTime);
        }
        return (float)(this.stopTime - nextFrom) / (float)(this.stopTime - this.startTime);
    }

    public boolean sameIntervalLength(long nextFrom, long nextTo) {
        return this.stopTime - this.startTime == nextTo - nextFrom;
    }

    public boolean leftOverlap(long nextFrom, long nextTo) {
        return nextFrom <= this.startTime && nextTo > this.startTime && nextTo < this.stopTime;
    }

    public boolean rightOverlap(long nextFrom, long nextTo) {
        return nextFrom > this.startTime && nextFrom < this.stopTime && nextTo >= this.stopTime;
    }

    public void shiftInterval(int distance) {
        if (this.mode == 1) {
            if (distance > 0) {
                if (this.leftTops != null) {
                    int copyLength = this.leftTops.length - distance;
                    System.arraycopy(this.leftTops, 0, this.leftTops, distance, copyLength);
                    System.arraycopy(this.leftBottoms, 0, this.leftBottoms, distance, copyLength);
                    if (this.rightTops != null) {
                        System.arraycopy(this.rightTops, 0, this.rightTops, distance, copyLength);
                        System.arraycopy(this.rightBottoms, 0, this.rightBottoms, distance, copyLength);
                    }
                }
            } else if (distance < 0 && this.leftTops != null) {
                int copyLength = this.leftTops.length + distance;
                System.arraycopy(this.leftTops, -distance, this.leftTops, 0, copyLength);
                System.arraycopy(this.leftBottoms, -distance, this.leftBottoms, 0, copyLength);
                if (this.rightTops != null) {
                    System.arraycopy(this.rightTops, -distance, this.rightTops, 0, copyLength);
                    System.arraycopy(this.rightBottoms, -distance, this.rightBottoms, 0, copyLength);
                }
            }
        }
    }

    public void reset() {
        if (this.mode == 0) {
            if (this.firstPath != null) {
                this.firstPath.reset();
            }
            if (this.secondPath != null) {
                this.secondPath.reset();
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WavePart - ");
        b.append("start time: ");
        b.append(this.startTime);
        b.append(" stop time: ");
        b.append(this.stopTime);
        b.append(" ms.");
        return b.toString();
    }
}

