/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient.tc;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.client.annotator.util.AnnotationCoreComparator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class TCEncoder {
    public String encodeTCTierBased(Transcription transcription, List<String> phraseTiers) {
        if (transcription == null || phraseTiers == null) {
            return null;
        }
        return null;
    }

    public String encodeTCTierBased(Transcription transcription, Map<String, List<String>> tierMap) {
        if (transcription == null || tierMap == null) {
            return null;
        }
        return null;
    }

    public String encodeTCTypeBased(TranscriptionImpl transcription, String phraseType) {
        block12: {
            if (transcription == null || phraseType == null) {
                return null;
            }
            Document doc = null;
            try {
                Element textEl;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                doc = db.newDocument();
                Element docEl = this.createDocElement(doc);
                if (docEl != null) {
                    doc.appendChild(docEl);
                }
                if ((textEl = this.createTextElement(doc, transcription)) == null) break block12;
                docEl.appendChild(textEl);
                List<TierImpl> phrTiers = transcription.getTiersWithLinguisticType(phraseType);
                List<AbstractAnnotation> annos = null;
                if (phrTiers != null && phrTiers.size() > 1) {
                    annos = this.sortAnnotations(phrTiers);
                } else if (phrTiers != null && phrTiers.size() == 1) {
                    annos = phrTiers.get(0).getAnnotations();
                }
                if (annos != null && annos.size() > 0) {
                    for (int i = 0; i < annos.size(); ++i) {
                        AbstractAnnotation aa = annos.get(i);
                        this.addPhraseElement(doc, transcription, textEl, aa);
                    }
                }
                try {
                    DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                    DOMImplementation domImpl = registry.getDOMImplementation("XML LS");
                    if (domImpl instanceof DOMImplementationLS) {
                        DOMImplementationLS domLS = (DOMImplementationLS)((Object)domImpl);
                        LSSerializer serializer = domLS.createLSSerializer();
                        LSOutput lsOut = domLS.createLSOutput();
                        lsOut.setEncoding("UTF-8");
                        StringWriter writer = new StringWriter();
                        lsOut.setCharacterStream(writer);
                        serializer.write(doc.getDocumentElement(), lsOut);
                        return writer.toString();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (ParserConfigurationException pce) {
                ClientLogger.LOG.warning("Could not create a document: " + pce.getMessage());
            }
        }
        return null;
    }

    public String encodeTCTypeBased(Transcription transcription, Map<String, List<String>> typeMapping) {
        if (transcription == null || typeMapping == null) {
            return null;
        }
        return null;
    }

    private List<AbstractAnnotation> sortAnnotations(List<TierImpl> phrTiers) {
        if (phrTiers == null || phrTiers.size() == 0) {
            return null;
        }
        ArrayList<AbstractAnnotation> sortedAnnos = new ArrayList<AbstractAnnotation>();
        for (int i = 0; i < phrTiers.size(); ++i) {
            TierImpl t = phrTiers.get(i);
            sortedAnnos.addAll(t.getAnnotations());
        }
        Collections.sort(sortedAnnos, new AnnotationCoreComparator());
        return sortedAnnos;
    }

    private Element createDocElement(Document doc) {
        if (doc != null) {
            Element root = doc.createElement("typecraft");
            root.setAttribute("xsi:schemaLocation", "http://typecraft.org/typecraft.xsd");
            root.setAttribute("xmlns", "http://typecraft.org/typecraft");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            return root;
        }
        return null;
    }

    private Element createTextElement(Document doc, TranscriptionImpl transcription) {
        if (doc != null && transcription != null) {
            Element text = doc.createElement("text");
            List<Property> props = transcription.getDocProperties();
            for (int i = 0; i < props.size(); ++i) {
                Property prop = props.get(i);
                if (prop.getName() != null && prop.getName().equals("id") && prop.getValue() != null) {
                    text.setAttribute(prop.getName(), (String)prop.getValue());
                    continue;
                }
                if (prop.getName() != null && prop.getName().equals("lang") && prop.getValue() != null) {
                    text.setAttribute(prop.getName(), (String)prop.getValue());
                    continue;
                }
                if (prop.getName() != null && prop.getName().equals("title") && prop.getValue() != null) {
                    Element tiEl = doc.createElement(prop.getName());
                    tiEl.appendChild(doc.createTextNode((String)prop.getValue()));
                    text.appendChild(tiEl);
                    continue;
                }
                if (prop.getName() != null && prop.getName().equals("titleTranslation") && prop.getValue() != null) {
                    Element trEl = doc.createElement(prop.getName());
                    trEl.appendChild(doc.createTextNode((String)prop.getValue()));
                    text.appendChild(trEl);
                    continue;
                }
                if (prop.getName() == null || !prop.getName().equals("body") || prop.getValue() == null) continue;
                Element boEl = doc.createElement(prop.getName());
                boEl.appendChild(doc.createTextNode((String)prop.getValue()));
                text.appendChild(boEl);
            }
            return text;
        }
        return null;
    }

    private void addPhraseElement(Document doc, Transcription transcription, Element textEl, AbstractAnnotation phrAnn) {
        List<Annotation> depAnnos;
        TierImpl valTier;
        int i;
        String id;
        String speak;
        if (doc == null || transcription == null || textEl == null || phrAnn == null) {
            return;
        }
        Element phrEl = doc.createElement("phrase");
        textEl.appendChild(phrEl);
        long bt = phrAnn.getBeginTimeBoundary();
        long dur = phrAnn.getEndTimeBoundary() - bt;
        if (dur > 0L) {
            phrEl.setAttribute("offset", String.valueOf(bt));
            phrEl.setAttribute("duration", String.valueOf(dur));
        }
        if ((speak = ((TierImpl)phrAnn.getTier()).getParticipant()) != null) {
            phrEl.setAttribute("speaker", speak);
        }
        if ((id = phrAnn.getId()) != null && id.startsWith("tc")) {
            phrEl.setAttribute("id", id.substring(2));
        }
        Element origEl = doc.createElement("original");
        origEl.appendChild(doc.createTextNode(phrAnn.getValue()));
        phrEl.appendChild(origEl);
        List<TierImpl> depTiers = ((TierImpl)phrAnn.getTier()).getDependentTiers();
        for (i = 0; i < depTiers.size(); ++i) {
            valTier = depTiers.get(i);
            if (valTier.getLinguisticType().getLinguisticTypeName().equals("validity")) {
                depAnnos = phrAnn.getChildrenOnTier(valTier);
                if (depAnnos == null || depAnnos.size() <= 0) continue;
                AbstractAnnotation vdAnn = (AbstractAnnotation)depAnnos.get(0);
                phrEl.setAttribute("valid", vdAnn.getValue());
                continue;
            }
            if (valTier.getLinguisticType().getLinguisticTypeName().equals("translation")) {
                depAnnos = phrAnn.getChildrenOnTier(valTier);
                if (depAnnos == null || depAnnos.size() <= 0) continue;
                AbstractAnnotation trAnn = (AbstractAnnotation)depAnnos.get(0);
                Element tranEl = doc.createElement("translation");
                tranEl.appendChild(doc.createTextNode(trAnn.getValue()));
                phrEl.appendChild(tranEl);
                continue;
            }
            if (!valTier.getLinguisticType().getLinguisticTypeName().equals("description") || (depAnnos = phrAnn.getChildrenOnTier(valTier)) == null || depAnnos.size() <= 0) continue;
            AbstractAnnotation descAnn = (AbstractAnnotation)depAnnos.get(0);
            Element descEl = doc.createElement("description");
            descEl.appendChild(doc.createTextNode(descAnn.getValue()));
            phrEl.appendChild(descEl);
        }
        for (i = 0; i < depTiers.size(); ++i) {
            valTier = depTiers.get(i);
            if (!valTier.getLinguisticType().getLinguisticTypeName().equals("words")) continue;
            depAnnos = phrAnn.getChildrenOnTier(valTier);
            if (depAnnos == null || depAnnos.size() <= 0) break;
            AbstractAnnotation woAnn = null;
            for (int j = 0; j < depAnnos.size(); ++j) {
                woAnn = (AbstractAnnotation)depAnnos.get(j);
                this.addWordElement(doc, transcription, phrEl, woAnn);
            }
            break;
        }
    }

    private void addWordElement(Document doc, Transcription transcription, Element phrEl, AbstractAnnotation woAnn) {
        TierImpl depTier;
        int i;
        if (doc == null || transcription == null || phrEl == null || woAnn == null) {
            return;
        }
        Element woEl = doc.createElement("word");
        woEl.setAttribute("text", woAnn.getValue());
        phrEl.appendChild(woEl);
        TierImpl wTier = (TierImpl)woAnn.getTier();
        List<TierImpl> depTiers = wTier.getDependentTiers();
        for (i = 0; i < depTiers.size(); ++i) {
            List<Annotation> posAnnos;
            depTier = depTiers.get(i);
            if (depTier.getLinguisticType().getLinguisticTypeName().equals("head")) {
                List<Annotation> headAnnos = woAnn.getChildrenOnTier(depTier);
                if (headAnnos == null || headAnnos.size() <= 0) continue;
                AbstractAnnotation heAnn = (AbstractAnnotation)headAnnos.get(0);
                woEl.setAttribute("head", heAnn.getValue());
                continue;
            }
            if (!depTier.getLinguisticType().getLinguisticTypeName().equals("pos") || (posAnnos = woAnn.getChildrenOnTier(depTier)) == null || posAnnos.size() <= 0) continue;
            AbstractAnnotation pAnn = (AbstractAnnotation)posAnnos.get(0);
            Element posEl = doc.createElement("pos");
            posEl.appendChild(doc.createTextNode(pAnn.getValue()));
            woEl.appendChild(posEl);
        }
        for (i = 0; i < depTiers.size(); ++i) {
            depTier = depTiers.get(i);
            if (!depTier.getLinguisticType().getLinguisticTypeName().equals("morph")) continue;
            List<Annotation> morAnnos = woAnn.getChildrenOnTier(depTier);
            if (morAnnos == null || morAnnos.size() <= 0) break;
            AbstractAnnotation morAnn = null;
            for (int j = 0; j < morAnnos.size(); ++j) {
                morAnn = (AbstractAnnotation)morAnnos.get(j);
                this.addMorphElement(doc, transcription, woEl, morAnn);
            }
            break;
        }
    }

    private void addMorphElement(Document doc, Transcription transcription, Element woEl, AbstractAnnotation morAnn) {
        if (doc == null || transcription == null || woEl == null || morAnn == null) {
            return;
        }
        Element morEl = doc.createElement("morpheme");
        morEl.setAttribute("text", morAnn.getValue());
        woEl.appendChild(morEl);
        TierImpl morTier = (TierImpl)morAnn.getTier();
        List<TierImpl> depTiers = morTier.getDependentTiers();
        for (int i = 0; i < depTiers.size(); ++i) {
            List<Annotation> glossAnns;
            TierImpl depTier = depTiers.get(i);
            if (depTier.getLinguisticType().getLinguisticTypeName().equals("meaning")) {
                List<Annotation> meanAnns = morAnn.getChildrenOnTier(depTier);
                if (meanAnns == null || meanAnns.size() <= 0) continue;
                AbstractAnnotation meanAn = (AbstractAnnotation)meanAnns.get(0);
                morEl.setAttribute("meaning", meanAn.getValue());
                continue;
            }
            if (depTier.getLinguisticType().getLinguisticTypeName().equals("baseform")) {
                List<Annotation> baseAnns = morAnn.getChildrenOnTier(depTier);
                if (baseAnns == null || baseAnns.size() <= 0) continue;
                AbstractAnnotation baseAn = (AbstractAnnotation)baseAnns.get(0);
                morEl.setAttribute("baseform", baseAn.getValue());
                continue;
            }
            if (!depTier.getLinguisticType().getLinguisticTypeName().equals("gloss") || (glossAnns = morAnn.getChildrenOnTier(depTier)) == null || glossAnns.size() <= 0) continue;
            AbstractAnnotation glossAn = (AbstractAnnotation)glossAnns.get(0);
            String concatValue = glossAn.getValue();
            if (concatValue.indexOf(";") > 0) {
                String[] glosses;
                for (String gloss : glosses = concatValue.split(";")) {
                    Element glEl = doc.createElement("gloss");
                    glEl.appendChild(doc.createTextNode(gloss));
                    morEl.appendChild(glEl);
                }
                continue;
            }
            Element glEl = doc.createElement("gloss");
            glEl.appendChild(doc.createTextNode(concatValue));
            morEl.appendChild(glEl);
        }
    }
}

