/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient.weblicht;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.webserviceclient.weblicht.WLDescriptorListRenderer;
import mpi.eudico.webserviceclient.weblicht.WLServiceDescriptor;
import mpi.eudico.webserviceclient.weblicht.WebLichtHarvester;

public class WebLichtTierBasedStep3
extends StepPane
implements ChangeListener,
ListSelectionListener,
DocumentListener {
    private JList serviceList;
    private DefaultListModel model;
    private String contentType;
    private JCheckBox manualURLCB;
    private JTextField manualURLTF;
    private List<WLServiceDescriptor> wlDescList = null;
    private WebLichtHarvester harvester;

    public WebLichtTierBasedStep3(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        String stringPref;
        super.initComponents();
        this.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        Insets insets = new Insets(2, 0, 2, 0);
        gbc.anchor = 18;
        gbc.insets = insets;
        this.add((Component)new JLabel(ElanLocale.getString("WebServicesDialog.WebLicht.SelectService")), gbc);
        this.model = new DefaultListModel();
        this.serviceList = new JList(this.model);
        this.serviceList.getSelectionModel().setSelectionMode(0);
        this.serviceList.setCellRenderer(new WLDescriptorListRenderer());
        JScrollPane scrollPane = new JScrollPane(this.serviceList);
        scrollPane.setPreferredSize(new Dimension(100, 80));
        gbc.fill = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
        this.manualURLCB = new JCheckBox(ElanLocale.getString("WebServicesDialog.WebLicht.ManualService"));
        this.manualURLCB.addChangeListener(this);
        this.manualURLTF = new JTextField();
        this.manualURLTF.setEnabled(false);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.gridy = 2;
        this.add((Component)this.manualURLCB, gbc);
        gbc.gridy = 3;
        this.add((Component)this.manualURLTF, gbc);
        this.manualURLTF.getDocument().addDocumentListener(this);
        Boolean boolPref = Preferences.getBool("WebLicht.CustomService", null);
        if (boolPref != null) {
            this.manualURLCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("WebLicht.CustomServiceURL", null)) != null) {
            this.manualURLTF.setText(stringPref);
        }
    }

    @Override
    public void enterStepForward() {
        super.enterStepForward();
        if (this.contentType == null) {
            this.contentType = (String)this.multiPane.getStepProperty("ContentType");
            this.fillListForType();
        } else {
            String oldContentType = this.contentType;
            this.contentType = (String)this.multiPane.getStepProperty("ContentType");
            if (this.contentType != null && !this.contentType.equals(oldContentType)) {
                this.fillListForType();
            }
            this.updateButtons();
        }
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("WebServicesDialog.WebLicht.StepTitle3b");
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private void fillListForType() {
        this.model.removeAllElements();
        this.serviceList.removeListSelectionListener(this);
        if (this.harvester == null) {
            this.harvester = new WebLichtHarvester();
        }
        if (this.wlDescList == null) {
            try {
                String cachePath = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + this.harvester.CACHE_FILENAME;
                long lastCache = this.harvester.getLastCachingTime(cachePath);
                if (lastCache == 0L || System.currentTimeMillis() - lastCache > this.harvester.cacheReloadInterval) {
                    String oaiResult = this.harvester.harvestServicesRemote();
                    if (oaiResult != null) {
                        this.wlDescList = this.harvester.parseRelevantServices(oaiResult);
                        this.harvester.storeCachedVersion(cachePath, oaiResult);
                    }
                } else {
                    this.wlDescList = this.harvester.loadRelevantServicesFromCache(cachePath);
                }
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Unable to harvest and show relevant WebLicht services: " + ioe.getMessage());
                this.showWarning(ElanLocale.getString("WebServicesDialog.WebLicht.Warning1") + ": \n" + ioe.getMessage());
                return;
            }
            catch (Throwable th) {
                ClientLogger.LOG.warning("Unable to harvest and show relevant WebLicht services: " + th.getMessage());
                this.showWarning(ElanLocale.getString("WebServicesDialog.WebLicht.Warning1") + ": \n" + th.getMessage());
                return;
            }
        }
        if (this.wlDescList == null) {
            this.showWarning(ElanLocale.getString("WebServicesDialog.WebLicht.Warning1"));
            return;
        }
        for (WLServiceDescriptor descriptor : this.wlDescList) {
            if (!descriptor.sentenceInput || !descriptor.tokensInput || !descriptor.tcfInput) continue;
            this.model.addElement(descriptor);
        }
        this.serviceList.addListSelectionListener(this);
        String servUrl = Preferences.getString("WebLicht.TierServiceDescriptor", null);
        if (servUrl != null) {
            for (int i = 0; i < this.model.getSize(); ++i) {
                WLServiceDescriptor wlDesc = (WLServiceDescriptor)this.model.getElementAt(i);
                if (!servUrl.equals(wlDesc.fullURL)) continue;
                this.serviceList.setSelectedIndex(i);
                this.serviceList.scrollRectToVisible(this.serviceList.getCellBounds(i, i));
                break;
            }
        }
    }

    private void updateButtons() {
        if (this.manualURLCB.isSelected()) {
            this.multiPane.setButtonEnabled(3, !this.manualURLTF.getText().isEmpty());
        } else {
            this.multiPane.setButtonEnabled(3, this.serviceList.getSelectedIndex() > -1);
        }
    }

    @Override
    public boolean leaveStepForward() {
        if (this.manualURLCB.isSelected()) {
            String manUrl = this.manualURLTF.getText();
            if (manUrl == null || manUrl.isEmpty()) {
                ClientLogger.LOG.warning("No service url has been specified manually");
                this.showWarning(ElanLocale.getString("WebServicesDialog.WebLicht.Warning2"));
                this.manualURLTF.requestFocus();
                this.multiPane.setButtonEnabled(3, false);
                return false;
            }
            this.multiPane.putStepProperty("ManualServiceURL", manUrl);
            Preferences.set("WebLicht.CustomService", true, null);
            Preferences.set("WebLicht.CustomServiceURL", manUrl, null);
        } else {
            Object selValue = this.serviceList.getSelectedValue();
            if (selValue == null) {
                this.showWarning(ElanLocale.getString("WebServicesDialog.WebLicht.Warning3"));
                this.multiPane.setButtonEnabled(3, false);
                return false;
            }
            this.multiPane.putStepProperty("WLServiceDescriptor", selValue);
            Preferences.set("WebLicht.CustomService", false, null);
            Preferences.set("WebLicht.TierServiceDescriptor", ((WLServiceDescriptor)selValue).fullURL, null);
        }
        return true;
    }

    @Override
    public boolean doFinish() {
        if (this.leaveStepForward()) {
            this.multiPane.nextStep();
            return false;
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.manualURLTF.setEnabled(this.manualURLCB.isSelected());
        this.serviceList.setEnabled(!this.manualURLCB.isSelected());
        this.updateButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.serviceList.getSelectedIndex() > -1) {
            this.multiPane.setButtonEnabled(3, true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.multiPane.setButtonEnabled(3, !this.manualURLTF.getText().isEmpty());
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.multiPane.setButtonEnabled(3, !this.manualURLTF.getText().isEmpty());
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.multiPane.setButtonEnabled(3, !this.manualURLTF.getText().isEmpty());
    }
}

