/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient.weblicht;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.AbstractProgressCommand;
import mpi.eudico.client.annotator.commands.WebLichtTierBasedCommand;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.webserviceclient.weblicht.WLServiceDescriptor;

public class WebLichtTierBasedStep4
extends ProgressStepPane {
    private String tierName;
    private String contentType;
    private Transcription trans;
    private WLServiceDescriptor wlDescriptor;
    private AbstractProgressCommand wlCommand;

    public WebLichtTierBasedStep4(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.progressLabel.setText("");
    }

    @Override
    public void enterStepForward() {
        if (this.progressLabel != null) {
            this.progressLabel.setText("");
        }
        this.progressBar.setValue(0);
        this.doFinish();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("WebServicesDialog.WebLicht.Uploading");
    }

    @Override
    protected void endOfProcess() {
        if (this.wlCommand != null) {
            this.wlCommand.removeProgressListener(this);
        }
        if (this.completed) {
            super.endOfProcess();
        } else {
            this.progressBar.setValue(0);
            this.multiPane.setButtonEnabled(4, true);
            this.multiPane.setButtonEnabled(2, true);
        }
    }

    @Override
    public boolean doFinish() {
        String manualURL;
        this.multiPane.setButtonEnabled(8, false);
        this.tierName = (String)this.multiPane.getStepProperty("Tier");
        this.contentType = (String)this.multiPane.getStepProperty("ContentType");
        this.trans = (Transcription)this.multiPane.getStepProperty("transcription");
        this.wlDescriptor = (WLServiceDescriptor)this.multiPane.getStepProperty("WLServiceDescriptor");
        if (this.wlDescriptor == null && (manualURL = (String)this.multiPane.getStepProperty("ManualServiceURL")) != null) {
            this.wlDescriptor = new WLServiceDescriptor("Custom Service");
            this.wlDescriptor.fullURL = manualURL;
        }
        if (this.wlDescriptor == null) {
            this.showWarningDialog(ElanLocale.getString("WebServicesDialog.WebLicht.Warning4"));
            this.multiPane.setButtonEnabled(4, true);
            this.multiPane.setButtonEnabled(2, true);
            return false;
        }
        this.completed = false;
        this.wlCommand = new WebLichtTierBasedCommand("WebLicht.TierBased.Command");
        this.wlCommand.addProgressListener(this);
        this.wlCommand.execute(this.trans, new Object[]{this.wlDescriptor, this.tierName, this.contentType});
        return false;
    }
}

