/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.im;

import guk.im.GateIM;
import guk.im.GateIMDescriptor;
import java.awt.AWTException;
import java.awt.Component;
import java.util.HashSet;
import java.util.Locale;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.im.spi.lookup.Lookup2;
import mpi.eudico.client.im.spi.lookup.LookupDescriptor;

public class ImUtil {
    private static final HashSet<String> allLocales;
    public static boolean showKeyboard;
    public static final Locale IPA96_RTR;
    public static final Locale IPA96_SAMPA;
    public static final Locale Cyrillic;
    public static final Locale Arabic1;
    public static final Locale Arabic2;
    public static final Locale Hebrew;
    public static final Locale GEORGIAN_HEI;
    public static final Locale GEORGIAN_IMNA;
    public static final Locale GEORGIAN_MLT;
    public static final Locale KOREAN;
    public static final Locale TURKISH;
    public static final Locale IPA_EXT_VK;
    public static final Locale ENGLISH;

    public static final Locale[] getLanguages(Component component) {
        Locale defaultLocale = component != null && component.getLocale() != null ? component.getLocale() : Locale.getDefault();
        return new Locale[]{defaultLocale, Arabic1, Arabic2, Lookup2.CHINESE_SIM, Lookup2.CHINESE_TRA, ENGLISH, GEORGIAN_HEI, GEORGIAN_IMNA, GEORGIAN_MLT, Hebrew, Lookup2.IPA96_RTR, IPA96_SAMPA, IPA_EXT_VK, KOREAN, Cyrillic, TURKISH};
    }

    public static final Locale[] getLanguages() {
        return ImUtil.getLanguages(null);
    }

    public static final void setLanguage(Component component, Locale language) {
        component.setLocale(language);
        try {
            if (component.getInputContext() != null) {
                Object imObject;
                boolean success = component.getInputContext().selectInputMethod(language);
                if (SystemReporting.isMacOS()) {
                    component.enableInputMethods(success);
                }
                if ((imObject = component.getInputContext().getInputMethodControlObject()) != null && imObject instanceof GateIM && showKeyboard) {
                    ((GateIM)imObject).setMapVisible(success);
                }
            }
        }
        catch (NullPointerException npe) {
            System.out.println("Component " + component.getClass() + " has no InputContext - no input method set!");
        }
    }

    static {
        int i;
        allLocales = new HashSet();
        showKeyboard = true;
        try {
            GateIMDescriptor gukDescriptor = new GateIMDescriptor();
            Locale[] gukLocales = gukDescriptor.getAvailableLocales();
            for (i = 0; i < gukLocales.length; ++i) {
                allLocales.add(gukLocales[i].toString());
            }
        }
        catch (AWTException gukDescriptor) {
            // empty catch block
        }
        LookupDescriptor lupDescriptor = new LookupDescriptor();
        Locale[] lupLocales = lupDescriptor.getAvailableLocales();
        for (i = 0; i < lupLocales.length; ++i) {
            allLocales.add(lupLocales[i].toString());
        }
        IPA96_RTR = Lookup2.IPA96_RTR;
        IPA96_SAMPA = new Locale("IPA-96", "", "SAMPA");
        Cyrillic = new Locale("RU", "", "YAWERTY (Phonetic)");
        Arabic1 = new Locale("AR", "", "MLT Arabic");
        Arabic2 = new Locale("AR", "", "Windows");
        Hebrew = new Locale("HE", "", "Standard");
        GEORGIAN_HEI = new Locale("ka", "", "Heinecke");
        GEORGIAN_IMNA = new Locale("ka", "", "Imnaishvili Arrangement");
        GEORGIAN_MLT = new Locale("ka", "", "MLT");
        KOREAN = new Locale("ko", "", "Standard Hangul");
        TURKISH = new Locale("tr", "", "Standard");
        IPA_EXT_VK = new Locale("ipa-ext", "", "IPA Extended");
        ENGLISH = new Locale("en", "", "ASCII");
    }
}

