/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.im.spi.lookup;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mpi.eudico.client.im.spi.lookup.LookupListPanel;

public class Lookup2
implements InputMethod {
    public static final Locale IPA96_RTR = new Locale("ipa-96", "", "rtr");
    public static final Locale CHINESE_SIM = new Locale("chinese", "", "simplified");
    public static final Locale CHINESE_TRA = new Locale("chinese", "", "traditional");
    static Locale[] SUPPORTED_LOCALES = new Locale[]{IPA96_RTR, CHINESE_SIM, CHINESE_TRA};
    private static Map<Locale, String> hashedFilenames = new HashMap<Locale, String>();
    private static HashMap<String, List<String>> pinyinHash;
    private String[] lookupCandidates;
    private LookupListPanel lookupList;
    private Font editorFont;
    private InputMethodContext inputMethodContext;
    private Locale locale;
    private boolean converted;
    private StringBuilder rawText = new StringBuilder();
    private String convertedText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initializeHash(Locale locale) throws IOException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            String buffer;
            pinyinHash = new HashMap();
            BufferedReader datafile = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(hashedFilenames.get(locale)), "UTF8"));
            while ((buffer = datafile.readLine()) != null) {
                int index = buffer.indexOf("\t");
                String pinyin = buffer.substring(0, index);
                ArrayList<String> newlist = new ArrayList<String>();
                int oldindex = index + 1;
                do {
                    String hanzi;
                    if ((index = buffer.indexOf(" ", oldindex)) == -1) {
                        index = buffer.length();
                    }
                    if ((hanzi = buffer.substring(oldindex, index)).length() <= 0) continue;
                    newlist.add(hanzi);
                } while ((oldindex = index + 1) < buffer.length());
                pinyinHash.put(pinyin.intern(), newlist);
            }
            datafile.close();
        }
    }

    private final boolean wordResultsInHash(char ch) {
        return pinyinHash.containsKey(this.rawText + new Character(ch).toString());
    }

    private final boolean lookupCharacter(char ch) {
        if (this.wordResultsInHash(ch)) {
            this.rawText.append(ch);
            this.sendText(false);
            return true;
        }
        return false;
    }

    private final void handlePressedKey(KeyEvent e) {
        if (this.lookupList == null) {
            return;
        }
        switch (e.getKeyCode()) {
            case 38: 
            case 224: {
                this.lookupList.selectPrevious();
                break;
            }
            case 40: 
            case 225: {
                this.lookupList.selectNext();
                break;
            }
            case 33: {
                this.lookupList.selectPageUp();
                break;
            }
            case 34: {
                this.lookupList.selectPageDown();
                break;
            }
            case 27: {
                this.cancelEdit();
                break;
            }
            case 36: {
                this.lookupList.selectHome();
                break;
            }
            case 35: {
                this.lookupList.selectEnd();
            }
        }
        e.consume();
    }

    private final void handleTypedKey(KeyEvent e) {
        char ch = e.getKeyChar();
        if (this.lookupList != null && this.lookupList.isVisible()) {
            int intValue;
            int indexInArray;
            if (' ' == ch || '\n' == ch) {
                this.selectCandidate(this.lookupList.getSelectedCandidateIndex());
                this.commit();
                this.closeLookupWindow();
                e.consume();
                return;
            }
            if (ch == '\b') {
                if (this.rawText.length() != 0) {
                    this.rawText.setLength(this.rawText.length() - 1);
                    this.sendText(false);
                }
                e.consume();
                return;
            }
            if (ch >= '0' && ch <= '9' && (indexInArray = this.lookupList.getCandidateIndexForNumberKeyShortcut(intValue = Character.getNumericValue(ch))) >= 0) {
                this.selectCandidate(indexInArray);
                this.commit();
                this.closeLookupWindow();
                e.consume();
                return;
            }
            this.lookupCharacter(ch);
            e.consume();
            return;
        }
        if (this.rawText.length() != 0) {
            System.out.println("There is Raw Text but no lookup list");
        }
        if (this.lookupCharacter(ch)) {
            e.consume();
        }
    }

    private final void commit() {
        this.sendText(true);
        this.rawText.setLength(0);
        this.convertedText = null;
        this.converted = false;
        this.closeLookupWindow();
    }

    private void cancelEdit() {
        this.inputMethodContext.dispatchInputMethodEvent(1100, null, 0, TextHitInfo.leading(0), null);
        this.rawText.setLength(0);
        this.convertedText = null;
        this.converted = false;
        this.closeLookupWindow();
    }

    private final void sendText(boolean committed) {
        InputMethodHighlight highlight;
        String text;
        int committedCharacterCount = 0;
        if (this.converted) {
            text = this.convertedText;
            highlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
        } else if (this.rawText.length() > 0) {
            text = new String(this.rawText);
            highlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            String lookupName = this.rawText.toString().toLowerCase();
            ArrayList templist = (ArrayList)pinyinHash.get(lookupName.intern());
            if (templist == null) {
                return;
            }
            this.lookupCandidates = new String[templist.size()];
            for (int k = 0; k < this.lookupCandidates.length; ++k) {
                this.lookupCandidates[k] = (String)templist.get(k);
            }
            if (this.lookupCandidates != null) {
                if (this.lookupList != null) {
                    this.lookupList.setVisible(false);
                    this.lookupList = null;
                }
                this.openLookupWindow();
            }
        } else {
            text = "";
            highlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            this.closeLookupWindow();
        }
        AttributedString as = new AttributedString(text);
        if (committed) {
            committedCharacterCount = text.length();
        } else if (text.length() > 0) {
            as.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, highlight);
        }
        this.inputMethodContext.dispatchInputMethodEvent(1100, as.getIterator(), committedCharacterCount, TextHitInfo.leading(text.length()), null);
    }

    private final void selectCandidate(int candidate) {
        if (candidate < 0 || candidate >= this.lookupCandidates.length) {
            return;
        }
        this.convertedText = this.lookupCandidates[candidate];
        this.converted = true;
        this.sendText(false);
    }

    private final void openLookupWindow() {
        this.lookupList = new LookupListPanel(this, this.inputMethodContext, this.lookupCandidates, this.editorFont);
        this.lookupList.selectCandidate(0);
    }

    private final void closeLookupWindow() {
        if (this.lookupList != null) {
            this.lookupList.setVisible(false);
            this.lookupList = null;
            this.editorFont = null;
        }
    }

    private void showLookupWindow() {
        if (this.lookupList != null) {
            this.lookupList.setVisible(true);
        }
    }

    @Override
    public void activate() {
        this.showLookupWindow();
    }

    @Override
    public void deactivate(boolean isTemporary) {
        this.cancelEdit();
    }

    @Override
    public void dispatchEvent(AWTEvent event) {
        MouseEvent mevent;
        if (this.locale == null) {
            return;
        }
        if (event instanceof KeyEvent) {
            if (this.editorFont == null && event.getSource() instanceof Component) {
                this.editorFont = ((Component)event.getSource()).getFont();
            }
            switch (((KeyEvent)event).getID()) {
                case 400: {
                    this.handleTypedKey((KeyEvent)event);
                    break;
                }
                case 401: {
                    this.handlePressedKey((KeyEvent)event);
                }
            }
        }
        if (event instanceof MouseEvent && (mevent = (MouseEvent)event).getID() == 501 && this.lookupList != null) {
            int y = mevent.getY();
            int index = this.lookupList.getSelectedCandidateIndex(y);
            if (index >= 0 && index < this.lookupCandidates.length) {
                this.convertedText = this.lookupCandidates[index];
                this.converted = true;
                this.sendText(false);
                mevent.consume();
                this.commit();
            } else {
                mevent.consume();
            }
        }
    }

    @Override
    public void dispose() {
        this.hideWindows();
    }

    @Override
    public void endComposition() {
        if (this.rawText.length() != 0) {
            this.commit();
        }
        this.hideWindows();
    }

    @Override
    public Object getControlObject() {
        return null;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void hideWindows() {
        this.closeLookupWindow();
    }

    @Override
    public boolean isCompositionEnabled() {
        return true;
    }

    @Override
    public void notifyClientWindowChange(Rectangle location) {
    }

    @Override
    public void reconvert() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNotify() {
    }

    @Override
    public void setCharacterSubsets(Character.Subset[] subsets) {
    }

    @Override
    public void setCompositionEnabled(boolean enable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInputMethodContext(InputMethodContext context) {
        this.inputMethodContext = context;
    }

    @Override
    public boolean setLocale(Locale locale) {
        if (locale == null) {
            this.locale = null;
            return false;
        }
        if (locale == this.locale) {
            return true;
        }
        if (!hashedFilenames.containsKey(locale)) {
            this.locale = null;
            return false;
        }
        try {
            this.initializeHash(locale);
            this.closeLookupWindow();
            this.locale = locale;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        hashedFilenames.put(SUPPORTED_LOCALES[0], "ipa96.u8");
        hashedFilenames.put(SUPPORTED_LOCALES[1], "PinyinSC.u8");
        hashedFilenames.put(SUPPORTED_LOCALES[2], "PinyinTC.u8");
    }
}

