/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeRelation;

public class EAF2SMIL {
    private static Transformer transformer2smil;
    private static Transformer transformer2rt;

    public static void export2SMIL(File eafFile, File smilFile, String[] tierNames, long offset, int minimalDur, Map<String, Object> fontSettingHashMap) throws IOException, TransformerException {
        EAF2SMIL.export2SMIL(eafFile, smilFile, tierNames, null, offset, minimalDur, fontSettingHashMap);
    }

    public static void export2SMIL(File eafFile, File smilFile, String[] tierNames, String mediaURL, long offset, int minimalDur, Map<String, Object> fontSettingHashMap) throws IOException, TransformerException {
        try {
            URL eafURL = new URL("file:///" + eafFile.getAbsolutePath());
            EAF2SMIL.export2SMIL(eafURL, smilFile, tierNames, mediaURL, offset, minimalDur, fontSettingHashMap);
        }
        catch (MalformedURLException e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public static void export2SMIL(URL eafURL, File smilFile, String[] tierNames, String mediaURL, long offset, int minimalDur, Map<String, Object> fontSettingMap) throws IOException, TransformerException {
        int i;
        EAF2SMIL.createTransformer();
        String fileName = new File(eafURL.getFile()).getName();
        int index = fileName.lastIndexOf(46);
        String title = index > 0 ? (fileName = fileName.substring(0, index)) : fileName;
        String comment = "Generated from " + fileName + " on " + new Date(System.currentTimeMillis());
        String rtFileName = smilFile.getName();
        index = rtFileName.lastIndexOf(46);
        if (index > 0) {
            rtFileName = rtFileName.substring(0, index);
        }
        transformer2rt.setParameter("offset", offset);
        transformer2rt.setParameter("minimalDur", minimalDur);
        transformer2smil.setParameter("offset", offset);
        transformer2smil.setParameter("comment", comment);
        transformer2smil.setParameter("title", title);
        if (fontSettingMap != null) {
            String rgb;
            if (fontSettingMap.get("size") != null) {
                transformer2smil.setParameter("font_size", (Integer)fontSettingMap.get("size"));
                transformer2rt.setParameter("font_size", (Integer)fontSettingMap.get("size"));
            }
            if (fontSettingMap.get("font") != null) {
                transformer2rt.setParameter("font", (String)fontSettingMap.get("font"));
            }
            if (fontSettingMap.get("textColor") != null) {
                rgb = Integer.toHexString(((Color)fontSettingMap.get("textColor")).getRGB());
                rgb = rgb.substring(2, rgb.length());
                transformer2rt.setParameter("subtitle_foreground_color", "#" + rgb);
            }
            if (fontSettingMap.get("backColor") != null) {
                rgb = Integer.toHexString(((Color)fontSettingMap.get("backColor")).getRGB());
                rgb = rgb.substring(2, rgb.length());
                transformer2rt.setParameter("subtitle_background_color", "#" + rgb);
                transformer2smil.setParameter("subtitle_background_color", "#" + rgb);
                transformer2smil.setParameter("video_background_color", "#" + rgb);
            }
        }
        if (mediaURL != null) {
            transformer2smil.setParameter("media_url", mediaURL);
        }
        if (tierNames != null) {
            Object tierString = tierNames[0];
            for (i = 1; i < tierNames.length; ++i) {
                tierString = (String)tierString + " " + tierNames[i];
            }
            transformer2smil.setParameter("tier", tierString);
        }
        transformer2smil.setParameter("rtFileName", rtFileName + ".rt");
        FileOutputStream stream = new FileOutputStream(smilFile);
        transformer2smil.transform(new StreamSource(eafURL.openStream()), new StreamResult(stream));
        stream.close();
        for (i = 0; i < tierNames.length; ++i) {
            File rtFile = new File(smilFile.getParent(), rtFileName + "_" + tierNames[i] + ".rt");
            transformer2rt.setParameter("tier", tierNames[i]);
            stream = new FileOutputStream(rtFile);
            transformer2rt.transform(new StreamSource(eafURL.openStream()), new StreamResult(stream));
            stream.close();
        }
        transformer2smil.clearParameters();
        transformer2rt.clearParameters();
    }

    public void export2SMIL(File eafFile, File smilFile, String[] tierNames, long beginTime, long endTime, long offset, int minimalDur, boolean recalculateTime, Map<String, Object> fontSettingHashMap) throws IOException, TransformerException {
        EAF2SMIL.export2SMIL(eafFile, smilFile, tierNames, null, beginTime, endTime, offset, minimalDur, recalculateTime, fontSettingHashMap);
    }

    public static void export2SMIL(File eafFile, File smilFile, String[] tierNames, String mediaURL, long beginTime, long endTime, long offset, int minimalDur, boolean recalculateTime, Map<String, Object> fontSettingHashMap) throws IOException, TransformerException {
        try {
            URL eafURL = new URL("file:///" + eafFile.getAbsolutePath());
            EAF2SMIL.export2SMIL(eafURL, smilFile, tierNames, mediaURL, beginTime, endTime, offset, minimalDur, recalculateTime, fontSettingHashMap);
        }
        catch (MalformedURLException e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public static void export2SMIL(Transcription transcription, File smilFile, String[] tierNames, String mediaURL, long beginTime, long endTime, long offset, int minimalDur, boolean recalculateTime, Map<String, Object> fontSettingHashMap) throws IOException, TransformerException {
        Annotation[] annotations = null;
        if (recalculateTime) {
            block2: for (int j = 0; j < tierNames.length; ++j) {
                if (tierNames.length <= 1) continue;
                Tier tier = transcription.getTierWithId(tierNames[j]);
                annotations = tier.getAnnotations().toArray(new Annotation[0]);
                for (int i = 0; i < annotations.length; ++i) {
                    long b;
                    if (annotations[i] == null || !TimeRelation.overlaps(annotations[i], beginTime, endTime) || (b = annotations[i].getBeginTimeBoundary()) >= beginTime) continue;
                    beginTime = b;
                    continue block2;
                }
            }
        }
        try {
            URL eafURL = new URL("file:///" + new File(((TranscriptionImpl)transcription).getPathName()).getAbsolutePath());
            EAF2SMIL.export2SMIL(eafURL, smilFile, tierNames, mediaURL, beginTime, endTime, offset, minimalDur, recalculateTime, fontSettingHashMap);
        }
        catch (MalformedURLException e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public static void export2SMIL(URL eafURL, File smilFile, String[] tierNames, String mediaURL, long beginTime, long endTime, long offset, int minimalDur, boolean recalculateTime, Map<String, Object> fontSettingHashMap) throws IOException, TransformerException {
        EAF2SMIL.createTransformer();
        transformer2smil.setParameter("media_start_time", "" + beginTime);
        transformer2smil.setParameter("media_stop_time", "" + endTime);
        transformer2rt.setParameter("media_start_time", "" + beginTime);
        transformer2rt.setParameter("media_stop_time", "" + endTime);
        if (recalculateTime) {
            transformer2rt.setParameter("recalculate_time_interval", "true");
            transformer2smil.setParameter("recalculate_time_interval", "true");
        }
        EAF2SMIL.export2SMIL(eafURL, smilFile, tierNames, mediaURL, offset, minimalDur, fontSettingHashMap);
    }

    public static void main(String[] args) {
        Object eafFile = null;
        if (args.length > 0 && ((String)(eafFile = args[0])).indexOf(58) == -1) {
            eafFile = "file:///" + (String)eafFile;
        }
        try {
            URL eafURL = new URL((String)(eafFile != null ? eafFile : "file:///" + System.getProperty("user.dir") + "/resources/testdata/elan/elan-example2.eaf"));
            EAF2SMIL.export2SMIL(eafURL, new File(eafURL.getFile().replaceAll(".eaf$", ".smil")), new String[]{"W-Spch", "K-Spch"}, null, 15200L, 17200L, 0L, 0, false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createTransformer() throws TransformerException, IOException {
        if (transformer2smil == null) {
            URL eaf2smil = EAF2SMIL.class.getResource("/mpi/eudico/resources/eaf2smil.xsl");
            URL eaf2rt = EAF2SMIL.class.getResource("/mpi/eudico/resources/eaf2rt.xsl");
            TransformerFactory tFactory = TransformerFactory.newInstance();
            transformer2smil = tFactory.newTransformer(new StreamSource(eaf2smil.openStream()));
            transformer2rt = tFactory.newTransformer(new StreamSource(eaf2rt.openStream()));
        }
    }
}

