/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class TierSorter {
    public final int UNSORTED = 0;
    public final int BY_HIERARCHY = 1;
    public final int BY_NAME = 2;
    public final int BY_PARTICIPANT = 3;
    public final int BY_LINGUISTIC_TYPE = 4;
    public final int BY_ANNOTATOR = 5;
    public final int BY_LANGUAGE = 6;
    private final String NOT_SPECIFIED = "not specified";
    private TranscriptionImpl transcription;

    public TierSorter(TranscriptionImpl transcription) {
        this.transcription = transcription;
    }

    public List<TierImpl> sortTiers(int mode) {
        return this.sortTiers(mode, null);
    }

    public List<TierImpl> sortTiers(int mode, List<TierImpl> currentTierOrder) {
        ArrayList<TierImpl> sortedTiers = new ArrayList<TierImpl>();
        ArrayList<Object> tierList = null;
        tierList = currentTierOrder == null ? new ArrayList() : new ArrayList<TierImpl>(currentTierOrder);
        List<TierImpl> allTiers = this.transcription.getTiers();
        for (int i = 0; i < allTiers.size(); ++i) {
            TierImpl tier = allTiers.get(i);
            if (tierList.contains(tier)) continue;
            tierList.add(tier);
        }
        TierImpl.ValueGetter getter = null;
        switch (mode) {
            case 1: {
                HashMap<TierImpl, DefaultMutableTreeNode> nodes = new HashMap<TierImpl, DefaultMutableTreeNode>();
                DefaultMutableTreeNode sortedRootNode = new DefaultMutableTreeNode("Root");
                for (TierImpl tierImpl : tierList) {
                    DefaultMutableTreeNode n = new DefaultMutableTreeNode(tierImpl);
                    nodes.put(tierImpl, n);
                }
                for (TierImpl tierImpl : tierList) {
                    if (tierImpl.getParentTier() == null) {
                        sortedRootNode.add((MutableTreeNode)nodes.get(tierImpl));
                        continue;
                    }
                    ((DefaultMutableTreeNode)nodes.get(tierImpl.getParentTier())).add((MutableTreeNode)nodes.get(tierImpl));
                }
                Enumeration<TreeNode> nodeEnum = sortedRootNode.preorderEnumeration();
                nodeEnum.nextElement();
                while (nodeEnum.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)nodeEnum.nextElement();
                    sortedTiers.add((TierImpl)defaultMutableTreeNode.getUserObject());
                }
                break;
            }
            case 2: {
                getter = new TierImpl.NameGetter();
                break;
            }
            case 3: {
                getter = new TierImpl.ParticipantGetter();
                break;
            }
            case 4: {
                getter = new TierImpl.LinguisticTypeNameGetter();
                break;
            }
            case 5: {
                getter = new TierImpl.AnnotatorGetter();
                break;
            }
            case 6: {
                getter = new TierImpl.LanguageGetter();
                break;
            }
            default: {
                sortedTiers = tierList;
            }
        }
        if (getter != null) {
            HashMap valueTable = new HashMap();
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < tierList.size(); ++i) {
                TierImpl tierImpl = (TierImpl)tierList.get(i);
                String value = getter.getSortValue(tierImpl);
                if (value.isEmpty()) {
                    value = "not specified";
                }
                if (valueTable.get(value) == null) {
                    ArrayList<TierImpl> list = new ArrayList<TierImpl>();
                    list.add(tierImpl);
                    valueTable.put(value, list);
                    names.add(value);
                    continue;
                }
                ((List)valueTable.get(value)).add(tierImpl);
            }
            if (valueTable.size() > 0) {
                if (mode == 2) {
                    Collections.sort(names);
                }
                for (String string : names) {
                    List pList = (List)valueTable.get(string);
                    for (TierImpl p : pList) {
                        sortedTiers.add(p);
                    }
                }
            }
        }
        return sortedTiers;
    }
}

