/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.SubtitleSequencer;
import mpi.eudico.client.util.SubtitleUnit;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeRelation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class Transcription2QtSubtitle {
    private static final String NEWLINE = "\n";
    private static final char[] bracks = new char[]{'[', ']', '(', ')'};
    private static final char NL_CHAR = '\n';

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile) throws IOException {
        Transcription2QtSubtitle.exportTiers(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, int minimalDuration) throws IOException {
        Transcription2QtSubtitle.exportTiers(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime) throws IOException {
        Transcription2QtSubtitle.exportTiers(transcription, tierNames, exportFile, beginTime, endTime, 0L, 0, 0L, false, null);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, long offset, int minimalDuration, long mediaDuration) throws IOException {
        Transcription2QtSubtitle.exportTiers(transcription, tierNames, exportFile, beginTime, endTime, offset, minimalDuration, mediaDuration, false, null);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, long offset, int minimalDuration, long mediaDuration, boolean reCalculateTime, Map<String, Object> newSubtitleSetting) throws IOException {
        Tier tier;
        int j;
        if (exportFile == null) {
            return;
        }
        if (exportFile.getName().toLowerCase().endsWith(".xml")) {
            Transcription2QtSubtitle.exportTiersTx3g(transcription, tierNames, exportFile, beginTime, endTime, offset, minimalDuration, mediaDuration, reCalculateTime, Transcription2QtSubtitle.toTx3gStyleMap(newSubtitleSetting));
            return;
        }
        Annotation[] annotations = null;
        FileOutputStream out = null;
        BufferedWriter writer = null;
        if (tierNames.length == 1) {
            out = new FileOutputStream(exportFile);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        }
        long recalculateTimeInterval = 0L;
        if (reCalculateTime) {
            recalculateTimeInterval = beginTime;
            offset = 0L;
            block0: for (j = 0; j < tierNames.length; ++j) {
                tier = transcription.getTierWithId(tierNames[j]);
                annotations = tier.getAnnotations().toArray(new Annotation[0]);
                for (int i = 0; i < annotations.length; ++i) {
                    long b;
                    if (annotations[i] == null || !TimeRelation.overlaps(annotations[i], beginTime, endTime) || (b = annotations[i].getBeginTimeBoundary()) >= recalculateTimeInterval) continue;
                    recalculateTimeInterval = b;
                    continue block0;
                }
            }
            annotations = null;
        }
        for (j = 0; j < tierNames.length; ++j) {
            if (tierNames.length > 1) {
                Object nextName = exportFile.getAbsolutePath();
                int index = ((String)nextName).lastIndexOf(46);
                nextName = index > 0 ? ((String)nextName).substring(0, index) + "_" + tierNames[j] + ".txt" : (String)nextName + "_" + tierNames[j];
                out = new FileOutputStream(new File((String)nextName));
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            }
            tier = transcription.getTierWithId(tierNames[j]);
            annotations = tier.getAnnotations().toArray(new Annotation[0]);
            writer.write(Transcription2QtSubtitle.getSettings(newSubtitleSetting));
            long nextB = 0L;
            long lastE = 0L;
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i] == null || !TimeRelation.overlaps(annotations[i], beginTime, endTime)) continue;
                long b = annotations[i].getBeginTimeBoundary();
                long d = b + (long)minimalDuration;
                long e = Math.max(annotations[i].getEndTimeBoundary(), d);
                if (i < annotations.length - 1) {
                    nextB = annotations[i + 1].getBeginTimeBoundary();
                    e = Math.min(e, nextB);
                }
                if (lastE < e) {
                    lastE = e;
                }
                writer.write("[" + TimeFormatter.toString(b - recalculateTimeInterval + offset) + "]\n");
                writer.write("{textEncoding:256}");
                writer.write(Transcription2QtSubtitle.replaceBrackets(annotations[i].getValue()));
                writer.append('\n');
                if (nextB - e < 10L && nextB - b >= 20L) {
                    writer.write("[" + TimeFormatter.toString(nextB - recalculateTimeInterval - 10L + offset) + "]\n");
                    continue;
                }
                writer.write("[" + TimeFormatter.toString(e - recalculateTimeInterval + offset) + "]\n");
            }
            if (mediaDuration > lastE + 20L) {
                writer.write("[" + TimeFormatter.toString(mediaDuration - Math.min(40L, mediaDuration - lastE + 10L)) + "]\n");
                writer.write("[" + TimeFormatter.toString(mediaDuration) + "]");
            }
            if (tierNames.length <= 1) continue;
            writer.close();
        }
        writer.close();
    }

    public static void exportTiersMerged(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, long offset, int minimalDuration, long mediaDuration) throws IOException {
        Transcription2QtSubtitle.exportTiersMerged(transcription, tierNames, exportFile, beginTime, endTime, offset, minimalDuration, mediaDuration, false, null);
    }

    public static void exportTiersMerged(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, long offset, int minimalDuration, long mediaDuration, boolean reCalculateTime, Map<String, Object> newSubtitleSetting) throws IOException {
        Object fileName;
        int index;
        if (exportFile == null) {
            return;
        }
        if (exportFile.getName().toLowerCase().endsWith(".xml")) {
            Transcription2QtSubtitle.exportTiersTx3g(transcription, tierNames, exportFile, beginTime, endTime, offset, minimalDuration, mediaDuration, reCalculateTime, Transcription2QtSubtitle.toTx3gStyleMap(newSubtitleSetting));
            return;
        }
        long recalculateTimeInterval = 0L;
        boolean selection = false;
        if (reCalculateTime) {
            recalculateTimeInterval = beginTime;
            offset = 0L;
        }
        if ((index = ((String)(fileName = exportFile.getAbsolutePath())).lastIndexOf(46)) > 0) {
            fileName = ((String)fileName).substring(0, index) + ".txt";
        }
        FileOutputStream out = new FileOutputStream(new File((String)fileName));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        writer.write(Transcription2QtSubtitle.getSettings(newSubtitleSetting));
        SubtitleSequencer sequencer = new SubtitleSequencer();
        List<SubtitleUnit> allUnits = sequencer.createSequence(transcription, tierNames, beginTime, endTime, minimalDuration, offset, true);
        SubtitleUnit unit = null;
        SubtitleUnit nextUnit = null;
        for (int i = 0; i < allUnits.size(); ++i) {
            unit = allUnits.get(i);
            if (!selection && unit.getBegin() < recalculateTimeInterval) {
                recalculateTimeInterval = unit.getBegin();
                selection = true;
            }
            writer.write("[" + TimeFormatter.toString(unit.getBegin() - recalculateTimeInterval) + "]\n");
            writer.write("{textEncoding:256}");
            for (int j = 0; j < unit.getValues().length; ++j) {
                writer.write(Transcription2QtSubtitle.replaceBrackets(unit.getValues()[j]));
                writer.append('\n');
            }
            if (i < allUnits.size() - 1) {
                nextUnit = allUnits.get(i + 1);
                if (nextUnit.getBegin() - unit.getCalcEnd() < 10L && nextUnit.getBegin() - unit.getBegin() >= 20L) {
                    writer.write("[" + TimeFormatter.toString(nextUnit.getBegin() - 10L - recalculateTimeInterval) + "]\n");
                    continue;
                }
                writer.write("[" + TimeFormatter.toString(unit.getCalcEnd() - recalculateTimeInterval) + "]\n");
                continue;
            }
            writer.write("[" + TimeFormatter.toString(unit.getCalcEnd() - recalculateTimeInterval) + "]\n");
        }
        if (unit != null && mediaDuration > unit.getCalcEnd() + 20L) {
            writer.write("[" + TimeFormatter.toString(mediaDuration - Math.min(40L, mediaDuration - unit.getCalcEnd() - 10L)) + "]\n");
            writer.write("[" + TimeFormatter.toString(mediaDuration) + "]");
        }
        writer.close();
    }

    public static void exportTiersMerged(Transcription transcription, String[] tierNames, File exportFile, int minimalDuration) throws IOException {
        Transcription2QtSubtitle.exportTiersMerged(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE, 0L, minimalDuration, 0L, false, null);
    }

    private static char[] replaceBrackets(String value) {
        if (value == null || value.length() == 0) {
            return new char[0];
        }
        char[] ch = value.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] == bracks[0]) {
                ch[i] = bracks[2];
                continue;
            }
            if (ch[i] != bracks[1]) continue;
            ch[i] = bracks[3];
        }
        return ch;
    }

    private static String getSettings(Map<String, Object> newSubtitleSetting) {
        if (newSubtitleSetting != null) {
            StringBuilder setting = new StringBuilder("{QTtext}{timescale:100}");
            if (newSubtitleSetting.get("font") != null) {
                setting.append("{font:");
                setting.append(newSubtitleSetting.get("font").toString());
                setting.append("}");
            } else {
                setting.append("{font:Arial Unicode MS}");
            }
            setting.append("{plain}");
            if (newSubtitleSetting.get("size") != null) {
                setting.append("{size:");
                setting.append(newSubtitleSetting.get("size").toString());
                setting.append("}");
            } else {
                setting.append("{size:12}");
            }
            Color newColor = (Color)newSubtitleSetting.get("backColor");
            int mc = 257;
            if (newColor != null) {
                setting.append("{backColor:");
                setting.append(newColor.getRed() * mc);
                setting.append(",");
                setting.append(newColor.getGreen() * mc);
                setting.append(",");
                setting.append(newColor.getBlue() * mc);
                setting.append("}");
            } else {
                setting.append("{backColor:0,0,0}");
            }
            newColor = (Color)newSubtitleSetting.get("textColor");
            if (newColor != null) {
                setting.append("{textColor:");
                setting.append(newColor.getRed() * mc);
                setting.append(",");
                setting.append(newColor.getGreen() * mc);
                setting.append(",");
                setting.append(newColor.getBlue() * mc);
                setting.append("}");
            } else {
                setting.append("{textColor:65535,65535,65535}");
            }
            if (newSubtitleSetting.get("transparent") != null) {
                if (((Boolean)newSubtitleSetting.get("transparent")).booleanValue()) {
                    setting.append("{keyedText:on}");
                } else {
                    setting.append("{keyedText:off}");
                }
            }
            if (newSubtitleSetting.get("width") != null) {
                setting.append("{width:");
                setting.append(newSubtitleSetting.get("width").toString());
                setting.append("}");
            } else {
                setting.append("{width:320}");
            }
            if (newSubtitleSetting.get("height") != null) {
                setting.append("{height:");
                setting.append(newSubtitleSetting.get("height").toString());
                setting.append("}");
            } else {
                setting.append("{height:0}");
            }
            if (newSubtitleSetting.get("justify") != null) {
                setting.append("{justify:");
                setting.append(newSubtitleSetting.get("justify").toString());
                setting.append("}");
            } else {
                setting.append("{justify:left}");
            }
            setting.append(NEWLINE);
            return setting.toString();
        }
        return "{QTtext}{timescale:100}{font:Arial Unicode MS}{plain}{size:12}{backColor:0,0,0}{textColor:65535,65535,65535}{width:320}{height:0}{justify:left}\n";
    }

    private static Element getSampleElement(Document doc, SubtitleUnit unit, Map<String, String> styleSettings) {
        Element sampleEl = doc.createElement("sample");
        sampleEl.setAttribute("duration", String.valueOf(unit.getCalcEnd() - unit.getBegin()));
        sampleEl.setAttribute("keyframe", "true");
        Element descriptionEl = doc.createElement("description");
        sampleEl.appendChild(descriptionEl);
        descriptionEl.setAttribute("horizontalJustification", styleSettings.get("horizontalJustification"));
        descriptionEl.setAttribute("verticalJustification", styleSettings.get("verticalJustification"));
        descriptionEl.setAttribute("backgroundColor", styleSettings.get("backgroundColor"));
        descriptionEl.setAttribute("format", "tx3g");
        Element textBoxEl = doc.createElement("defaultTextBox");
        descriptionEl.appendChild(textBoxEl);
        textBoxEl.setAttribute("width", styleSettings.get("width"));
        textBoxEl.setAttribute("height", styleSettings.get("height"));
        Element fonttableEl = doc.createElement("fontTable");
        descriptionEl.appendChild(fonttableEl);
        Element fontEl = doc.createElement("font");
        fonttableEl.appendChild(fontEl);
        fontEl.setAttribute("id", "1");
        fontEl.setAttribute("name", styleSettings.get("font"));
        Element sharedEl = doc.createElement("sharedStyles");
        descriptionEl.appendChild(sharedEl);
        Element styleEl = doc.createElement("style");
        sharedEl.appendChild(styleEl);
        styleEl.setAttribute("id", "1");
        styleEl.appendChild(doc.createTextNode(Transcription2QtSubtitle.getStyleString("1", styleSettings)));
        Element dataEl = doc.createElement("sampleData");
        sampleEl.appendChild(dataEl);
        dataEl.setAttribute("targetEncoding", "utf8");
        Element textEl = doc.createElement("text");
        dataEl.appendChild(textEl);
        textEl.setAttribute("styleID", "1");
        if (unit.getValues().length == 1) {
            textEl.appendChild(doc.createTextNode(unit.getValues()[0]));
        } else if (unit.getValues().length > 1) {
            StringBuilder sb = new StringBuilder(unit.getValues()[0]);
            for (int i = 1; i < unit.getValues().length; ++i) {
                sb.append(" ");
                sb.append(unit.getValues()[i]);
            }
            textEl.appendChild(doc.createTextNode(sb.toString()));
        }
        return sampleEl;
    }

    private static String getStyleString(String id, Map<String, String> styleSettings) {
        return String.format("{font-table: %s}{font-size: %s}{font-style: normal}{font-weight: normal}{text-decoration: normal}{color: %s}", id, styleSettings.get("fontSize"), styleSettings.get("foregroundColor"));
    }

    private static String colorToPercentString(Color c) {
        float max = 255.0f;
        int r = (int)((float)c.getRed() / max * 100.0f);
        int g = (int)((float)c.getGreen() / max * 100.0f);
        int b = (int)((float)c.getBlue() / max * 100.0f);
        int a = (int)((float)c.getAlpha() / max * 100.0f);
        return String.format("%d%5$s, %d%5$s, %d%5$s, %d%5$s", r, g, b, a, "%");
    }

    private static Map<String, String> toTx3gStyleMap(Map<String, Object> settingsMap) {
        Color fc;
        String horJust;
        HashMap<String, String> tx3gMap = new HashMap<String, String>();
        if (settingsMap == null) {
            settingsMap = new HashMap<String, Object>(0);
        }
        if ((horJust = (String)settingsMap.get("justify")) != null) {
            tx3gMap.put("horizontalJustification", horJust.replaceFirst(horJust.substring(0, 1), String.valueOf(Character.toUpperCase(horJust.charAt(0)))));
        } else {
            tx3gMap.put("horizontalJustification", "Center");
        }
        tx3gMap.put("verticalJustification", "Bottom");
        tx3gMap.put("backgroundColor", "0%, 0%, 0% 0%");
        tx3gMap.put("foregroundColor", "100%, 100%, 100%, 100%");
        Boolean transparent = (Boolean)settingsMap.get("transparent");
        Color bc = (Color)settingsMap.get("backColor");
        if (bc == null) {
            if (transparent != null && !transparent.booleanValue()) {
                tx3gMap.put("backgroundColor", "0%, 0%, 0% 100%");
            }
        } else if (transparent == null || !transparent.booleanValue()) {
            tx3gMap.put("backgroundColor", Transcription2QtSubtitle.colorToPercentString(bc));
        }
        if ((fc = (Color)settingsMap.get("textColor")) == null) {
            tx3gMap.put("foregroundColor", "100%, 100%, 100%, 100%");
        } else {
            tx3gMap.put("foregroundColor", Transcription2QtSubtitle.colorToPercentString(fc));
        }
        Integer width = (Integer)settingsMap.get("width");
        if (width == null) {
            tx3gMap.put("width", "320");
        } else {
            tx3gMap.put("width", String.valueOf(width));
        }
        Integer height = (Integer)settingsMap.get("height");
        if (height == null) {
            tx3gMap.put("height", "50");
        } else {
            tx3gMap.put("height", String.valueOf(height));
        }
        Integer vidHeight = (Integer)settingsMap.get("videoHeight");
        if (vidHeight == null) {
            tx3gMap.put("videoHeight", "240");
        } else {
            tx3gMap.put("videoHeight", String.valueOf(vidHeight));
        }
        String fontName = (String)settingsMap.get("font");
        if (fontName != null) {
            tx3gMap.put("font", fontName);
        } else {
            tx3gMap.put("font", "Arial Unicode MS");
        }
        Integer fontSize = (Integer)settingsMap.get("size");
        if (fontSize != null) {
            tx3gMap.put("fontSize", String.valueOf(fontSize));
        } else {
            tx3gMap.put("fontSize", "24");
        }
        return tx3gMap;
    }

    private static void exportTiersTx3g(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, long offset, int minimalDuration, long mediaDuration, boolean reCalculateTime, Map<String, String> newSubtitleSetting) throws IOException {
        Annotation[] annotations = null;
        long recalculateTimeInterval = 0L;
        if (reCalculateTime) {
            recalculateTimeInterval = beginTime;
            offset = 0L;
            block3: for (int j = 0; j < tierNames.length; ++j) {
                Tier tier = transcription.getTierWithId(tierNames[j]);
                annotations = tier.getAnnotations().toArray(new Annotation[0]);
                for (int i = 0; i < annotations.length; ++i) {
                    long b;
                    if (annotations[i] == null || !TimeRelation.overlaps(annotations[i], beginTime, endTime) || (b = annotations[i].getBeginTimeBoundary()) >= recalculateTimeInterval) continue;
                    recalculateTimeInterval = b;
                    continue block3;
                }
            }
            annotations = null;
        }
        HashMap<String, Object> tierToFileNameMap = new HashMap<String, Object>(tierNames.length);
        if (tierNames.length == 1) {
            tierToFileNameMap.put(tierNames[0], exportFile.getAbsolutePath());
        } else {
            int dotIndex = exportFile.getAbsolutePath().lastIndexOf(46);
            String[] stringArray = tierNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String tn = stringArray[i];
                Object nextName = exportFile.getAbsolutePath();
                nextName = dotIndex > 0 ? ((String)nextName).substring(0, dotIndex) + "_" + tn.replaceAll("[:;/|!?\\\\]", "_") + ((String)nextName).substring(dotIndex) : (String)nextName + "_" + tn.replaceAll("[:;/|!?\\\\]", "_");
                tierToFileNameMap.put(tn, nextName);
            }
        }
        int failedExports = 0;
        for (String tierName : tierNames) {
            TierImpl t = (TierImpl)transcription.getTierWithId(tierName);
            String language = "eng";
            if (t.getLangRef() != null) {
                language = t.getLangRef();
            }
            List<AbstractAnnotation> annots = t.getAnnotations();
            ArrayList<SubtitleUnit> subUnits = new ArrayList<SubtitleUnit>();
            long lastE = 0L;
            for (AbstractAnnotation aa : annots) {
                if (aa == null) continue;
                if (TimeRelation.overlaps(aa, beginTime, endTime)) {
                    long b = aa.getBeginTimeBoundary();
                    long d = b + (long)minimalDuration;
                    long e = Math.max(aa.getEndTimeBoundary(), d);
                    if (lastE < e) {
                        lastE = e;
                    }
                    subUnits.add(new SubtitleUnit(b - recalculateTimeInterval + offset, e - recalculateTimeInterval + offset, aa.getValue()));
                    continue;
                }
                if (aa.getBeginTimeBoundary() <= endTime) continue;
                break;
            }
            SubtitleUnit suCur = null;
            SubtitleUnit suPrev = null;
            for (int j = subUnits.size() - 1; j >= 0; --j) {
                suCur = (SubtitleUnit)subUnits.get(j);
                if (j > 0) {
                    if (j == subUnits.size() - 1 && suCur.getRealEnd() < mediaDuration) {
                        subUnits.add(new SubtitleUnit(suCur.getRealEnd(), mediaDuration, ""));
                    }
                    suPrev = (SubtitleUnit)subUnits.get(j - 1);
                    if (suCur.getBegin() <= suPrev.getRealEnd()) continue;
                    subUnits.add(j, new SubtitleUnit(suPrev.getRealEnd(), suCur.getBegin(), ""));
                    continue;
                }
                if (suCur.getBegin() <= 0L) continue;
                subUnits.add(0, new SubtitleUnit(0L, suCur.getBegin(), ""));
            }
            Document doc = Transcription2QtSubtitle.getT3GTrackDocument();
            Element root = doc.createElement("text3GTrack");
            root.setAttribute("trackWidth", newSubtitleSetting.get("width"));
            root.setAttribute("trackHeight", newSubtitleSetting.get("height"));
            root.setAttribute("transform", "translate(0.0,0.0)");
            root.setAttribute("timeScale", "1000");
            root.setAttribute("language", language);
            doc.appendChild(root);
            for (SubtitleUnit su : subUnits) {
                Element sampleEl = Transcription2QtSubtitle.getSampleElement(doc, su, newSubtitleSetting);
                if (sampleEl == null) continue;
                root.appendChild(sampleEl);
            }
            try {
                FileOutputStream outputstream = new FileOutputStream((String)tierToFileNameMap.get(tierName));
                DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)doc.getImplementation());
                LSSerializer serializer = domImplLS.createLSSerializer();
                serializer.getDomConfig().setParameter("format-pretty-print", true);
                LSOutput destination = domImplLS.createLSOutput();
                destination.setEncoding("utf-8");
                destination.setByteStream(outputstream);
                serializer.write(doc, destination);
                outputstream.close();
            }
            catch (FileNotFoundException fnfe) {
                ClientLogger.LOG.severe("Cannot write to file: " + fnfe.getMessage());
                ++failedExports;
            }
            catch (IOException ioe) {
                ClientLogger.LOG.severe("Cannot export the XML: " + ioe.getMessage());
                ++failedExports;
            }
        }
        if (failedExports > 0) {
            throw new IOException(String.format("Some tiers could not be exported: %d", failedExports));
        }
    }

    private static Document getT3GTrackDocument() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (db != null) {
                Document doc = db.newDocument();
                ProcessingInstruction piNode = doc.createProcessingInstruction("quicktime", "type=\"application/x-quicktime-texml\"");
                if (piNode != null) {
                    doc.appendChild(piNode);
                }
                return doc;
            }
        }
        catch (FactoryConfigurationError fce) {
            ClientLogger.LOG.severe("Unable to create an XML Document Builder: " + fce.getMessage());
        }
        catch (ParserConfigurationException pce) {
            ClientLogger.LOG.severe("Unable to create an XML Document Builder: " + pce.getMessage());
        }
        return null;
    }
}

