/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.List;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.SubtitleSequencer;
import mpi.eudico.client.util.SubtitleUnit;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.util.TimeFormatter;

public class Transcription2SubtitleText
implements ClientLogger {
    private final String WIN_NEWLINE = "\r\n";
    private static final DecimalFormat twoDigits = new DecimalFormat("00");

    public void exportTiersSRT(Transcription transcription, String[] tierNames, File exportFile, String encoding, long beginTime, long endTime, int minimalDuration, long offset, boolean reCalculateTime) throws IOException {
        if (exportFile == null) {
            LOG.severe("No export file specified");
            return;
        }
        long recalculateTimeInterval = 0L;
        boolean selection = false;
        if (reCalculateTime) {
            recalculateTimeInterval = beginTime;
            offset = 0L;
        }
        SubtitleSequencer sequencer = new SubtitleSequencer();
        List<SubtitleUnit> allUnits = sequencer.createSequence(transcription, tierNames, beginTime, endTime, minimalDuration, offset, true);
        FileOutputStream out = null;
        BufferedWriter writer = null;
        out = new FileOutputStream(exportFile);
        if (encoding != null) {
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.warning("Encoding not supported: " + encoding);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            }
        } else {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        }
        for (int i = 0; i < allUnits.size(); ++i) {
            SubtitleUnit unit = allUnits.get(i);
            writer.write(String.valueOf(i + 1));
            writer.write("\r\n");
            Long b = unit.getBegin();
            Long e = unit.getCalcEnd();
            if (!selection && b < recalculateTimeInterval) {
                recalculateTimeInterval = b;
                selection = true;
            }
            writer.write(TimeFormatter.toString(b - recalculateTimeInterval).replace('.', ','));
            writer.write(" --> ");
            writer.write(TimeFormatter.toString(e - recalculateTimeInterval).replace('.', ','));
            writer.write("\r\n");
            for (int j = 0; j < unit.getValues().length; ++j) {
                writer.write(unit.getValues()[j].replace('\n', ' '));
                if (j == unit.getValues().length - 1) continue;
                writer.write("\r\n");
            }
            writer.write("\r\n");
            writer.write("\r\n");
        }
        writer.close();
    }

    public void exportTiersSRT(Transcription transcription, String[] tierNames, File exportFile, String encoding, long beginTime, long endTime, int minimalDuration, long offset) throws IOException {
        this.exportTiersSRT(transcription, tierNames, exportFile, encoding, beginTime, endTime, minimalDuration, offset, false);
    }

    public void exportTiersSRT(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, int minimalDuration) throws IOException {
        this.exportTiersSRT(transcription, tierNames, exportFile, null, beginTime, endTime, minimalDuration, 0L, false);
    }

    public void exportTiersSRT(Transcription transcription, String[] tierNames, File exportFile) throws IOException {
        this.exportTiersSRT(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE, 0);
    }

    private String toSTLTimecode(long time, double frameRate) {
        Object tc = null;
        if (frameRate == 25.0) {
            tc = TimeFormatter.toTimecodePAL(time);
        } else if (frameRate == 29.97) {
            tc = TimeFormatter.toTimecodeNTSC(time);
        } else if (frameRate == 30.0) {
            int fc = (int)((double)time * 29.97 / 1000.0);
            String hours = twoDigits.format(fc / 30 / 60 / 60 % 24);
            String minutes = twoDigits.format(fc / 30 / 60 % 60);
            String seconds = twoDigits.format(fc / 30 % 60);
            String frames = twoDigits.format(fc % 30);
            tc = hours + ":" + minutes + ":" + seconds + "." + frames;
        } else {
            tc = TimeFormatter.toTimecodePAL(time);
        }
        tc = ((String)tc).substring(0, 8) + "." + ((String)tc).substring(9);
        return tc;
    }

    public void exportTiersSTL(Transcription transcription, String[] tierNames, File exportFile, String encoding, long beginTime, long endTime, int minimalDuration, long offset, double frameRate, boolean reCalculateTime) throws IOException {
        if (exportFile == null) {
            LOG.severe("No export file specified");
            return;
        }
        long recalculateTimeInterval = 0L;
        boolean selection = false;
        if (reCalculateTime) {
            recalculateTimeInterval = beginTime;
            offset = 0L;
        }
        SubtitleSequencer sequencer = new SubtitleSequencer();
        List<SubtitleUnit> allUnits = sequencer.createSequence(transcription, tierNames, beginTime, endTime, minimalDuration, offset, true);
        FileOutputStream out = null;
        BufferedWriter writer = null;
        out = new FileOutputStream(exportFile);
        if (encoding != null) {
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.warning("Encoding not supported: " + encoding);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            }
        } else {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        }
        writer.write("$TapeOffset = False");
        writer.write("\r\n");
        for (int i = 0; i < allUnits.size(); ++i) {
            SubtitleUnit unit = allUnits.get(i);
            Long b = unit.getBegin();
            Long e = unit.getCalcEnd();
            if (!selection && b < recalculateTimeInterval) {
                recalculateTimeInterval = b;
                selection = true;
            }
            writer.write(this.toSTLTimecode(b - recalculateTimeInterval, frameRate));
            writer.write(44);
            writer.write(this.toSTLTimecode(e - recalculateTimeInterval, frameRate));
            writer.write(44);
            String[] values = unit.getValues();
            for (int j = 0; j < values.length; ++j) {
                writer.write(values[j].replace('\n', '|'));
                if (j >= values.length - 1) continue;
                writer.write(124);
            }
            writer.write("\r\n");
        }
        writer.close();
    }

    public void exportTiersSTL(Transcription transcription, String[] tierNames, File exportFile, String encoding, long beginTime, long endTime, int minimalDuration, long offset, double frameRate) throws IOException {
        this.exportTiersSTL(transcription, tierNames, exportFile, null, beginTime, endTime, minimalDuration, 0L, -1.0, false);
    }

    public void exportTiersSTL(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, int minimalDuration) throws IOException {
        this.exportTiersSTL(transcription, tierNames, exportFile, null, beginTime, endTime, minimalDuration, 0L, -1.0);
    }

    public void exportTiersSTL(Transcription transcription, String[] tierNames, File exportFile) throws IOException {
        this.exportTiersSTL(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE, 0);
    }

    public void exportTiersLRC(Transcription transcription, String[] tierNames, File exportFile, String encoding, long beginTime, long endTime, int minimalDuration, long offset, boolean reCalculateTime) throws IOException {
        if (exportFile == null) {
            LOG.severe("No export file specified");
            return;
        }
        long recalculateTimeInterval = 0L;
        boolean selection = false;
        if (reCalculateTime) {
            recalculateTimeInterval = beginTime;
            offset = 0L;
        }
        SubtitleSequencer sequencer = new SubtitleSequencer();
        List<SubtitleUnit> allUnits = sequencer.createSequence(transcription, tierNames, beginTime, endTime, minimalDuration, offset, true);
        FileOutputStream out = null;
        BufferedWriter writer = null;
        out = new FileOutputStream(exportFile);
        if (encoding != null) {
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.warning("Encoding not supported: " + encoding);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            }
        } else {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        }
        writer.write("\r\n");
        for (int i = 0; i < allUnits.size(); ++i) {
            SubtitleUnit unit = allUnits.get(i);
            Long b = unit.getBegin();
            Long e = unit.getCalcEnd();
            if (!selection && b < recalculateTimeInterval) {
                recalculateTimeInterval = b;
                selection = true;
            }
            writer.write(91);
            writer.write(this.toLRCTimeCode(b - recalculateTimeInterval));
            writer.write(93);
            String[] values = unit.getValues();
            for (int j = 0; j < values.length; ++j) {
                writer.write(values[j].replace('\n', ' '));
                if (j >= values.length - 1) continue;
                writer.write(32);
            }
            writer.write("\r\n");
            if (i >= allUnits.size() - 1) continue;
            SubtitleUnit nextUnit = allUnits.get(i + 1);
            if (e >= nextUnit.getBegin() - 100L) continue;
            writer.write(91);
            writer.write(this.toLRCTimeCode(e - recalculateTimeInterval));
            writer.write(93);
            writer.write("\r\n");
        }
        writer.close();
    }

    private String toLRCTimeCode(long t) {
        long minutes = t / 60000L;
        String minString = twoDigits.format(minutes);
        long seconds = (t - 60000L * minutes) / 1000L;
        String secString = twoDigits.format(seconds);
        long millis = (t - 60000L * minutes - 1000L * seconds) / 10L;
        String msString = twoDigits.format(millis);
        return minString + ":" + secString + "." + msString;
    }

    public void exportTiersTTML(Transcription transcription, String[] tierNames, File exportFile, String encoding, long beginTime, long endTime, int minimalDuration, long offset, boolean reCalculateTime) throws IOException {
        if (exportFile == null) {
            LOG.severe("No export file specified");
            return;
        }
        long recalculateTimeInterval = 0L;
        boolean selection = false;
        if (reCalculateTime) {
            recalculateTimeInterval = beginTime;
            offset = 0L;
        }
        SubtitleSequencer sequencer = new SubtitleSequencer();
        List<SubtitleUnit> allUnits = sequencer.createSequence(transcription, tierNames, beginTime, endTime, minimalDuration, offset, true);
        FileOutputStream out = null;
        BufferedWriter writer = null;
        out = new FileOutputStream(exportFile);
        if (encoding != null) {
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.warning("Encoding not supported: " + encoding);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            }
        } else {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        }
        String IND1 = "    ";
        String IND2 = "        ";
        String IND3 = "            ";
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write("\r\n");
        writer.write("<tt xmlns=\"http://www.w3.org/ns/ttml\">");
        writer.write("\r\n");
        writer.write("    <head>");
        writer.write("\r\n");
        writer.write("        <metadata xmlns:ttm=\"http://www.w3.org/ns/ttml#metadata\">");
        writer.write("\r\n");
        writer.write("            <ttm:title>" + transcription.getName() + "</ttm:title>");
        writer.write("\r\n");
        writer.write("        </metadata>");
        writer.write("\r\n");
        writer.write("    </head>");
        writer.write("\r\n");
        writer.write("    <body><div>");
        writer.write("\r\n");
        for (int i = 0; i < allUnits.size(); ++i) {
            SubtitleUnit unit = allUnits.get(i);
            Long b = unit.getBegin();
            Long e = unit.getCalcEnd();
            if (!selection && b < recalculateTimeInterval) {
                recalculateTimeInterval = b;
                selection = true;
            }
            writer.write("        <p begin=\"");
            writer.write(TimeFormatter.toSSMSString(b - recalculateTimeInterval));
            writer.write("s\" end=\"");
            writer.write(TimeFormatter.toSSMSString(e - recalculateTimeInterval));
            writer.write("s\">");
            writer.write("\r\n");
            for (int j = 0; j < unit.getValues().length; ++j) {
                writer.write("            " + unit.getValues()[j].replace('\n', ' '));
                if (j == unit.getValues().length - 1) continue;
                writer.write("<br/>");
                writer.write("\r\n");
            }
            writer.write("\r\n");
            writer.write("        </p>");
            writer.write("\r\n");
        }
        writer.write("    </div></body>");
        writer.write("\r\n");
        writer.write("</tt>");
        writer.close();
    }
}

