/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.MutableInt;

public class Transcription2WordList
implements ClientLogger {
    private final String NEWLINE = "\n";
    private String delimiters = " \t\n\r\f.,!?\"'";

    public void exportWords(TranscriptionImpl transcription, List<String> tierNames, File exportFile, String charEncoding, String delimiters, boolean countOccurrences) throws IOException {
        if (countOccurrences) {
            this.exportWordsAndCount(transcription, tierNames, exportFile, charEncoding, delimiters);
            return;
        }
        if (exportFile == null) {
            LOG.warning("No destination file specified for export");
            throw new IOException("No destination file specified for export");
        }
        if (transcription == null) {
            LOG.severe("No transcription specified for wordlist");
            return;
        }
        if (tierNames == null) {
            LOG.warning("No tiers specified for the wordlist: using all tiers");
        }
        if (delimiters != null) {
            this.delimiters = delimiters;
        }
        TreeSet<String> uniqueWords = new TreeSet<String>();
        this.addUniqueWords(uniqueWords, transcription, tierNames);
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        for (String word : uniqueWords) {
            writer.write(word);
            writer.write("\n");
        }
        writer.close();
    }

    public void exportWords(List<File> files, List<String> tierNames, File exportFile, String charEncoding, String delimiters, boolean countOccurrences) throws IOException {
        if (countOccurrences) {
            this.exportWordsAndCount(files, tierNames, exportFile, charEncoding, delimiters);
            return;
        }
        if (exportFile == null) {
            LOG.warning("No destination file specified for export");
            throw new IOException("No destination file specified for export");
        }
        if (files == null || files.size() == 0) {
            LOG.warning("No files specified for export");
            throw new IOException("No files specified for export");
        }
        if (delimiters != null) {
            this.delimiters = delimiters;
        }
        TreeSet<String> uniqueWords = new TreeSet<String>();
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            if (file == null) continue;
            try {
                TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                this.addUniqueWords(uniqueWords, trans, tierNames);
                continue;
            }
            catch (Exception ex) {
                LOG.severe("Could not handle file: " + file.getAbsolutePath());
                LOG.severe(ex.getMessage());
            }
        }
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        for (String word : uniqueWords) {
            writer.write(word);
            writer.write("\n");
        }
        writer.close();
    }

    private void addUniqueWords(Set<String> uniqueWords, TranscriptionImpl transcription, List<String> tierNames) {
        if (transcription == null) {
            LOG.severe("No transcription specified to extract words from");
            return;
        }
        List<TierImpl> tierList = tierNames != null ? transcription.getTiersWithIds(tierNames) : transcription.getTiers();
        for (Tier tier : tierList) {
            for (Annotation annotation : tier.getAnnotations()) {
                if (annotation != null) {
                    String value = annotation.getValue();
                    if (value.length() <= 0) continue;
                    if (this.delimiters.length() > 0) {
                        StringTokenizer tokenizer = new StringTokenizer(value, this.delimiters);
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            uniqueWords.add(token);
                        }
                        continue;
                    }
                    uniqueWords.add(value);
                    continue;
                }
                LOG.warning("Annotation is null");
            }
        }
    }

    public void exportWordsAndCount(TranscriptionImpl transcription, List<String> tierNames, File exportFile, String charEncoding, String delimiters) throws IOException {
        if (exportFile == null) {
            LOG.warning("No destination file specified for export");
            throw new IOException("No destination file specified for export");
        }
        if (transcription == null) {
            LOG.severe("No transcription specified for wordlist");
            return;
        }
        if (tierNames == null) {
            LOG.warning("No tiers specified for the wordlist: using all tiers");
        }
        if (delimiters != null) {
            this.delimiters = delimiters;
        }
        TreeMap<String, MutableInt> uniqueWords = new TreeMap<String, MutableInt>();
        this.addUniqueWordsAndCount(uniqueWords, transcription, tierNames);
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        for (Map.Entry e : uniqueWords.entrySet()) {
            String key = (String)e.getKey();
            MutableInt val = (MutableInt)e.getValue();
            writer.write(key);
            writer.write("\t" + val.intValue);
            writer.write("\n");
        }
        writer.close();
    }

    public void exportWordsAndCount(List<File> files, List<String> tierNames, File exportFile, String charEncoding, String delimiters) throws IOException {
        if (exportFile == null) {
            LOG.warning("No destination file specified for export");
            throw new IOException("No destination file specified for export");
        }
        if (files == null || files.size() == 0) {
            LOG.warning("No files specified for export");
            throw new IOException("No files specified for export");
        }
        if (delimiters != null) {
            this.delimiters = delimiters;
        }
        TreeMap<String, MutableInt> uniqueWords = new TreeMap<String, MutableInt>();
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            if (file == null) continue;
            try {
                TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                this.addUniqueWordsAndCount(uniqueWords, trans, tierNames);
                continue;
            }
            catch (Exception ex) {
                LOG.severe("Could not handle file: " + file.getAbsolutePath());
                LOG.severe(ex.getMessage());
            }
        }
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        for (Map.Entry e : uniqueWords.entrySet()) {
            String key = (String)e.getKey();
            MutableInt val = (MutableInt)e.getValue();
            writer.write(key);
            writer.write("\t" + val.intValue);
            writer.write("\n");
        }
        writer.close();
    }

    private void addUniqueWordsAndCount(Map<String, MutableInt> uniqueWords, TranscriptionImpl transcription, List<String> tierNames) {
        if (transcription == null) {
            LOG.severe("No transcription specified to extract words from");
            return;
        }
        List<TierImpl> tierList = tierNames != null ? transcription.getTiersWithIds(tierNames) : transcription.getTiers();
        for (Tier tier : tierList) {
            if (tier == null) continue;
            for (Annotation annotation : tier.getAnnotations()) {
                if (annotation != null) {
                    String value = annotation.getValue();
                    if (value.length() <= 0) continue;
                    if (this.delimiters.length() > 0) {
                        StringTokenizer tokenizer = new StringTokenizer(value, this.delimiters);
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            if (!uniqueWords.containsKey(token)) {
                                uniqueWords.put(token, new MutableInt(1));
                                continue;
                            }
                            ++uniqueWords.get((Object)token).intValue;
                        }
                        continue;
                    }
                    if (!uniqueWords.containsKey(value)) {
                        uniqueWords.put(value, new MutableInt(1));
                        continue;
                    }
                    ++uniqueWords.get((Object)value).intValue;
                    continue;
                }
                LOG.warning("Annotation is null");
            }
        }
    }
}

