/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ECVStore;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.RecentLanguages;

public class TranscriptionECVLoader {
    private HashMap<String, List<ExternalCV>> urlMap;

    public void loadExternalCVs(TranscriptionImpl transcription, Frame parent) {
        this.loadExternalCVs(transcription, parent, true);
    }

    public void loadExternalCVs(TranscriptionImpl transcription, Frame parent, Boolean checkConsistency) {
        int numCV = transcription.getControlledVocabularies().size();
        if (numCV > 0) {
            int numLoadedExternal = 0;
            ControlledVocabulary cv = null;
            ECVStore ecvStore = null;
            this.urlMap = new HashMap(4);
            for (int i = 0; i < numCV; ++i) {
                String urlString;
                ExternalReference extRef;
                ExternalCV ecv;
                cv = transcription.getControlledVocabularies().get(i);
                if (!(cv instanceof ExternalCV) || (ecv = (ExternalCV)cv).isLoadedFromURL() || ecv.isLoadedFromCache() || !((extRef = ecv.getExternalRef()) instanceof ExternalReference) || extRef.getReferenceType() != 4 || (urlString = extRef.getValue()) == null) continue;
                if (this.urlMap.containsKey(urlString)) {
                    this.urlMap.get(urlString).add(ecv);
                    continue;
                }
                ArrayList<ExternalCV> ecvList = new ArrayList<ExternalCV>(4);
                ecvList.add(ecv);
                this.urlMap.put(urlString, ecvList);
            }
            Iterator<String> keyIt = this.urlMap.keySet().iterator();
            String urlStr = null;
            List<ExternalCV> ecvList = null;
            String cachedCVBase = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + "CVCACHE";
            while (keyIt.hasNext()) {
                String cachedCV = cachedCVBase;
                urlStr = keyIt.next();
                ecvList = this.urlMap.get(urlStr);
                if (ecvStore == null) {
                    ecvStore = new ECVStore();
                }
                try {
                    ecvStore.loadExternalCVS(ecvList, urlStr);
                    for (ExternalCV excv : ecvList) {
                        excv.setLoadedFromURL(true);
                        for (int i = 0; i < excv.getNumberOfLanguages(); ++i) {
                            LangInfo lInfo = excv.getLangInfo(i);
                            int li = RecentLanguages.getInstance().addRecentLanguage(lInfo);
                            if (!ClientLogger.LOG.isLoggable(Level.FINE)) continue;
                            ClientLogger.LOG.fine(String.format("Added language %s (%s) at index %d", lInfo.getId(), lInfo.getLabel(), li));
                        }
                    }
                    numLoadedExternal += ecvList.size();
                    ecvStore.storeExternalCVS(ecvList, cachedCV, urlStr);
                }
                catch (Exception exc) {
                    try {
                        URL url = new URL(urlStr);
                        String urlHost = url.getHost();
                        if (urlHost.equals("")) {
                            urlHost = "localfile_system";
                        }
                        cachedCV = cachedCV + Constants.FILESEPARATOR + urlHost;
                        String[] pathElements = url.getPath().substring(1).split("/");
                        for (int j = 0; j < pathElements.length; ++j) {
                            cachedCV = cachedCV + Constants.FILESEPARATOR + pathElements[j];
                        }
                        ecvStore.loadExternalCVS(ecvList, cachedCV);
                        for (ExternalCV excv : ecvList) {
                            excv.setLoadedFromCache(true);
                        }
                        String message = ElanLocale.getString("LoadExternalCV.Message.Readerror") + " " + urlStr + "\n" + ElanLocale.getString("LoadExternalCV.Message.LoadedFromCache");
                        if (parent != null) {
                            JOptionPane.showMessageDialog(parent, message, ElanLocale.getString("Message.Warning"), 2);
                            continue;
                        }
                        ClientLogger.LOG.warning("Warning: " + message);
                    }
                    catch (Exception ex) {
                        String message = ElanLocale.getString("LoadExternalCV.Message.Readerror") + " " + urlStr + "\n" + ElanLocale.getString("LoadExternalCV.Message.NotLoadedFromCache");
                        if (parent != null) {
                            JOptionPane.showMessageDialog(parent, message, ElanLocale.getString("Message.Warning"), 2);
                            continue;
                        }
                        ClientLogger.LOG.warning("Warning: " + message);
                    }
                }
            }
            if (checkConsistency.booleanValue() && numLoadedExternal > 0) {
                boolean annotationValuePrecedence = false;
                Boolean prefBool = Preferences.getBool("AnnotationValuePrecedenceOverCVERef", null);
                if (prefBool != null) {
                    annotationValuePrecedence = prefBool;
                }
                transcription.checkAnnotECVConsistency(annotationValuePrecedence);
            }
        }
    }

    public HashMap<String, List<ExternalCV>> getLoadedECVMap() {
        return this.urlMap;
    }
}

