/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import mpi.eudico.client.util.WAVCuePoint;
import mpi.eudico.client.util.WAVCueSection;

public class WAVHeader {
    public static final short WAVE_FORMAT_UNCOMPRESSED = 0;
    public static final short WAVE_FORMAT_PCM = 1;
    public static final short WAVE_FORMAT_IEEE_FLOAT = 3;
    public static final short WAVE_FORMAT_ALAW = 6;
    public static final short WAVE_FORMAT_MULAW = 7;
    public static final String[] formatDescriptions = new String[]{"Unknown", "PCM (uncompressed)", "MS ADPCM", "IEEE float", "", "IBM CVSD", "8-bit ITU-T G.711 A-law", "8-bit ITU-T G.711 \u00b5-law"};
    private HashMap<String, String> infos = new HashMap();
    private WAVCuePoint[] cuePoints = new WAVCuePoint[0];
    private WAVCueSection[] cueSections = new WAVCueSection[0];
    private char[] dID = new char[4];
    private char[] fID = new char[4];
    private short[] formatSpecific;
    private char[] riff = new char[4];
    private char[] wID = new char[4];
    private int dLen;
    private int fLen;
    private int headerSize;
    private int nAvgBytesPerSec;
    private int nSamplesPerSec;
    private int rLen;
    private long fileSize;
    private short nBlockAlign;
    private short nChannels;
    private short wFormatTag;
    private short wBitsPerSample;
    private short cbSize;
    private char[] factID;
    private int factLen;
    private int dwSampleLength;
    private long dataLengthLong = 0L;

    public WAVHeader(String fileName) {
        try {
            this.read(new RandomAccessFile(fileName, "r"));
        }
        catch (FileNotFoundException fne) {
            System.out.println("File " + fileName + " not found.");
            return;
        }
        catch (IOException e) {
            this.setInvalid();
        }
    }

    public WAVHeader(RandomAccessFile soundFile) {
        try {
            this.read(soundFile);
        }
        catch (IOException e) {
            this.setInvalid();
        }
    }

    private void setInvalid() {
        this.headerSize = 0;
        this.nChannels = 0;
        this.wFormatTag = 0;
        this.dLen = 0;
        this.dataLengthLong = 0L;
        this.fileSize = 0L;
        this.nSamplesPerSec = 1;
        this.nBlockAlign = 1;
        this.infos = new HashMap();
        this.cuePoints = new WAVCuePoint[0];
        this.cueSections = new WAVCueSection[0];
    }

    public short getCompressionCode() {
        return this.wFormatTag;
    }

    public String getCompressionString(short compressionCode) {
        switch (compressionCode) {
            case 0: {
                return formatDescriptions[0];
            }
            case 1: {
                return formatDescriptions[1];
            }
            case 2: {
                return formatDescriptions[2];
            }
            case 6: {
                return formatDescriptions[6];
            }
            case 7: {
                return formatDescriptions[7];
            }
            case 17: {
                return "IMA ADPCM";
            }
            case 20: {
                return "ITU G.723 ADPCM";
            }
            case 49: {
                return "GSM 6.10";
            }
            case 64: {
                return "ITU G.721 ADPCM";
            }
            case 80: {
                return "MPEG";
            }
            case -2: {
                return "WAVE Format Extensible";
            }
        }
        return formatDescriptions[0];
    }

    public WAVCuePoint[] getCuePoints() {
        return this.cuePoints;
    }

    public WAVCueSection[] getCueSections() {
        return this.cueSections;
    }

    public long getDataLength() {
        return this.dataLengthLong;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public int getFrequency() {
        return this.nSamplesPerSec;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public String getInfo() {
        StringBuilder info = new StringBuilder();
        for (String key : this.infos.keySet()) {
            info.append("\n" + key + " : " + this.infos.get(key));
        }
        return info.toString();
    }

    public short getNumberOfChannels() {
        return this.nChannels;
    }

    public short getSampleSize() {
        return this.nBlockAlign;
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                WAVHeader wavHeader = new WAVHeader(args[0]);
                System.out.println(wavHeader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(RandomAccessFile soundFile) throws IOException, InvalidHeaderException {
        int i;
        this.fileSize = soundFile.length();
        byte[] b = new byte[12];
        int rc = soundFile.read(b);
        if (rc != b.length) {
            throw new InvalidHeaderException();
        }
        for (i = 0; i < 4; ++i) {
            this.riff[i] = (char)b[i];
        }
        if (!"RIFF".equals(new String(this.riff))) {
            throw new InvalidHeaderException("RIFF marker not found");
        }
        this.rLen = WAVHeader.getInt(b[4], b[5], b[6], b[7]);
        for (i = 0; i < 4; ++i) {
            this.wID[i] = (char)b[8 + i];
        }
        if (!"WAVE".equals(new String(this.wID))) {
            throw new InvalidHeaderException("WAVE marker not found");
        }
        this.headerSize = 12;
        while (true) {
            if ((rc = soundFile.read(b = new byte[8])) != b.length) {
                throw new InvalidHeaderException();
            }
            this.headerSize += 8;
            String chunkID = WAVHeader.getString(b, 4);
            int chunkDataSize = WAVHeader.getInt(b[4], b[5], b[6], b[7]);
            if ("data".equalsIgnoreCase(chunkID)) {
                this.dID = chunkID.toCharArray();
                this.dLen = chunkDataSize;
                if (chunkDataSize < 0) {
                    try {
                        this.dataLengthLong = Long.decode(String.format("%#x", chunkDataSize));
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidHeaderException(nfe);
                    }
                    if (this.dataLengthLong >= 0L) break;
                    throw new InvalidHeaderException("Failed to detect the data chunk size");
                }
                this.dataLengthLong = this.dLen;
                break;
            }
            if (chunkDataSize < 0) {
                throw new InvalidHeaderException("Cannot read the size of the data size chunk");
            }
            b = new byte[chunkDataSize];
            rc = soundFile.read(b);
            if (rc != b.length) {
                throw new InvalidHeaderException();
            }
            if ("fmt ".equals(chunkID)) {
                if (chunkDataSize < 14) {
                    throw new InvalidHeaderException("Failed to read the fmt section");
                }
                this.fID = chunkID.toCharArray();
                this.fLen = chunkDataSize;
                this.wFormatTag = WAVHeader.getShort(b[0], b[1]);
                this.nChannels = WAVHeader.getShort(b[2], b[3]);
                this.nSamplesPerSec = WAVHeader.getInt(b[4], b[5], b[6], b[7]);
                this.nAvgBytesPerSec = WAVHeader.getInt(b[8], b[9], b[10], b[11]);
                this.nBlockAlign = WAVHeader.getShort(b[12], b[13]);
                int index = 14;
                int fslength = this.fLen - index;
                if (fslength >= 2) {
                    this.wBitsPerSample = WAVHeader.getShort(b[14], b[15]);
                    fslength -= 2;
                    index += 2;
                }
                this.formatSpecific = new short[fslength / 2];
                for (int i2 = 0; i2 < fslength; i2 += 2) {
                    this.formatSpecific[i2 / 2] = WAVHeader.getShort(b[index + i2], b[index + 1 + i2]);
                }
            } else if ("fact".equals(chunkID)) {
                this.factID = chunkID.toCharArray();
                this.factLen = chunkDataSize;
                this.dwSampleLength = WAVHeader.getInt(b[0], b[1], b[2], b[3]);
            } else {
                System.out.println(chunkID + " header found - ignoring contents...");
            }
            this.headerSize += chunkDataSize;
        }
        if (this.fileSize > (long)(28 + this.fLen) + this.dataLengthLong) {
            try {
                this.readCues(soundFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder("File size: " + this.fileSize + " Bytes");
        output.append("\nHeader Size: " + this.headerSize);
        try {
            int i;
            output.append("\n00-03 Letters                 : ").append(this.riff);
            output.append("\n04-07 Length of rdata chunk   : ").append(this.rLen);
            output.append("\n================ rdata chunk ===================");
            output.append("\n08-11 Letters                 : ").append(this.wID);
            output.append("\n=============== format chunk ================");
            output.append("\n12-15 Letters                 : ").append(this.fID);
            output.append("\n16-19 Length of rest of chunk : ").append(this.fLen);
            output.append("\n20-21 WAV Format Tag          : ").append(this.wFormatTag);
            output.append("\n22-23 Number of channels      : ").append(this.nChannels);
            output.append("\n24-27 Sample frequency        : ").append(this.nSamplesPerSec);
            output.append("\n28-31 nAvgBytesPerSec         : ").append(this.nAvgBytesPerSec);
            output.append("\n32-33 nBlockAlign             : ").append(this.nBlockAlign);
            output.append("\n34-35 wBitsPerSample          : ").append(this.wBitsPerSample);
            for (i = 0; i < this.formatSpecific.length; ++i) {
                output.append("\n").append(36 + i * 2 + "-" + (37 + i * 2));
                output.append(" Format specific data    : ").append(this.formatSpecific[i]);
            }
            if (this.factID != null) {
                output.append("\n================ fact chunk =================");
                output.append("\n" + (20 + this.fLen) + "-" + (23 + this.fLen) + " Letters                 : ").append(this.factID);
                output.append("\n" + (24 + this.fLen) + "-" + (27 + this.fLen) + " Length of rest of chunk : ").append(this.factLen);
                output.append("\n" + (28 + this.fLen) + "-" + (31 + this.fLen) + " dwSampleLength          : ").append(this.dwSampleLength);
            }
            output.append("\n================ data chunk =================");
            output.append("\n" + (20 + this.fLen + this.factLen) + "-" + (23 + this.fLen + this.factLen)).append(" Letters                 : ");
            output.append(this.dID).append("\n" + (24 + this.fLen + this.factLen) + "-" + (27 + this.fLen + this.factLen));
            output.append(" Length of following data: ").append(this.dLen + "\n" + (28 + this.fLen + this.factLen) + "-" + (28 + this.fLen + this.factLen + this.dLen)).append(" (data)");
            if (this.cuePoints.length > 0) {
                output.append("\n================= cue Chunk =================");
                for (i = 0; i < this.cuePoints.length; ++i) {
                    output.append("\nCue point " + i + ":\n" + this.cuePoints[i]);
                }
            }
            if (this.cueSections.length > 0) {
                output.append("\n==================list chunk ================");
                output.append("\n============ labeled text chunk ===========");
                for (i = 0; i < this.cueSections.length; ++i) {
                    output.append("\nCue section " + i + ":\n" + this.cueSections[i]);
                }
            }
            output.append(this.getInfo());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return "";
        }
        return output.toString();
    }

    private static WAVCuePoint[] getCuePoints(RandomAccessFile soundFile) throws IOException {
        byte[] b = new byte[4];
        int rc = soundFile.read(b);
        if (rc != b.length) {
            throw new InvalidHeaderException();
        }
        int numCuePoints = WAVHeader.getInt(b, soundFile);
        WAVCuePoint[] cuePoints = new WAVCuePoint[numCuePoints];
        for (int i = 0; i < cuePoints.length; ++i) {
            int ID = WAVHeader.getInt(b, soundFile);
            int position = WAVHeader.getInt(b, soundFile);
            String dataChunkID = WAVHeader.getString(b, soundFile);
            int chunkStart = WAVHeader.getInt(b, soundFile);
            int blockStart = WAVHeader.getInt(b, soundFile);
            int sampleOffset = WAVHeader.getInt(b, soundFile);
            if (!"data".equals(dataChunkID)) {
                System.out.println("Warning: Reading of cue points failed!");
                System.out.println("Cannot handle Cue Point with Data Chunk ID '" + dataChunkID + "'");
                return new WAVCuePoint[0];
            }
            cuePoints[i] = new WAVCuePoint(ID, position, chunkStart, blockStart, sampleOffset);
        }
        return cuePoints;
    }

    private static WAVCueSection getCueSection(RandomAccessFile soundFile, WAVCuePoint[] cuePoints) throws IOException {
        String label;
        byte[] b = new byte[4];
        byte[] s = new byte[2];
        WAVCueSection cueSection = null;
        long seek = soundFile.getFilePointer();
        int chunkDataSize = WAVHeader.getInt(b, soundFile);
        int cuePointID = WAVHeader.getInt(b, soundFile);
        int sampleLength = WAVHeader.getInt(b, soundFile);
        String purposeID = WAVHeader.getString(b, soundFile);
        short country = WAVHeader.getShort(s, soundFile);
        short language = WAVHeader.getShort(s, soundFile);
        short dialect = WAVHeader.getShort(s, soundFile);
        short codePage = WAVHeader.getShort(s, soundFile);
        if (chunkDataSize - 20 - 1 >= 0) {
            byte[] t = new byte[chunkDataSize - 20 - 1];
            soundFile.read(t);
            label = WAVHeader.getString(t);
        } else {
            label = "";
        }
        for (int i = 0; i < cuePoints.length; ++i) {
            if (cuePoints[i].getID() != cuePointID) continue;
            cueSection = new WAVCueSection(cuePoints[i], sampleLength, purposeID, country, language, dialect, codePage, label);
            break;
        }
        seek += (long)(chunkDataSize + 4);
        seek += seek % 2L;
        soundFile.seek(seek);
        return cueSection;
    }

    private static String getInfo(RandomAccessFile soundFile) throws IOException {
        String info = "";
        byte[] b = new byte[4];
        int chunkDataSize = WAVHeader.getInt(b, soundFile);
        if (chunkDataSize > 0) {
            byte[] t = new byte[chunkDataSize];
            info = WAVHeader.getString(t, soundFile);
        }
        soundFile.seek(soundFile.getFilePointer() + soundFile.getFilePointer() % 2L);
        return info;
    }

    private static int getInt(byte[] bytes) {
        return WAVHeader.getInt(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    private static int getInt(byte[] bytes, RandomAccessFile file) throws IOException {
        int rc = file.read(bytes);
        if (rc != bytes.length) {
            throw new InvalidHeaderException();
        }
        return WAVHeader.getInt(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    private static int getInt(byte b1, byte b2, byte b3, byte b4) {
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    private static long getLong(byte b1, byte b2, byte b3, byte b4) {
        return (long)(b1 & 0xFF) | (long)((b2 & 0xFF) << 8) | (long)((b3 & 0xFF) << 16) | (long)((b4 & 0xFF) << 24);
    }

    private static short getShort(byte[] s) {
        return WAVHeader.getShort(s[0], s[1]);
    }

    private static short getShort(byte[] bytes, RandomAccessFile file) throws IOException {
        int rc = file.read(bytes);
        if (rc != bytes.length) {
            throw new InvalidHeaderException();
        }
        return WAVHeader.getShort(bytes[0], bytes[1]);
    }

    private static short getShort(byte b1, byte b2) {
        return (short)(b1 & 0xFF | (b2 & 0xFF) << 8);
    }

    private static String getString(byte[] bytes) {
        return WAVHeader.getString(bytes, bytes.length);
    }

    private static String getString(byte[] bytes, RandomAccessFile file) throws IOException {
        int rc = file.read(bytes);
        if (rc != bytes.length) {
            throw new InvalidHeaderException();
        }
        return WAVHeader.getString(bytes, bytes.length);
    }

    private static String getString(byte[] bytes, int nrOfBytes) {
        char[] asChar = new char[nrOfBytes];
        for (int i = 0; i < nrOfBytes; ++i) {
            asChar[i] = bytes[i] > 32 ? (int)bytes[i] : 32;
        }
        return new String(asChar);
    }

    private void readAssociatedDataList(RandomAccessFile soundFile) throws InvalidHeaderException, IOException {
        ArrayList<WAVCueSection> cueSectionList = new ArrayList<WAVCueSection>();
        byte[] b = new byte[4];
        while (soundFile.getFilePointer() < soundFile.length()) {
            String chunkId = WAVHeader.getString(b, soundFile);
            if ("ltxt".equals(chunkId)) {
                WAVCueSection cueSection = WAVHeader.getCueSection(soundFile, this.cuePoints);
                if (cueSection == null) continue;
                cueSectionList.add(cueSection);
                continue;
            }
            if ("labl".equals(chunkId)) {
                WAVHeader.readCuePointLabels(soundFile, this.cuePoints);
                continue;
            }
            if (!"note".equals(chunkId)) break;
            WAVHeader.readCuePointNotes(soundFile, this.cuePoints);
        }
        this.cueSections = cueSectionList.toArray(new WAVCueSection[0]);
    }

    private static void readCuePointLabels(RandomAccessFile soundFile, WAVCuePoint[] cuePoints) throws IOException {
        byte[] b = new byte[4];
        long seek = soundFile.getFilePointer();
        int chunkDataSize = WAVHeader.getInt(b, soundFile);
        int cuePointID = WAVHeader.getInt(b, soundFile);
        if (chunkDataSize - 4 - 1 >= 0) {
            byte[] t = new byte[chunkDataSize - 4 - 1];
            String label = WAVHeader.getString(t, soundFile);
            for (int i = 0; i < cuePoints.length; ++i) {
                if (cuePoints[i].getID() != cuePointID) continue;
                cuePoints[i].setLabel(label);
                break;
            }
        }
        seek += (long)(chunkDataSize + 4);
        seek += seek % 2L;
        soundFile.seek(seek);
    }

    private static void readCuePointNotes(RandomAccessFile soundFile, WAVCuePoint[] cuePoints) throws IOException {
        byte[] b = new byte[4];
        long seek = soundFile.getFilePointer();
        int chunkDataSize = WAVHeader.getInt(b, soundFile);
        int cuePointID = WAVHeader.getInt(b, soundFile);
        if (chunkDataSize - 4 - 1 >= 0) {
            byte[] t = new byte[chunkDataSize - 4 - 1];
            String label = WAVHeader.getString(t, soundFile);
            for (int i = 0; i < cuePoints.length; ++i) {
                if (cuePoints[i].getID() != cuePointID) continue;
                cuePoints[i].setNote(label);
                break;
            }
        }
        seek += (long)(chunkDataSize + 4);
        seek += seek % 2L;
        soundFile.seek(seek);
    }

    private void readCues(RandomAccessFile soundFile) throws IOException {
        byte[] b = new byte[4];
        soundFile.seek((long)(28 + this.fLen) + this.dataLengthLong);
        int listChunkSize = 0;
        while (soundFile.getFilePointer() < soundFile.length()) {
            String chunkId = WAVHeader.getString(b, soundFile);
            if ("list".equals(chunkId.toLowerCase())) {
                listChunkSize = WAVHeader.getInt(b, soundFile);
            }
            if ("cue ".equals(chunkId)) {
                this.cuePoints = WAVHeader.getCuePoints(soundFile);
                continue;
            }
            if ("adtl".equals(chunkId)) {
                this.readAssociatedDataList(soundFile);
                continue;
            }
            if (!"info".equals(chunkId.toLowerCase())) break;
            long endOfChunk = soundFile.getFilePointer() + (long)listChunkSize - 4L;
            while (soundFile.getFilePointer() < endOfChunk && soundFile.getFilePointer() < soundFile.length()) {
                String str = WAVHeader.getString(b, soundFile);
                this.infos.put(str, WAVHeader.getInfo(soundFile));
            }
        }
    }

    private static class InvalidHeaderException
    extends IOException {
        public InvalidHeaderException() {
        }

        public InvalidHeaderException(String message) {
            super(message);
        }

        public InvalidHeaderException(Throwable cause) {
            super(cause);
        }
    }
}

