/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceGroup;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ParentAnnotationListener;
import mpi.eudico.server.corpora.util.ACMEditableObject;

public abstract class AbstractAnnotation
implements Annotation {
    private Tier tier;
    private String value = "";
    private String id = null;
    private boolean markedDeleted = false;
    private List<Annotation> parentAnnotListeners = new ArrayList<Annotation>();
    private ExternalReference extRef;
    private String cvEntryId;

    @Override
    public abstract long getBeginTimeBoundary();

    @Override
    public abstract long getEndTimeBoundary();

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String theValue) {
        this.value = theValue;
        this.modified(8, null);
    }

    @Override
    public String getId() {
        if (this.id == null || this.id.isEmpty()) {
            TierImpl ti = (TierImpl)this.tier;
            TranscriptionImpl tr = ti.getTranscription();
            Property p = tr.getDocProperty("lastUsedAnnotationId");
            Integer lastUsedAnnId = 0;
            if (p == null) {
                p = new PropertyImpl("lastUsedAnnotationId", null);
                tr.addDocProperty(p);
            } else if (p.getValue() != null) {
                try {
                    lastUsedAnnId = (Integer)p.getValue();
                }
                catch (ClassCastException nfe) {
                    System.out.println("Could not retrieve the last used annotation id.");
                }
            }
            lastUsedAnnId = lastUsedAnnId + 1;
            this.id = "a" + lastUsedAnnId;
            p.setValue(lastUsedAnnId);
        }
        return this.id;
    }

    public String getIdLazily() {
        return this.id;
    }

    @Override
    public void setId(String s) {
        this.id = s;
    }

    public ExternalReference getExtRef() {
        return this.extRef;
    }

    public void setExtRef(ExternalReference extRef) {
        this.extRef = extRef;
        this.modified(15, extRef);
    }

    @Override
    public String getCVEntryId() {
        return this.cvEntryId;
    }

    @Override
    public void setCVEntryId(String cVEntryId) {
        this.cvEntryId = cVEntryId;
    }

    public String getExtRefValue(int type) {
        if (this.extRef != null) {
            String value = null;
            ExternalReference ef = this.extRef;
            ArrayList<ExternalReference> extRefList = new ArrayList<ExternalReference>();
            extRefList.add(ef);
            for (int i = 0; i < extRefList.size(); ++i) {
                if (((ExternalReference)extRefList.get(i)).getReferenceType() == type) {
                    value = ((ExternalReference)extRefList.get(i)).getValue();
                    break;
                }
                if (((ExternalReference)extRefList.get(i)).getReferenceType() != 1) continue;
                extRefList.addAll(((ExternalReferenceGroup)extRefList.get(i)).getAllReferences());
            }
            return value;
        }
        return null;
    }

    public void removeExtRef(ExternalReferenceImpl er) {
        if (this.extRef != null) {
            if (this.extRef.equals(er)) {
                this.extRef = null;
            } else if (this.extRef instanceof ExternalReferenceGroup) {
                this.removeExtRefFromGroup((ExternalReferenceGroup)this.extRef, er);
            }
        }
        this.modified(15, this.extRef);
    }

    private void removeExtRefFromGroup(ExternalReferenceGroup extRefGrp, ExternalReference er) {
        List<ExternalReference> extRefList = extRefGrp.getAllReferences();
        for (int i = 0; i < extRefList.size(); ++i) {
            ExternalReference externalReference = extRefList.get(i);
            if (externalReference instanceof ExternalReferenceGroup) {
                this.removeExtRefFromGroup((ExternalReferenceGroup)externalReference, er);
                continue;
            }
            if (externalReference == null || !externalReference.equals(er)) continue;
            extRefGrp.removeReference(er);
        }
    }

    public void addExtRef(ExternalReference er) {
        if (this.extRef == null) {
            this.extRef = er;
        } else if (this.extRef instanceof ExternalReferenceGroup) {
            ((ExternalReferenceGroup)this.extRef).addReference(er);
        } else {
            this.extRef = ExternalReferenceGroup.create(this.extRef, er);
        }
        this.modified(15, this.extRef);
    }

    public List<ExternalReference> getExtRefs() {
        ArrayList<ExternalReference> extRefs = new ArrayList<ExternalReference>();
        if (this.extRef != null) {
            if (this.extRef instanceof ExternalReferenceGroup) {
                this.addExtRefToList((ExternalReferenceGroup)this.extRef, extRefs);
            } else {
                extRefs.add(this.extRef);
            }
        }
        return extRefs;
    }

    private void addExtRefToList(ExternalReferenceGroup extRefGrp, List<ExternalReference> extRefs) {
        for (ExternalReference er : extRefGrp.getAllReferences()) {
            if (er == null) continue;
            if (er instanceof ExternalReferenceGroup) {
                this.addExtRefToList((ExternalReferenceGroup)er, extRefs);
                continue;
            }
            extRefs.add(er);
        }
    }

    @Override
    public void updateValue(String theValue) {
        this.value = theValue;
        this.modified(8, null);
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    protected void setTier(Tier theTier) {
        this.tier = theTier;
    }

    @Override
    public void markDeleted(boolean deleted) {
        this.markedDeleted = deleted;
        this.notifyParentListeners();
        this.unregisterWithParent();
    }

    @Override
    public boolean isMarkedDeleted() {
        return this.markedDeleted;
    }

    public void unregisterWithParent() {
        Annotation p;
        if (this.hasParentAnnotation() && (p = this.getParentAnnotation()) != null) {
            p.removeParentAnnotationListener(this);
        }
    }

    @Override
    public void modified(int operation, Object modification) {
        this.handleModification(this, operation, modification);
    }

    @Override
    public void handleModification(ACMEditableObject source, int operation, Object modification) {
        if (this.tier != null) {
            this.tier.handleModification(source, operation, modification);
        }
    }

    @Override
    public void addParentAnnotationListener(ParentAnnotationListener listener) {
        this.addParentAnnotationListener((Annotation)listener);
    }

    protected void addParentAnnotationListener(Annotation child) {
        if (!this.parentAnnotListeners.contains(child)) {
            this.parentAnnotListeners.add(child);
        }
    }

    @Override
    public void removeParentAnnotationListener(ParentAnnotationListener l) {
        this.parentAnnotListeners.remove(l);
    }

    @Override
    public void notifyParentListeners() {
        ArrayList<Annotation> copiedList = new ArrayList<Annotation>(this.parentAnnotListeners);
        for (ParentAnnotationListener parentAnnotationListener : copiedList) {
            parentAnnotationListener.parentAnnotationChanged(new EventObject(this));
        }
    }

    public List<Annotation> getParentListeners() {
        return this.parentAnnotListeners;
    }

    @Override
    public final List<Annotation> getChildrenOnTier(Tier tier) {
        ArrayList<Annotation> children = new ArrayList<Annotation>();
        Annotation annotation = null;
        for (Annotation annotation2 : this.parentAnnotListeners) {
            annotation = annotation2;
            if (annotation.getTier() != tier) continue;
            children.add(annotation);
        }
        return children;
    }

    @Override
    public int compareTo(Annotation obj) {
        int ret = 0;
        AbstractAnnotation a1 = this;
        Annotation a2 = obj;
        if (a1.isMarkedDeleted() || a2.isMarkedDeleted()) {
            return this.compareOtherwise(a1, a2);
        }
        int numOfRefAnnotations = 0;
        if (this instanceof RefAnnotation) {
            ++numOfRefAnnotations;
            a1 = ((RefAnnotation)this).getFirstAlignableRoot();
        }
        if (obj instanceof RefAnnotation) {
            ++numOfRefAnnotations;
            a2 = ((RefAnnotation)obj).getFirstAlignableRoot();
        }
        if (a1 != a2) {
            ret = ((AlignableAnnotation)a1).getBegin().compareTo(((AlignableAnnotation)a2).getBegin());
            if (ret == 0) {
                ret = -1;
            }
        } else if (numOfRefAnnotations == 1) {
            ret = this instanceof AlignableAnnotation ? -1 : 1;
        } else if (numOfRefAnnotations == 2) {
            ret = this.compareRefAnnotations((RefAnnotation)this, (RefAnnotation)obj);
        }
        return ret;
    }

    private int compareOtherwise(Annotation a1, Annotation a2) {
        Tier t2;
        if (a1.equals(a2)) {
            return 0;
        }
        Tier t1 = a1.getTier();
        if (t1 == (t2 = a2.getTier())) {
            List<AbstractAnnotation> v = null;
            v = ((TierImpl)t1).getAnnotations();
            if (v.indexOf(a1) < v.indexOf(a2)) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public int compareRefAnnotations(RefAnnotation a1, RefAnnotation a2) {
        int ret = 0;
        if (a1.getTier() == a2.getTier() && a1.getReferences().get(0) == a2.getReferences().get(0)) {
            ret = this.compareUsingRefChain(a1, a2);
        } else {
            Annotation parent = a1.getReferences().get(0);
            if (parent instanceof RefAnnotation) {
                ret = this.compareRefAnnotations((RefAnnotation)parent, a2);
            }
            if (ret == 0 && (parent = a2.getReferences().get(0)) instanceof RefAnnotation) {
                ret = this.compareRefAnnotations(a1, (RefAnnotation)parent);
            }
        }
        return ret;
    }

    public int compareUsingRefChain(RefAnnotation a1, RefAnnotation a2) {
        int ret = 1;
        if (a1 == a2) {
            ret = 0;
        } else {
            for (RefAnnotation nextR = a1.getNext(); nextR != null; nextR = nextR.getNext()) {
                if (nextR != a2) continue;
                ret = -1;
                break;
            }
        }
        return ret;
    }
}

