/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;

public class ExternalReferenceGroup
extends ExternalReferenceImpl {
    private static final long serialVersionUID = 2228267290242872070L;
    private List<ExternalReference> group;

    public ExternalReferenceGroup() {
        super(null, 1);
    }

    public ExternalReferenceGroup(String value) {
        super(value, 1);
    }

    public void addReference(ExternalReference extRef) {
        if (extRef == null) {
            return;
        }
        if (this.group == null) {
            this.group = new ArrayList<ExternalReference>(4);
        }
        this.group.add(extRef);
    }

    public boolean removeReference(ExternalReference extRef) {
        if (extRef == null || this.group == null) {
            return false;
        }
        return this.group.remove(extRef);
    }

    public List<ExternalReference> getAllReferences() {
        return this.group;
    }

    @Override
    public void setReferenceType(int refType) {
    }

    @Override
    public String paramString() {
        if (this.group != null) {
            StringBuilder buf = new StringBuilder();
            ExternalReference er = null;
            for (int i = 0; i < this.group.size(); ++i) {
                er = this.group.get(i);
                buf.append(i + " - " + er.paramString() + "; ");
            }
            return buf.toString();
        }
        return super.paramString();
    }

    @Override
    public ExternalReferenceGroup clone() throws CloneNotSupportedException {
        ExternalReferenceGroup groupCopy = new ExternalReferenceGroup();
        if (this.group != null) {
            for (int i = 0; i < this.group.size(); ++i) {
                ExternalReference er = this.group.get(i);
                if (er == null) continue;
                groupCopy.addReference(er.clone());
            }
        }
        return groupCopy;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExternalReferenceGroup)) {
            return false;
        }
        ExternalReferenceGroup other = (ExternalReferenceGroup)obj;
        List<ExternalReference> allReferences = other.getAllReferences();
        if (allReferences == null && this.group != null || allReferences != null && this.group == null) {
            return false;
        }
        if (this.group != null) {
            if (this.group.size() != allReferences.size()) {
                return false;
            }
            for (int i = 0; i < this.group.size(); ++i) {
                ExternalReference o1 = this.group.get(i);
                ExternalReference o2 = allReferences.get(i);
                if (o1 == null && o2 != null) {
                    return false;
                }
                if (o1 != null && o2 == null) {
                    return false;
                }
                if (o1 == null || o1.equals(o2)) continue;
                return false;
            }
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int h = 12;
        if (this.group != null) {
            h += this.group.hashCode();
        }
        return h;
    }

    public static ExternalReference create(ExternalReference existing, ExternalReference fresh) {
        if (existing == null) {
            return fresh;
        }
        if (existing instanceof ExternalReferenceGroup) {
            try {
                ExternalReferenceGroup group = ((ExternalReferenceGroup)existing).clone();
                group.addReference(fresh);
                return group;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return fresh;
            }
        }
        ExternalReferenceGroup group = new ExternalReferenceGroup();
        group.addReference(existing);
        group.addReference(fresh);
        return group;
    }

    @Override
    public String getTypeString() {
        return "reference_group";
    }
}

