/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

public class RefAnnotation
extends AbstractAnnotation {
    private List<Annotation> references = new ArrayList<Annotation>();
    private RefAnnotation next;
    private RefAnnotation previous;

    public RefAnnotation(Annotation theReference, Tier theTier) {
        if (theReference != null) {
            this.addReference(theReference);
        }
        this.setTier(theTier);
    }

    @Override
    public long getBeginTimeBoundary() {
        long beginTimeBoundary = Long.MAX_VALUE;
        Constraint c = ((TierImpl)this.getTier()).getLinguisticType().getConstraints();
        if (c != null) {
            beginTimeBoundary = c.getBeginTimeForRefAnnotation(this);
        } else {
            long beginB = 0L;
            Iterator<Annotation> refIter = this.references.iterator();
            while (refIter.hasNext()) {
                beginB = refIter.next().getBeginTimeBoundary();
                beginTimeBoundary = Math.min(beginTimeBoundary, beginB);
            }
        }
        return beginTimeBoundary;
    }

    @Override
    public long getEndTimeBoundary() {
        long endTimeBoundary = 0L;
        Constraint c = ((TierImpl)this.getTier()).getLinguisticType().getConstraints();
        if (c != null) {
            endTimeBoundary = c.getEndTimeForRefAnnotation(this);
        } else {
            long endB = 0L;
            Iterator<Annotation> refIter = this.references.iterator();
            while (refIter.hasNext()) {
                endB = refIter.next().getEndTimeBoundary();
                endTimeBoundary = Math.max(endTimeBoundary, endB);
            }
        }
        return endTimeBoundary;
    }

    public AlignableAnnotation getFirstAlignableRoot() {
        Annotation parent = this.references.get(0);
        if (parent instanceof AlignableAnnotation) {
            return (AlignableAnnotation)parent;
        }
        return ((RefAnnotation)parent).getFirstAlignableRoot();
    }

    public void addReference(Annotation theReference) {
        this.references.add(theReference);
        theReference.addParentAnnotationListener(this);
    }

    public void removeReference(Annotation theReference) {
        theReference.removeParentAnnotationListener(this);
        this.references.remove(theReference);
        if (this.references.size() == 0) {
            this.markDeleted(true);
        }
    }

    public List<Annotation> getReferences() {
        return this.references;
    }

    public RefAnnotation getNext() {
        return this.next;
    }

    public void setNext(RefAnnotation a) {
        this.next = a;
        if (a != null) {
            a.setPrevious(this);
        }
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public RefAnnotation getPrevious() {
        return this.previous;
    }

    public void setPrevious(RefAnnotation a) {
        this.previous = a;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    @Override
    public void parentAnnotationChanged(EventObject e) {
        if (e.getSource() instanceof Annotation && ((Annotation)e.getSource()).isMarkedDeleted()) {
            this.removeReference((Annotation)e.getSource());
        }
    }

    @Override
    public boolean hasParentAnnotation() {
        boolean hasParent = false;
        if (this.references.size() > 0) {
            hasParent = true;
        }
        return hasParent;
    }

    @Override
    public Annotation getParentAnnotation() {
        Annotation p = null;
        if (this.hasParentAnnotation()) {
            p = this.references.get(0);
        }
        return p;
    }
}

