/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class TimeOrderImpl
implements TimeOrder {
    private ArrayList<TimeSlot> orderedTimeSlotList;
    private TranscriptionImpl transcription;

    public TimeOrderImpl(TranscriptionImpl theTranscription) {
        this.transcription = theTranscription;
        this.orderedTimeSlotList = new ArrayList();
    }

    @Override
    public void insertTimeSlot(TimeSlot theTimeSlot) {
        if (theTimeSlot.isTimeAligned()) {
            int index = 0;
            long time = theTimeSlot.getTime();
            if (this.orderedTimeSlotList.size() > 0) {
                Iterator<TimeSlot> tsIter = this.orderedTimeSlotList.iterator();
                while (tsIter.hasNext() && tsIter.next().getTime() <= time) {
                    ++index;
                }
            }
            this.orderedTimeSlotList.add(index, theTimeSlot);
            this.reindex(index);
        } else {
            this.orderedTimeSlotList.add(theTimeSlot);
            this.reindex(this.orderedTimeSlotList.size() - 1);
        }
    }

    private void reindex() {
        this.reindex(0);
    }

    private void reindex(int fromIndex) {
        int size = this.orderedTimeSlotList.size();
        for (int i = fromIndex; i < size; ++i) {
            this.orderedTimeSlotList.get(i).setIndex(i);
        }
    }

    @Override
    public void insertTimeSlot(TimeSlot theTimeSlot, TimeSlot afterSlot, TimeSlot beforeSlot) {
        int index = 0;
        boolean positioned = false;
        long time = theTimeSlot.getTime();
        Iterator<TimeSlot> tsIter = this.orderedTimeSlotList.iterator();
        while (tsIter.hasNext()) {
            ++index;
            if (tsIter.next() != afterSlot) continue;
        }
        if (!tsIter.hasNext()) {
            positioned = true;
        }
        while (tsIter.hasNext()) {
            TimeSlot ts = tsIter.next();
            if (ts.isTimeAligned() && ts.getTime() > time) {
                positioned = true;
                break;
            }
            if (!theTimeSlot.isTimeAligned() && beforeSlot == null) {
                positioned = true;
                break;
            }
            if (ts == beforeSlot) {
                if (ts.isTimeAligned()) break;
                positioned = true;
                break;
            }
            ++index;
        }
        tsIter = null;
        if (positioned) {
            this.orderedTimeSlotList.add(index, theTimeSlot);
            this.reindex(index);
        } else {
            System.out.println("Not positioned...");
            this.reindex();
        }
    }

    @Override
    public void removeTimeSlot(TimeSlot theSlot) {
        this.orderedTimeSlotList.remove(theSlot);
        this.reindex();
    }

    @Override
    public void printTimeOrder() {
        System.out.println("");
        for (TimeSlot t : this.orderedTimeSlotList) {
            System.out.println(t.getIndex() + " " + t.getTime());
        }
    }

    @Override
    public boolean isBefore(TimeSlot timeSlot1, TimeSlot timeSlot2) {
        boolean before = true;
        before = timeSlot1.getIndex() <= timeSlot2.getIndex();
        return before;
    }

    @Override
    public TimeSlot getPredecessorOf(TimeSlot timeSlot) {
        int index = timeSlot.getIndex();
        if (index > 0 && this.orderedTimeSlotList.get(index) == timeSlot) {
            return this.orderedTimeSlotList.get(index - 1);
        }
        return null;
    }

    @Override
    public int size() {
        return this.orderedTimeSlotList.size();
    }

    @Override
    public void pruneTimeSlots() {
        ArrayList<TimeSlot> slotsToBeDeleted = new ArrayList<TimeSlot>();
        HashSet<TimeSlot> usedSlots = this.transcription.getTimeSlotsInUse();
        TimeSlot ts = null;
        for (int i = this.orderedTimeSlotList.size() - 1; i >= 0; --i) {
            ts = this.orderedTimeSlotList.get(i);
            if (usedSlots.contains(ts)) continue;
            slotsToBeDeleted.add(ts);
        }
        if (!slotsToBeDeleted.isEmpty()) {
            this.orderedTimeSlotList.removeAll(slotsToBeDeleted);
            this.reindex();
        }
    }

    @Override
    public long proposeTimeFor(TimeSlot theSlot) {
        if (theSlot.isTimeAligned()) {
            return theSlot.getTime();
        }
        TimeSlot lastAlignedSlot = null;
        long segmentBegin = 0L;
        long segmentEnd = 0L;
        boolean slotFound = false;
        int numOfUnalignedSlots = 0;
        int slotCount = 0;
        for (TimeSlot sl : this.orderedTimeSlotList) {
            if (sl.isTimeAligned()) {
                lastAlignedSlot = sl;
                if (slotFound) {
                    segmentEnd = lastAlignedSlot.getTime();
                    break;
                }
                numOfUnalignedSlots = 0;
            } else {
                ++numOfUnalignedSlots;
            }
            if (sl != theSlot) continue;
            if (lastAlignedSlot != null) {
                segmentBegin = lastAlignedSlot.getTime();
            }
            slotFound = true;
            slotCount = numOfUnalignedSlots;
        }
        long deltaT = (segmentEnd - segmentBegin) / (long)(numOfUnalignedSlots + 1);
        return segmentBegin + (long)slotCount * deltaT;
    }

    @Override
    public Iterator<TimeSlot> iterator() {
        return this.orderedTimeSlotList.iterator();
    }

    @Override
    public void modifyTimeSlot(TimeSlot theSlot, long newTime) {
        TimeSlot ts;
        int i;
        int currentIndex = this.orderedTimeSlotList.indexOf(theSlot);
        int newIndex = -1;
        if (!theSlot.isTimeAligned() || newTime > theSlot.getTime()) {
            for (i = currentIndex + 1; i < this.orderedTimeSlotList.size(); ++i) {
                ts = this.orderedTimeSlotList.get(i);
                if (ts.isTimeAligned() && ts.getTime() <= newTime) {
                    newIndex = i;
                    continue;
                }
                if (ts.getTime() >= newTime) break;
            }
        }
        if (!(newIndex != -1 || theSlot.isTimeAligned() && newTime >= theSlot.getTime())) {
            for (i = currentIndex - 1; i >= 0; --i) {
                ts = this.orderedTimeSlotList.get(i);
                if (ts.isTimeAligned() && ts.getTime() >= newTime) {
                    newIndex = i;
                    continue;
                }
                if (ts.getTime() <= newTime && ts.isTimeAligned()) break;
            }
        }
        theSlot.updateTime(newTime);
        if (newIndex >= 0 && currentIndex >= 0) {
            this.orderedTimeSlotList.remove(currentIndex);
            if (newIndex < currentIndex) {
                this.orderedTimeSlotList.add(newIndex, theSlot);
            } else {
                this.orderedTimeSlotList.add(newIndex, theSlot);
            }
            this.reindex();
        }
    }

    @Override
    public void shift(long fromTime, long shift, TimeSlot lastFixedSlot, List<TimeSlot> otherFixedSlots) {
        TimeSlot slot;
        if (shift < 0L) {
            Iterator<TimeSlot> en = this.iterator();
            while (en.hasNext()) {
                TimeSlot ts = en.next();
                if (!ts.isTimeAligned() || ts.getTime() <= fromTime || ts == lastFixedSlot || otherFixedSlots != null && (otherFixedSlots == null || otherFixedSlots.contains(ts))) continue;
                ts.updateTime(ts.getTime() + shift);
            }
            return;
        }
        if (otherFixedSlots != null && otherFixedSlots.contains(lastFixedSlot)) {
            otherFixedSlots.remove(lastFixedSlot);
        }
        ArrayList<TimeSlot> slotsToShift = new ArrayList<TimeSlot>();
        ArrayList<TimeSlot> slotsToReorder = new ArrayList<TimeSlot>();
        Iterator<TimeSlot> enum1 = this.iterator();
        boolean startAdding = false;
        boolean pastFixedSlot = false;
        TimeSlot beforeSlot = null;
        while (enum1.hasNext()) {
            TimeSlot ts = enum1.next();
            if (otherFixedSlots != null && otherFixedSlots.contains(ts)) continue;
            if (ts.isTimeAligned() && ts.getTime() >= fromTime) {
                startAdding = true;
            }
            if (!startAdding) continue;
            if (ts != lastFixedSlot) {
                slotsToShift.add(ts);
            } else {
                pastFixedSlot = true;
            }
            if (!pastFixedSlot) {
                slotsToReorder.add(ts);
                continue;
            }
            if (beforeSlot != null || ts == lastFixedSlot) continue;
            beforeSlot = ts;
        }
        TimeSlot afterSlot = lastFixedSlot;
        for (int k = 0; k < slotsToShift.size(); ++k) {
            slot = (TimeSlot)slotsToShift.get(k);
            if (!slot.isTimeAligned()) continue;
            slot.updateTime(slot.getTime() + shift);
        }
        for (int i = 0; i < slotsToReorder.size(); ++i) {
            slot = (TimeSlot)slotsToReorder.get(i);
            this.removeTimeSlot(slot);
            this.insertTimeSlot(slot, afterSlot, beforeSlot);
            afterSlot = slot;
        }
    }

    @Override
    public void shiftAll(long shiftValue) throws IllegalArgumentException {
        if (this.orderedTimeSlotList.size() <= 0) {
            return;
        }
        long firstAlignedTime = 0L;
        for (TimeSlot slot : this.orderedTimeSlotList) {
            if (!slot.isTimeAligned()) continue;
            firstAlignedTime = slot.getTime();
            break;
        }
        if (firstAlignedTime + shiftValue < 0L) {
            throw new IllegalArgumentException("The shift value should be greater than: " + firstAlignedTime + " otherwise slots would get a negative time value.");
        }
        for (TimeSlot slot : this.orderedTimeSlotList) {
            if (!slot.isTimeAligned()) continue;
            slot.updateTime(slot.getTime() + shiftValue);
        }
    }

    public void insertOrderedSlots(List<TimeSlot> slots) {
        if (slots == null) {
            return;
        }
        this.orderedTimeSlotList.addAll(slots);
        this.reindex();
    }
}

