/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.util.ACMEditableObject;

public class TimeProposer {
    public void correctProposedTimes(TranscriptionImpl transcription, ACMEditableObject source, int operation, Object modification) {
        TierImpl invalidTier;
        Annotation modAnnotation;
        if (transcription != null && transcription.getTimeChangePropagationMode() != 0) {
            this.correctAllProposedTimes(transcription);
            return;
        }
        switch (operation) {
            case 3: 
            case 4: 
            case 5: {
                modAnnotation = (Annotation)modification;
                invalidTier = (TierImpl)modAnnotation.getTier();
                if (modAnnotation instanceof AlignableAnnotation) break;
                return;
            }
            case 6: 
            case 7: 
            case 14: {
                this.correctAllProposedTimes(transcription);
                return;
            }
            default: {
                return;
            }
        }
        AlignableAnnotation rootAnn = (AlignableAnnotation)modAnnotation;
        TierImpl rootTier = null;
        if (invalidTier.hasParentTier()) {
            boolean rootAnnFound = false;
            rootTier = invalidTier.getParentTier();
            block4: while (!rootAnnFound) {
                List<AlignableAnnotation> annos = rootTier.getAlignableAnnotations();
                Iterator<AlignableAnnotation> anIt = annos.iterator();
                AlignableAnnotation ann = null;
                while (anIt.hasNext()) {
                    ann = anIt.next();
                    if (!ann.getParentListeners().contains(rootAnn)) continue;
                    rootAnn = ann;
                    if (rootAnn.getBegin().isTimeAligned() && rootAnn.getEnd().isTimeAligned()) {
                        rootAnnFound = true;
                        continue block4;
                    }
                    rootTier = rootTier.getParentTier();
                    continue block4;
                }
            }
        } else {
            return;
        }
        this.calculateProposedTimesForPL(rootAnn);
    }

    private void correctAllProposedTimes(TranscriptionImpl transcription) {
        int i;
        if (transcription == null) {
            return;
        }
        List<TierImpl> allTiers = null;
        ArrayList<TierImpl> allTierCopy = null;
        allTiers = transcription.getTiers();
        allTierCopy = new ArrayList<TierImpl>(allTiers);
        for (i = allTierCopy.size() - 1; i >= 0; --i) {
            TierImpl t = (TierImpl)allTierCopy.get(i);
            if (!t.hasParentTier()) continue;
            allTierCopy.remove(i);
        }
        if (!allTierCopy.isEmpty()) {
            for (i = 0; i < allTierCopy.size(); ++i) {
                TierImpl tier = (TierImpl)allTierCopy.get(i);
                for (Annotation annotation : tier.getAnnotations()) {
                    if (!(annotation instanceof AlignableAnnotation)) continue;
                    this.calculateProposedTimesForPL((AlignableAnnotation)annotation);
                }
            }
        }
    }

    private List<TierImpl> getRelevantOrderedTiers(TierImpl rootTier) {
        List<TierImpl> depTiers = rootTier.getDependentTiers();
        for (int i = depTiers.size() - 1; i >= 0; --i) {
            TierImpl t = depTiers.get(i);
            if (t.isTimeAlignable()) continue;
            depTiers.remove(i);
        }
        ArrayList<TierImpl> orderedTiers = new ArrayList<TierImpl>(depTiers.size() + 1);
        orderedTiers.add(rootTier);
        block1: while (depTiers.size() > 0) {
            for (int i = 0; i < depTiers.size(); ++i) {
                TierImpl t1 = depTiers.get(i);
                for (int j = 0; j < orderedTiers.size(); ++j) {
                    Tier t2 = (Tier)orderedTiers.get(j);
                    if (t1.getParentTier() != t2) continue;
                    depTiers.remove(i);
                    orderedTiers.add(j + 1, t1);
                    continue block1;
                }
            }
        }
        return orderedTiers;
    }

    private void calculateProposedTimes(List<TierImpl> orderedTiers, AlignableAnnotation rootAnn) {
        if (orderedTiers.size() > 1) {
            ArrayList<TimeSlotImpl> slotsDone = new ArrayList<TimeSlotImpl>();
            TimeSlot beginSlot = rootAnn.getBegin();
            TimeSlot endSlot = rootAnn.getEnd();
            for (int i = 1; i < orderedTiers.size(); ++i) {
                TierImpl curTier = orderedTiers.get(i);
                TreeSet<TimeSlot> betweenSlots = new TreeSet<TimeSlot>();
                List<AbstractAnnotation> allAnnos = curTier.getAnnotations();
                for (AbstractAnnotation aa : allAnnos) {
                    if (!(aa instanceof AlignableAnnotation)) continue;
                    AlignableAnnotation ann = (AlignableAnnotation)aa;
                    if (ann.getBegin().getIndex() >= beginSlot.getIndex() && ann.getEnd().getIndex() <= endSlot.getIndex() && ann.getBegin().getIndex() < ann.getEnd().getIndex()) {
                        betweenSlots.add(ann.getBegin());
                        betweenSlots.add(ann.getEnd());
                    }
                    if (ann.getBegin().getIndex() <= endSlot.getIndex()) continue;
                }
                if (betweenSlots.size() <= 0) continue;
                TimeSlotImpl[] slots = betweenSlots.toArray(new TimeSlotImpl[0]);
                int beginIndex = -1;
                int endIndex = -1;
                boolean beginFound = false;
                long beginTime = 0L;
                long endTime = 0L;
                for (int j = 0; j < slots.length; ++j) {
                    if (!slots[j].isTimeAligned() && !slotsDone.contains(slots[j])) {
                        if (beginFound) continue;
                        beginFound = true;
                        beginIndex = j - 1;
                        if (beginIndex < 0) continue;
                        if (slots[beginIndex].isTimeAligned()) {
                            beginTime = slots[beginIndex].getTime();
                            continue;
                        }
                        beginTime = slots[beginIndex].getProposedTime();
                        continue;
                    }
                    if (!slots[j].isTimeAligned() && !slotsDone.contains(slots[j]) || !beginFound) continue;
                    endIndex = j;
                    endTime = slots[j].isTimeAligned() ? slots[j].getTime() : slots[j].getProposedTime();
                    int count = endIndex - beginIndex;
                    long segmentDiff = (endTime - beginTime) / (long)count;
                    for (int k = 1; k < count; ++k) {
                        slots[beginIndex + k].setProposedTime(beginTime + (long)k * segmentDiff);
                        slotsDone.add(slots[beginIndex + k]);
                    }
                    beginFound = false;
                    beginIndex = -1;
                    endIndex = -1;
                    beginTime = 0L;
                    endTime = 0L;
                }
            }
        }
    }

    private void calculateProposedTimesForPL(AlignableAnnotation rootAnn) {
        List<Annotation> pList = rootAnn.getParentListeners();
        if (pList.size() == 0) {
            return;
        }
        HashMap map = new HashMap();
        for (int i = 0; i < pList.size(); ++i) {
            Annotation ann = pList.get(i);
            if (!(ann instanceof AlignableAnnotation)) continue;
            AlignableAnnotation aa = (AlignableAnnotation)ann;
            if (map.containsKey(aa.getTier())) {
                ((TreeSet)map.get(aa.getTier())).add(aa.getBegin());
                ((TreeSet)map.get(aa.getTier())).add(aa.getEnd());
                continue;
            }
            TreeSet<TimeSlot> ts = new TreeSet<TimeSlot>();
            ts.add(aa.getBegin());
            ts.add(aa.getEnd());
            map.put(aa.getTier(), ts);
        }
        TreeSet betweenSlots = null;
        ArrayList<TimeSlot> slotsDone = null;
        Iterator tierIt = map.keySet().iterator();
        while (tierIt.hasNext()) {
            betweenSlots = (TreeSet)map.get(tierIt.next());
            slotsDone = new ArrayList<TimeSlot>();
            slotsDone.add(rootAnn.getBegin());
            slotsDone.add(rootAnn.getEnd());
            if (betweenSlots.size() <= 0) continue;
            TimeSlotImpl[] slots = betweenSlots.toArray(new TimeSlotImpl[0]);
            int beginIndex = -1;
            int endIndex = -1;
            boolean beginFound = false;
            long beginTime = 0L;
            long endTime = 0L;
            for (int j = 0; j < slots.length; ++j) {
                if (!slots[j].isTimeAligned() && !slotsDone.contains(slots[j])) {
                    if (beginFound) continue;
                    beginFound = true;
                    beginIndex = j - 1;
                    if (beginIndex < 0) continue;
                    if (slots[beginIndex].isTimeAligned()) {
                        beginTime = slots[beginIndex].getTime();
                        continue;
                    }
                    beginTime = slots[beginIndex].getProposedTime();
                    continue;
                }
                if (!slots[j].isTimeAligned() && !slotsDone.contains(slots[j]) || !beginFound) continue;
                endIndex = j;
                endTime = slots[j].isTimeAligned() ? slots[j].getTime() : slots[j].getProposedTime();
                int count = endIndex - beginIndex;
                long segmentDiff = (endTime - beginTime) / (long)count;
                for (int k = 1; k < count; ++k) {
                    slots[beginIndex + k].setProposedTime(beginTime + (long)k * segmentDiff);
                    slotsDone.add(slots[beginIndex + k]);
                }
                beginFound = false;
                beginIndex = -1;
                endIndex = -1;
                beginTime = 0L;
                endTime = 0L;
            }
        }
        for (int i = 0; i < pList.size(); ++i) {
            Annotation ann = pList.get(i);
            if (!(ann instanceof AlignableAnnotation)) continue;
            this.calculateProposedTimesForPL((AlignableAnnotation)ann);
        }
    }
}

