/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;

public class TimeProposer2 {
    public Annotation getAnnotationAtTime(List<TierImpl> tierTree, AlignableAnnotation rootAnn, Tier targetTier, long time) {
        if (tierTree == null || rootAnn == null || targetTier == null) {
            return null;
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(rootAnn);
        this.addChildren(rootNode, rootAnn, tierTree);
        HashMap<TimeSlot, Long> slotsAndTimes = new HashMap<TimeSlot, Long>(10);
        this.calculateInterpolatedTimes(rootNode, slotsAndTimes);
        Enumeration<TreeNode> nodeEn = rootNode.postorderEnumeration();
        long bb = 0L;
        long ee = 0L;
        while (nodeEn.hasMoreElements()) {
            DefaultMutableTreeNode nn = (DefaultMutableTreeNode)nodeEn.nextElement();
            AlignableAnnotation aa = (AlignableAnnotation)nn.getUserObject();
            if (aa.getTier() != targetTier) continue;
            if (aa.getBegin().isTimeAligned()) {
                bb = aa.getBegin().getTime();
            } else {
                Long bL = (Long)slotsAndTimes.get(aa.getBegin());
                if (bL != null) {
                    bb = bL;
                }
            }
            if (aa.getEnd().isTimeAligned()) {
                ee = aa.getEnd().getTime();
            } else {
                Long eL = (Long)slotsAndTimes.get(aa.getEnd());
                if (eL != null) {
                    ee = eL;
                }
            }
            if (bb > time || time >= ee) continue;
            return aa;
        }
        return null;
    }

    protected void addChildren(DefaultMutableTreeNode node, AlignableAnnotation ann, List<TierImpl> tierTree) {
        int index = tierTree.indexOf(ann.getTier());
        if (index < tierTree.size() - 1) {
            TierImpl nextTier = tierTree.get(index + 1);
            Iterator<Annotation> annIt = nextTier.annotations.iterator();
            boolean beginFound = false;
            while (annIt.hasNext()) {
                DefaultMutableTreeNode nextNode;
                AlignableAnnotation loopAnn = (AlignableAnnotation)annIt.next();
                if (loopAnn.getBegin() == ann.getBegin()) {
                    beginFound = true;
                    nextNode = new DefaultMutableTreeNode(loopAnn);
                    node.add(nextNode);
                    this.addChildren(nextNode, loopAnn, tierTree);
                    continue;
                }
                if (!beginFound) continue;
                nextNode = new DefaultMutableTreeNode(loopAnn);
                node.add(nextNode);
                this.addChildren(nextNode, loopAnn, tierTree);
                if (loopAnn.getEnd() != ann.getEnd()) continue;
                break;
            }
        }
    }

    protected void calculateInterpolatedTimes(DefaultMutableTreeNode node, Map<TimeSlot, Long> slotsAndTimes) {
        DefaultMutableTreeNode nn;
        int i;
        int numCh = node.getChildCount();
        ArrayList<TimeSlot> uSlots = new ArrayList<TimeSlot>(5);
        long lastRealTime = 0L;
        long curRealTime = 0L;
        boolean inUnalignedChain = false;
        for (i = 0; i < numCh; ++i) {
            int j;
            long perSlot;
            long span;
            int j2;
            long perSlot2;
            long span2;
            nn = (DefaultMutableTreeNode)node.getChildAt(i);
            AlignableAnnotation aa = (AlignableAnnotation)nn.getUserObject();
            TimeSlot ts = aa.getBegin();
            if (ts.isTimeAligned()) {
                if (inUnalignedChain) {
                    curRealTime = ts.getTime();
                    span2 = curRealTime - lastRealTime;
                    perSlot2 = span2 / (long)(uSlots.size() + 1);
                    for (j2 = 0; j2 < uSlots.size(); ++j2) {
                        slotsAndTimes.put((TimeSlot)uSlots.get(j2), lastRealTime + (long)(j2 + 1) * perSlot2);
                    }
                    uSlots.clear();
                }
                inUnalignedChain = false;
                lastRealTime = ts.getTime();
            } else {
                Long bt = slotsAndTimes.get(ts);
                if (bt != null) {
                    if (inUnalignedChain) {
                        curRealTime = bt;
                        span = curRealTime - lastRealTime;
                        perSlot = span / (long)(uSlots.size() + 1);
                        for (j = 0; j < uSlots.size(); ++j) {
                            slotsAndTimes.put((TimeSlot)uSlots.get(j), new Long(lastRealTime + (long)(j + 1) * perSlot));
                        }
                        uSlots.clear();
                    }
                    inUnalignedChain = false;
                    lastRealTime = bt;
                } else {
                    if (!uSlots.contains(ts)) {
                        uSlots.add(ts);
                    }
                    if (!inUnalignedChain) {
                        inUnalignedChain = true;
                    }
                }
            }
            ts = (TimeSlotImpl)aa.getEnd();
            if (ts.isTimeAligned()) {
                if (inUnalignedChain) {
                    curRealTime = ts.getTime();
                    span2 = curRealTime - lastRealTime;
                    perSlot2 = span2 / (long)(uSlots.size() + 1);
                    for (j2 = 0; j2 < uSlots.size(); ++j2) {
                        slotsAndTimes.put((TimeSlot)uSlots.get(j2), new Long(lastRealTime + (long)(j2 + 1) * perSlot2));
                    }
                    uSlots.clear();
                }
                inUnalignedChain = false;
                lastRealTime = ts.getTime();
                continue;
            }
            Long bt = slotsAndTimes.get(ts);
            if (bt != null) {
                if (inUnalignedChain) {
                    curRealTime = bt;
                    span = curRealTime - lastRealTime;
                    perSlot = span / (long)(uSlots.size() + 1);
                    for (j = 0; j < uSlots.size(); ++j) {
                        slotsAndTimes.put((TimeSlot)uSlots.get(j), new Long(lastRealTime + (long)(j + 1) * perSlot));
                    }
                    uSlots.clear();
                }
                inUnalignedChain = false;
                lastRealTime = bt;
                continue;
            }
            if (!uSlots.contains(ts)) {
                uSlots.add(ts);
            }
            if (inUnalignedChain) continue;
            inUnalignedChain = true;
        }
        for (i = 0; i < numCh; ++i) {
            nn = (DefaultMutableTreeNode)node.getChildAt(i);
            this.calculateInterpolatedTimes(nn, slotsAndTimes);
        }
    }
}

