/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.LicenseRecord;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeOrderImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeProposer;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.UndoTransaction;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.reflink.RefLinkSet;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientFactory;
import mpi.eudico.server.corpora.util.ACMEditableObject;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.Pair;
import mpi.eudico.util.TimeFormatter;

public class TranscriptionImpl
implements Transcription {
    private List<ACMEditListener> listeners;
    public static final String UNDEFINED_FILE_NAME = "aishug294879ryshfda9763afo8947a5gf";
    protected String fileName;
    protected List<TierImpl> tiers;
    protected List<MediaDescriptor> mediaDescriptors;
    protected List<LinkedFileDescriptor> linkedFileDescriptors;
    protected String url;
    protected String name;
    protected TimeOrder timeOrder;
    protected List<LinguisticType> linguisticTypes;
    protected String author;
    protected boolean isLoaded;
    private boolean changed = false;
    private int timeChangePropagationMode = 0;
    private TimeProposer timeProposer;
    protected List<ControlledVocabulary> controlledVocabularies;
    private List<Property> docProperties;
    private Map<String, LexiconServiceClientFactory> lexiconServiceClientFactories;
    private boolean lexiconServicesLoaded = false;
    private HashMap<String, LexiconLink> lexiconLinks;
    protected boolean isNotifying;
    public static final String URN_PROPERTY_NAME = "URN";
    private static final String URN_PREFIX = "urn:nl-mpi-tools-elan-eaf:";
    private URI cachedURNValue;
    private String currentCVLanguage = "";
    private List<LicenseRecord> licenses;
    private List<RefLinkSet> refLinkSets;
    private final Deque<UndoTransaction> undoStack = new ArrayDeque<UndoTransaction>();
    private static final UndoTransaction terminatingUndoTransaction = new TerminatingUndoTransaction();

    public TranscriptionImpl() {
        this(UNDEFINED_FILE_NAME);
    }

    public TranscriptionImpl(String eafFilePath) {
        this(FileUtility.fileNameFromPath(eafFilePath), FileUtility.pathToURLString(eafFilePath));
        this.initialize(FileUtility.fileNameFromPath(eafFilePath), eafFilePath, null);
    }

    public TranscriptionImpl(String sourceFilePath, DecoderInfo decoderInfo) {
        this(FileUtility.fileNameFromPath(sourceFilePath), FileUtility.pathToURLString(sourceFilePath));
        this.initialize(FileUtility.fileNameFromPath(sourceFilePath), sourceFilePath, decoderInfo);
    }

    private TranscriptionImpl(String theName, String myURL) {
        this.name = theName;
        this.url = myURL;
        this.tiers = new ArrayList<TierImpl>();
        this.listeners = new ArrayList<ACMEditListener>();
        this.timeOrder = new TimeOrderImpl(this);
        this.linguisticTypes = new ArrayList<LinguisticType>();
        this.mediaDescriptors = new ArrayList<MediaDescriptor>();
        this.linkedFileDescriptors = new ArrayList<LinkedFileDescriptor>();
        this.controlledVocabularies = new ArrayList<ControlledVocabulary>();
        this.docProperties = new ArrayList<Property>(5);
        this.isLoaded = false;
        this.isNotifying = true;
        this.timeProposer = new TimeProposer();
    }

    private void initialize(String name, String fileName, DecoderInfo decoderInfo) {
        fileName = FileUtility.urlToAbsPath(fileName);
        this.author = "";
        File fff = new File(fileName);
        if (!fff.exists()) {
            this.isLoaded = true;
            if (!UNDEFINED_FILE_NAME.equals(fileName)) {
                System.out.println("The source file of the transcription could not be found: " + fileName);
            }
        } else {
            this.isLoaded = false;
        }
        this.fileName = fileName;
        this.lexiconLinks = new HashMap();
        if (!this.isLoaded()) {
            ACMTranscriptionStore.getCurrentTranscriptionStore().loadTranscription(this, decoderInfo);
            this.timeProposer.correctProposedTimes(this, null, 14, null);
            String errors = this.checkConsistency();
            if (!errors.isEmpty()) {
                System.err.println("Consistency problems have been detected in the transcription:");
                System.err.print(errors);
            }
        }
    }

    @Override
    public void addACMEditListener(ACMEditListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeACMEditListener(ACMEditListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void notifyListeners(ACMEditableObject source, int operation, Object modification) {
        Iterator<ACMEditListener> i = this.listeners.iterator();
        ACMEditEvent event = new ACMEditEvent(source, operation, modification);
        while (i.hasNext()) {
            i.next().ACMEdited(event);
        }
    }

    @Override
    public void modified(int operation, Object modification) {
        this.handleModification(this, operation, modification);
    }

    @Override
    public void handleModification(ACMEditableObject source, int operation, Object modification) {
        this.setChanged();
        this.timeProposer.correctProposedTimes(this, source, operation, modification);
        if (this.isNotifying) {
            this.notifyListeners(source, operation, modification);
        }
    }

    public void setNotifying(boolean notify) {
        this.isNotifying = notify;
        if (this.isNotifying && this.changed) {
            this.modified(14, null);
        }
    }

    public boolean isNotifying() {
        return this.isNotifying;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String theName) {
        this.name = theName;
    }

    @Override
    public String getFullPath() {
        return this.url;
    }

    @Override
    public List<MediaDescriptor> getMediaDescriptors() {
        return this.mediaDescriptors;
    }

    @Override
    public void setMediaDescriptors(List<MediaDescriptor> theMediaDescriptors) {
        this.mediaDescriptors = theMediaDescriptors;
    }

    @Override
    public List<LinkedFileDescriptor> getLinkedFileDescriptors() {
        return this.linkedFileDescriptors;
    }

    @Override
    public void setLinkedFileDescriptors(List<LinkedFileDescriptor> descriptors) {
        this.linkedFileDescriptors = descriptors;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    @Override
    public void addTier(Tier theTier) {
        this.addTier((TierImpl)theTier);
    }

    public void addTier(TierImpl theTier) {
        if (theTier == null || this.getTierWithId(theTier.getName()) != null) {
            return;
        }
        this.tiers.add(theTier);
        if (this.isLoaded()) {
            this.modified(0, theTier);
        }
    }

    @Override
    public void removeTier(Tier theTier) {
        this.removeTier((TierImpl)theTier);
    }

    public void removeTier(TierImpl theTier) {
        theTier.removeAllAnnotations();
        ArrayList<TierImpl> deletedTiers = new ArrayList<TierImpl>();
        deletedTiers.add(theTier);
        for (TierImpl t : this.tiers) {
            if (t.getNumberOfAnnotations() != 0 || !t.hasAncestor(theTier)) continue;
            deletedTiers.add(t);
        }
        this.tiers.removeAll(deletedTiers);
        this.modified(1, theTier);
    }

    @Override
    public TimeOrder getTimeOrder() {
        return this.timeOrder;
    }

    public void pruneAnnotations() {
        boolean anythingChanged = false;
        for (TierImpl t : this.tiers) {
            anythingChanged |= t.pruneAnnotations();
        }
        this.timeOrder.pruneTimeSlots();
        if (anythingChanged) {
            this.modified(6, null);
        }
    }

    public void pruneAnnotations(Tier fromTier) {
        this.pruneAnnotations(fromTier, null);
    }

    public void pruneAnnotations(Tier fromTier, Annotation removedAnnotation) {
        if (fromTier instanceof TierImpl) {
            TierImpl fromTierImpl = (TierImpl)fromTier;
            List<TierImpl> depTiers = fromTierImpl.getDependentTiers();
            depTiers.add(0, fromTierImpl);
            boolean somethingChanged = false;
            for (TierImpl t : depTiers) {
                somethingChanged |= t.pruneAnnotations();
            }
            this.timeOrder.pruneTimeSlots();
            if (somethingChanged) {
                this.modified(6, removedAnnotation);
            }
        }
    }

    @Override
    public void setAuthor(String theAuthor) {
        this.author = theAuthor;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setLinguisticTypes(List<LinguisticType> theTypes) {
        this.linguisticTypes = theTypes;
    }

    @Override
    public List<LinguisticType> getLinguisticTypes() {
        return this.linguisticTypes;
    }

    @Override
    public LinguisticType getLinguisticTypeByName(String name) {
        if (this.linguisticTypes != null) {
            for (LinguisticType ct : this.linguisticTypes) {
                if (!ct.getLinguisticTypeName().equals(name)) continue;
                return ct;
            }
        }
        return null;
    }

    @Override
    public void addLinguisticType(LinguisticType theType) {
        this.linguisticTypes.add(theType);
        this.modified(9, theType);
    }

    @Override
    public void removeLinguisticType(LinguisticType theType) {
        this.linguisticTypes.remove(theType);
        this.modified(10, theType);
    }

    @Override
    public void changeLinguisticType(LinguisticType linType, String newTypeName, List<Constraint> constraints, String cvName, boolean newTimeAlignable, String dcId, LexiconQueryBundle2 queryBundle) {
        linType.setLinguisticTypeName(newTypeName);
        linType.removeConstraints();
        if (constraints != null) {
            for (Constraint constraint : constraints) {
                linType.addConstraint(constraint);
            }
        }
        linType.setControlledVocabularyName(cvName);
        linType.setTimeAlignable(newTimeAlignable);
        linType.setDataCategory(dcId);
        linType.setLexiconQueryBundle(queryBundle);
        this.modified(11, linType);
        for (TierImpl ti : this.tiers) {
            LinguisticType tlt = ti.getLinguisticType();
            if (tlt != linType) continue;
            ti.setLinguisticType(tlt);
        }
    }

    public List<TierImpl> getTiersWithLinguisticType(String typeID) {
        ArrayList<TierImpl> matchingTiers = new ArrayList<TierImpl>();
        for (TierImpl t : this.tiers) {
            if (!t.getLinguisticType().getLinguisticTypeName().equals(typeID)) continue;
            matchingTiers.add(t);
        }
        return matchingTiers;
    }

    @Override
    public TierImpl getTierWithId(String theTierId) {
        TierImpl result = null;
        for (TierImpl t : this.tiers) {
            if (!t.getName().equals(theTierId)) continue;
            result = t;
            break;
        }
        return result;
    }

    public List<TierImpl> getTiersWithIds(List<String> names) {
        ArrayList<TierImpl> tiers = new ArrayList<TierImpl>(names.size());
        for (String tierName : names) {
            TierImpl ti = this.getTierWithId(tierName);
            if (ti == null) continue;
            tiers.add(ti);
        }
        return tiers;
    }

    @Override
    public List<Annotation> getAnnotationsUsingTimeSlot(TimeSlot theSlot) {
        ArrayList<Annotation> resultAnnots = new ArrayList<Annotation>();
        for (TierImpl t : this.tiers) {
            resultAnnots.addAll(t.getAnnotationsUsingTimeSlot(theSlot));
        }
        return resultAnnots;
    }

    public List<Annotation> getAnnotsBeginningAtTimeSlot(TimeSlot theSlot) {
        ArrayList<Annotation> resultAnnots = new ArrayList<Annotation>();
        for (TierImpl t : this.tiers) {
            resultAnnots.addAll(t.getAnnotsBeginningAtTimeSlot(theSlot));
        }
        return resultAnnots;
    }

    public List<Annotation> getAnnotsBeginningAtTimeSlot(TimeSlot theSlot, Tier forTier, boolean includeThisTier) {
        ArrayList<Annotation> resultAnnots = new ArrayList<Annotation>();
        TierImpl forTierImpl = (TierImpl)forTier;
        List<TierImpl> depTiers = forTierImpl.getDependentTiers();
        if (includeThisTier) {
            depTiers.add(0, forTierImpl);
        }
        for (TierImpl t : depTiers) {
            resultAnnots.addAll(t.getAnnotsBeginningAtTimeSlot(theSlot));
        }
        return resultAnnots;
    }

    public List<Annotation> getAnnotsEndingAtTimeSlot(TimeSlot theSlot) {
        ArrayList<Annotation> resultAnnots = new ArrayList<Annotation>();
        for (TierImpl t : this.tiers) {
            resultAnnots.addAll(t.getAnnotsEndingAtTimeSlot(theSlot));
        }
        return resultAnnots;
    }

    public List<Annotation> getAnnotsEndingAtTimeSlot(TimeSlot theSlot, TierImpl forTier, boolean includeThisTier) {
        ArrayList<Annotation> resultAnnots = new ArrayList<Annotation>();
        List<TierImpl> depTiers = forTier.getDependentTiers();
        if (includeThisTier) {
            depTiers.add(0, forTier);
        }
        for (TierImpl t : depTiers) {
            resultAnnots.addAll(t.getAnnotsEndingAtTimeSlot(theSlot));
        }
        return resultAnnots;
    }

    public HashSet<TimeSlot> getTimeSlotsInUse() {
        HashSet<TimeSlot> usedSlots = new HashSet<TimeSlot>(this.getTimeOrder().size());
        for (TierImpl t : this.tiers) {
            if (!t.isTimeAlignable()) continue;
            for (Annotation annotation : t.getAnnotations()) {
                if (!(annotation instanceof AlignableAnnotation)) continue;
                AlignableAnnotation aa = (AlignableAnnotation)annotation;
                usedSlots.add(aa.getBegin());
                usedSlots.add(aa.getEnd());
            }
        }
        return usedSlots;
    }

    @Override
    public List<String> getAnnotationIdsAtTime(long time) {
        ArrayList<String> resultAnnots = new ArrayList<String>();
        for (TierImpl t : this.tiers) {
            Annotation ann = t.getAnnotationAtTime(time);
            if (ann == null) continue;
            resultAnnots.add(ann.getId());
        }
        return resultAnnots;
    }

    @Override
    public Annotation getAnnotationById(String id) {
        if (id == null) {
            return null;
        }
        for (TierImpl t : this.tiers) {
            Annotation a = t.getAnnotationById(id);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public Map<String, Annotation> getAnnotationsByIdMap() {
        HashMap<String, Annotation> map = new HashMap<String, Annotation>();
        for (TierImpl t : this.tiers) {
            t.getAnnotationsByIdMap(map);
        }
        return map;
    }

    @Override
    public long getLatestTime() {
        long latestTime = 0L;
        Iterator<TimeSlot> elmts = this.getTimeOrder().iterator();
        while (elmts.hasNext()) {
            long t = elmts.next().getTime();
            if (t <= latestTime) continue;
            latestTime = t;
        }
        return latestTime;
    }

    public List<Annotation> getChildAnnotationsOf(Annotation theAnnot) {
        ArrayList<Annotation> children = new ArrayList<Annotation>();
        if (theAnnot instanceof RefAnnotation) {
            children.addAll(((RefAnnotation)theAnnot).getParentListeners());
        } else {
            TreeSet<AlignableAnnotation> connectedAnnots = new TreeSet<AlignableAnnotation>();
            Tier theAnnotsTier = theAnnot.getTier();
            this.getConnectedSubtree(connectedAnnots, ((AlignableAnnotation)theAnnot).getBegin(), ((AlignableAnnotation)theAnnot).getEnd(), theAnnotsTier);
            ArrayList<AlignableAnnotation> connAnnotVector = new ArrayList<AlignableAnnotation>(connectedAnnots);
            ArrayList<TierImpl> descTiers = new ArrayList<TierImpl>();
            for (TierImpl t : this.tiers) {
                if (!t.hasAncestor(theAnnotsTier)) continue;
                descTiers.add(t);
            }
            block1: for (TierImpl descT : descTiers) {
                for (Annotation annotation : descT.getAnnotations()) {
                    if (annotation instanceof RefAnnotation) {
                        if (((RefAnnotation)annotation).getReferences().size() <= 0 || ((RefAnnotation)annotation).getReferences().get(0) != theAnnot) continue;
                        children.add(annotation);
                        continue;
                    }
                    if (!(annotation instanceof AlignableAnnotation)) continue;
                    if (connAnnotVector.contains(annotation)) {
                        children.add(annotation);
                        continue;
                    }
                    if (descT.getLinguisticType().getConstraints().getStereoType() != 1) continue;
                    if (annotation.getBeginTimeBoundary() < theAnnot.getEndTimeBoundary() && annotation.getEndTimeBoundary() > theAnnot.getBeginTimeBoundary()) {
                        children.add(annotation);
                    }
                    if (annotation.getBeginTimeBoundary() <= theAnnot.getEndTimeBoundary()) continue;
                    continue block1;
                }
            }
        }
        return children;
    }

    public void getConnectedAnnots(TreeSet<AbstractAnnotation> connectedAnnots, TreeSet connectedTimeSlots, AlignableAnnotation fromAnn) {
        this.getConnectedAnnots(connectedAnnots, (TreeSet<TimeSlot>)connectedTimeSlots, fromAnn.getBegin());
        TierImpl t = (TierImpl)fromAnn.getTier();
        List<TierImpl> depTiers = t.getDependentTiers();
        for (TierImpl tt : depTiers) {
            if (tt.getLinguisticType().getConstraints().getStereoType() != 1) continue;
            for (AlignableAnnotation aa : tt.getAlignableAnnotations()) {
                if (!fromAnn.isAncestorOf(aa)) continue;
                this.getConnectedAnnots(connectedAnnots, connectedTimeSlots, aa);
            }
        }
    }

    public void getConnectedAnnots(TreeSet<AbstractAnnotation> connectedAnnots, TreeSet<TimeSlot> connectedTimeSlots, TimeSlot startingFromTimeSlot) {
        List<Annotation> annots = null;
        connectedTimeSlots.add(startingFromTimeSlot);
        annots = this.getAnnotationsUsingTimeSlot(startingFromTimeSlot);
        if (annots != null) {
            for (AlignableAnnotation alignableAnnotation : annots) {
                boolean added = connectedAnnots.add(alignableAnnotation);
                if (!added) continue;
                if (!connectedTimeSlots.contains(alignableAnnotation.getBegin())) {
                    this.getConnectedAnnots(connectedAnnots, connectedTimeSlots, alignableAnnotation.getBegin());
                }
                if (connectedTimeSlots.contains(alignableAnnotation.getEnd())) continue;
                this.getConnectedAnnots(connectedAnnots, connectedTimeSlots, alignableAnnotation.getEnd());
            }
        }
    }

    public boolean getConnectedSubtree(TreeSet<AlignableAnnotation> connectedAnnots, TimeSlot startingFromTimeSlot, TimeSlot stopTimeSlot, Tier topTier) {
        List<Annotation> annots = null;
        boolean endFound = false;
        annots = topTier == null ? this.getAnnotsBeginningAtTimeSlot(startingFromTimeSlot) : this.getAnnotsBeginningAtTimeSlot(startingFromTimeSlot, topTier, true);
        if (annots != null) {
            for (AlignableAnnotation alignableAnnotation : annots) {
                if (alignableAnnotation.getEnd() != stopTimeSlot) {
                    endFound = this.getConnectedSubtree(connectedAnnots, alignableAnnotation.getEnd(), stopTimeSlot, alignableAnnotation.getTier());
                    connectedAnnots.add(alignableAnnotation);
                    continue;
                }
                endFound = true;
                connectedAnnots.add(alignableAnnotation);
            }
        }
        return endFound;
    }

    public boolean eachRootHasSubdiv() {
        boolean eachRootHasSubdiv = true;
        List<TierImpl> topTiers = this.getTopTiers();
        for (TierImpl t : topTiers) {
            for (AbstractAnnotation a : t.getAnnotations()) {
                List<Annotation> children = a.getParentListeners();
                if (children == null || children.size() == 0) {
                    return false;
                }
                boolean subdivFound = false;
                for (Annotation ch : children) {
                    Constraint constraint = ((TierImpl)ch.getTier()).getLinguisticType().getConstraints();
                    if (constraint.getStereoType() != 3 && constraint.getStereoType() != 0) continue;
                    subdivFound = true;
                    break;
                }
                if (subdivFound) continue;
                return false;
            }
        }
        return eachRootHasSubdiv;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setUnchanged() {
        this.changed = false;
        if (this.controlledVocabularies != null) {
            for (int i = 0; i < this.controlledVocabularies.size(); ++i) {
                ControlledVocabulary cv = this.controlledVocabularies.get(i);
                cv.setChanged(false);
            }
        }
    }

    @Override
    public void setChanged() {
        this.changed = true;
    }

    @Override
    public int getTimeChangePropagationMode() {
        return this.timeChangePropagationMode;
    }

    @Override
    public void setTimeChangePropagationMode(int theMode) {
        this.timeChangePropagationMode = theMode;
    }

    public void correctOverlapsByShifting(AlignableAnnotation fixedAnnotation, List<TimeSlot> fixedSlots, long oldBegin, long oldEnd) {
        long newEnd = fixedAnnotation.getEnd().getTime();
        if (newEnd > oldEnd) {
            long shift = newEnd - oldEnd;
            List<TimeSlot> otherFixedSLots = this.getOtherFixedSlots(oldBegin, fixedAnnotation.getTier().getName());
            if (otherFixedSLots != null) {
                for (int i = 0; i < otherFixedSLots.size(); ++i) {
                    if (fixedSlots.contains(otherFixedSLots.get(i))) continue;
                    fixedSlots.add(otherFixedSLots.get(i));
                }
            }
            this.getTimeOrder().shift(oldBegin, shift, fixedAnnotation.getEnd(), fixedSlots);
        }
    }

    private List<TimeSlot> getOtherFixedSlots(long from, String excludeTimeSlotsFromTier) {
        List<TierImpl> tiers = this.getTiers();
        ArrayList<TimeSlot> fixedSlots = new ArrayList<TimeSlot>();
        for (int t = 0; t < tiers.size(); ++t) {
            TierImpl tier = tiers.get(t);
            if (tier.getLinguisticType().getConstraints() != null || excludeTimeSlotsFromTier != null && tier.getName().equals(excludeTimeSlotsFromTier)) continue;
            for (AlignableAnnotation ann : tier.getAlignableAnnotations()) {
                List<TierImpl> dependingdTiers;
                if (ann.getBeginTimeBoundary() > from) break;
                if (ann.getBeginTimeBoundary() >= from || ann.getEndTimeBoundary() <= from) continue;
                if (!fixedSlots.contains(ann.endTime)) {
                    fixedSlots.add(ann.endTime);
                }
                if ((dependingdTiers = tier.getDependentTiers()) == null) continue;
                for (int i = 0; i < dependingdTiers.size(); ++i) {
                    List<Annotation> childAnnotations;
                    TierImpl dependTier = dependingdTiers.get(i);
                    if (dependTier.getLinguisticType().getConstraints().getStereoType() != 0 && dependTier.getLinguisticType().getConstraints().getStereoType() != 1 || (childAnnotations = ann.getChildrenOnTier(dependTier)) == null) continue;
                    for (int a = 0; a < childAnnotations.size(); ++a) {
                        AlignableAnnotation childAnn = (AlignableAnnotation)childAnnotations.get(a);
                        if (childAnn.getBeginTimeBoundary() > from && !fixedSlots.contains(childAnn.beginTime)) {
                            fixedSlots.add(childAnn.beginTime);
                        }
                        if (childAnn.getEndTimeBoundary() <= from || fixedSlots.contains(childAnn.endTime)) continue;
                        fixedSlots.add(childAnn.endTime);
                    }
                }
            }
        }
        return fixedSlots;
    }

    public void shiftBackward(long from, long amount) {
        if (amount < 0L) {
            this.getTimeOrder().shift(from, amount, null, this.getOtherFixedSlots(from, null));
            this.modified(14, null);
        }
    }

    public void shiftAllAnnotations(long shiftValue) throws IllegalArgumentException {
        this.timeOrder.shiftAll(shiftValue);
        this.modified(14, null);
    }

    public List<TierImpl> getTiers() {
        return this.tiers;
    }

    public boolean equals(Object obj) {
        return obj instanceof TranscriptionImpl && ((TranscriptionImpl)obj).getName() == this.name;
    }

    public String getPathName() {
        return this.fileName;
    }

    public void setPathName(String theFileName) {
        this.fileName = theFileName = FileUtility.urlToAbsPath(theFileName);
        this.url = FileUtility.pathToURLString(this.fileName);
        this.name = FileUtility.fileNameFromPath(theFileName);
    }

    @Override
    public void setControlledVocabularies(List<ControlledVocabulary> controlledVocabs) {
        if (controlledVocabs != null) {
            this.controlledVocabularies = controlledVocabs;
        }
    }

    @Override
    public List<ControlledVocabulary> getControlledVocabularies() {
        return this.controlledVocabularies;
    }

    @Override
    public ControlledVocabulary getControlledVocabulary(String name) {
        if (name == null) {
            return null;
        }
        ControlledVocabulary conVoc = null;
        for (int i = 0; i < this.controlledVocabularies.size() && !(conVoc = this.controlledVocabularies.get(i)).getName().equalsIgnoreCase(name); ++i) {
            conVoc = null;
        }
        return conVoc;
    }

    public void addControlledVocabulary(ControlledVocabulary cv) {
        if (cv == null) {
            return;
        }
        for (int i = 0; i < this.controlledVocabularies.size(); ++i) {
            ControlledVocabulary conVoc = this.controlledVocabularies.get(i);
            if (conVoc != cv && !conVoc.getName().equalsIgnoreCase(cv.getName())) continue;
            return;
        }
        this.controlledVocabularies.add(cv);
        cv.setACMEditableObject(this);
        if (this.isLoaded) {
            this.modified(13, cv);
        }
    }

    public void removeControlledVocabulary(ControlledVocabulary cv) {
        if (cv == null) {
            return;
        }
        List<LinguisticType> types = this.getLinguisticTypesWithCV(cv.getName());
        for (LinguisticType lt : types) {
            lt.setControlledVocabularyName(null);
        }
        cv.removeACMEditableObject();
        this.controlledVocabularies.remove(cv);
        this.modified(13, cv);
    }

    public void replaceControlledVocabulary(ControlledVocabulary cv) {
        if (cv == null) {
            return;
        }
        ControlledVocabulary oldCV = this.getControlledVocabulary(cv.getName());
        if (oldCV == null) {
            return;
        }
        oldCV.removeACMEditableObject();
        this.controlledVocabularies.remove(oldCV);
        this.controlledVocabularies.add(cv);
        cv.setACMEditableObject(this);
        this.modified(13, cv);
    }

    public void changeControlledVocabulary(ControlledVocabulary cv, String name, int langIndex, String description) {
        boolean newChange = false;
        String oldName = cv.getName();
        String oldDescription = cv.getDescription(langIndex);
        for (int i = 0; i < this.controlledVocabularies.size(); ++i) {
            ControlledVocabulary conVoc = this.controlledVocabularies.get(i);
            if (conVoc == cv || !conVoc.getName().equalsIgnoreCase(name)) continue;
            return;
        }
        if (!oldName.equals(name)) {
            newChange = true;
            List<LinguisticType> types = this.getLinguisticTypesWithCV(oldName);
            for (int i = 0; i < types.size(); ++i) {
                types.get(i).setControlledVocabularyName(name);
            }
            cv.setName(name);
        }
        if (oldDescription == null || !oldDescription.equals(description)) {
            cv.setDescription(langIndex, description);
            newChange = true;
        }
        if (newChange) {
            this.modified(13, cv);
        }
    }

    public void checkAnnotECVConsistency(boolean annotationValuePrecedence) {
        for (TierImpl currentTier : this.tiers) {
            ExternalCV ecv;
            Pair<ControlledVocabulary, Integer> pair = currentTier.getEffectiveLanguage();
            if (pair == null) continue;
            ControlledVocabulary cv = pair.getFirst();
            int langIndex = pair.getSecond();
            if (!(cv instanceof ExternalCV) || langIndex < 0 || !(ecv = (ExternalCV)cv).isLoadedFromURL() && !ecv.isLoadedFromCache()) continue;
            for (AbstractAnnotation currentAnn : currentTier.getAnnotations()) {
                String value;
                CVEntry cvEntry;
                String cvEntryRefId = currentAnn.getCVEntryId();
                if (cvEntryRefId == null) {
                    if (currentAnn.getValue().isEmpty() || (cvEntry = ecv.getEntryWithValue(langIndex, currentAnn.getValue())) == null) continue;
                    currentAnn.setCVEntryId(cvEntry.getId());
                    this.setChanged();
                    continue;
                }
                if (annotationValuePrecedence) {
                    if (currentAnn.getValue().isEmpty()) continue;
                    cvEntry = ecv.getEntryWithValue(langIndex, currentAnn.getValue());
                    if (cvEntry != null) {
                        if (cvEntryRefId.equals(cvEntry.getId())) continue;
                        currentAnn.setCVEntryId(cvEntry.getId());
                        this.setChanged();
                        continue;
                    }
                    currentAnn.setCVEntryId(null);
                    this.setChanged();
                    continue;
                }
                CVEntry entry = ecv.getEntrybyId(cvEntryRefId);
                if (entry != null && (value = entry.getValue(langIndex)) != null && !value.equals(currentAnn.getValue())) {
                    currentAnn.setValue(value);
                    this.setChanged();
                    continue;
                }
                if (entry != null) continue;
                currentAnn.setCVEntryId(null);
                this.setChanged();
            }
        }
    }

    @Override
    public List<LinguisticType> getLinguisticTypesWithCV(String name) {
        ArrayList<LinguisticType> matchingTypes = new ArrayList<LinguisticType>();
        for (LinguisticType lt : this.linguisticTypes) {
            String cvName = lt.getControlledVocabularyName();
            if (cvName == null || !cvName.equalsIgnoreCase(name)) continue;
            matchingTypes.add(lt);
        }
        return matchingTypes;
    }

    public List<TierImpl> getTiersWithCV(String name) {
        ArrayList<TierImpl> matchingTiers = new ArrayList<TierImpl>();
        if (name == null || name.length() == 0) {
            return matchingTiers;
        }
        List<LinguisticType> types = this.getLinguisticTypesWithCV(name);
        if (types.size() > 0) {
            for (LinguisticType type : types) {
                List<TierImpl> tv = this.getTiersWithLinguisticType(type.getLinguisticTypeName());
                if (tv.size() <= 0) continue;
                matchingTiers.addAll(tv);
            }
        }
        return matchingTiers;
    }

    public boolean allRootAnnotsUnaligned() {
        List<TierImpl> topTiers = this.getTopTiers();
        for (TierImpl t : topTiers) {
            for (AlignableAnnotation a : t.getAlignableAnnotations()) {
                if (!a.getBegin().isTimeAligned() && !a.getEnd().isTimeAligned()) continue;
                return false;
            }
        }
        return true;
    }

    public void alignRootAnnots() {
        ArrayList<TimeSlot> rootTimeSlots = new ArrayList<TimeSlot>();
        List<TierImpl> topTiers = this.getTopTiers();
        for (TierImpl t : topTiers) {
            for (AlignableAnnotation a : t.getAlignableAnnotations()) {
                rootTimeSlots.add(a.getBegin());
                rootTimeSlots.add(a.getEnd());
            }
        }
        int cnt = 0;
        Object[] tsArray = rootTimeSlots.toArray();
        Arrays.sort(tsArray);
        for (int i = 0; i < tsArray.length; ++i) {
            TimeSlot ts = (TimeSlot)tsArray[i];
            if (i % 2 == 0) {
                ts.setTime(1000 * cnt++);
                continue;
            }
            ts.setTime(1000 * cnt);
        }
    }

    public final List<TierImpl> getTopTiers() {
        ArrayList<TierImpl> result = new ArrayList<TierImpl>();
        for (TierImpl t : this.getTiers()) {
            TierImpl dad = t.getParentTier();
            if (dad != null) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    public void addDocProperties(List<Property> props) {
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                Property prop = props.get(i);
                if (!(prop instanceof Property) || this.docProperties.contains(prop)) continue;
                this.docProperties.add(prop);
            }
        }
    }

    @Override
    public void addDocProperty(Property prop) {
        if (prop != null && !this.docProperties.contains(prop)) {
            this.docProperties.add(prop);
        }
    }

    @Override
    public boolean removeDocProperty(Property prop) {
        if (prop != null) {
            return this.docProperties.remove(prop);
        }
        return false;
    }

    public List<Property> getDocProperties() {
        return this.docProperties;
    }

    public void clearDocProperties() {
        this.docProperties.clear();
    }

    public Property getDocProperty(String name) {
        List<Property> props = this.getDocProperties();
        for (Property p : props) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public Map<String, LexiconServiceClientFactory> getLexiconServiceClientFactories() {
        return this.lexiconServiceClientFactories;
    }

    public void addLexiconServiceClientFactory(String name, LexiconServiceClientFactory fact) {
        if (this.lexiconServiceClientFactories == null) {
            this.lexiconServiceClientFactories = new HashMap<String, LexiconServiceClientFactory>(6);
        }
        this.lexiconServiceClientFactories.put(name, fact);
        this.lexiconServicesLoaded = true;
    }

    public void removeLexiconServiceClientFactory(String name) {
        if (this.lexiconServiceClientFactories != null) {
            this.lexiconServiceClientFactories.remove(name);
        }
    }

    public boolean isLexiconServicesLoaded() {
        return this.lexiconServicesLoaded;
    }

    public void setLexiconServicesLoaded(boolean lexiconServicesLoaded) {
        this.lexiconServicesLoaded = lexiconServicesLoaded;
    }

    public HashMap<String, LexiconLink> getLexiconLinks() {
        return this.lexiconLinks;
    }

    @Override
    public void addLexiconLink(LexiconLink link) {
        this.lexiconLinks.put(link.getName(), link);
        if (this.isLoaded) {
            this.modified(19, link);
        }
    }

    @Override
    public void removeLexiconLink(LexiconLink link) {
        for (LinguisticType type : this.linguisticTypes) {
            if (!type.isUsingLexiconQueryBundle() || !type.getLexiconQueryBundle().getLink().getName().equals(link.getName())) continue;
            type.setLexiconQueryBundle(null);
        }
        this.lexiconLinks.remove(link.getName());
        if (this.isLoaded) {
            this.modified(18, link);
        }
    }

    @Override
    public LexiconLink getLexiconLink(String linkName) {
        return this.lexiconLinks.get(linkName);
    }

    public List<LinguisticType> getLinguisticTypesWithLexLink(String name) {
        ArrayList<LinguisticType> types = new ArrayList<LinguisticType>();
        for (LinguisticType type : this.linguisticTypes) {
            if (!type.isUsingLexiconQueryBundle() || !type.getLexiconQueryBundle().getLink().getName().equals(name)) continue;
            types.add(type);
        }
        return types;
    }

    @Override
    public URI getURN() {
        if (this.cachedURNValue == null) {
            List<Property> props = this.getDocProperties();
            for (Property p : props) {
                if (!p.getName().equals(URN_PROPERTY_NAME)) continue;
                try {
                    this.cachedURNValue = new URI((String)p.getValue());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if (this.cachedURNValue == null) {
                this.createNewURN(null);
            }
        }
        return this.cachedURNValue;
    }

    public void createNewURN() {
        List<Property> props = this.getDocProperties();
        for (Property p : props) {
            if (!p.getName().equals(URN_PROPERTY_NAME)) continue;
            this.createNewURN(p);
            return;
        }
        this.createNewURN(null);
    }

    private void createNewURN(Property overwrite) {
        try {
            this.cachedURNValue = new URI(URN_PREFIX + UUID.randomUUID());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (overwrite != null) {
            overwrite.setValue(this.cachedURNValue);
        } else {
            PropertyImpl p = new PropertyImpl(URN_PROPERTY_NAME, this.cachedURNValue);
            this.addDocProperty(p);
        }
    }

    public void updateCVLanguage(String newLanguage, boolean force) {
        if (newLanguage == null || newLanguage.isEmpty()) {
            return;
        }
        if (!force && this.currentCVLanguage.equals(newLanguage)) {
            return;
        }
        this.currentCVLanguage = newLanguage;
        for (ControlledVocabulary controlledVocabulary : this.getControlledVocabularies()) {
            controlledVocabulary.setPreferenceLanguage(newLanguage);
        }
        this.setNotifying(false);
        for (Tier tier : this.tiers) {
            ((TierImpl)tier).updateCVLanguage();
        }
        this.setNotifying(true);
    }

    public String getCVLanguage() {
        return this.currentCVLanguage;
    }

    @Override
    public List<LicenseRecord> getLicenses() {
        return this.licenses;
    }

    @Override
    public void setLicenses(List<LicenseRecord> licenses) {
        this.licenses = licenses;
    }

    public String checkConsistency() {
        StringBuilder complaints = new StringBuilder();
        FixTimeslots fixTS = new FixTimeslots();
        List<TierImpl> tiers = this.getTiers();
        for (TierImpl t : tiers) {
            if (t.isTimeAlignable()) {
                this.fixTierTimeSlots(t, fixTS);
                this.checkTierTimes(t, complaints);
            }
            this.checkTierAnnotations(t, complaints);
        }
        return complaints.toString();
    }

    private void fixTierTimeSlots(TierImpl t, FixTimeslots fixTS) {
        TierImpl localRootTier = this.getLocalRoot(t);
        for (Annotation annotation : t.getAnnotations()) {
            if (!(annotation instanceof AlignableAnnotation)) continue;
            AlignableAnnotation aa = (AlignableAnnotation)annotation;
            aa.setBegin(fixTS.fixTimeSlot(localRootTier, aa.getBegin()));
            aa.setEnd(fixTS.fixTimeSlot(localRootTier, aa.getEnd()));
        }
    }

    private TierImpl getLocalRoot(TierImpl t) {
        Constraint s = t.getLinguisticType().getConstraints();
        if (s != null && s.getStereoType() == 1) {
            return t;
        }
        TierImpl parent = t.getParentTier();
        if (parent == null) {
            return t;
        }
        return this.getLocalRoot(parent);
    }

    private void checkTierTimes(TierImpl t, StringBuilder complaints) {
        for (Annotation a : t.annotations) {
            long endTime;
            long startTime = a.getBeginTimeBoundary();
            if (startTime <= (endTime = a.getEndTimeBoundary())) continue;
            complaints.append("Error: end time before start time.");
            complaints.append(" Tier: ");
            complaints.append(t.getName());
            complaints.append(" Start time: ");
            complaints.append(TimeFormatter.toString(startTime));
            complaints.append(" End time: ");
            complaints.append(TimeFormatter.toString(endTime));
            complaints.append('\n');
        }
    }

    private void checkTierAnnotations(TierImpl t, StringBuilder complaints) {
        for (Annotation a : t.annotations) {
            int codePoint;
            int type;
            String text = a.getValue();
            if (text.length() <= 0 || (type = Character.getType(codePoint = text.codePointAt(0))) != 6 && type != 8 && type != 7) continue;
            long startTime = a.getBeginTimeBoundary();
            complaints.append("Error: Unicode combining or enclosing mark at the start of the annotation. A space character was prepended.");
            complaints.append(" Tier: ");
            complaints.append(t.getName());
            complaints.append(" Start time: ");
            complaints.append(TimeFormatter.toString(startTime));
            complaints.append('\n');
            a.setValue(" " + text);
        }
    }

    @Override
    public void addRefLinkSet(RefLinkSet refLinkSet) {
        if (refLinkSet == null) {
            return;
        }
        if (this.refLinkSets == null) {
            this.refLinkSets = new ArrayList<RefLinkSet>();
        }
        if (!this.refLinkSets.contains(refLinkSet)) {
            this.refLinkSets.add(refLinkSet);
            this.addACMEditListener(refLinkSet);
            if (this.isLoaded) {
                this.modified(26, refLinkSet);
            }
        }
    }

    @Override
    public void removeRefLinkSet(RefLinkSet refLinkSet) {
        if (refLinkSet == null) {
            return;
        }
        if (this.refLinkSets != null && this.refLinkSets.remove(refLinkSet)) {
            this.removeACMEditListener(refLinkSet);
            if (this.isLoaded) {
                this.modified(27, refLinkSet);
            }
        }
    }

    @Override
    public RefLinkSet getRefLinkSetByName(String name) {
        if (this.refLinkSets != null) {
            for (RefLinkSet rls : this.refLinkSets) {
                if (rls.getLinksName() == null || !rls.getLinksName().equals(name)) continue;
                return rls;
            }
        }
        return null;
    }

    @Override
    public RefLinkSet getRefLinkSetById(String id) {
        if (this.refLinkSets != null) {
            for (RefLinkSet rls : this.refLinkSets) {
                if (!rls.getLinksID().equals(id)) continue;
                return rls;
            }
        }
        return null;
    }

    public void setRefLinkSets(List<RefLinkSet> refLinksSets) {
        this.refLinkSets = refLinksSets;
    }

    @Override
    public List<RefLinkSet> getRefLinkSets() {
        return this.refLinkSets;
    }

    public void pushNewUndoTransaction() {
        this.undoStack.push(terminatingUndoTransaction);
    }

    public void popAndUndoTransaction() {
        for (UndoTransaction undo = this.undoStack.pollFirst(); undo != null; undo = undo.getNext()) {
            undo.undo();
        }
    }

    public void popAndForgetTransaction() {
        this.undoStack.pollFirst();
    }

    public void forgetOldUndoTransactions(int keep) {
        while (this.undoStack.size() > keep) {
            this.undoStack.pollLast();
        }
    }

    public void addToCurrentUndoTransaction(UndoTransaction u) {
        if (!this.undoStack.isEmpty()) {
            UndoTransaction uPrev = this.undoStack.pop();
            u.setNext(uPrev);
            this.undoStack.push(u);
        }
    }

    public UndoTransaction getCurrentUndoTransaction() {
        return this.undoStack.peek();
    }

    static class TerminatingUndoTransaction
    extends UndoTransaction {
        TerminatingUndoTransaction() {
        }

        @Override
        public void undo() {
        }

        @Override
        public void setNext(UndoTransaction u) {
            throw new UnsupportedOperationException("Must not change this object");
        }
    }

    private class FixTimeslots {
        Map<TimeSlot, TierImpl> timeslotsInUse = new HashMap<TimeSlot, TierImpl>();
        Map<Pair<TimeSlot, TierImpl>, TimeSlot> replacementTimeSlot = new HashMap<Pair<TimeSlot, TierImpl>, TimeSlot>();
        TimeOrder timeOrder;

        FixTimeslots() {
            this.timeOrder = TranscriptionImpl.this.getTimeOrder();
        }

        private TimeSlot fixTimeSlot(TierImpl rootTier, TimeSlot ts) {
            TierImpl rootTierUsedBefore = this.timeslotsInUse.get(ts);
            if (rootTierUsedBefore == null) {
                this.timeslotsInUse.put(ts, rootTier);
                return ts;
            }
            if (rootTierUsedBefore == rootTier) {
                return ts;
            }
            Pair<TimeSlot, TierImpl> p = Pair.makePair(ts, rootTier);
            TimeSlot newTS = this.replacementTimeSlot.get(p);
            if (newTS != null) {
                return newTS;
            }
            if (ts.isTimeAligned()) {
                newTS = new TimeSlotImpl(ts.getTime(), this.timeOrder);
                this.timeOrder.insertTimeSlot(newTS);
            } else {
                newTS = new TimeSlotImpl(this.timeOrder);
                TimeSlot pred = this.timeOrder.getPredecessorOf(ts);
                TimeSlot predClone = this.replacementTimeSlot.get(Pair.makePair(pred, rootTier));
                if (predClone == null) {
                    predClone = pred;
                }
                this.timeOrder.insertTimeSlot(newTS, predClone, null);
            }
            this.replacementTimeSlot.put(p, newTS);
            System.err.printf("Duplicated timeslot at time %d ms: seen on not-sharing tier trees '%s' and '%s'.\n", ts.getTime(), rootTier.getName(), rootTierUsedBefore.getName());
            return newTS;
        }
    }
}

