/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.chat;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.chat.CHATEncoderInfo;

public class CHATEncoder
implements AnnotationDocEncoder {
    private static String BEGIN_LABEL = "@Begin";
    private static String END_LABEL = "@End";
    private static String LANGUAGE_LABEL = "@Languages:\t";
    private static String PARTICIPANTS_LABEL = "@Participants:\t";
    private static String ID_LABEL = "@ID:\t";
    private static String SOUND_LABEL = "%snd:";
    private static String VIDEO_LABEL = "%mov:";
    private static String LANG_LABEL = "%lan:";
    private final char BULLET = (char)21;
    private long lastAlignedBeginTime = 0L;
    private String[][] mainTierInfo;
    private String[][] dependentTierInfo;

    @Override
    public void encodeAndSave(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String path) throws IOException {
        this.mainTierInfo = ((CHATEncoderInfo)encoderInfo).getMainTierInfo();
        this.dependentTierInfo = ((CHATEncoderInfo)encoderInfo).getDependentTierInfo();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
        out.write("@UTF8\n");
        out.write(BEGIN_LABEL + "\n");
        this.writeHeader(theTranscription, encoderInfo, out);
        this.writeBlocks(theTranscription, encoderInfo, out);
        out.write(END_LABEL + "\n");
        out.close();
    }

    private void writeHeader(Transcription theTranscription, EncoderInfo encoderInfo, OutputStreamWriter out) {
        try {
            Object langString = LANGUAGE_LABEL;
            HashSet<String> languages = new HashSet<String>();
            List<? extends Tier> tiers = theTranscription.getTiers();
            if (tiers != null) {
                for (Tier tier : tiers) {
                    if (!(tier instanceof TierImpl)) continue;
                    String langId = tier.getLangRef();
                    if (langId != null) {
                        languages.add(langId);
                        continue;
                    }
                    Locale loc = ((TierImpl)tier).getDefaultLocale();
                    if (loc == null) continue;
                    languages.add(loc.getLanguage());
                }
            }
            for (int i = 0; i < this.mainTierInfo[5].length; ++i) {
                if (this.mainTierInfo[5][i] == null || this.mainTierInfo[5][i].length() <= 0) continue;
                languages.add(this.mainTierInfo[5][i]);
            }
            int j = 0;
            Iterator iterator = languages.iterator();
            while (iterator.hasNext()) {
                if (j > 0) {
                    langString = (String)langString + ", ";
                }
                langString = (String)langString + (String)iterator.next();
                ++j;
            }
            if (langString != LANGUAGE_LABEL) {
                out.write((String)langString + "\n");
            } else {
                out.write((String)langString + "en\n");
            }
            Object participantsString = PARTICIPANTS_LABEL;
            ArrayList<Integer> partTierInd = new ArrayList<Integer>();
            for (int i = 0; i < this.mainTierInfo[1].length; ++i) {
                if (this.mainTierInfo[1][i] == null || this.mainTierInfo[1][i].charAt(0) != '*') continue;
                partTierInd.add(i);
                if (i > 0) {
                    participantsString = (String)participantsString + ", ";
                }
                participantsString = this.mainTierInfo[4][i] != null && !this.mainTierInfo[4][i].isEmpty() ? (String)participantsString + this.mainTierInfo[4][i] : (String)participantsString + this.mainTierInfo[1][i].substring(1);
                if (!this.mainTierInfo[2][i].equals("")) {
                    participantsString = (String)participantsString + " " + this.mainTierInfo[2][i].replace(" ", "_");
                }
                participantsString = !this.mainTierInfo[3][i].equals("") ? (String)participantsString + " " + this.mainTierInfo[3][i] : (String)participantsString + " Unidentified";
            }
            if (participantsString != PARTICIPANTS_LABEL) {
                out.write((String)participantsString + "\n");
            }
            String idTemplate = "@ID:\t%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|";
            for (int i = 0; i < this.mainTierInfo[4].length; ++i) {
                if (!partTierInd.contains(i) || this.mainTierInfo[4][i] == null) continue;
                String curCode = this.mainTierInfo[4][i] == null || this.mainTierInfo[4][i].isEmpty() ? this.mainTierInfo[1][i].substring(1) : this.mainTierInfo[4][i];
                String curRole = this.mainTierInfo[3][i] == null || this.mainTierInfo[3][i].isEmpty() ? "Unidentified" : this.mainTierInfo[3][i];
                out.write(String.format(idTemplate, this.nonNull(this.mainTierInfo[5][i]), "", curCode, "", "", "", "", curRole, "", "") + "\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String nonNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private void writeBlocks(Transcription theTranscription, EncoderInfo encoderInfo, OutputStreamWriter out) {
        ArrayList<AbstractAnnotation> rootAnnotations = new ArrayList<AbstractAnnotation>();
        try {
            List<TierImpl> topTiers = ((TranscriptionImpl)theTranscription).getTopTiers();
            for (TierImpl t : topTiers) {
                rootAnnotations.addAll(t.getAnnotations());
            }
            Collections.sort(rootAnnotations);
            for (Annotation annotation : rootAnnotations) {
                String blockString = this.getBlock(theTranscription, encoderInfo, annotation);
                out.write(blockString);
            }
        }
        catch (Exception rex) {
            rex.printStackTrace();
        }
    }

    private String getBlock(Transcription tr, EncoderInfo encoderInfo, Annotation ann) {
        boolean exportBlock = false;
        StringBuilder blockString = new StringBuilder("");
        String tierName = ann.getTier().getName();
        int tierIndex = -1;
        for (int i = 0; i < this.mainTierInfo[0].length; ++i) {
            if (this.mainTierInfo[0][i] == null || !this.mainTierInfo[0][i].equals(tierName)) continue;
            blockString.append(this.mainTierInfo[1][i] + ":\t" + ann.getValue().replaceAll("\t", "\n\t"));
            exportBlock = true;
            tierIndex = i;
            break;
        }
        if (!exportBlock) {
            return blockString.toString();
        }
        if (((AlignableAnnotation)ann).getBegin().isTimeAligned()) {
            this.lastAlignedBeginTime = ((AlignableAnnotation)ann).getBegin().getTime();
            if (((CHATEncoderInfo)encoderInfo).getCorrectAnnotationTimes()) {
                this.lastAlignedBeginTime += ((CHATEncoderInfo)encoderInfo).getMediaOffset();
            }
        }
        if (((AlignableAnnotation)ann).getEnd().isTimeAligned()) {
            long endTime = ann.getEndTimeBoundary();
            if (((CHATEncoderInfo)encoderInfo).getCorrectAnnotationTimes()) {
                endTime += ((CHATEncoderInfo)encoderInfo).getMediaOffset();
            }
            String mediaFileName = "";
            List<MediaDescriptor> mediaDescriptors = tr.getMediaDescriptors();
            String mediaLabel = SOUND_LABEL;
            if (mediaDescriptors != null && mediaDescriptors.size() > 0) {
                String mimeType;
                int index;
                mediaFileName = mediaDescriptors.get((int)0).mediaURL;
                mediaFileName = mediaFileName.substring(mediaFileName.lastIndexOf("/") + 1);
                if (!((CHATEncoderInfo)encoderInfo).isTimesOnSeparateLine() && (index = mediaFileName.indexOf(46)) > 0) {
                    mediaFileName = mediaFileName.substring(0, index);
                }
                if ((mimeType = mediaDescriptors.get((int)0).mimeType).startsWith("video")) {
                    mediaLabel = VIDEO_LABEL;
                }
                if (((CHATEncoderInfo)encoderInfo).isTimesOnSeparateLine()) {
                    blockString.append("\n\u0015" + mediaLabel + "\t\"" + mediaFileName + "\" " + this.lastAlignedBeginTime + " " + endTime + "\u0015\n");
                } else {
                    blockString.append(" \u0015" + mediaLabel + "\"" + mediaFileName + "\"_" + this.lastAlignedBeginTime + "_" + endTime + "\u0015\n");
                }
            }
        }
        if (((CHATEncoderInfo)encoderInfo).isIncludeLangLine() && tierIndex > -1 && this.mainTierInfo[5][tierIndex] != null && this.mainTierInfo[5][tierIndex].length() > 0) {
            blockString.append(LANG_LABEL + "\t$");
            blockString.append(this.mainTierInfo[5][tierIndex] + "\n");
        }
        HashMap<Tier, List<Annotation>> annotsPerTier = new HashMap<Tier, List<Annotation>>();
        ArrayList<Tier> tierOrder = new ArrayList<Tier>();
        this.getDependentLines(ann, tr, annotsPerTier, tierOrder);
        for (int i = 0; i < tierOrder.size(); ++i) {
            Tier t = (Tier)tierOrder.get(i);
            List annots = (List)annotsPerTier.get(t);
            boolean exportTier = false;
            if (annots == null) continue;
            Collections.sort(annots);
            for (int j = 0; j < this.dependentTierInfo[0].length; ++j) {
                if (this.dependentTierInfo[0][j] == null || !this.dependentTierInfo[0][j].equals(t.getName())) continue;
                blockString.append(this.dependentTierInfo[1][j] + ":\t");
                exportTier = true;
                break;
            }
            if (!exportTier) continue;
            for (int k = 0; k < annots.size(); ++k) {
                if (k != 0) {
                    blockString.append(" ");
                }
                blockString.append(((Annotation)annots.get(k)).getValue().replaceAll("\t", "\n\t"));
            }
            blockString.append("\n");
        }
        return blockString.toString();
    }

    private void getDependentLines(Annotation ann, Transcription tr, Map<Tier, List<Annotation>> annotsPerTier, List<Tier> tierOrder) {
        List<? extends Annotation> childAnnots = tr.getChildAnnotationsOf(ann);
        List<Annotation> annots = null;
        for (Annotation annotation : childAnnots) {
            annots = annotsPerTier.get(annotation.getTier());
            if (annots == null) {
                annots = new ArrayList<Annotation>();
                annotsPerTier.put(annotation.getTier(), annots);
                tierOrder.add(annotation.getTier());
            }
            annots.add(annotation);
            this.getDependentLines(annotation, tr, annotsPerTier, tierOrder);
        }
    }
}

