/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.chat;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

public class CHATParser
extends Parser {
    private static final String MAIN_TYPE = "orthography";
    private static final char TIER_NAME_SEPARATOR = '@';
    private static final String TS_ID_PREFIX = "ts";
    private final char BULLET = (char)21;
    private final String MEDIA_HEADER = "@Media";
    private final String PARTICIPANTS_HEADER = "@Participants";
    private final String AT = "@";
    private final String PERC = "%";
    private final String AST = "*";
    private final String COLON = ":";
    private final String SND = "%snd";
    private final String MOV = "%mov";
    private String participantLine = null;
    private String mediaFileName = null;
    private ArrayList<ArrayList<String[]>> chatBlocks = new ArrayList();
    private ArrayList<Integer> blocksWithTime = new ArrayList();
    private ArrayList<LingTypeRecord> lingTypeRecords = new ArrayList();
    private ArrayList<String> tierNames = new ArrayList();
    private HashMap<String, String> parentHash = new HashMap();
    private ArrayList<long[]> timeOrder = new ArrayList();
    private ArrayList<long[]> timeSlots = new ArrayList();
    private ArrayList<AnnotationRecord> annotationRecords = new ArrayList();
    private HashMap<AnnotationRecord, String> annotRecordToTierMap = new HashMap();
    private String lastParsed = "";
    private BufferedReader br;

    public ArrayList<MediaDescriptor> getMediaDescriptors(String fileName) {
        ArrayList<MediaDescriptor> mediaDescriptors = new ArrayList<MediaDescriptor>();
        this.parse(fileName);
        String mediaURL = null;
        if (this.mediaFileName != null) {
            mediaURL = this.pathToURLString(this.mediaFileName);
            String mimeType = "unknown";
            String lower = this.mediaFileName.toLowerCase();
            if (lower.endsWith(".wav")) {
                mimeType = "audio/x-wav";
            } else if (lower.endsWith(".mov")) {
                mimeType = "video/quicktime";
            } else if (lower.endsWith(".mp4")) {
                mimeType = "video/mp4";
            }
            MediaDescriptor md = new MediaDescriptor(mediaURL, mimeType);
            mediaDescriptors.add(md);
        }
        return mediaDescriptors;
    }

    public ArrayList<LingTypeRecord> getLinguisticTypes(String fileName) {
        this.parse(fileName);
        if (this.lingTypeRecords.size() != 0) {
            return this.lingTypeRecords;
        }
        HashSet<String> labels = new HashSet<String>();
        for (ArrayList<String[]> block : this.chatBlocks) {
            for (String[] line : block) {
                String lbl = line[0];
                if (lbl.equals("%snd") || lbl.length() > 1 && lbl.substring(1).startsWith("%")) continue;
                labels.add(lbl);
            }
        }
        LingTypeRecord orthoType = new LingTypeRecord();
        orthoType.setLingTypeId(MAIN_TYPE);
        orthoType.setTimeAlignable("true");
        this.lingTypeRecords.add(orthoType);
        for (String label : labels) {
            if (label.startsWith("*")) continue;
            LingTypeRecord lt = new LingTypeRecord();
            lt.setLingTypeId(label);
            lt.setTimeAlignable("false");
            lt.setStereoType(Constraint.stereoTypes[4]);
            this.lingTypeRecords.add(lt);
        }
        return this.lingTypeRecords;
    }

    public ArrayList<String> getTimeOrder(String fileName) {
        this.parse(fileName);
        ArrayList<long[]> unalignedSlots = new ArrayList<long[]>();
        long[] firstSlotAfter = this.firstTimeSlotAfter(null, unalignedSlots);
        if (firstSlotAfter == null) {
            this.timeOrder.addAll(unalignedSlots);
        }
        while (firstSlotAfter != null) {
            this.timeOrder.addAll(unalignedSlots);
            this.timeOrder.add(firstSlotAfter);
            unalignedSlots.clear();
            firstSlotAfter = this.firstTimeSlotAfter(firstSlotAfter, unalignedSlots);
        }
        long[] lastAddedSlot = this.timeOrder.get(this.timeOrder.size() - 1);
        if (this.timeSlots.indexOf(lastAddedSlot) != this.timeSlots.size() - 1) {
            for (int i = this.timeSlots.indexOf(lastAddedSlot); i < this.timeSlots.size(); ++i) {
                this.timeOrder.add(this.timeSlots.get(i));
                if (i != this.timeSlots.size() - 1) continue;
                this.timeSlots.get((int)i)[1] = lastAddedSlot[1] + 1000L;
            }
        }
        ArrayList<String> resultTimeOrder = new ArrayList<String>();
        for (int i = 0; i < this.timeOrder.size(); ++i) {
            resultTimeOrder.add(TS_ID_PREFIX + this.timeOrder.get(i)[0]);
        }
        return resultTimeOrder;
    }

    private long[] firstTimeSlotAfter(long[] afterTimeSlot, ArrayList<long[]> unalignedSlots) {
        long[] firstSlot = null;
        long firstTimeAfter = Long.MAX_VALUE;
        ArrayList<long[]> unalignedStore = new ArrayList<long[]>();
        long afterTime = 0L;
        long afterTimeId = -1L;
        if (afterTimeSlot != null) {
            afterTime = afterTimeSlot[1];
            afterTimeId = afterTimeSlot[0];
        }
        for (long[] ts : this.timeSlots) {
            long time = ts[1];
            if (time < 0L) {
                unalignedStore.add(ts);
                continue;
            }
            if (time >= afterTime && time < firstTimeAfter && ts[0] != afterTimeId && !this.timeOrder.contains(ts)) {
                firstTimeAfter = time;
                firstSlot = ts;
                unalignedSlots.clear();
                unalignedSlots.addAll(unalignedStore);
                unalignedStore.clear();
                continue;
            }
            if (time <= 0L) continue;
            unalignedStore.clear();
        }
        if (firstSlot == null) {
            unalignedSlots.addAll(unalignedStore);
        }
        return firstSlot;
    }

    public HashMap<String, String> getTimeSlots(String fileName) {
        this.parse(fileName);
        HashMap<String, String> resultSlots = new HashMap<String, String>();
        for (long[] timeSlot : this.timeSlots) {
            String tsId = TS_ID_PREFIX + timeSlot[0];
            String timeValue = Long.toString(timeSlot[1]);
            resultSlots.put(tsId, timeValue);
        }
        return resultSlots;
    }

    public ArrayList<String> getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        String participant = "";
        if (tierName.startsWith("*")) {
            participant = tierName.substring(1);
        } else {
            int i = tierName.indexOf(64);
            if (i > 0 && tierName.length() > i + 2) {
                participant = tierName.substring(i + 1);
            }
        }
        return participant;
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        String lingTypeId = "";
        if (tierName.startsWith("*")) {
            lingTypeId = MAIN_TYPE;
        } else {
            int i = tierName.indexOf(64);
            if (i > 0) {
                lingTypeId = tierName.substring(0, i);
            }
        }
        return lingTypeId;
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        return this.parentHash.get(tierName);
    }

    public ArrayList<AnnotationRecord> getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        ArrayList<AnnotationRecord> resultAnnotRecords = new ArrayList<AnnotationRecord>();
        for (AnnotationRecord annRec : this.annotRecordToTierMap.keySet()) {
            if (!this.annotRecordToTierMap.get(annRec).equals(tierName)) continue;
            resultAnnotRecords.add(annRec);
        }
        return resultAnnotRecords;
    }

    private void parse(String fileName) {
        if (this.lastParsed.equals(fileName)) {
            return;
        }
        this.participantLine = null;
        this.mediaFileName = null;
        this.chatBlocks.clear();
        this.lingTypeRecords.clear();
        this.tierNames.clear();
        this.parentHash.clear();
        this.timeOrder.clear();
        this.timeSlots.clear();
        this.annotationRecords.clear();
        this.annotRecordToTierMap.clear();
        this.br = null;
        this.lastParsed = fileName;
        try {
            this.br = new BufferedReader(new FileReader(fileName));
        }
        catch (Exception fnf) {
            fnf.printStackTrace();
        }
        String line = null;
        try {
            line = this.br.readLine();
            if (line != null && line.startsWith("@UTF8")) {
                this.br.close();
                this.br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        this.parseLines();
        this.processBlocks();
        try {
            this.br.close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    private void parseLines() {
        String line = null;
        Object outputLine = "";
        boolean recordingParticipant = false;
        boolean containsMediaTime = false;
        int numBlocks = 0;
        ArrayList<String[]> chatBlock = null;
        try {
            while ((line = this.br.readLine()) != null) {
                if (line.startsWith("@Participants")) {
                    recordingParticipant = true;
                    this.participantLine = line;
                } else if (recordingParticipant) {
                    if (!(line.startsWith("@") || line.startsWith("*") || line.startsWith("%"))) {
                        this.participantLine = this.participantLine + line;
                    } else {
                        recordingParticipant = false;
                    }
                }
                if (line.startsWith("@Media")) {
                    this.mediaFileName = this.extractMediaFromHeader(line);
                    continue;
                }
                if (line.startsWith("*")) {
                    if (!((String)outputLine).equals("") && chatBlock != null) {
                        this.addLineToBlock((String)outputLine, chatBlock);
                    }
                    if (chatBlock != null) {
                        this.chatBlocks.add(chatBlock);
                        if (containsMediaTime) {
                            this.blocksWithTime.add(numBlocks);
                        }
                        ++numBlocks;
                    }
                    chatBlock = new ArrayList<String[]>();
                    containsMediaTime = false;
                    if (this.containsMediaTime(line)) {
                        containsMediaTime = true;
                    }
                    outputLine = line;
                    continue;
                }
                if (line.startsWith("%") || line.length() > 1 && line.substring(1).startsWith("%")) {
                    if (!((String)outputLine).equals("") && chatBlock != null) {
                        this.addLineToBlock((String)outputLine, chatBlock);
                    }
                    outputLine = line;
                    if (this.mediaFileName == null && this.startsWithMediaLabel(line)) {
                        containsMediaTime = true;
                        StringTokenizer st = new StringTokenizer(line);
                        if (st.hasMoreTokens()) {
                            st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            this.mediaFileName = st.nextToken();
                        }
                        if (this.mediaFileName.startsWith("\"")) {
                            this.mediaFileName = this.mediaFileName.substring(1);
                        }
                        if (!this.mediaFileName.endsWith("\"")) continue;
                        this.mediaFileName = this.mediaFileName.substring(0, this.mediaFileName.length() - 1);
                        continue;
                    }
                    if (!this.startsWithMediaLabel(line)) continue;
                    containsMediaTime = true;
                    continue;
                }
                if (line.startsWith("@") || !this.containsMediaTime((String)(outputLine = (String)outputLine + line.replace('\t', ' ')))) continue;
                containsMediaTime = true;
            }
            if (!((String)outputLine).equals("") && chatBlock != null) {
                this.addLineToBlock((String)outputLine, chatBlock);
            }
            if (chatBlock != null) {
                this.chatBlocks.add(chatBlock);
                if (containsMediaTime) {
                    this.blocksWithTime.add(numBlocks);
                }
            }
        }
        catch (FileNotFoundException fex) {
            fex.printStackTrace();
        }
        catch (IOException iex) {
            iex.printStackTrace();
        }
    }

    private void addLineToBlock(String theLine, ArrayList<String[]> theBlock) {
        String label = null;
        String value = null;
        label = this.getLabelPart(theLine);
        value = this.getValuePart(theLine);
        if (label != null && value != null) {
            String[] line = new String[]{label, value};
            theBlock.add(line);
        } else if (label != null && value == null) {
            String[] line = new String[]{label, ""};
            theBlock.add(line);
        }
    }

    private String getLabelPart(String theLine) {
        String label = null;
        int index = theLine.indexOf(":");
        if (index > 0) {
            label = theLine.substring(0, index);
        }
        return label;
    }

    private String getValuePart(String theLine) {
        String value = null;
        int index = theLine.indexOf(":");
        if (index < theLine.length() - 2) {
            value = theLine.substring(index + 1).trim();
        }
        return value;
    }

    private void processBlocks() {
        HashSet<String> tNames = new HashSet<String>();
        String annotationIdPrefix = "ann";
        long annotId = 0L;
        long tsId = 0L;
        HashMap<String, Long> lastEndTimes = new HashMap<String, Long>();
        int blockIndex = 0;
        int numBlocksForSegment = 1;
        boolean hasTime = false;
        long interpol = 0L;
        long blockDur = 0L;
        Iterator<ArrayList<String[]>> blockIter = this.chatBlocks.iterator();
        while (blockIter.hasNext()) {
            String participantLabel = "";
            Object tierName = null;
            String[] mediaLine = null;
            int bi = this.blocksWithTime.indexOf(blockIndex);
            if (bi > -1) {
                hasTime = true;
                blockDur = 0L;
                if (bi < this.blocksWithTime.size() - 1) {
                    int nextWith = this.blocksWithTime.get(bi + 1);
                    numBlocksForSegment = nextWith - blockIndex;
                } else if (blockIndex < this.chatBlocks.size() - 1) {
                    numBlocksForSegment = this.chatBlocks.size() - 1 - blockIndex;
                }
            } else {
                hasTime = false;
            }
            Object rootAnnotId = "";
            long beginTSId = 0L;
            long endTSId = 0L;
            long begin = -1L;
            long end = -1L;
            ArrayList<String[]> block = blockIter.next();
            for (String[] line : block) {
                AnnotationRecord annRec;
                String lbl = line[0];
                String value = line[1];
                if (lbl.startsWith("*")) {
                    participantLabel = lbl;
                    tierName = lbl;
                } else if (!this.startsWithMediaLabel(lbl)) {
                    tierName = lbl + participantLabel.replace('*', '@');
                    this.parentHash.put((String)tierName, participantLabel);
                }
                tNames.add((String)tierName);
                if (lbl.startsWith("*")) {
                    annRec = new AnnotationRecord();
                    rootAnnotId = annotationIdPrefix + annotId;
                    annRec.setAnnotationId(annotationIdPrefix + annotId++);
                    annRec.setAnnotationType("alignable");
                    ++tsId;
                    ++tsId;
                    annRec.setBeginTimeSlotId(TS_ID_PREFIX + Long.toString(beginTSId));
                    annRec.setEndTimeSlotId(TS_ID_PREFIX + Long.toString(endTSId));
                    if (hasTime) {
                        int index = value.indexOf(21);
                        if (index == -1) {
                            index = value.indexOf("%mov");
                        }
                        if (index == -1) {
                            index = value.indexOf("%snd");
                        }
                        if (index > -1) {
                            mediaLine = this.extractMediaAndTime(value.substring(index));
                            if (mediaLine != null) {
                                if (mediaLine[0] != null && this.startsWithMediaLabel(mediaLine[0]) && mediaLine[1] != null && this.mediaFileName == null) {
                                    this.mediaFileName = mediaLine[1];
                                }
                                if (mediaLine[2] != null) {
                                    try {
                                        begin = Long.parseLong(mediaLine[2]);
                                    }
                                    catch (NumberFormatException nfe) {
                                        System.out.println("Invalid time value: " + mediaLine[2]);
                                    }
                                }
                                if (mediaLine[3] != null) {
                                    try {
                                        end = Long.parseLong(mediaLine[3]);
                                    }
                                    catch (NumberFormatException nfe) {
                                        System.out.println("Invalid time value: " + mediaLine[3]);
                                    }
                                }
                            }
                            annRec.setValue(this.filterValue(value.substring(0, index)));
                        } else {
                            annRec.setValue(this.filterValue(value));
                        }
                    } else {
                        annRec.setValue(this.filterValue(value));
                    }
                    this.annotationRecords.add(annRec);
                    this.annotRecordToTierMap.put(annRec, (String)tierName);
                    continue;
                }
                if (hasTime && this.startsWithMediaLabel(lbl)) {
                    int positionOfDot;
                    String timeString = value;
                    if (timeString == null) continue;
                    StringTokenizer st = new StringTokenizer(timeString);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        String bString = st.nextToken();
                        positionOfDot = bString.indexOf(".");
                        if (positionOfDot > 0) {
                            bString = bString.substring(0, positionOfDot);
                        }
                        begin = Long.parseLong(bString);
                    }
                    if (!st.hasMoreTokens()) continue;
                    String eString = st.nextToken();
                    positionOfDot = eString.indexOf(".");
                    if (positionOfDot > 0) {
                        eString = eString.substring(0, positionOfDot);
                    }
                    end = Long.parseLong(eString);
                    continue;
                }
                annRec = new AnnotationRecord();
                annRec.setAnnotationId(annotationIdPrefix + annotId++);
                annRec.setAnnotationType("reference");
                annRec.setReferredAnnotId((String)rootAnnotId);
                annRec.setValue(this.filterValue(value));
                this.annotationRecords.add(annRec);
                this.annotRecordToTierMap.put(annRec, (String)tierName);
            }
            long beginMsec = -1L;
            long endMsec = -1L;
            if (hasTime) {
                beginMsec = begin;
                long lastEnd = 0L;
                if (lastEndTimes.get(participantLabel) != null) {
                    lastEnd = (Long)lastEndTimes.get(participantLabel);
                }
                if (lastEnd > beginMsec) {
                    beginMsec = lastEnd;
                }
                if ((blockDur = (end - begin) / (long)numBlocksForSegment) <= 0L) {
                    System.out.println("Overlapping annotations on a tier: " + (String)tierName + " at: " + begin);
                }
                interpol = endMsec = beginMsec + blockDur;
                if (end > beginMsec) {
                    lastEndTimes.put(participantLabel, new Long(endMsec));
                }
            } else if (interpol > 0L) {
                beginMsec = interpol;
                interpol = endMsec = beginMsec + blockDur;
            }
            long[] bSlot = new long[]{beginTSId, beginMsec};
            long[] eSlot = new long[]{endTSId, endMsec};
            this.timeSlots.add(bSlot);
            this.timeSlots.add(eSlot);
            ++blockIndex;
        }
        this.tierNames = new ArrayList(tNames);
    }

    private boolean startsWithMediaLabel(String line) {
        boolean start = false;
        if (line.startsWith("%snd") || line.startsWith("%mov")) {
            start = true;
        }
        if (line.startsWith("\u0015%snd") || line.startsWith("\u0015%mov")) {
            start = true;
        }
        return start;
    }

    private boolean containsMediaTime(String line) {
        if (line == null || line.length() == 0) {
            return false;
        }
        if (line.indexOf("%snd") > -1) {
            return true;
        }
        if (line.indexOf("%mov") > -1) {
            return true;
        }
        return line.indexOf(21) > -1;
    }

    private String[] extractMediaAndTime(String value) {
        int under2;
        int under;
        if (value == null) {
            return null;
        }
        String[] result = new String[4];
        StringBuilder buf = new StringBuilder(value);
        if (buf.charAt(0) == '\u0015') {
            buf.delete(0, 1);
        }
        if (buf.charAt(buf.length() - 1) == '\u0015') {
            buf.delete(buf.length() - 1, buf.length());
        }
        int colon = buf.indexOf(":");
        int quot = buf.indexOf("\"");
        int quot2 = buf.lastIndexOf("\"");
        if (colon > -1) {
            result[0] = buf.substring(0, colon);
        }
        if (quot > -1 && quot2 > quot + 1) {
            result[1] = buf.substring(quot + 1, quot2);
            under = buf.indexOf("_", quot2);
            under2 = buf.indexOf("_", under + 1);
            if (under > -1) {
                if (under2 > under + 1) {
                    result[2] = buf.substring(under + 1, under2);
                    if (under2 < buf.length() - 1) {
                        result[3] = buf.substring(under2 + 1);
                    }
                } else {
                    result[2] = buf.substring(under + 1);
                }
            }
        }
        if (colon < 0 && quot < 0 && (under = buf.indexOf("_")) > -1 && under < buf.length() - 1 && (under2 = buf.indexOf("_", under + 1)) < 0) {
            result[2] = buf.substring(0, under);
            result[3] = buf.substring(under + 1);
        }
        return result;
    }

    private String pathToURLString(String path) {
        path = path.replace('\\', '/');
        int n = 0;
        while (path.charAt(0) == '/') {
            path = path.substring(1);
            ++n;
        }
        if (n == 2) {
            return "file://" + path;
        }
        return "file:///" + path;
    }

    private String filterValue(String value) {
        char[] ch;
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuilder b = new StringBuilder(value.length());
        for (char c : ch = value.toCharArray()) {
            if (c >= ' ') {
                b.append(c);
                continue;
            }
            System.out.println("Illegal char in CHAT content: " + Integer.toHexString(c));
        }
        return b.toString();
    }

    private String extractMediaFromHeader(String line) {
        if (line == null) {
            return null;
        }
        if (!line.startsWith("@Media")) {
            return null;
        }
        int colonIndex = line.indexOf(58);
        if (colonIndex > -1 && colonIndex < line.length() - 1) {
            String medString = line.substring(colonIndex + 1);
            int commaIndex = medString.indexOf(44);
            if (commaIndex > -1) {
                return medString.substring(0, commaIndex).trim();
            }
            return medString.trim();
        }
        return null;
    }
}

