/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.delimitedtext;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextReader;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecordComparator;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TimeSlotRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TimeSlotRecordComparator;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.TimeFormatter;

public class DelimitedTextParser
extends Parser
implements ServerLogger {
    private DelimitedTextDecoderInfo decoderInfo;
    private DelimitedTextReader reader;
    private String lastParsedFile;
    private final String TS_ID_PREFIX = "ts";
    private final String ANN_PREFIX = "a";
    private final String TYPE_NAME = "imported-sep";
    private ArrayList<LingTypeRecord> lingTypeRecords = new ArrayList();
    private ArrayList<String> tierNames = new ArrayList();
    private ArrayList<String> timeOrder = new ArrayList();
    private ArrayList<TimeSlotRecord> timeSlots = new ArrayList();
    private HashMap<String, ArrayList<AnnotationRecord>> recordsPerTier = new HashMap();

    public DelimitedTextParser() {
    }

    public DelimitedTextParser(DelimitedTextDecoderInfo decoderInfo) {
        this.decoderInfo = decoderInfo;
        this.parse(decoderInfo.getSourceFilePath());
    }

    public void parse(String fileName) {
        if (fileName == null || fileName.equals(this.lastParsedFile)) {
            return;
        }
        this.lingTypeRecords.clear();
        this.tierNames.clear();
        this.timeOrder.clear();
        this.timeSlots.clear();
        this.recordsPerTier.clear();
        try {
            this.reader = new DelimitedTextReader(fileName);
            if (this.decoderInfo != null) {
                this.reader.setDelimiter(this.decoderInfo.getDelimiter());
                if (this.decoderInfo.isSingleAnnotationPerRow()) {
                    this.parseSingleAnnColumn();
                    this.sortTimeSlots();
                } else {
                    this.parseMultiAnnColumns();
                    this.sortTimeSlots();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.warning("The file is not found: " + fileName);
            return;
        }
        this.lastParsedFile = fileName;
    }

    /*
     * WARNING - void declaration
     */
    private void parseSingleAnnColumn() {
        int[] annColumn = this.decoderInfo.getAnnotationColumns();
        int annIndex = -1;
        if (annColumn != null && annColumn.length >= 1) {
            annIndex = annColumn[0];
        }
        int tierIndex = this.decoderInfo.getTierColumnIndex();
        int btIndex = this.decoderInfo.getBeginTimeColumn();
        int etIndex = this.decoderInfo.getEndTimeColumn();
        int durIndex = this.decoderInfo.getDurationColumn();
        TimeFormatter.TIME_FORMAT btFormat = this.decoderInfo.getTimeFormat(btIndex);
        TimeFormatter.TIME_FORMAT etFormat = this.decoderInfo.getTimeFormat(etIndex);
        TimeFormatter.TIME_FORMAT durFormat = this.decoderInfo.getTimeFormat(durIndex);
        int[] inclColumns = this.decoderInfo.getIncludedColumns();
        Map<Integer, String> colToTierName = this.decoderInfo.getColumnsWithTierNames();
        String defTier = "Tier-1";
        if (annIndex > -1 && colToTierName != null) {
            for (Integer keyInt : colToTierName.keySet()) {
                String tName;
                if (keyInt != annIndex || (tName = colToTierName.get(keyInt)) == null) continue;
                defTier = tName;
            }
        }
        for (int i = 0; i < inclColumns.length; ++i) {
            if (inclColumns[i] == annIndex) {
                annIndex = i;
                continue;
            }
            if (inclColumns[i] == tierIndex) {
                tierIndex = i;
                continue;
            }
            if (inclColumns[i] == btIndex) {
                btIndex = i;
                continue;
            }
            if (inclColumns[i] == etIndex) {
                etIndex = i;
                continue;
            }
            if (inclColumns[i] != durIndex) continue;
            durIndex = i;
        }
        try {
            List<String[]> rows = this.reader.getRowDataForColumns(this.decoderInfo.getFirstRowIndex(), inclColumns);
            String curTier = defTier;
            int tsCount = 1;
            boolean bl = true;
            for (int i = 0; i < rows.size(); ++i) {
                void var16_23;
                String[] row = rows.get(i);
                long bt = -1L;
                long et = -1L;
                long dur = -1L;
                if (btIndex > -1 && btIndex < row.length) {
                    bt = TimeFormatter.toMilliSeconds(row[btIndex], btFormat);
                }
                if (etIndex > -1 && etIndex < row.length) {
                    et = TimeFormatter.toMilliSeconds(row[etIndex], etFormat);
                } else if (durIndex > -1 && durIndex < row.length) {
                    dur = TimeFormatter.toMilliSeconds(row[durIndex], durFormat);
                    et = dur == -1L || bt == -1L ? -1L : bt + dur;
                }
                String ann = "";
                if (annIndex > -1 && annIndex < row.length) {
                    ann = row[annIndex];
                }
                if (tierIndex > -1 && tierIndex < row.length) {
                    curTier = row[tierIndex];
                    if (curTier.length() == 0) {
                        curTier = defTier;
                    }
                } else {
                    curTier = defTier;
                }
                if (!this.tierNames.contains(curTier)) {
                    this.tierNames.add(curTier);
                    this.recordsPerTier.put(curTier, new ArrayList());
                }
                if (this.decoderInfo.isSkipEmptyCells() && ann.length() == 0) continue;
                AnnotationRecord annRec = new AnnotationRecord();
                annRec.setAnnotationType("alignable");
                annRec.setValue(ann);
                annRec.setAnnotationId("a" + (int)(++var16_23));
                TimeSlotRecord tsRec = new TimeSlotRecord(tsCount++, bt);
                annRec.setBeginTimeSlotRecord(tsRec);
                this.timeSlots.add(tsRec);
                tsRec = new TimeSlotRecord(tsCount++, et);
                annRec.setEndTimeSlotRecord(tsRec);
                this.timeSlots.add(tsRec);
                this.recordsPerTier.get(curTier).add(annRec);
            }
        }
        catch (IOException ioe) {
            LOG.severe("Error retrieving rowdata: " + ioe.getMessage());
        }
        Iterator<ArrayList<AnnotationRecord>> valIt = this.recordsPerTier.values().iterator();
        AnnotationRecordComparator comp = new AnnotationRecordComparator(true);
        while (valIt.hasNext()) {
            List records = valIt.next();
            Collections.sort(records, comp);
        }
        for (String string : this.recordsPerTier.keySet()) {
            List records = this.recordsPerTier.get(string);
            this.calculateUnalignedSlots(records);
        }
        for (List list : this.recordsPerTier.values()) {
            this.correctOverlaps(list);
        }
    }

    private void parseMultiAnnColumns() {
        int[] inclColumns = this.decoderInfo.getIncludedColumns();
        Map<Integer, String> orgColsToTierName = this.decoderInfo.getColumnsWithTierNames();
        HashMap<Integer, String> colsToTierName = new HashMap<Integer, String>(orgColsToTierName.size());
        int btIndex = this.decoderInfo.getBeginTimeColumn();
        int etIndex = this.decoderInfo.getEndTimeColumn();
        int durIndex = this.decoderInfo.getDurationColumn();
        TimeFormatter.TIME_FORMAT btFormat = this.decoderInfo.getTimeFormat(btIndex);
        TimeFormatter.TIME_FORMAT etFormat = this.decoderInfo.getTimeFormat(etIndex);
        TimeFormatter.TIME_FORMAT durFormat = this.decoderInfo.getTimeFormat(durIndex);
        for (Integer colIndex : orgColsToTierName.keySet()) {
            for (int i = 0; i < inclColumns.length; ++i) {
                if (inclColumns[i] != colIndex) continue;
                String tierName = orgColsToTierName.get(colIndex);
                colsToTierName.put(i, tierName);
                if (this.tierNames.contains(tierName)) continue;
                this.tierNames.add(tierName);
                this.recordsPerTier.put(tierName, new ArrayList());
            }
        }
        Integer[] tierCols = new Integer[colsToTierName.size()];
        Iterator<Integer> colIter = colsToTierName.keySet().iterator();
        int z = 0;
        while (colIter.hasNext()) {
            tierCols[z] = colIter.next();
            ++z;
        }
        for (int i = 0; i < inclColumns.length; ++i) {
            if (inclColumns[i] == btIndex) {
                btIndex = i;
                continue;
            }
            if (inclColumns[i] == etIndex) {
                etIndex = i;
                continue;
            }
            if (inclColumns[i] != durIndex) continue;
            durIndex = i;
        }
        HashMap slotToSlots = new HashMap();
        String refTier = null;
        try {
            List<String[]> rows = this.reader.getRowDataForColumns(this.decoderInfo.getFirstRowIndex(), inclColumns);
            int tsCount = 1;
            int annCount = 1;
            for (int i = 0; i < rows.size(); ++i) {
                long bt = -1L;
                long et = -1L;
                long dur = -1L;
                String[] row = rows.get(i);
                if (btIndex > -1 && btIndex < row.length) {
                    bt = TimeFormatter.toMilliSeconds(row[btIndex], btFormat);
                }
                if (etIndex > -1 && etIndex < row.length) {
                    et = TimeFormatter.toMilliSeconds(row[etIndex], etFormat);
                } else if (durIndex > -1 && durIndex < row.length) {
                    dur = TimeFormatter.toMilliSeconds(row[durIndex], durFormat);
                    et = dur == -1L || bt == -1L ? -1L : bt + dur;
                }
                TimeSlotRecord curRefBTTS = null;
                TimeSlotRecord curRefETTS = null;
                for (int j = 0; j < tierCols.length; ++j) {
                    String ann = "";
                    if (tierCols[j] > -1 && tierCols[j] < row.length) {
                        ann = row[tierCols[j]];
                    }
                    String curTier = (String)colsToTierName.get(tierCols[j]);
                    if (j == 0 && refTier == null) {
                        refTier = curTier;
                    }
                    AnnotationRecord annRec = new AnnotationRecord();
                    annRec.setAnnotationType("alignable");
                    annRec.setValue(ann);
                    annRec.setAnnotationId("a" + annCount++);
                    TimeSlotRecord tsRec = new TimeSlotRecord(tsCount++, bt);
                    annRec.setBeginTimeSlotRecord(tsRec);
                    this.timeSlots.add(tsRec);
                    tsRec = new TimeSlotRecord(tsCount++, et);
                    annRec.setEndTimeSlotRecord(tsRec);
                    this.timeSlots.add(tsRec);
                    this.recordsPerTier.get(curTier).add(annRec);
                    if (j == 0) {
                        curRefBTTS = annRec.getBeginTimeSlotRecord();
                        curRefETTS = annRec.getEndTimeSlotRecord();
                        slotToSlots.put(curRefBTTS, new ArrayList(5));
                        slotToSlots.put(curRefETTS, new ArrayList(5));
                        continue;
                    }
                    ((ArrayList)slotToSlots.get(curRefBTTS)).add(annRec.getBeginTimeSlotRecord());
                    ((ArrayList)slotToSlots.get(curRefETTS)).add(annRec.getEndTimeSlotRecord());
                }
            }
        }
        catch (IOException ioe) {
            LOG.severe("Error retrieving rowdata: " + ioe.getMessage());
        }
        if (!this.decoderInfo.isSkipEmptyCells()) {
            List records = this.recordsPerTier.get(refTier);
            Collections.sort(records, new AnnotationRecordComparator(true));
            this.calculateUnalignedSlots(records);
            this.correctOverlaps(records);
            for (TimeSlotRecord keyRec : slotToSlots.keySet()) {
                ArrayList refSlots = (ArrayList)slotToSlots.get(keyRec);
                for (int i = 0; i < refSlots.size(); ++i) {
                    TimeSlotRecord valRec = (TimeSlotRecord)refSlots.get(i);
                    valRec.setValue(keyRec.getValue());
                }
            }
        } else {
            AnnotationRecordComparator annRecComp = new AnnotationRecordComparator(true);
            for (int i = 0; i < this.tierNames.size(); ++i) {
                String tierNm = this.tierNames.get(i);
                List records = this.recordsPerTier.get(tierNm);
                this.removeEmptyRecords(records);
                Collections.sort(records, annRecComp);
                this.calculateUnalignedSlots(records);
                this.correctOverlaps(records);
            }
        }
    }

    private void sortTimeSlots() {
        if (this.timeSlots != null && this.timeSlots.size() > 1) {
            Collections.sort(this.timeSlots, new TimeSlotRecordComparator());
            for (int i = 0; i < this.timeSlots.size(); ++i) {
                TimeSlotRecord tsr = this.timeSlots.get(i);
                tsr.setId(i + 1);
            }
        }
    }

    private void calculateUnalignedSlots(List<AnnotationRecord> records) {
        if (records == null || records.size() == 0) {
            return;
        }
        long curAdv = 0L;
        for (int i = 0; i < records.size(); ++i) {
            AnnotationRecord annRec = records.get(i);
            TimeSlotRecord tsBRec = annRec.getBeginTimeSlotRecord();
            TimeSlotRecord tsERec = annRec.getEndTimeSlotRecord();
            if (tsBRec.getValue() < 0L) {
                if (i > 0) {
                    if (tsERec.getValue() < 0L) {
                        tsBRec.setValue(curAdv);
                    } else {
                        tsBRec.setValue(Math.max(curAdv, tsERec.getValue() - this.decoderInfo.getDefaultDuration()));
                    }
                } else {
                    tsBRec.setValue(0L);
                }
            } else {
                curAdv = Math.max(curAdv, tsBRec.getValue());
            }
            if (tsERec.getValue() < 0L) {
                int numUnalignedSlots = 1;
                long nextTime = 0L;
                for (int j = i + 1; j < records.size(); ++j) {
                    AnnotationRecord nextRec = records.get(j);
                    if (nextRec.getBeginTimeSlotRecord().getValue() >= 0L) {
                        nextTime = nextRec.getBeginTimeSlotRecord().getValue();
                        break;
                    }
                    if (nextRec.getEndTimeSlotRecord().getValue() < 0L) {
                        ++numUnalignedSlots;
                        continue;
                    }
                    nextTime = nextRec.getEndTimeSlotRecord().getValue();
                    break;
                }
                if (numUnalignedSlots > 0) {
                    if (nextTime == 0L) {
                        nextTime = curAdv + (long)numUnalignedSlots * this.decoderInfo.getDefaultDuration();
                    }
                    long avgDur = (nextTime - curAdv) / (long)numUnalignedSlots;
                    avgDur = Math.min(avgDur, this.decoderInfo.getDefaultDuration());
                    int j = i;
                    for (int k = 0; j < records.size() && k < numUnalignedSlots; ++j, ++k) {
                        AnnotationRecord nextRec = records.get(j);
                        if (k == 0) {
                            nextRec.getEndTimeSlotRecord().setValue(curAdv + avgDur);
                            continue;
                        }
                        if (nextRec.getBeginTimeSlotRecord().getValue() < 0L) {
                            nextRec.getBeginTimeSlotRecord().setValue(curAdv + avgDur * (long)k);
                        }
                        if (nextRec.getEndTimeSlotRecord().getValue() >= 0L) continue;
                        nextRec.getEndTimeSlotRecord().setValue(curAdv + avgDur * (long)(k + 1));
                    }
                    curAdv = nextTime;
                    i = j - 1;
                    continue;
                }
                tsERec.setValue(Math.min(nextTime, curAdv + this.decoderInfo.getDefaultDuration()));
                curAdv = tsERec.getValue();
                continue;
            }
            curAdv = tsERec.getValue();
        }
    }

    private void correctOverlaps(List<AnnotationRecord> annRecords) {
        for (int i = 0; i < annRecords.size() - 1; ++i) {
            AnnotationRecord annRec = annRecords.get(i);
            AnnotationRecord nextRec = annRecords.get(i + 1);
            TimeSlotRecord tsERec = annRec.getEndTimeSlotRecord();
            TimeSlotRecord tsBRec = nextRec.getBeginTimeSlotRecord();
            if (tsERec.getValue() <= tsBRec.getValue()) continue;
            tsERec.setValue(tsBRec.getValue());
        }
    }

    private void removeEmptyRecords(List<AnnotationRecord> annRecords) {
        for (int i = annRecords.size() - 1; i >= 0; --i) {
            AnnotationRecord annRec = annRecords.get(i);
            if (annRec.getValue() != null && annRec.getValue().length() != 0) continue;
            annRecords.remove(i);
            this.timeSlots.remove(annRec.getBeginTimeSlotRecord());
            this.timeSlots.remove(annRec.getEndTimeSlotRecord());
        }
    }

    public ArrayList<MediaDescriptor> getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return new ArrayList<MediaDescriptor>();
    }

    public ArrayList<LingTypeRecord> getLinguisticTypes(String fileName) {
        this.parse(fileName);
        if (this.lingTypeRecords.size() == 0) {
            LingTypeRecord lt = new LingTypeRecord();
            lt.setLingTypeId("imported-sep");
            lt.setTimeAlignable("true");
            this.lingTypeRecords.add(lt);
        }
        return this.lingTypeRecords;
    }

    public ArrayList<String> getTimeOrder(String fileName) {
        this.parse(fileName);
        this.timeOrder.clear();
        for (int i = 0; i < this.timeSlots.size(); ++i) {
            TimeSlotRecord tsr = this.timeSlots.get(i);
            this.timeOrder.add("ts" + tsr.getId());
        }
        return this.timeOrder;
    }

    public HashMap<String, String> getTimeSlots(String fileName) {
        this.parse(fileName);
        HashMap<String, String> tsMap = new HashMap<String, String>(this.timeSlots.size());
        for (int i = 0; i < this.timeSlots.size(); ++i) {
            TimeSlotRecord tsr = this.timeSlots.get(i);
            tsMap.put("ts" + tsr.getId(), Long.toString(tsr.getValue()));
        }
        return tsMap;
    }

    public ArrayList<String> getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        return null;
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        return "imported-sep";
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        return null;
    }

    public ArrayList<AnnotationRecord> getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        ArrayList<AnnotationRecord> records = this.recordsPerTier.get(tierName);
        if (records != null) {
            return records;
        }
        return new ArrayList<AnnotationRecord>();
    }

    @Override
    public void setDecoderInfo(DecoderInfo decoderInfo) {
        if (decoderInfo instanceof DelimitedTextDecoderInfo) {
            this.decoderInfo = (DelimitedTextDecoderInfo)decoderInfo;
        }
    }
}

