/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.ParserFactory;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeOrderImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotComparator;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.chat.CHATEncoder;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVEntryRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF26Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.flex.FlexDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxEncoder;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo2;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class ACM26TranscriptionStore
implements TranscriptionStore,
ServerLogger {
    public File fileToWriteXMLinto = null;
    public boolean debug = false;
    private boolean concatenateAfterParse = false;

    @Override
    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, int format) throws IOException {
        if (theTranscription instanceof TranscriptionImpl) {
            Object pathName = ((TranscriptionImpl)theTranscription).getPathName();
            if (!((String)pathName).substring(((String)pathName).length() - 4, ((String)pathName).length() - 3).equals(".")) {
                pathName = (String)pathName + ".eaf";
            } else {
                pathName = ((String)pathName).substring(0, ((String)pathName).length() - 3);
                pathName = (String)pathName + "eaf";
            }
            this.storeTranscriptionIn(theTranscription, encoderInfo, tierOrder, (String)pathName, format);
        }
    }

    @Override
    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String pathName, int format) throws IOException {
        if (theTranscription instanceof TranscriptionImpl) {
            if (!((String)pathName).substring(((String)pathName).length() - 4, ((String)pathName).length() - 3).equals(".")) {
                pathName = (String)pathName + ".eaf";
            } else {
                pathName = ((String)pathName).substring(0, ((String)pathName).length() - 3);
                pathName = (String)pathName + "eaf";
            }
            this.storeTranscriptionIn(theTranscription, encoderInfo, tierOrder, (String)pathName, format);
        }
    }

    @Override
    public void storeTranscriptionIn(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String path, int format) throws IOException {
        switch (format) {
            case 0: {
                if (this.fileToWriteXMLinto != null) {
                    path = this.fileToWriteXMLinto.getAbsolutePath();
                }
                new EAF26Encoder().encodeAndSave(theTranscription, (EncoderInfo)null, (List)tierOrder, path);
                break;
            }
            case 1: {
                new CHATEncoder().encodeAndSave(theTranscription, encoderInfo, tierOrder, path);
                break;
            }
            case 2: {
                new ShoeboxEncoder(path).encodeAndSave(theTranscription, encoderInfo, tierOrder, path);
                break;
            }
        }
    }

    public void storeTranscriptionAsTemplateIn(Transcription theTranscription, List tierOrder, String path) throws IOException {
        if (this.fileToWriteXMLinto != null) {
            path = this.fileToWriteXMLinto.getAbsolutePath();
        }
        new EAF26Encoder().encodeAsTemplateAndSave(theTranscription, tierOrder, path);
    }

    @Override
    public void loadTranscription(Transcription theTranscription) {
        this.loadTranscription(theTranscription, null);
    }

    @Override
    public void loadTranscription(Transcription theTranscription, DecoderInfo decoderInfo) {
        Map<String, CVRecord> cvTable;
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        String trPathName = attisTr.getPathName();
        String lowerPathName = trPathName.toLowerCase();
        Parser parser = null;
        if (lowerPathName.endsWith("cha")) {
            parser = ParserFactory.getParser(1);
        } else if (decoderInfo instanceof DelimitedTextDecoderInfo) {
            parser = ParserFactory.getParser(10);
            parser.setDecoderInfo(decoderInfo);
        } else if ((lowerPathName.endsWith("txt") || lowerPathName.endsWith("sht") || lowerPathName.endsWith("tbt")) && decoderInfo instanceof ToolboxDecoderInfo2) {
            parser = ParserFactory.getParser(12);
            parser.setDecoderInfo(decoderInfo);
            this.concatenateAfterParse = true;
        } else if (lowerPathName.endsWith("txt") || lowerPathName.endsWith("sht") || lowerPathName.endsWith("tbt")) {
            parser = ParserFactory.getParser(2);
            parser.setDecoderInfo(decoderInfo);
            this.concatenateAfterParse = true;
        } else if (lowerPathName.endsWith("trs")) {
            parser = ParserFactory.getParser(3);
            parser.setDecoderInfo(decoderInfo);
        } else if (decoderInfo instanceof FlexDecoderInfo) {
            parser = ParserFactory.getParser(13);
            parser.setDecoderInfo(decoderInfo);
        } else {
            parser = lowerPathName.endsWith("imdi") ? ParserFactory.getParser(4) : ParserFactory.getParser(11);
        }
        long beginTime = System.currentTimeMillis();
        if (this.debug) {
            System.out.println("Parsing eaf took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        List<MediaDescriptor> mediaDescriptors = parser.getMediaDescriptors(trPathName);
        attisTr.setMediaDescriptors(new Vector<MediaDescriptor>(mediaDescriptors));
        List<LinkedFileDescriptor> linkedFileDescriptors = parser.getLinkedFileDescriptors(trPathName);
        if (linkedFileDescriptors != null) {
            attisTr.setLinkedFileDescriptors(new Vector<LinkedFileDescriptor>(linkedFileDescriptors));
        }
        List<Property> props = parser.getTranscriptionProperties(trPathName);
        int lastUsedAnnotationId = 0;
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                PropertyImpl pimpl = (PropertyImpl)props.get(i);
                if (!"lastUsedAnnotationId".equals(pimpl.getName())) continue;
                String val = (String)pimpl.getValue();
                if (val != null) {
                    try {
                        lastUsedAnnotationId = Integer.parseInt(val);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                props.remove(i);
                break;
            }
            attisTr.addDocProperties(props);
        }
        String author = parser.getAuthor(trPathName);
        if (attisTr.getAuthor().equals("")) {
            attisTr.setAuthor(author);
        }
        if (this.debug) {
            System.out.println("Extracting header took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        Map<String, ExternalReferenceImpl> extReferences = parser.getExternalReferences(trPathName);
        List<LingTypeRecord> linguisticTypes = parser.getLinguisticTypes(trPathName);
        ArrayList<LinguisticType> typesCopy = new ArrayList<LinguisticType>(linguisticTypes.size());
        for (int i = 0; i < linguisticTypes.size(); ++i) {
            ExternalReferenceImpl eri;
            LingTypeRecord ltr = linguisticTypes.get(i);
            LinguisticType lt = new LinguisticType(ltr.getLingTypeId());
            boolean timeAlignable = true;
            if (ltr.getTimeAlignable().equals("false")) {
                timeAlignable = false;
            }
            lt.setTimeAlignable(timeAlignable);
            String stereotype = ltr.getStereoType();
            ConstraintImpl c = null;
            if (stereotype != null) {
                if ((stereotype = stereotype.replace('_', ' ')).equals(Constraint.stereoTypes[0])) {
                    c = new TimeSubdivision();
                } else if (stereotype.equals(Constraint.stereoTypes[3])) {
                    c = new SymbolicSubdivision();
                } else if (stereotype.equals(Constraint.stereoTypes[4])) {
                    c = new SymbolicAssociation();
                } else if (stereotype.equals(Constraint.stereoTypes[1])) {
                    c = new IncludedIn();
                }
            }
            if (c != null) {
                lt.addConstraint(c);
            }
            lt.setControlledVocabularyName(ltr.getControlledVocabulary());
            if (extReferences != null && ltr.getExtRefId() != null && (eri = extReferences.get(ltr.getExtRefId())) != null) {
                lt.setDataCategory(eri.getValue());
            }
            typesCopy.add(lt);
        }
        attisTr.setLinguisticTypes(new Vector<LinguisticType>(typesCopy));
        if (this.debug) {
            System.out.println("Creating linguistic types took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        TimeOrder timeOrder = attisTr.getTimeOrder();
        List<String> order = parser.getTimeOrder(trPathName);
        Map<String, String> slots = parser.getTimeSlots(trPathName);
        HashMap<String, TimeSlotImpl> timeSlothash = new HashMap<String, TimeSlotImpl>();
        Iterator<String> orderedIter = order.iterator();
        TimeSlotImpl ts = null;
        String tsKey = null;
        ArrayList<TimeSlot> tempSlots = new ArrayList<TimeSlot>(order.size());
        int index = 0;
        while (orderedIter.hasNext()) {
            tsKey = orderedIter.next();
            long time = Long.parseLong(slots.get(tsKey));
            ts = time != -1L ? new TimeSlotImpl(time, timeOrder) : new TimeSlotImpl(timeOrder);
            ts.setIndex(index++);
            tempSlots.add(ts);
            timeSlothash.put(tsKey, ts);
        }
        Collections.sort(tempSlots, new TimeSlotComparator());
        ((TimeOrderImpl)timeOrder).insertOrderedSlots(tempSlots);
        if (this.debug) {
            System.out.println("Creating time slots and time order took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        HashMap<TierImpl, String> parentHash = new HashMap<TierImpl, String>();
        if (!attisTr.isLoaded()) {
            Iterator<String> iter = parser.getTierNames(trPathName).iterator();
            attisTr.setLoaded(true);
            while (iter.hasNext()) {
                String parentId;
                String tierName = iter.next();
                TierImpl tier = new TierImpl(null, tierName, null, attisTr, null);
                String participant = parser.getParticipantOf(tierName, trPathName);
                String linguisticTypeID = parser.getLinguisticTypeIDOf(tierName, trPathName);
                String annotator = parser.getAnnotatorOf(tierName, trPathName);
                LinguisticType linguisticType = null;
                for (LinguisticType lt : typesCopy) {
                    if (!lt.getLinguisticTypeName().equals(linguisticTypeID)) continue;
                    linguisticType = lt;
                    break;
                }
                Locale defaultLanguage = parser.getDefaultLanguageOf(tierName, trPathName);
                tier.setParticipant(participant);
                tier.setAnnotator(annotator);
                tier.setLinguisticType(linguisticType);
                if (defaultLanguage != null) {
                    tier.setDefaultLocale(defaultLanguage);
                }
                if ((parentId = parser.getParentNameOf(tierName, trPathName)) != null) {
                    parentHash.put(tier, parentId);
                }
                attisTr.addTier(tier);
            }
        }
        for (TierImpl t : parentHash.keySet()) {
            t.setParentTier(attisTr.getTierWithId((String)parentHash.get(t)));
        }
        if (this.debug) {
            System.out.println("Creating tiers took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        List<TierImpl> tiers = attisTr.getTiers();
        HashMap<String, RefAnnotation> idToAnnotation = new HashMap<String, RefAnnotation>();
        HashMap<String, String> references = new HashMap<String, String>();
        HashMap<String, String> referenceChains = new HashMap<String, String>();
        HashMap tempAnnotationsForTiers = new HashMap();
        for (Tier tier : tiers) {
            List<AnnotationRecord> annotationRecords = parser.getAnnotationsOf(tier.getName(), trPathName);
            ArrayList<RefAnnotation> tempAnnotations = new ArrayList<RefAnnotation>();
            Iterator<AnnotationRecord> it1 = annotationRecords.iterator();
            while (it1.hasNext()) {
                ExternalReferenceImpl eri;
                AbstractAnnotation annotation = null;
                AnnotationRecord annotationRecord = it1.next();
                if (annotationRecord.getAnnotationType().equals("alignable")) {
                    annotation = new AlignableAnnotation((TimeSlot)timeSlothash.get(annotationRecord.getBeginTimeSlotId()), (TimeSlot)timeSlothash.get(annotationRecord.getEndTimeSlotId()), tier);
                } else if (annotationRecord.getAnnotationType().equals("reference")) {
                    annotation = new RefAnnotation(null, tier);
                    references.put(annotationRecord.getAnnotationId(), annotationRecord.getReferredAnnotId());
                    if (annotationRecord.getPreviousAnnotId() != null) {
                        referenceChains.put(annotationRecord.getAnnotationId(), annotationRecord.getPreviousAnnotId());
                    }
                }
                if (annotationRecord.getValue() != null) {
                    annotation.setValue(annotationRecord.getValue());
                }
                annotation.setId(annotationRecord.getAnnotationId());
                idToAnnotation.put(annotationRecord.getAnnotationId(), (RefAnnotation)annotation);
                if (annotationRecord.getAnnotationId() != null && annotationRecord.getAnnotationId().charAt(0) == 'a') {
                    try {
                        int aid = Integer.parseInt(annotationRecord.getAnnotationId().substring(1));
                        if (aid > lastUsedAnnotationId) {
                            lastUsedAnnotationId = aid;
                        }
                    }
                    catch (NumberFormatException aid) {
                    }
                    catch (Exception aid) {
                        // empty catch block
                    }
                }
                if (extReferences != null && annotationRecord.getExtRefId() != null && (eri = extReferences.get(annotationRecord.getExtRefId())) != null) {
                    try {
                        ((AbstractAnnotation)annotation).setExtRef(eri.clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        LOG.severe("Could not set the external reference: " + cloneNotSupportedException.getMessage());
                    }
                }
                tempAnnotations.add((RefAnnotation)annotation);
            }
            tempAnnotationsForTiers.put(tier, tempAnnotations);
        }
        PropertyImpl propertyImpl = new PropertyImpl("lastUsedAnnotationId", lastUsedAnnotationId);
        attisTr.addDocProperty(propertyImpl);
        for (String key : references.keySet()) {
            Annotation referedAnnotation = (Annotation)idToAnnotation.get(references.get(key));
            RefAnnotation refAnnotation = null;
            try {
                refAnnotation = (RefAnnotation)idToAnnotation.get(key);
                refAnnotation.addReference(referedAnnotation);
            }
            catch (Exception ex) {
                Object o = idToAnnotation.get(key);
                LOG.warning("failed to add a refanno to  (" + referedAnnotation.getTier().getName() + ", " + referedAnnotation.getBeginTimeBoundary() + ", " + referedAnnotation.getEndTimeBoundary() + ") " + referedAnnotation.getValue());
                if (o instanceof AlignableAnnotation) {
                    AlignableAnnotation alignableAnnotation = (AlignableAnnotation)o;
                    LOG.warning("  found AlignableAnnotation (" + alignableAnnotation.getTier().getName() + ", " + alignableAnnotation.getBeginTimeBoundary() + ", " + alignableAnnotation.getEndTimeBoundary() + ") " + alignableAnnotation.getValue());
                    continue;
                }
                LOG.warning("  found " + o);
            }
        }
        for (String key : referenceChains.keySet()) {
            RefAnnotation previous = (RefAnnotation)idToAnnotation.get(referenceChains.get(key));
            RefAnnotation a = (RefAnnotation)idToAnnotation.get(key);
            if (previous == null) continue;
            previous.setNext(a);
        }
        for (TierImpl t : tempAnnotationsForTiers.keySet()) {
            ArrayList annots = (ArrayList)tempAnnotationsForTiers.get(t);
            Iterator aIter = annots.iterator();
            while (aIter.hasNext()) {
                t.insertAnnotation((Annotation)aIter.next());
            }
        }
        for (TierImpl t : tiers) {
            if (!t.isTimeAlignable() || !t.hasParentTier()) continue;
            for (Annotation annotation : t.getAnnotations()) {
                if (!(annotation instanceof AlignableAnnotation)) continue;
                ((AlignableAnnotation)annotation).registerWithParent();
            }
        }
        if (this.debug) {
            System.out.println("Creating and connecting annotations took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if ((cvTable = parser.getControlledVocabularies(trPathName)) != null && cvTable.size() > 0) {
            ControlledVocabulary cv = null;
            for (String cvName : cvTable.keySet()) {
                if (cvName == null) continue;
                cv = new ControlledVocabulary(cvName);
                ArrayList contents = (ArrayList)((Object)cvTable.get(cvName));
                if (contents.size() > 0) {
                    for (int i = 0; i < contents.size(); ++i) {
                        ExternalReferenceImpl eri;
                        CVEntry entry;
                        Object next = contents.get(i);
                        if (next instanceof String) {
                            cv.setDescription((String)next);
                            continue;
                        }
                        if (!(next instanceof CVEntryRecord) || (entry = new CVEntry(cv, ((CVEntryRecord)next).getValue(), ((CVEntryRecord)next).getDescription())) == null) continue;
                        if (extReferences != null && ((CVEntryRecord)next).getExtRefId() != null && (eri = extReferences.get(((CVEntryRecord)next).getExtRefId())) != null) {
                            try {
                                entry.setExternalRef(eri.clone());
                            }
                            catch (CloneNotSupportedException cnse) {
                                LOG.severe("Could not set the external reference: " + cnse.getMessage());
                            }
                        }
                        cv.addEntry(entry);
                    }
                }
                attisTr.addControlledVocabulary(cv);
            }
        }
        if (this.debug) {
            System.out.println("Creating CV's took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if (attisTr.allRootAnnotsUnaligned()) {
            attisTr.alignRootAnnots();
        }
        if (this.concatenateAfterParse) {
            this.concatenateSymbolicAssociations(attisTr);
        }
        if (this.debug) {
            System.out.println("Post-processing took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
    }

    public void concatenateSymbolicAssociations(TranscriptionImpl transcription) {
        Annotation lastParent = null;
        AbstractAnnotation lastAnnot = null;
        Vector<RefAnnotation> annotsToRemove = new Vector<RefAnnotation>();
        List<TierImpl> tiers = transcription.getTiers();
        Iterator<TierImpl> tierIter = tiers.iterator();
        while (tierIter.hasNext()) {
            lastParent = null;
            lastAnnot = null;
            annotsToRemove.clear();
            TierImpl t = tierIter.next();
            LinguisticType lt = t.getLinguisticType();
            Constraint c = null;
            if (lt != null) {
                c = lt.getConstraints();
            }
            if (c == null || c.getStereoType() != 4) continue;
            for (RefAnnotation refAnnotation : t.getAnnotations()) {
                if (refAnnotation.getParentAnnotation() == lastParent) {
                    lastAnnot.setValue(lastAnnot.getValue() + " " + refAnnotation.getValue());
                    annotsToRemove.add(refAnnotation);
                    continue;
                }
                lastParent = refAnnotation.getParentAnnotation();
                lastAnnot = refAnnotation;
            }
            Iterator iterator = annotsToRemove.iterator();
            while (iterator.hasNext()) {
                t.removeAnnotation((Annotation)iterator.next());
            }
        }
    }
}

