/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.ParserFactory;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeOrderImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotComparator;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.chat.CHATEncoder;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVDescriptionRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVEntryRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF27Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF28Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.LanguageRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LexiconServiceRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.flex.FlexDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.reflink.RefLinkSet;
import mpi.eudico.server.corpora.clomimpl.reflink.RefLinkSetRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxEncoder;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo2;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.server.corpora.lexicon.LexicalEntryFieldIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.RecentLanguages;

public class ACM28TranscriptionStore
implements TranscriptionStore {
    public File fileToWriteXMLinto = null;
    public boolean debug = false;
    private boolean concatenateAfterParse = false;

    @Override
    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, int format) throws IOException {
        if (theTranscription instanceof TranscriptionImpl) {
            Object pathName = ((TranscriptionImpl)theTranscription).getPathName();
            if (!((String)pathName).substring(((String)pathName).length() - 4, ((String)pathName).length() - 3).equals(".")) {
                pathName = (String)pathName + ".eaf";
            } else {
                pathName = ((String)pathName).substring(0, ((String)pathName).length() - 3);
                pathName = (String)pathName + "eaf";
            }
            this.storeTranscriptionIn(theTranscription, encoderInfo, tierOrder, (String)pathName, format);
        }
    }

    @Override
    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String pathName, int format) throws IOException {
        if (theTranscription instanceof TranscriptionImpl) {
            if (!((String)pathName).substring(((String)pathName).length() - 4, ((String)pathName).length() - 3).equals(".")) {
                pathName = (String)pathName + ".eaf";
            } else {
                pathName = ((String)pathName).substring(0, ((String)pathName).length() - 3);
                pathName = (String)pathName + "eaf";
            }
            this.storeTranscriptionIn(theTranscription, encoderInfo, tierOrder, (String)pathName, format);
        }
    }

    @Override
    public void storeTranscriptionIn(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String path, int format) throws IOException {
        theTranscription.getURN();
        switch (format) {
            case 0: {
                if (this.fileToWriteXMLinto != null) {
                    path = this.fileToWriteXMLinto.getAbsolutePath();
                }
                new EAF28Encoder().encodeAndSave(theTranscription, null, tierOrder, path);
                break;
            }
            case 4: {
                if (this.fileToWriteXMLinto != null) {
                    path = this.fileToWriteXMLinto.getAbsolutePath();
                }
                new EAF27Encoder().encodeAndSave(theTranscription, null, tierOrder, path);
                break;
            }
            case 1: {
                new CHATEncoder().encodeAndSave(theTranscription, encoderInfo, tierOrder, path);
                break;
            }
            case 2: {
                new ShoeboxEncoder(path).encodeAndSave(theTranscription, encoderInfo, tierOrder, path);
                break;
            }
        }
    }

    @Override
    public void storeTranscriptionAsTemplateIn(Transcription theTranscription, List<TierImpl> tierOrder, String path) throws IOException {
        if (this.fileToWriteXMLinto != null) {
            path = this.fileToWriteXMLinto.getAbsolutePath();
        }
        new EAF28Encoder().encodeAsTemplateAndSave(theTranscription, tierOrder, path);
    }

    @Override
    public void loadTranscription(Transcription theTranscription) {
        this.loadTranscription(theTranscription, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadTranscription(Transcription theTranscription, DecoderInfo decoderInfo) {
        Map<String, LexiconServiceRecord> map;
        int fileFormat;
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        String trPathName = attisTr.getPathName();
        Parser parser = this.getParser(trPathName, decoderInfo);
        if (parser == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning("No Parser found for file: " + trPathName);
            }
            return;
        }
        long beginTime = System.currentTimeMillis();
        if (this.debug) {
            System.out.println("Parsing eaf took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        attisTr.setLicenses(parser.getLicenses(trPathName));
        List<MediaDescriptor> mediaDescriptors = parser.getMediaDescriptors(trPathName);
        attisTr.setMediaDescriptors(new ArrayList<MediaDescriptor>(mediaDescriptors));
        List<LinkedFileDescriptor> linkedFileDescriptors = parser.getLinkedFileDescriptors(trPathName);
        if (linkedFileDescriptors != null) {
            attisTr.setLinkedFileDescriptors(new ArrayList<LinkedFileDescriptor>(linkedFileDescriptors));
        }
        List<Property> props = parser.getTranscriptionProperties(trPathName);
        int lastUsedAnnotationId = 0;
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                PropertyImpl pimpl = (PropertyImpl)props.get(i);
                if (!"lastUsedAnnotationId".equals(pimpl.getName())) continue;
                String val = (String)pimpl.getValue();
                if (val != null) {
                    try {
                        lastUsedAnnotationId = Integer.parseInt(val);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                props.remove(i);
                break;
            }
            attisTr.addDocProperties(props);
        }
        String author = parser.getAuthor(trPathName);
        if (attisTr.getAuthor() == null || attisTr.getAuthor().isEmpty()) {
            attisTr.setAuthor(author);
        }
        if (this.debug) {
            System.out.println("Extracting header took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        Map<String, ExternalReferenceImpl> extReferences = parser.getExternalReferences(trPathName);
        List<LingTypeRecord> linguisticTypes = parser.getLinguisticTypes(trPathName);
        HashMap<String, LinguisticType> lexRefs = new HashMap<String, LinguisticType>();
        ArrayList<LinguisticType> typesCopy = new ArrayList<LinguisticType>(linguisticTypes.size());
        for (int i = 0; i < linguisticTypes.size(); ++i) {
            ExternalReferenceImpl eri;
            LingTypeRecord ltr = linguisticTypes.get(i);
            LinguisticType lt = new LinguisticType(ltr.getLingTypeId());
            boolean timeAlignable = true;
            if (ltr.getTimeAlignable().equals("false")) {
                timeAlignable = false;
            }
            lt.setTimeAlignable(timeAlignable);
            String stereotype = ltr.getStereoType();
            ConstraintImpl c = null;
            if (stereotype != null) {
                if ((stereotype = stereotype.replace('_', ' ')).equals(Constraint.stereoTypes[0])) {
                    c = new TimeSubdivision();
                } else if (stereotype.equals(Constraint.stereoTypes[3])) {
                    c = new SymbolicSubdivision();
                } else if (stereotype.equals(Constraint.stereoTypes[4])) {
                    c = new SymbolicAssociation();
                } else if (stereotype.equals(Constraint.stereoTypes[1])) {
                    c = new IncludedIn();
                }
            }
            if (c != null) {
                lt.addConstraint(c);
            }
            lt.setControlledVocabularyName(ltr.getControlledVocabulary());
            lexRefs.put(ltr.getLexiconReference(), lt);
            if (extReferences != null && ltr.getExtRefId() != null && (eri = extReferences.get(ltr.getExtRefId())) != null) {
                lt.setDataCategory(eri.getValue());
            }
            typesCopy.add(lt);
        }
        attisTr.setLinguisticTypes(new ArrayList<LinguisticType>(typesCopy));
        if (this.debug) {
            System.out.println("Creating linguistic types took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        TimeOrder timeOrder = attisTr.getTimeOrder();
        List<String> order = parser.getTimeOrder(trPathName);
        Map<String, String> slots = parser.getTimeSlots(trPathName);
        HashMap<String, TimeSlotImpl> timeSlothash = new HashMap<String, TimeSlotImpl>();
        Iterator<String> orderedIter = order.iterator();
        TimeSlotImpl ts = null;
        String tsKey = null;
        ArrayList<TimeSlot> tempSlots = new ArrayList<TimeSlot>(order.size());
        int index = 0;
        while (orderedIter.hasNext()) {
            tsKey = orderedIter.next();
            long time = Long.parseLong(slots.get(tsKey));
            ts = time != -1L ? new TimeSlotImpl(time, timeOrder) : new TimeSlotImpl(timeOrder);
            ts.setIndex(index++);
            tempSlots.add(ts);
            timeSlothash.put(tsKey, ts);
        }
        Collections.sort(tempSlots, new TimeSlotComparator());
        ((TimeOrderImpl)timeOrder).insertOrderedSlots(tempSlots);
        if (this.debug) {
            System.out.println("Creating time slots and time order took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        HashMap<TierImpl, String> parentHash = new HashMap<TierImpl, String>();
        if (!attisTr.isLoaded()) {
            for (String tierName : parser.getTierNames(trPathName)) {
                TierImpl tier = new TierImpl(null, tierName, null, attisTr, null);
                String participant = parser.getParticipantOf(tierName, trPathName);
                String linguisticTypeID = parser.getLinguisticTypeIDOf(tierName, trPathName);
                String annotator = parser.getAnnotatorOf(tierName, trPathName);
                Object linguisticType = null;
                for (LinguisticType lt : typesCopy) {
                    if (!lt.getLinguisticTypeName().equals(linguisticTypeID)) continue;
                    linguisticType = lt;
                    break;
                }
                Locale defaultLocale = parser.getDefaultLanguageOf(tierName, trPathName);
                tier.setParticipant(participant);
                tier.setAnnotator(annotator);
                tier.setLinguisticType((LinguisticType)linguisticType);
                tier.setDefaultLocale(defaultLocale);
                String parentId = parser.getParentNameOf(tierName, trPathName);
                if (parentId != null) {
                    parentHash.put(tier, parentId);
                }
                tier.setLangRef(parser.getLangRefOf(tierName, trPathName));
                tier.setExtRef(parser.getExtRefOf(tierName, trPathName));
                attisTr.addTier(tier);
            }
        }
        for (TierImpl t : parentHash.keySet()) {
            t.setParentTier(attisTr.getTierWithId((String)parentHash.get(t)));
        }
        if (this.debug) {
            System.out.println("Creating tiers took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        List<TierImpl> tiers = attisTr.getTiers();
        HashMap<String, void> idToAnnotation = new HashMap<String, void>();
        HashMap<String, String> references = new HashMap<String, String>();
        HashMap<String, String> referenceChains = new HashMap<String, String>();
        HashMap tempAnnotationsForTiers = new HashMap();
        for (Tier tier : tiers) {
            List<AnnotationRecord> annotationRecords = parser.getAnnotationsOf(tier.getName(), trPathName);
            boolean tierHasExternalCV = false;
            String cvName = ((TierImpl)tier).getLinguisticType().getControlledVocabularyName();
            Map<String, CVRecord> cvTable = parser.getControlledVocabularies(trPathName);
            if (cvTable != null && cvName != null) {
                CVRecord cvRecord = cvTable.get(cvName);
                tierHasExternalCV = cvRecord != null && cvRecord.getExtRefId() != null && !cvRecord.getExtRefId().isEmpty();
            }
            ArrayList<void> tempAnnotations = new ArrayList<void>();
            Iterator<AnnotationRecord> iterator = annotationRecords.iterator();
            while (iterator.hasNext()) {
                void var43_65;
                Object var43_66 = null;
                AnnotationRecord annotationRecord = iterator.next();
                if (annotationRecord.getAnnotationType().equals("alignable")) {
                    AlignableAnnotation alignableAnnotation = new AlignableAnnotation((TimeSlot)timeSlothash.get(annotationRecord.getBeginTimeSlotId()), (TimeSlot)timeSlothash.get(annotationRecord.getEndTimeSlotId()), tier);
                } else {
                    RefAnnotation refAnnotation = new RefAnnotation(null, tier);
                    references.put(annotationRecord.getAnnotationId(), annotationRecord.getReferredAnnotId());
                    if (annotationRecord.getPreviousAnnotId() != null) {
                        referenceChains.put(annotationRecord.getAnnotationId(), annotationRecord.getPreviousAnnotId());
                    }
                }
                if (annotationRecord.getValue() != null) {
                    var43_65.setValue(annotationRecord.getValue());
                }
                var43_65.setId(annotationRecord.getAnnotationId());
                if (annotationRecord.getCvEntryId() != null && !annotationRecord.getCvEntryId().isEmpty()) {
                    var43_65.setCVEntryId(annotationRecord.getCvEntryId());
                }
                idToAnnotation.put(annotationRecord.getAnnotationId(), var43_65);
                if (annotationRecord.getAnnotationId() != null && annotationRecord.getAnnotationId().charAt(0) == 'a') {
                    try {
                        int aid = Integer.parseInt(annotationRecord.getAnnotationId().substring(1));
                        if (aid > lastUsedAnnotationId) {
                            lastUsedAnnotationId = aid;
                        }
                    }
                    catch (NumberFormatException aid) {
                    }
                    catch (Exception aid) {
                        // empty catch block
                    }
                }
                if (extReferences != null && annotationRecord.getExtRefId() != null) {
                    String[] extRefIds;
                    for (String string : extRefIds = annotationRecord.getExtRefId().split(" ")) {
                        ExternalReferenceImpl eri = extReferences.get(string);
                        if (eri == null) continue;
                        if (tierHasExternalCV && eri.getReferenceType() == 5 && var43_65.getCVEntryId() == null) {
                            String cvEntryId = eri.getValue();
                            var43_65.setCVEntryId(cvEntryId);
                            continue;
                        }
                        if (eri.getReferenceType() != 2 && eri.getReferenceType() != 5) continue;
                        try {
                            ((AbstractAnnotation)var43_65).addExtRef(eri.clone());
                        }
                        catch (CloneNotSupportedException cnse) {
                            ServerLogger.LOG.severe("Could not set the external reference: " + cnse.getMessage());
                        }
                    }
                }
                tempAnnotations.add(var43_65);
            }
            tempAnnotationsForTiers.put(tier, tempAnnotations);
        }
        PropertyImpl luaid = new PropertyImpl("lastUsedAnnotationId", lastUsedAnnotationId);
        attisTr.addDocProperty(luaid);
        for (String key : references.keySet()) {
            Annotation referedAnnotation = (Annotation)idToAnnotation.get(references.get(key));
            RefAnnotation refAnnotation = null;
            try {
                refAnnotation = (RefAnnotation)idToAnnotation.get(key);
                refAnnotation.addReference(referedAnnotation);
            }
            catch (Exception ex) {
                Object o = idToAnnotation.get(key);
                ServerLogger.LOG.warning("failed to add a refanno to  (" + referedAnnotation.getTier().getName() + ", " + referedAnnotation.getBeginTimeBoundary() + ", " + referedAnnotation.getEndTimeBoundary() + ") " + referedAnnotation.getValue());
                if (o instanceof AlignableAnnotation) {
                    AlignableAnnotation alignableAnnotation = (AlignableAnnotation)o;
                    ServerLogger.LOG.warning("  found AlignableAnnotation (" + alignableAnnotation.getTier().getName() + ", " + alignableAnnotation.getBeginTimeBoundary() + ", " + alignableAnnotation.getEndTimeBoundary() + ") " + alignableAnnotation.getValue());
                    continue;
                }
                ServerLogger.LOG.warning("  found " + o);
            }
        }
        for (String key : referenceChains.keySet()) {
            RefAnnotation previous = (RefAnnotation)idToAnnotation.get(referenceChains.get(key));
            RefAnnotation a = (RefAnnotation)idToAnnotation.get(key);
            if (previous == null) continue;
            previous.setNext(a);
        }
        for (Object t : tempAnnotationsForTiers.keySet()) {
            List annots = (List)tempAnnotationsForTiers.get(t);
            Iterator aIter = annots.iterator();
            while (aIter.hasNext()) {
                ((TierImpl)t).insertAnnotation((Annotation)aIter.next());
            }
        }
        for (TierImpl t : tiers) {
            if (!t.isTimeAlignable() || !t.hasParentTier()) continue;
            for (Annotation annotation : t.getAnnotations()) {
                if (!(annotation instanceof AlignableAnnotation)) continue;
                ((AlignableAnnotation)annotation).registerWithParent();
            }
        }
        if (this.debug) {
            System.out.println("Creating and connecting annotations took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        Map<String, CVRecord> cvTable = parser.getControlledVocabularies(trPathName);
        List<LanguageRecord> languages = parser.getLanguages(trPathName);
        if (languages != null) {
            for (LanguageRecord languageRecord : languages) {
                RecentLanguages.getInstance().addRecentLanguage(new LangInfo(languageRecord.getId(), languageRecord.getDef(), languageRecord.getLabel()));
            }
        }
        if (cvTable != null && cvTable.size() > 0) {
            ControlledVocabulary cv = null;
            Set<String> set = cvTable.keySet();
            for (String cvName : set) {
                boolean isMultiLanguage;
                if (cvName == null) continue;
                CVRecord contents = cvTable.get(cvName);
                if (contents.getExtRefId() != null && contents.getExtRefId() != "" && extReferences != null) {
                    cv = new ExternalCV(cvName);
                    ExternalReferenceImpl eri = extReferences.get(contents.getExtRefId());
                    if (eri != null) {
                        try {
                            ((ExternalCV)cv).setExternalRef(eri.clone());
                        }
                        catch (CloneNotSupportedException cnse) {
                            ServerLogger.LOG.severe("Could not set the external reference: " + cnse.getMessage());
                        }
                    }
                } else {
                    cv = new ControlledVocabulary(cvName);
                    cv.setInitMode(true);
                }
                List<CVDescriptionRecord> descriptions = contents.getDescriptions();
                boolean bl = isMultiLanguage = descriptions != null && !descriptions.isEmpty();
                if (isMultiLanguage) {
                    for (CVDescriptionRecord cVDescriptionRecord : descriptions) {
                        String langId = cVDescriptionRecord.getLangRef();
                        String longLanguageId = "";
                        Object langLabel = "";
                        if (languages != null) {
                            for (LanguageRecord lr : languages) {
                                if (!langId.equals(lr.getId())) continue;
                                longLanguageId = lr.getDef();
                                langLabel = lr.getLabel();
                                break;
                            }
                        }
                        int langIndex = cv.addLanguage(langId, longLanguageId, (String)langLabel);
                        langIndex = Math.max(0, langIndex);
                        cv.setDescription(langIndex, cVDescriptionRecord.getDescription());
                    }
                }
                if (contents.hasContents()) {
                    if (contents.getDescription() != null && !contents.getDescription().isEmpty()) {
                        cv.setDescription(0, contents.getDescription());
                    }
                    if (!(cv instanceof ExternalCV)) {
                        ArrayList<CVEntryRecord> arrayList = contents.getEntries();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            ExternalReferenceImpl eri;
                            CVEntryRecord cveRecord = (CVEntryRecord)arrayList.get(i);
                            CVEntry entry = new CVEntry(cv);
                            if (cveRecord.getId() != null) {
                                entry.setId(cveRecord.getId());
                            }
                            if (isMultiLanguage) {
                                if (cveRecord.getSubEntries() != null) {
                                    for (CVEntryRecord subRecord : cveRecord.getSubEntries()) {
                                        String langId = subRecord.getSubEntryLangRef();
                                        int langIndex = cv.getIndexOfLanguage(langId);
                                        if (langIndex >= 0) {
                                            entry.setDescription(langIndex, subRecord.getDescription());
                                            entry.setValue(langIndex, subRecord.getValue());
                                            continue;
                                        }
                                        ServerLogger.LOG.warning("<CVE_VALUE> element with attribute LANG_REF=\"" + langId + "\" for which there was no <DESCRIPTION>. The element was ignored.");
                                    }
                                }
                            } else {
                                entry.setDescription(cveRecord.getDescription());
                                entry.setValue(cveRecord.getValue());
                            }
                            if (extReferences != null && cveRecord.getExtRefId() != null && (eri = extReferences.get(cveRecord.getExtRefId())) != null) {
                                try {
                                    entry.setExternalRef(eri.clone());
                                }
                                catch (CloneNotSupportedException cnse) {
                                    ServerLogger.LOG.severe("Could not set the external reference: " + cnse.getMessage());
                                }
                            }
                            cv.addEntry(entry);
                        }
                    }
                }
                cv.setInitMode(false);
                attisTr.addControlledVocabulary(cv);
            }
        }
        if (this.debug) {
            System.out.println("Creating CVs took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if ((fileFormat = parser.getFileFormat()) > 0 && fileFormat < 2008000) {
            for (Tier tier : tiers) {
                TierImpl ti = (TierImpl)tier;
                String cvName = ti.getLinguisticType().getControlledVocabularyName();
                ControlledVocabulary controlledVocabulary = ((TranscriptionImpl)theTranscription).getControlledVocabulary(cvName);
                if (controlledVocabulary == null) continue;
                List<AbstractAnnotation> va = ti.getAnnotations();
                for (Annotation annotation : va) {
                    String id = annotation.getCVEntryId();
                    if (id != null && !id.isEmpty()) continue;
                    String word = annotation.getValue();
                    boolean langIndex = false;
                    CVEntry entry = controlledVocabulary.getEntryWithValue(0, word);
                    if (entry == null) continue;
                    annotation.setCVEntryId(entry.getId());
                }
            }
            if (this.debug) {
                System.out.println("Looking up Annotation values in their CVs took: " + (System.currentTimeMillis() - beginTime) + " ms");
                beginTime = System.currentTimeMillis();
            }
        }
        if ((map = parser.getLexiconServices(trPathName)) != null && map.size() > 0) {
            Object var43_73 = null;
            for (String lexRef : map.keySet()) {
                if (lexRef == null) continue;
                LexiconServiceRecord contents = map.get(lexRef);
                LexiconIdentification lexiconIdentification = new LexiconIdentification(contents.getLexiconId(), contents.getLexiconName());
                LexiconLink link = new LexiconLink(contents.getName(), contents.getType(), contents.getUrl(), null, lexiconIdentification);
                attisTr.addLexiconLink(link);
                if (!lexRefs.containsKey(lexRef)) continue;
                LexiconQueryBundle2 lexiconQueryBundle2 = new LexiconQueryBundle2(link, new LexicalEntryFieldIdentification(contents.getDatcatId(), contents.getDatcatName()));
                ((LinguisticType)lexRefs.get(lexRef)).setLexiconQueryBundle(lexiconQueryBundle2);
            }
        }
        this.loadReferenceLinks(attisTr, parser);
        if (attisTr.allRootAnnotsUnaligned()) {
            attisTr.alignRootAnnots();
        }
        if (this.concatenateAfterParse) {
            this.concatenateSymbolicAssociations(attisTr);
        }
        attisTr.setLoaded(true);
        if (this.debug) {
            System.out.println("Post-processing took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
    }

    public void concatenateSymbolicAssociations(TranscriptionImpl transcription) {
        Annotation lastParent = null;
        AbstractAnnotation lastAnnot = null;
        ArrayList<RefAnnotation> annotsToRemove = new ArrayList<RefAnnotation>();
        for (TierImpl t : transcription.getTiers()) {
            lastParent = null;
            lastAnnot = null;
            annotsToRemove.clear();
            LinguisticType lt = t.getLinguisticType();
            Constraint c = null;
            if (lt != null) {
                c = lt.getConstraints();
            }
            if (c == null || c.getStereoType() != 4) continue;
            for (RefAnnotation a : t.getRefAnnotations()) {
                if (a.getParentAnnotation() == lastParent && lastAnnot != null) {
                    lastAnnot.setValue(lastAnnot.getValue() + " " + a.getValue());
                    annotsToRemove.add(a);
                    continue;
                }
                lastParent = a.getParentAnnotation();
                lastAnnot = a;
            }
            Iterator rIter = annotsToRemove.iterator();
            while (rIter.hasNext()) {
                t.removeAnnotation((Annotation)rIter.next());
            }
        }
    }

    protected Parser getParser(String filePath, DecoderInfo decoderInfo) {
        String lowerPathName = filePath.toLowerCase();
        Parser parser = null;
        if (lowerPathName.endsWith("cha")) {
            parser = ParserFactory.getParser(1);
        } else if (decoderInfo instanceof DelimitedTextDecoderInfo) {
            parser = ParserFactory.getParser(10);
            parser.setDecoderInfo(decoderInfo);
        } else if ((lowerPathName.endsWith("txt") || lowerPathName.endsWith("sht") || lowerPathName.endsWith("tbt")) && decoderInfo instanceof ToolboxDecoderInfo2) {
            parser = ParserFactory.getParser(12);
            parser.setDecoderInfo(decoderInfo);
            this.concatenateAfterParse = true;
        } else if (lowerPathName.endsWith("txt") || lowerPathName.endsWith("sht") || lowerPathName.endsWith("tbt")) {
            parser = ParserFactory.getParser(2);
            parser.setDecoderInfo(decoderInfo);
            this.concatenateAfterParse = true;
        } else if (lowerPathName.endsWith("trs")) {
            parser = ParserFactory.getParser(3);
            parser.setDecoderInfo(decoderInfo);
        } else if (decoderInfo instanceof FlexDecoderInfo) {
            parser = ParserFactory.getParser(13);
            parser.setDecoderInfo(decoderInfo);
        } else if (lowerPathName.endsWith("imdi")) {
            parser = ParserFactory.getParser(4);
        } else {
            int version = ACMTranscriptionStore.eafFileFormatTaster(filePath);
            parser = ParserFactory.getParser(version);
        }
        return parser;
    }

    protected void loadReferenceLinks(TranscriptionImpl transcription, Parser parser) {
        RefLinkSetRecord refLinkSetRecord;
        List<RefLinkSetRecord> refLinkRecords = parser.getRefLinkSetList(transcription.getPathName());
        if (refLinkRecords != null && !refLinkRecords.isEmpty() && (refLinkSetRecord = refLinkRecords.get(0)) != null) {
            RefLinkSet refLinkSet = refLinkSetRecord.fabricate(transcription, parser.getExternalReferences(transcription.getPathName()));
            transcription.addRefLinkSet(refLinkSet);
        }
    }
}

