/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.util.List;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.ParserFactory;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.chat.CHATEncoder;
import mpi.eudico.server.corpora.clomimpl.dobes.ACM28TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF27Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF28Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF30Encoder;
import mpi.eudico.server.corpora.clomimpl.reflink.RefLinkSet;
import mpi.eudico.server.corpora.clomimpl.reflink.RefLinkSetRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxEncoder;
import mpi.eudico.server.corpora.clomimpl.subtitletext.SubtitleDecoderInfo;

public class ACM30TranscriptionStore
extends ACM28TranscriptionStore {
    @Override
    public void storeTranscriptionIn(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String path, int format) throws IOException {
        theTranscription.getURN();
        switch (format) {
            case 0: {
                if (this.fileToWriteXMLinto != null) {
                    path = this.fileToWriteXMLinto.getAbsolutePath();
                }
                new EAF30Encoder().encodeAndSave(theTranscription, null, tierOrder, path);
                break;
            }
            case 5: {
                if (this.fileToWriteXMLinto != null) {
                    path = this.fileToWriteXMLinto.getAbsolutePath();
                }
                new EAF28Encoder().encodeAndSave(theTranscription, null, tierOrder, path);
                break;
            }
            case 4: {
                if (this.fileToWriteXMLinto != null) {
                    path = this.fileToWriteXMLinto.getAbsolutePath();
                }
                new EAF27Encoder().encodeAndSave(theTranscription, null, tierOrder, path);
                break;
            }
            case 1: {
                new CHATEncoder().encodeAndSave(theTranscription, encoderInfo, tierOrder, path);
                break;
            }
            case 2: {
                new ShoeboxEncoder(path).encodeAndSave(theTranscription, encoderInfo, tierOrder, path);
                break;
            }
        }
    }

    @Override
    public void storeTranscriptionAsTemplateIn(Transcription theTranscription, List<TierImpl> tierOrder, String path) throws IOException {
        if (this.fileToWriteXMLinto != null) {
            path = this.fileToWriteXMLinto.getAbsolutePath();
        }
        new EAF30Encoder().encodeAsTemplateAndSave(theTranscription, tierOrder, path);
    }

    @Override
    protected Parser getParser(String filePath, DecoderInfo decoderInfo) {
        if (decoderInfo instanceof SubtitleDecoderInfo) {
            Parser parser = ParserFactory.getParser(17);
            parser.setDecoderInfo(decoderInfo);
            return parser;
        }
        return super.getParser(filePath, decoderInfo);
    }

    @Override
    protected void loadReferenceLinks(TranscriptionImpl transcription, Parser parser) {
        List<RefLinkSetRecord> refLinkRecords = parser.getRefLinkSetList(transcription.getPathName());
        if (refLinkRecords != null && !refLinkRecords.isEmpty()) {
            for (RefLinkSetRecord rlsRecord : refLinkRecords) {
                RefLinkSet refLinkSet = rlsRecord.fabricate(transcription, parser.getExternalReferences(transcription.getPathName()));
                transcription.addRefLinkSet(refLinkSet);
            }
        }
    }
}

