/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Scanner;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.ACM30TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF30Parser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ACMTranscriptionStore {
    private ACMTranscriptionStore() {
    }

    public static final TranscriptionStore getCurrentTranscriptionStore() {
        return new ACM30TranscriptionStore();
    }

    public static final Parser getCurrentEAFParser() {
        return new EAF30Parser();
    }

    public static final EntityResolver getCurrentEAFResolver() {
        return new EAF30Parser.EAFResolver();
    }

    public static final String getCurrentEAFSchemaLocal() {
        return "/mpi/eudico/resources/EAFv3.0.xsd";
    }

    public static final String getCurrentEAFSchemaRemote() {
        return "http://www.mpi.nl/tools/elan/EAFv3.0.xsd";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int eafFileFormatTaster(String trPathName) {
        TasterContentHandler handler = new TasterContentHandler();
        int version = 16;
        FileInputStream fis = null;
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setFeature("http://xml.org/sax/features/namespaces", false);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setContentHandler(handler);
            reader.setEntityResolver(ACMTranscriptionStore.getCurrentEAFResolver());
            File f = new File(trPathName);
            fis = new FileInputStream(f);
            InputSource source = new InputSource(fis);
            source.setSystemId(trPathName);
            reader.parse(source);
        }
        catch (SAXParseException f) {
        }
        catch (SAXException e) {
            e.printStackTrace();
            int source = version;
            return source;
        }
        catch (IOException e) {
            e.printStackTrace();
            int source = version;
            return source;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (handler.format != null) {
            Scanner scanner = new Scanner(handler.format).useDelimiter("\\.");
            int majorVersion = scanner.nextInt();
            int minorVersion = scanner.nextInt();
            int toolow = 11;
            int toohigh = 16;
            if (majorVersion < 2) {
                version = toolow;
            } else if (majorVersion == 2) {
                if (minorVersion < 7) {
                    version = toolow;
                } else if (minorVersion == 7) {
                    version = 14;
                } else if (minorVersion == 8) {
                    version = 15;
                } else if (minorVersion > 8) {
                    version = toohigh;
                }
            } else if (majorVersion > 2) {
                version = toohigh;
            }
        }
        return version;
    }

    static class TasterContentHandler
    implements ContentHandler {
        String format;

        TasterContentHandler() {
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localname, String qName, Attributes atts) throws SAXException {
            if (localname.isEmpty()) {
                localname = qName;
            }
            if (localname.equals("ANNOTATION_DOCUMENT")) {
                this.format = atts.getValue("FORMAT");
            }
            throw new SAXParseException("Seen enough of the document", null);
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

