/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.util.Locale;
import java.util.Set;
import mpi.eudico.server.corpora.clomimpl.abstr.LicenseRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF27;
import mpi.eudico.server.corpora.clomimpl.reflink.CrossRefLink;
import org.w3c.dom.Element;

public class EAF28
extends EAF27 {
    public static final String EAF28_SCHEMA_LOCATION = "http://www.mpi.nl/tools/elan/EAFv2.8.xsd";
    public static final String EAF28_SCHEMA_RESOURCE = "/mpi/eudico/resources/EAFv2.8.xsd";

    public EAF28() throws Exception {
        this.EAF_Format = "2.8";
        this.EAF_Schema_Location = EAF28_SCHEMA_LOCATION;
    }

    public Element newTier(String id, String participant, String annotator, String typeRef, Locale language, String parent, String extRef, String langRef) {
        Element result = super.newTier(id, participant, annotator, typeRef, language, parent);
        this.attributeIfNotEmpty(result, "EXT_REF", extRef);
        this.attributeIfNotEmpty(result, "LANG_REF", langRef);
        return result;
    }

    public Element newAlignableAnnotation(String id, String beginTimeSlot, String endTimeSlot, String extRefId, String cveId) {
        Element result = super.newAlignableAnnotation(id, beginTimeSlot, endTimeSlot, extRefId);
        this.attributeIfNotEmpty(result, "CVE_REF", cveId);
        return result;
    }

    public Element newRefAnnotation(String id, String annotationRef, String previousAnnotation, String extRefId, String cveId) {
        Element result = super.newRefAnnotation(id, annotationRef, previousAnnotation, extRefId);
        this.attributeIfNotEmpty(result, "CVE_REF", cveId);
        return result;
    }

    public Element newLanguage(String id, String def, String label) {
        if (id == null || id.isEmpty()) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("LANGUAGE");
        result.setAttribute("LANG_ID", id);
        this.attributeIfNotEmpty(result, "LANG_DEF", def);
        this.attributeIfNotEmpty(result, "LANG_LABEL", label);
        return result;
    }

    public Element newDescription(String languageId, String description) {
        if (languageId == null || languageId.isEmpty()) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("DESCRIPTION");
        result.setAttribute("LANG_REF", languageId);
        result.appendChild(this.doc.createTextNode(description));
        return result;
    }

    public Element newCVEntryValue(String langRef, String value, String description) {
        if (langRef == null || langRef.isEmpty()) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CVE_VALUE");
        this.attributeIfNotEmpty(result, "DESCRIPTION", description);
        result.setAttribute("LANG_REF", langRef);
        result.appendChild(this.doc.createTextNode(value));
        return result;
    }

    public Element newCVEntryML(String id, String extRefId) {
        if (id == null || id.isEmpty()) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CV_ENTRY_ML");
        result.setAttribute("CVE_ID", id);
        this.attributeIfNotEmpty(result, "EXT_REF", extRefId);
        return result;
    }

    public Element newLicense(LicenseRecord licenseRecord) {
        if (licenseRecord == null) {
            return this.doc.createElement("LICENSE");
        }
        String licenseURL = licenseRecord.getUrl();
        String license = licenseRecord.getText();
        Element result = this.doc.createElement("LICENSE");
        if (licenseURL != null) {
            result.setAttribute("LICENSE_URL", licenseURL);
        }
        result.appendChild(this.doc.createTextNode(license));
        return result;
    }

    public Element newRefLinkSet(String linksID, String extRefId, String langRef, String cvRef) {
        Element result = this.doc.createElement("REF_LINK_SET");
        result.setAttribute("LINKS_ID", linksID);
        this.attributeIfNotEmpty(result, "EXT_REF", extRefId);
        this.attributeIfNotEmpty(result, "LANG_REF", langRef);
        this.attributeIfNotEmpty(result, "CV_REF", cvRef);
        return result;
    }

    public Element newCrossRefLink(String id, String extRefId, String langRef, String cveRef, String refType, String content, String ref1, String ref2, CrossRefLink.Directionality dir) {
        Element result = this.doc.createElement("CROSS_REF_LINK");
        result.setAttribute("REF_LINK_ID", id);
        this.attributeIfNotEmpty(result, "EXT_REF", extRefId);
        this.attributeIfNotEmpty(result, "LANG_REF", langRef);
        this.attributeIfNotEmpty(result, "CVE_REF", cveRef);
        this.attributeIfNotEmpty(result, "REF_TYPE", refType);
        if (content != null && !content.isEmpty()) {
            result.appendChild(this.doc.createTextNode(content));
        }
        result.setAttribute("REF1", ref1);
        result.setAttribute("REF2", ref2);
        result.setAttribute("DIRECTIONALITY", dir.toString());
        return result;
    }

    public Element newGroupRefLink(String id, String extRefId, String langRef, String cveRef, String refType, String content, Set<String> refs) {
        Element result = this.doc.createElement("GROUP_REF_LINK");
        result.setAttribute("REF_LINK_ID", id);
        this.attributeIfNotEmpty(result, "EXT_REF", extRefId);
        this.attributeIfNotEmpty(result, "LANG_REF", langRef);
        this.attributeIfNotEmpty(result, "CVE_REF", cveRef);
        this.attributeIfNotEmpty(result, "REF_TYPE", refType);
        if (content != null && !content.isEmpty()) {
            result.appendChild(this.doc.createTextNode(content));
        }
        StringBuffer sb = new StringBuffer();
        for (String ref : refs) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(ref);
        }
        result.setAttribute("REFS", sb.toString());
        return result;
    }
}

