/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.LicenseRecord;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVDescriptionRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVEntryRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LanguageRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LexiconServiceRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TierRecord;
import mpi.eudico.server.corpora.clomimpl.reflink.AbstractRefLinkRecord;
import mpi.eudico.server.corpora.clomimpl.reflink.CrossRefLinkRecord;
import mpi.eudico.server.corpora.clomimpl.reflink.GroupRefLinkRecord;
import mpi.eudico.server.corpora.clomimpl.reflink.RefLinkSetRecord;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class EAF30Parser
extends Parser {
    private boolean verbose = false;
    private XMLReader reader;
    private final Map<String, TierRecord> tierMap = new HashMap<String, TierRecord>();
    private final Map<String, List<AnnotationRecord>> tiers = new HashMap<String, List<AnnotationRecord>>();
    private final List<String> tierNames = new ArrayList<String>();
    private final List<LingTypeRecord> linguisticTypes = new ArrayList<LingTypeRecord>();
    private final List<Locale> locales = new ArrayList<Locale>();
    private final Map<String, String> timeSlots = new HashMap<String, String>();
    private final Map<String, CVRecord> controlledVocabularies = new HashMap<String, CVRecord>();
    private final Map<String, LexiconServiceRecord> lexiconServices = new HashMap<String, LexiconServiceRecord>();
    private final List<Property> docProperties = new ArrayList<Property>();
    private final Map<String, ExternalReferenceImpl> extReferences = new HashMap<String, ExternalReferenceImpl>();
    private final List<LanguageRecord> languages = new ArrayList<LanguageRecord>();
    private final List<LicenseRecord> licenses = new ArrayList<LicenseRecord>();
    private final List<String> timeOrder = new ArrayList<String>();
    private List<MediaDescriptor> mediaDescriptors = new ArrayList<MediaDescriptor>();
    private List<LinkedFileDescriptor> linkedFileDescriptors = new ArrayList<LinkedFileDescriptor>();
    private String author;
    private String currentTierId;
    private String currentAnnotationId;
    private AnnotationRecord currentAnnRecord;
    private String currentCVId;
    private boolean controlledVocabularyIsMultiLanguage;
    private CVEntryRecord currentEntryRecord;
    private CVEntryRecord currentSubEntryRecord;
    private CVDescriptionRecord cvDescriptionRecord;
    private String content = "";
    private String lastParsed = "";
    private String currentFileName;
    private String currentPropertyName;
    private String fileFormat;
    private RefLinkSetRecord refLinkSet;
    private AbstractRefLinkRecord refLinkRecord;
    private List<RefLinkSetRecord> refLinkSetList = new ArrayList<RefLinkSetRecord>();

    public EAF30Parser() {
        try {
            boolean validate = Boolean.parseBoolean(System.getProperty("ELAN.EAF.Validate", "true"));
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", validate);
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", validate);
            this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", validate);
            EAFContentHandler handler = new EAFContentHandler();
            this.reader.setContentHandler(handler);
            this.reader.setErrorHandler(handler);
            this.reader.setEntityResolver(new EAFResolver());
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    @Override
    public String getMediaFile(String fileName) {
        this.parse(fileName);
        return null;
    }

    @Override
    public List<MediaDescriptor> getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return this.mediaDescriptors;
    }

    @Override
    public List<LinkedFileDescriptor> getLinkedFileDescriptors(String fileName) {
        this.parse(fileName);
        return this.linkedFileDescriptors;
    }

    @Override
    public String getAuthor(String fileName) {
        this.parse(fileName);
        return this.author;
    }

    @Override
    public List<Property> getTranscriptionProperties(String fileName) {
        this.parse(fileName);
        return this.docProperties;
    }

    @Override
    public List<LingTypeRecord> getLinguisticTypes(String fileName) {
        this.parse(fileName);
        return this.linguisticTypes;
    }

    @Override
    public List<String> getTimeOrder(String fileName) {
        this.parse(fileName);
        return this.timeOrder;
    }

    @Override
    public Map<String, String> getTimeSlots(String fileName) {
        this.parse(fileName);
        return this.timeSlots;
    }

    @Override
    public Map<String, CVRecord> getControlledVocabularies(String fileName) {
        this.parse(fileName);
        return this.controlledVocabularies;
    }

    @Override
    public Map<String, LexiconServiceRecord> getLexiconServices(String fileName) {
        this.parse(fileName);
        return this.lexiconServices;
    }

    @Override
    public List<String> getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && this.tierMap.get(tierName).getParticipant() != null) {
            return this.tierMap.get(tierName).getParticipant();
        }
        return "";
    }

    @Override
    public String getAnnotatorOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && this.tierMap.get(tierName).getAnnotator() != null) {
            return this.tierMap.get(tierName).getAnnotator();
        }
        return "";
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && this.tierMap.get(tierName).getLinguisticType() != null) {
            return this.tierMap.get(tierName).getLinguisticType();
        }
        return "";
    }

    @Override
    public Locale getDefaultLanguageOf(String tierName, String fileName) {
        this.parse(fileName);
        Locale resultLoc = null;
        String localeId = null;
        if (this.tierMap.get(tierName) != null) {
            localeId = this.tierMap.get(tierName).getDefaultLocale();
        }
        for (Locale l : this.locales) {
            if (!l.getLanguage().equals(localeId)) continue;
            resultLoc = l;
        }
        return resultLoc;
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null) {
            return this.tierMap.get(tierName).getParentTier();
        }
        return null;
    }

    @Override
    public String getExtRefOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null) {
            return this.tierMap.get(tierName).getExtRef();
        }
        return null;
    }

    @Override
    public String getLangRefOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null) {
            return this.tierMap.get(tierName).getLangRef();
        }
        return null;
    }

    @Override
    public List<AnnotationRecord> getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        return this.tiers.get(tierName);
    }

    @Override
    public Map<String, ExternalReferenceImpl> getExternalReferences(String fileName) {
        this.parse(fileName);
        return this.extReferences;
    }

    @Override
    public List<LanguageRecord> getLanguages(String fileName) {
        this.parse(fileName);
        return this.languages;
    }

    @Override
    public int getFileFormat() {
        int result = 0;
        if (this.fileFormat != null) {
            String[] parts = this.fileFormat.split("\\.");
            result = Integer.valueOf(parts[0]) * 1000 * 1000;
            if (parts.length >= 2) {
                result += Integer.valueOf(parts[1]) * 1000;
                if (parts.length >= 3) {
                    result += Integer.valueOf(parts[2]).intValue();
                }
            }
        }
        return result;
    }

    @Override
    public List<LicenseRecord> getLicenses(String fileName) {
        this.parse(fileName);
        return this.licenses;
    }

    @Override
    public List<RefLinkSetRecord> getRefLinkSetList(String fileName) {
        return this.refLinkSetList;
    }

    private void clear() {
        this.tiers.clear();
        this.tierNames.clear();
        this.linguisticTypes.clear();
        this.locales.clear();
        this.timeSlots.clear();
        this.timeOrder.clear();
        this.mediaDescriptors.clear();
        this.linkedFileDescriptors.clear();
        this.controlledVocabularies.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String fileName) {
        if (this.lastParsed.equals(fileName)) {
            return;
        }
        this.lastParsed = fileName;
        this.currentFileName = fileName;
        this.clear();
        File f = new File(fileName);
        if (f.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                InputSource source = new InputSource(fis);
                source.setSystemId(fileName);
                this.reader.parse(source);
            }
            catch (SAXException e) {
                System.out.println("Parsing error: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("IO error: " + e.getMessage());
            }
            catch (Exception e) {
                this.printErrorLocationInfo("Fatal(?) Error! " + e.getMessage() + " " + e.toString());
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {}
            }
        } else {
            System.out.println("The file does not exist or is not a local file: " + fileName);
            InputStream urlInStream = null;
            try {
                URI fileURI = new URI(fileName);
                urlInStream = fileURI.toURL().openStream();
                InputSource is = new InputSource(urlInStream);
                is.setSystemId(fileName);
                this.reader.parse(is);
            }
            catch (URISyntaxException use) {
                System.out.println("URI sysntax error: " + use.getMessage());
            }
            catch (IOException ioe) {
                System.out.println("URI IO error: " + ioe.getMessage());
            }
            catch (SAXException e) {
                System.out.println("URI parsing error: " + e.getMessage());
            }
            finally {
                try {
                    if (urlInStream != null) {
                        urlInStream.close();
                    }
                }
                catch (Throwable use) {}
            }
        }
    }

    private void println(String s) {
        if (this.verbose) {
            System.out.println(s);
        }
    }

    private void printErrorLocationInfo(String message) {
        System.out.println(message);
        System.out.println("Exception for " + this.currentFileName);
        System.out.println("Tier id " + this.currentTierId);
        System.out.println("Annotation id " + this.currentAnnotationId);
    }

    public static class EAFResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            InputStream stream = null;
            String resource = null;
            resource = systemId.equals("http://www.mpi.nl/tools/elan/EAFv3.0.xsd") ? "/mpi/eudico/resources/EAFv3.0.xsd" : (systemId.equals("http://www.mpi.nl/tools/elan/EAFv2.8.xsd") ? "/mpi/eudico/resources/EAFv2.8.xsd" : (systemId.equals("http://www.mpi.nl/tools/elan/EAFv2.8.xsd") ? "/mpi/eudico/resources/EAFv2.8.xsd" : (systemId.equals("http://www.mpi.nl/tools/elan/EAFv2.7.xsd") ? "/mpi/eudico/resources/EAFv2.7.xsd" : "/mpi/eudico/resources/EAFv2.7.xsd")));
            if (resource != null) {
                try {
                    stream = this.getClass().getResource(resource).openStream();
                    InputStreamReader reader = new InputStreamReader(stream);
                    return new InputSource(reader);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }

    class EAFContentHandler
    extends DefaultHandler
    implements ContentHandler,
    ErrorHandler {
        EAFContentHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            EAF30Parser.this.content = "";
            if (name.equals("ANNOTATION_DOCUMENT")) {
                EAF30Parser.this.author = attributes.getValue("AUTHOR");
                EAF30Parser.this.fileFormat = attributes.getValue("FORMAT");
            } else if (name.equals("LICENSE")) {
                String licenseURL = attributes.getValue("LICENSE_URL");
                LicenseRecord lr = new LicenseRecord();
                lr.setUrl(licenseURL);
                EAF30Parser.this.licenses.add(lr);
            } else if (!name.equals("HEADER")) {
                if (name.equals("MEDIA_DESCRIPTOR")) {
                    String relURL;
                    String mediaURL = attributes.getValue("MEDIA_URL");
                    String mimeType = attributes.getValue("MIME_TYPE");
                    MediaDescriptor md = new MediaDescriptor(mediaURL, mimeType);
                    long timeOrigin = 0L;
                    if (attributes.getValue("TIME_ORIGIN") != null) {
                        md.timeOrigin = timeOrigin = Long.parseLong(attributes.getValue("TIME_ORIGIN"));
                    }
                    String extractedFrom = "";
                    if (attributes.getValue("EXTRACTED_FROM") != null) {
                        md.extractedFrom = extractedFrom = attributes.getValue("EXTRACTED_FROM");
                    }
                    if ((relURL = attributes.getValue("RELATIVE_MEDIA_URL")) != null) {
                        md.relativeMediaURL = relURL;
                    }
                    EAF30Parser.this.mediaDescriptors.add(md);
                } else if (name.equals("LINKED_FILE_DESCRIPTOR")) {
                    String relURL;
                    String assoc;
                    String linkURL = attributes.getValue("LINK_URL");
                    String mime = attributes.getValue("MIME_TYPE");
                    LinkedFileDescriptor lfd = new LinkedFileDescriptor(linkURL, mime);
                    if (attributes.getValue("TIME_ORIGIN") != null) {
                        try {
                            long origin;
                            lfd.timeOrigin = origin = Long.parseLong(attributes.getValue("TIME_ORIGIN"));
                        }
                        catch (NumberFormatException nfe) {
                            System.out.println("Could not parse the time origin: " + nfe.getMessage());
                        }
                    }
                    if ((assoc = attributes.getValue("ASSOCIATED_WITH")) != null) {
                        lfd.associatedWith = assoc;
                    }
                    if ((relURL = attributes.getValue("RELATIVE_LINK_URL")) != null) {
                        lfd.relativeLinkURL = relURL;
                    }
                    EAF30Parser.this.linkedFileDescriptors.add(lfd);
                } else if (name.equals("PROPERTY")) {
                    EAF30Parser.this.currentPropertyName = attributes.getValue("NAME");
                } else if (!name.equals("TIME_ORDER")) {
                    if (name.equals("TIME_SLOT")) {
                        String timeValue = String.valueOf(-1);
                        if (attributes.getValue("TIME_VALUE") != null) {
                            timeValue = attributes.getValue("TIME_VALUE");
                        }
                        EAF30Parser.this.timeSlots.put(attributes.getValue("TIME_SLOT_ID"), timeValue);
                        EAF30Parser.this.timeOrder.add(attributes.getValue("TIME_SLOT_ID"));
                    } else if (name.equals("TIER")) {
                        EAF30Parser.this.currentTierId = attributes.getValue("TIER_ID");
                        if (!EAF30Parser.this.tiers.containsKey(EAF30Parser.this.currentTierId)) {
                            TierRecord tr = new TierRecord();
                            tr.setName(EAF30Parser.this.currentTierId);
                            EAF30Parser.this.tierMap.put(EAF30Parser.this.currentTierId, tr);
                            tr.setParticipant(attributes.getValue("PARTICIPANT"));
                            tr.setAnnotator(attributes.getValue("ANNOTATOR"));
                            tr.setLinguisticType(attributes.getValue("LINGUISTIC_TYPE_REF"));
                            tr.setDefaultLocale(attributes.getValue("DEFAULT_LOCALE"));
                            tr.setParentTier(attributes.getValue("PARENT_REF"));
                            tr.setExtRef(attributes.getValue("EXT_REF"));
                            tr.setLangRef(attributes.getValue("LANG_REF"));
                            EAF30Parser.this.tiers.put(EAF30Parser.this.currentTierId, new ArrayList());
                            EAF30Parser.this.tierNames.add(EAF30Parser.this.currentTierId);
                        }
                    } else if (name.equals("ALIGNABLE_ANNOTATION")) {
                        EAF30Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                        EAF30Parser.this.currentAnnRecord = new AnnotationRecord();
                        EAF30Parser.this.currentAnnRecord.setAnnotationId(EAF30Parser.this.currentAnnotationId);
                        EAF30Parser.this.currentAnnRecord.setAnnotationType("alignable");
                        EAF30Parser.this.currentAnnRecord.setBeginTimeSlotId(attributes.getValue("TIME_SLOT_REF1"));
                        EAF30Parser.this.currentAnnRecord.setEndTimeSlotId(attributes.getValue("TIME_SLOT_REF2"));
                        EAF30Parser.this.currentAnnRecord.setExtRefId(attributes.getValue("EXT_REF"));
                        EAF30Parser.this.currentAnnRecord.setCvEntryId(attributes.getValue("CVE_REF"));
                        ((List)EAF30Parser.this.tiers.get(EAF30Parser.this.currentTierId)).add(EAF30Parser.this.currentAnnRecord);
                    } else if (name.equals("REF_ANNOTATION")) {
                        EAF30Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                        EAF30Parser.this.currentAnnRecord = new AnnotationRecord();
                        EAF30Parser.this.currentAnnRecord.setAnnotationId(EAF30Parser.this.currentAnnotationId);
                        EAF30Parser.this.currentAnnRecord.setAnnotationType("reference");
                        EAF30Parser.this.currentAnnRecord.setReferredAnnotId(attributes.getValue("ANNOTATION_REF"));
                        if (attributes.getValue("PREVIOUS_ANNOTATION") != null) {
                            EAF30Parser.this.currentAnnRecord.setPreviousAnnotId(attributes.getValue("PREVIOUS_ANNOTATION"));
                        } else {
                            EAF30Parser.this.currentAnnRecord.setPreviousAnnotId("");
                        }
                        EAF30Parser.this.currentAnnRecord.setExtRefId(attributes.getValue("EXT_REF"));
                        EAF30Parser.this.currentAnnRecord.setCvEntryId(attributes.getValue("CVE_REF"));
                        ((List)EAF30Parser.this.tiers.get(EAF30Parser.this.currentTierId)).add(EAF30Parser.this.currentAnnRecord);
                    } else if (!name.equals("ANNOTATION_VALUE")) {
                        if (name.equals("LINGUISTIC_TYPE")) {
                            LingTypeRecord ltr = new LingTypeRecord();
                            ltr.setLingTypeId(attributes.getValue("LINGUISTIC_TYPE_ID"));
                            String timeAlignable = "true";
                            if (attributes.getValue("TIME_ALIGNABLE") != null && attributes.getValue("TIME_ALIGNABLE").equals("false")) {
                                timeAlignable = "false";
                            }
                            ltr.setTimeAlignable(timeAlignable);
                            String stereotype = attributes.getValue("CONSTRAINTS");
                            ltr.setStereoType(stereotype);
                            if (stereotype != null && stereotype.startsWith("Symbolic")) {
                                ltr.setTimeAlignable("false");
                            }
                            ltr.setControlledVocabulary(attributes.getValue("CONTROLLED_VOCABULARY_REF"));
                            ltr.setLexiconReference(attributes.getValue("LEXICON_REF"));
                            ltr.setExtRefId(attributes.getValue("EXT_REF"));
                            EAF30Parser.this.linguisticTypes.add(ltr);
                        } else if (name.equals("LEXICON_REF")) {
                            String lexiconSrvcRef = attributes.getValue("LEX_REF_ID");
                            String lexiconClientName = attributes.getValue("NAME");
                            String lexiconSrvcType = attributes.getValue("TYPE");
                            String lexiconSrvcUrl = attributes.getValue("URL");
                            String lexiconSrvcId = attributes.getValue("LEXICON_ID");
                            String lexiconSrvcName = attributes.getValue("LEXICON_NAME");
                            String dataCategory = attributes.getValue("DATCAT_NAME");
                            String dataCategoryId = attributes.getValue("DATCAT_ID");
                            LexiconServiceRecord lsr = new LexiconServiceRecord();
                            lsr.setName(lexiconClientName);
                            lsr.setType(lexiconSrvcType);
                            lsr.setUrl(lexiconSrvcUrl);
                            lsr.setLexiconId(lexiconSrvcId);
                            lsr.setLexiconName(lexiconSrvcName);
                            lsr.setDatcatName(dataCategory);
                            lsr.setDatcatId(dataCategoryId);
                            EAF30Parser.this.lexiconServices.put(lexiconSrvcRef, lsr);
                        } else if (name.equals("LOCALE")) {
                            String variant;
                            String langCode = attributes.getValue("LANGUAGE_CODE");
                            String countryCode = attributes.getValue("COUNTRY_CODE");
                            if (countryCode == null) {
                                countryCode = "";
                            }
                            if ((variant = attributes.getValue("VARIANT")) == null) {
                                variant = "";
                            }
                            Locale l = new Locale(langCode, countryCode, variant);
                            EAF30Parser.this.locales.add(l);
                        } else if (name.equals("LANGUAGE")) {
                            String id = attributes.getValue("LANG_ID");
                            String def = attributes.getValue("LANG_DEF");
                            String label = attributes.getValue("LANG_LABEL");
                            if (id != null && def != null) {
                                EAF30Parser.this.languages.add(new LanguageRecord(id, def, label));
                            }
                        } else if (name.equals("CONTROLLED_VOCABULARY")) {
                            String extRefId;
                            EAF30Parser.this.currentCVId = attributes.getValue("CV_ID");
                            EAF30Parser.this.controlledVocabularyIsMultiLanguage = false;
                            CVRecord cv = new CVRecord(EAF30Parser.this.currentCVId);
                            String desc = attributes.getValue("DESCRIPTION");
                            if (desc != null) {
                                cv.setDescription(desc);
                            }
                            if ((extRefId = attributes.getValue("EXT_REF")) != null) {
                                cv.setExtRefId(extRefId);
                            }
                            EAF30Parser.this.controlledVocabularies.put(EAF30Parser.this.currentCVId, cv);
                        } else if (name.equals("DESCRIPTION")) {
                            EAF30Parser.this.cvDescriptionRecord = new CVDescriptionRecord();
                            EAF30Parser.this.controlledVocabularyIsMultiLanguage = true;
                            String langRef = attributes.getValue("LANG_REF");
                            if (langRef != null) {
                                EAF30Parser.this.cvDescriptionRecord.setLangRef(langRef);
                            }
                            ((CVRecord)EAF30Parser.this.controlledVocabularies.get(EAF30Parser.this.currentCVId)).addDescription(EAF30Parser.this.cvDescriptionRecord);
                        } else if (name.equals("CV_ENTRY")) {
                            assert (!EAF30Parser.this.controlledVocabularyIsMultiLanguage);
                            EAF30Parser.this.currentEntryRecord = new CVEntryRecord();
                            EAF30Parser.this.currentEntryRecord.setDescription(attributes.getValue("DESCRIPTION"));
                            EAF30Parser.this.currentEntryRecord.setExtRefId(attributes.getValue("EXT_REF"));
                            EAF30Parser.this.currentEntryRecord.setId(attributes.getValue("ID"));
                            ((CVRecord)EAF30Parser.this.controlledVocabularies.get(EAF30Parser.this.currentCVId)).addEntry(EAF30Parser.this.currentEntryRecord);
                        } else if (name.equals("CV_ENTRY_ML")) {
                            assert (EAF30Parser.this.controlledVocabularyIsMultiLanguage);
                            EAF30Parser.this.currentEntryRecord = new CVEntryRecord();
                            String cveID = attributes.getValue("CVE_ID");
                            String extRef = attributes.getValue("EXT_REF");
                            EAF30Parser.this.currentEntryRecord.setExtRefId(extRef);
                            EAF30Parser.this.currentEntryRecord.setId(cveID);
                            ((CVRecord)EAF30Parser.this.controlledVocabularies.get(EAF30Parser.this.currentCVId)).addEntry(EAF30Parser.this.currentEntryRecord);
                        } else if (name.equals("CVE_VALUE")) {
                            assert (EAF30Parser.this.controlledVocabularyIsMultiLanguage);
                            String description = attributes.getValue("DESCRIPTION");
                            String langRef = attributes.getValue("LANG_REF");
                            EAF30Parser.this.currentSubEntryRecord = new CVEntryRecord();
                            EAF30Parser.this.currentSubEntryRecord.setDescription(description);
                            EAF30Parser.this.currentSubEntryRecord.setSubEntryLangRef(langRef);
                            EAF30Parser.this.currentEntryRecord.addSubEntry(EAF30Parser.this.currentSubEntryRecord);
                        } else if (name.equals("REF_LINK_SET")) {
                            EAF30Parser.this.refLinkSet = new RefLinkSetRecord();
                            String linksID = attributes.getValue("LINK_SET_ID");
                            if (linksID == null) {
                                linksID = attributes.getValue("LINKS_ID");
                            }
                            String linksName = attributes.getValue("LINK_SET_NAME");
                            String extRef = attributes.getValue("EXT_REF");
                            String langRef = attributes.getValue("LANG_REF");
                            String cvRef = attributes.getValue("CV_REF");
                            EAF30Parser.this.refLinkSet.setLinksID(linksID);
                            EAF30Parser.this.refLinkSet.setLinksName(linksName);
                            EAF30Parser.this.refLinkSet.setExtRefID(extRef);
                            EAF30Parser.this.refLinkSet.setLangRef(langRef);
                            EAF30Parser.this.refLinkSet.setCvRef(cvRef);
                            EAF30Parser.this.refLinkSetList.add(EAF30Parser.this.refLinkSet);
                        } else if (name.equals("CROSS_REF_LINK")) {
                            CrossRefLinkRecord rec = new CrossRefLinkRecord();
                            EAF30Parser.this.refLinkSet.getRefLinks().add(rec);
                            EAF30Parser.this.refLinkRecord = rec;
                            String refLinkID = attributes.getValue("REF_LINK_ID");
                            String refLinkName = attributes.getValue("REF_LINK_NAME");
                            String extRef = attributes.getValue("EXT_REF");
                            String langRef = attributes.getValue("LANG_REF");
                            String cveRef = attributes.getValue("CVE_REF");
                            String refType = attributes.getValue("REF_TYPE");
                            rec.setId(refLinkID);
                            rec.setRefName(refLinkName);
                            rec.setExtRefID(extRef);
                            rec.setLangRef(langRef);
                            rec.setCveRef(cveRef);
                            rec.setRefType(refType);
                            String ref1 = attributes.getValue("REF1");
                            String ref2 = attributes.getValue("REF2");
                            String dir = attributes.getValue("DIRECTIONALITY");
                            rec.setRef1(ref1);
                            rec.setRef2(ref2);
                            rec.setDirectionality(dir);
                        } else if (name.equals("GROUP_REF_LINK")) {
                            GroupRefLinkRecord rec = new GroupRefLinkRecord();
                            EAF30Parser.this.refLinkSet.getRefLinks().add(rec);
                            EAF30Parser.this.refLinkRecord = rec;
                            String refLinkID = attributes.getValue("REF_LINK_ID");
                            String refLinkName = attributes.getValue("REF_LINK_NAME");
                            String extRef = attributes.getValue("EXT_REF");
                            String langRef = attributes.getValue("LANG_REF");
                            String cveRef = attributes.getValue("CVE_REF");
                            String refType = attributes.getValue("REF_TYPE");
                            rec.setId(refLinkID);
                            rec.setRefName(refLinkName);
                            rec.setExtRefID(extRef);
                            rec.setLangRef(langRef);
                            rec.setCveRef(cveRef);
                            rec.setRefType(refType);
                            String refs = attributes.getValue("REFS");
                            rec.setRefs(refs);
                        } else if (name.equals("EXTERNAL_REF")) {
                            String value = attributes.getValue("VALUE");
                            String type = attributes.getValue("TYPE");
                            String dcId = attributes.getValue("EXT_REF_ID");
                            if (value != null && value.length() > 0) {
                                ExternalReferenceImpl eri = new ExternalReferenceImpl(value, type);
                                EAF30Parser.this.extReferences.put(dcId, eri);
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            String c;
            if (name.equals("ANNOTATION_VALUE")) {
                EAF30Parser.this.currentAnnRecord.setValue(EAF30Parser.this.content);
            } else if (name.equals("CV_ENTRY")) {
                EAF30Parser.this.currentEntryRecord.setValue(EAF30Parser.this.content);
            } else if (name.equals("PROPERTY")) {
                if (EAF30Parser.this.content.length() > 0 && EAF30Parser.this.currentPropertyName != null) {
                    PropertyImpl prop = new PropertyImpl(EAF30Parser.this.currentPropertyName, EAF30Parser.this.content);
                    EAF30Parser.this.docProperties.add(prop);
                }
            } else if (name.equals("DESCRIPTION")) {
                if (EAF30Parser.this.content.length() > 0 && EAF30Parser.this.cvDescriptionRecord != null) {
                    EAF30Parser.this.cvDescriptionRecord.setDescription(EAF30Parser.this.content);
                }
                EAF30Parser.this.cvDescriptionRecord = null;
            } else if (name.equals("CVE_VALUE")) {
                EAF30Parser.this.currentSubEntryRecord.setValue(EAF30Parser.this.content);
            } else if (name.equals("LICENSE")) {
                String licenseText = EAF30Parser.this.content;
                LicenseRecord lr = (LicenseRecord)EAF30Parser.this.licenses.get(EAF30Parser.this.licenses.size() - 1);
                lr.setText(licenseText);
            } else if ((name.equals("CROSS_REF_LINK") || name.equals("GROUP_REF_LINK")) && !(c = EAF30Parser.this.content.trim()).isEmpty()) {
                EAF30Parser.this.refLinkRecord.setContent(c);
            }
        }

        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            EAF30Parser.this.content = EAF30Parser.this.content + new String(ch, start, end);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error:     " + exception.getMessage());
            System.out.println("System id: " + exception.getSystemId());
            System.out.println("Public id: " + exception.getPublicId());
            System.out.println("Line:      " + exception.getLineNumber());
            System.out.println("Column:    " + exception.getColumnNumber());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("FatalError: " + exception.getMessage());
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Warning: " + exception.getMessage());
        }
    }
}

