/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF28Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.LanguageRecord;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.ExternalCVEntry;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ECV02Parser {
    private XMLReader reader;
    private String url;
    private List<ExternalCV> cvList;
    private List<ExternalCV> unexpectedCvList;
    private final Map<String, ExternalReference> extReferences = new HashMap<String, ExternalReference>();
    private final Map<CVEntry, String> cvEntryExtRef = new HashMap<CVEntry, String>();
    private String currentCVId;
    private ControlledVocabulary currentCV;
    private String currentEntryDesc;
    private String currentEntryExtRef;
    private String content = "";
    public String currentEntryId;

    public ECV02Parser(String url) throws ParseException {
        this(url, false);
    }

    public ECV02Parser(String url, boolean strict) throws ParseException {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.reader.setEntityResolver(new EAF28Parser.EAFResolver());
            this.reader.setContentHandler(new ECV02Handler());
            if (strict) {
                this.reader.setErrorHandler(new ECV02ErrorHandler());
            }
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    public void parse(List<ExternalCV> ecvList) throws ParseException {
        if (ecvList != null) {
            this.cvList = ecvList;
            this.unexpectedCvList = null;
        } else {
            this.cvList = new ArrayList<ExternalCV>();
            this.unexpectedCvList = this.cvList;
        }
        FileInputStream fis = null;
        try {
            if (this.url.toLowerCase().startsWith("file:")) {
                String fileName = FileUtility.urlToAbsPath(this.url);
                File f = new File(fileName);
                try {
                    fis = new FileInputStream(f);
                    InputSource source = new InputSource(fis);
                    this.reader.parse(source);
                }
                catch (FileNotFoundException fnfe) {
                    URL localURL = new URL(this.url);
                    InputSource sourceU = new InputSource(localURL.openStream());
                    this.reader.parse(sourceU);
                }
            } else {
                this.reader.parse(this.url);
            }
            this.createObjects();
        }
        catch (SAXException sax) {
            System.out.println("Parsing error: " + sax.getMessage());
            throw new ParseException("Parsing error: " + sax.getMessage(), sax.getCause());
        }
        catch (IOException ioe) {
            System.out.println("IO error: " + ioe.getMessage());
            throw new ParseException("IO error: " + ioe.getMessage(), ioe.getCause());
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), e.getCause());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private ExternalCV findOrCreate(String name) {
        for (int j = 0; j < this.cvList.size(); ++j) {
            ExternalCV cvFromList = this.cvList.get(j);
            if (!name.equals(cvFromList.getName())) continue;
            return cvFromList;
        }
        if (this.unexpectedCvList == null) {
            this.unexpectedCvList = new ArrayList<ExternalCV>();
        }
        ExternalCV ecv = new ExternalCV(name);
        this.unexpectedCvList.add(ecv);
        return ecv;
    }

    private void createObjects() {
        if (this.cvEntryExtRef.size() > 0) {
            for (Map.Entry<CVEntry, String> mapentry : this.cvEntryExtRef.entrySet()) {
                CVEntry entry = mapentry.getKey();
                String erId = mapentry.getValue();
                ExternalReferenceImpl eri = (ExternalReferenceImpl)this.extReferences.get(erId);
                if (eri == null) continue;
                try {
                    entry.setExternalRef(eri.clone());
                }
                catch (CloneNotSupportedException cnse) {
                    System.out.println("Could not set the external reference: " + cnse.getMessage());
                }
            }
        }
    }

    public List<ControlledVocabulary> getControlledVocabularies() {
        return Collections.unmodifiableList(this.cvList);
    }

    public List<ControlledVocabulary> getExtraControlledVocabularies() {
        return Collections.unmodifiableList(this.unexpectedCvList);
    }

    public Map<String, ExternalReference> getExternalReferences() {
        return this.extReferences;
    }

    public class ECV02Handler
    implements ContentHandler {
        private ExternalCVEntry currentEntry;
        private boolean controlledVocabularyIsMultiLanguage;
        private String currentEntryLangRef;
        private List<LanguageRecord> languages = new ArrayList<LanguageRecord>();

        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            ECV02Parser.this.content = ECV02Parser.this.content + new String(ch, start, end);
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            int index;
            if (name.equals("CV_ENTRY")) {
                if (!this.controlledVocabularyIsMultiLanguage) {
                    ExternalCVEntry entry = new ExternalCVEntry((BasicControlledVocabulary)ECV02Parser.this.currentCV, ECV02Parser.this.content, ECV02Parser.this.currentEntryDesc, ECV02Parser.this.currentEntryId);
                    ECV02Parser.this.currentCV.addEntry(entry);
                    if (ECV02Parser.this.currentEntryExtRef != null) {
                        ECV02Parser.this.cvEntryExtRef.put(entry, ECV02Parser.this.currentEntryExtRef);
                    }
                }
            } else if (name.equals("DESCRIPTION")) {
                if (ECV02Parser.this.content.length() > 0) {
                    int index2 = ECV02Parser.this.currentCV.getNumberOfLanguages() - 1;
                    ECV02Parser.this.currentCV.setDescription(index2, ECV02Parser.this.content);
                }
            } else if (name.equals("CVE_VALUE") && (index = ECV02Parser.this.currentCV.getIndexOfLanguage(this.currentEntryLangRef)) >= 0) {
                this.currentEntry.setDescription(index, ECV02Parser.this.currentEntryDesc);
                this.currentEntry.setValue(index, ECV02Parser.this.content);
            }
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            ECV02Parser.this.content = "";
            if (!name.equals("CV_RESOURCE")) {
                if (name.equals("LANGUAGE")) {
                    String id = attributes.getValue("LANG_ID");
                    String def = attributes.getValue("LANG_DEF");
                    String label = attributes.getValue("LANG_LABEL");
                    if (id != null && def != null) {
                        this.languages.add(new LanguageRecord(id, def, label));
                    }
                } else if (name.equals("CONTROLLED_VOCABULARY")) {
                    ExternalReference eri;
                    ECV02Parser.this.currentCVId = attributes.getValue("CV_ID");
                    ECV02Parser.this.currentCV = ECV02Parser.this.findOrCreate(ECV02Parser.this.currentCVId);
                    this.controlledVocabularyIsMultiLanguage = false;
                    String desc = attributes.getValue("DESCRIPTION");
                    if (desc != null) {
                        ECV02Parser.this.currentCV.setDescription(desc);
                    }
                    this.controlledVocabularyIsMultiLanguage = false;
                    String extRefId = attributes.getValue("EXT_REF");
                    if (extRefId != null && (eri = (ExternalReference)ECV02Parser.this.extReferences.get(extRefId)) != null) {
                        try {
                            ((ExternalCV)ECV02Parser.this.currentCV).setExternalRef(eri.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    }
                } else if (name.equals("DESCRIPTION")) {
                    this.controlledVocabularyIsMultiLanguage = true;
                    String shortId = attributes.getValue("LANG_REF");
                    if (shortId != null) {
                        for (LanguageRecord lr : this.languages) {
                            if (!shortId.equals(lr.getId())) continue;
                            String longId = lr.getDef();
                            String label = lr.getLabel();
                            int index = ECV02Parser.this.currentCV.addLanguage(shortId, longId, label);
                            break;
                        }
                    }
                } else if (name.equals("CV_ENTRY")) {
                    ECV02Parser.this.currentEntryDesc = attributes.getValue("DESCRIPTION");
                    ECV02Parser.this.currentEntryExtRef = attributes.getValue("EXT_REF");
                    ECV02Parser.this.currentEntryId = attributes.getValue("CVE_ID");
                } else if (name.equals("CV_ENTRY_ML")) {
                    assert (this.controlledVocabularyIsMultiLanguage);
                    this.currentEntry = new ExternalCVEntry(ECV02Parser.this.currentCV);
                    String cveID = attributes.getValue("CVE_ID");
                    String extRefID = attributes.getValue("EXT_REF");
                    this.currentEntry.setId(cveID);
                    ECV02Parser.this.currentCV.addEntry(this.currentEntry);
                    if (extRefID != null && !extRefID.isEmpty()) {
                        ECV02Parser.this.cvEntryExtRef.put(this.currentEntry, extRefID);
                    }
                } else if (name.equals("CVE_VALUE")) {
                    assert (this.controlledVocabularyIsMultiLanguage);
                    ECV02Parser.this.currentEntryDesc = attributes.getValue("DESCRIPTION");
                    this.currentEntryLangRef = attributes.getValue("LANG_REF");
                } else if (name.equals("EXTERNAL_REF")) {
                    String value = attributes.getValue("VALUE");
                    String type = attributes.getValue("TYPE");
                    String refId = attributes.getValue("EXT_REF_ID");
                    if (value != null) {
                        ExternalReferenceImpl eri = new ExternalReferenceImpl(value, type);
                        ECV02Parser.this.extReferences.put(refId, eri);
                    }
                }
            }
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }

    class ECV02ErrorHandler
    implements ErrorHandler {
        ECV02ErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error:     " + exception.getMessage());
            System.out.println("System id: " + exception.getSystemId());
            System.out.println("Public id: " + exception.getPublicId());
            System.out.println("Line:      " + exception.getLineNumber());
            System.out.println("Column:    " + exception.getColumnNumber());
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("FatalError: " + exception.getMessage());
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Warning: " + exception.getMessage());
        }
    }
}

