/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV02Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV02Parser;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.ExternalCV;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ECVStore {
    public void loadExternalCV(ExternalCV cv, String url) throws ParseException {
        ArrayList<ExternalCV> ecvList = new ArrayList<ExternalCV>(1);
        ecvList.add(cv);
        this.loadExternalCVS(ecvList, url);
    }

    public void loadExternalCVS(List<ExternalCV> ecvList, String url) throws ParseException {
        if (ecvList == null || ecvList.size() == 0) {
            return;
        }
        ECV02Parser ecvParser = null;
        try {
            ecvParser = new ECV02Parser(url);
            ecvParser.parse(ecvList);
        }
        catch (ParseException pe) {
            ServerLogger.LOG.severe("Parse failed " + url);
            throw pe;
        }
    }

    public void storeExternalCV(ExternalCV cv, String cachePath, String urlString) {
        if (cv == null) {
            ServerLogger.LOG.warning("Could not create a cached version: no external CV provided.");
            return;
        }
        ArrayList<ExternalCV> list = new ArrayList<ExternalCV>(1);
        this.storeExternalCVS(list, cachePath, urlString);
    }

    public void storeExternalCVS(List<ExternalCV> ecvList, String cachePath, String urlString) {
        if (ecvList == null || ecvList.size() == 0) {
            ServerLogger.LOG.warning("Could not create a cached version: no external CV's provided.");
            return;
        }
        if (cachePath == null) {
            ServerLogger.LOG.warning("Could not create a cached version: no cache folder specified.");
            return;
        }
        if (urlString == null) {
            ServerLogger.LOG.warning("Could not create a cached version: no source URL specified.");
            return;
        }
        ExternalReferenceImpl eri = new ExternalReferenceImpl(urlString, 4);
        try {
            ECV02Encoder encoder = new ECV02Encoder();
            encoder.encodeAndSave(ecvList, cachePath, eri);
        }
        catch (Throwable thr) {
            ServerLogger.LOG.severe("Could not create a cached version: " + thr.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ecvFileFormatTest(String path) {
        FormatTestHandler handler = new FormatTestHandler();
        FileInputStream fis = null;
        InputSource source = null;
        String version = "0.2";
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setFeature("http://xml.org/sax/features/namespaces", false);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setContentHandler(handler);
            try {
                File f = new File(path);
                fis = new FileInputStream(f);
                source = new InputSource(fis);
            }
            catch (IOException ioe) {
                try {
                    URI pathUri = new URI(path);
                    source = new InputSource(pathUri.toURL().openStream());
                }
                catch (URISyntaxException e) {
                    throw ioe;
                }
            }
            source.setSystemId(path);
            reader.parse(source);
        }
        catch (SAXParseException ioe) {
        }
        catch (SAXException e) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning(e.getMessage());
            }
            String string = version;
            return string;
        }
        catch (IOException e) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning(e.getMessage());
            }
            String string = version;
            return string;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (handler.version != null) {
            if (ServerLogger.LOG.isLoggable(Level.FINE)) {
                ServerLogger.LOG.fine("The .ecv file has version: " + handler.version);
            }
            return handler.version;
        }
        return version;
    }

    class FormatTestHandler
    extends DefaultHandler {
        String version;

        FormatTestHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.isEmpty()) {
                localName = qName;
            }
            if (localName.equals("CV_RESOURCE")) {
                this.version = attributes.getValue("VERSION");
            }
            throw new SAXParseException("Seen enough of the document", null);
        }
    }
}

