/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.flex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.util.AnnotationCoreComparator;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.flex.FlexEncoderInfo;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlexEncoder {
    private FlexEncoderInfo encoderInfo;
    private AnnotationCoreComparator comparator;
    private String mediaGUID;
    private HashMap<String, String> guidMap = new HashMap();
    private boolean exportEmptyItems = true;

    public FlexEncoder() {
        String emptyItemsSetting = System.getProperty("FLExExport.ExportEmptyItems");
        if (emptyItemsSetting != null) {
            this.exportEmptyItems = Boolean.valueOf(emptyItemsSetting);
        }
    }

    public void setEncoderInfo(FlexEncoderInfo info) {
        this.encoderInfo = info;
    }

    public void encode(TranscriptionImpl transcription) {
        if (transcription == null) {
            return;
        }
        this.comparator = new AnnotationCoreComparator();
        List<TierImpl> tiers = null;
        TierImpl tier = null;
        Annotation ann = null;
        try {
            int i;
            int i2;
            Element interlinearTextItemEl;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            if (doc == null) {
                // empty if block
            }
            Element docEl = this.createDocElement(doc);
            doc.appendChild(docEl);
            Element interlinearTextEl = doc.createElement("interlinear-text");
            List<TierImpl> itTiers = this.encoderInfo.getMappingForElement("interlinear-text");
            if (itTiers.size() > 0) {
                tier = itTiers.get(0);
            }
            if (tier != null) {
                if (tier.getAnnotations() != null && tier.getAnnotations().size() > 0) {
                    ann = tier.getAnnotations().get(0);
                }
                if (ann != null) {
                    interlinearTextItemEl = this.createItemElement(doc, tier.getName(), ann);
                    interlinearTextEl.appendChild(interlinearTextItemEl);
                }
            }
            interlinearTextEl.setAttribute("guid", this.getGuidValue(ann, "interlinear-text"));
            docEl.appendChild(interlinearTextEl);
            if (tier != null) {
                tiers = this.encoderInfo.getMappingForItem("interlinear-text");
                for (int i3 = 0; i3 < tiers.size(); ++i3) {
                    ann = null;
                    tier = tiers.get(i3);
                    if (tier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
                    if (tier.getAnnotations() != null && tier.getAnnotations().size() > 0) {
                        ann = tier.getAnnotations().get(0);
                    }
                    if (ann == null) continue;
                    interlinearTextItemEl = this.createItemElement(doc, tier.getName(), ann);
                    interlinearTextEl.appendChild(interlinearTextItemEl);
                }
            }
            Element paraGraphsEl = doc.createElement("paragraphs");
            interlinearTextEl.appendChild(paraGraphsEl);
            List<TierImpl> paragraphTiers = this.encoderInfo.getMappingForElement("paragraph");
            List<TierImpl> phraseTiers = this.encoderInfo.getMappingForElement("phrase");
            ArrayList<AbstractAnnotation> paragraphAnnotations = new ArrayList<AbstractAnnotation>();
            ArrayList<Annotation> phraseAnns = null;
            Element paraGraphEl = null;
            Element phrasesEl = null;
            for (i2 = 0; i2 < paragraphTiers.size(); ++i2) {
                tier = paragraphTiers.get(i2);
                paragraphAnnotations.addAll(tier.getAnnotations());
            }
            if (paragraphAnnotations.size() > 0) {
                Collections.sort(paragraphAnnotations, this.comparator);
                long beginTime = 0L;
                long endTime = 0L;
                for (i = 0; i < paragraphAnnotations.size(); ++i) {
                    ann = (Annotation)paragraphAnnotations.get(i);
                    if (i == 0) {
                        paraGraphEl = this.createParaGraphElement(doc, ann);
                        paraGraphsEl.appendChild(paraGraphEl);
                        phrasesEl = doc.createElement("phrases");
                        paraGraphEl.appendChild(phrasesEl);
                        beginTime = ann.getBeginTimeBoundary();
                        endTime = ann.getEndTimeBoundary();
                    } else if (ann.getBeginTimeBoundary() < endTime) {
                        if (ann.getEndTimeBoundary() > endTime) {
                            endTime = ann.getEndTimeBoundary();
                        }
                    } else {
                        paraGraphEl = this.createParaGraphElement(doc, ann);
                        paraGraphsEl.appendChild(paraGraphEl);
                        phrasesEl = doc.createElement("phrases");
                        paraGraphEl.appendChild(phrasesEl);
                        beginTime = ann.getBeginTimeBoundary();
                        endTime = ann.getEndTimeBoundary();
                    }
                    phraseAnns = new ArrayList();
                    for (int t = 0; t < phraseTiers.size(); ++t) {
                        phraseAnns.addAll(ann.getChildrenOnTier(phraseTiers.get(t)));
                    }
                    Collections.sort(phraseAnns, this.comparator);
                    for (int a = 0; a < phraseAnns.size(); ++a) {
                        this.addPhraseElement(doc, phrasesEl, (Annotation)phraseAnns.get(a));
                    }
                    if (paraGraphEl == null) continue;
                    if (phraseAnns.size() == 0) {
                        if (paraGraphEl.getParentNode() != paraGraphsEl) continue;
                        paraGraphsEl.removeChild(paraGraphEl);
                        continue;
                    }
                    paraGraphsEl.appendChild(paraGraphEl);
                }
            } else {
                phraseAnns = new ArrayList<Annotation>();
                for (i2 = 0; i2 < phraseTiers.size(); ++i2) {
                    phraseAnns.addAll(phraseTiers.get(i2).getAnnotations());
                }
                Collections.sort(phraseAnns, this.comparator);
                for (int a = 0; a < phraseAnns.size(); ++a) {
                    paraGraphEl = this.createParaGraphElement(doc, ann);
                    paraGraphsEl.appendChild(paraGraphEl);
                    phrasesEl = doc.createElement("phrases");
                    paraGraphEl.appendChild(phrasesEl);
                    this.addPhraseElement(doc, phrasesEl, (Annotation)phraseAnns.get(a));
                }
            }
            Element mediaFileEl = doc.createElement("media-files");
            mediaFileEl.setAttribute("offset-type", "");
            Element mediaEl = doc.createElement("media");
            mediaEl.setAttribute("guid", this.mediaGUID);
            if (ELANCommandFactory.getViewerManager(transcription) != null) {
                if (ELANCommandFactory.getViewerManager(transcription).getMasterMediaPlayer().getMediaDescriptor() != null) {
                    mediaEl.setAttribute("location", ELANCommandFactory.getViewerManager((Transcription)transcription).getMasterMediaPlayer().getMediaDescriptor().mediaURL);
                    if (transcription != null) {
                        List<MediaDescriptor> mediaDescriptors = transcription.getMediaDescriptors();
                        for (i = 0; i < mediaDescriptors.size(); ++i) {
                            MediaDescriptor md = mediaDescriptors.get(i);
                            if (md == ELANCommandFactory.getViewerManager(transcription).getMasterMediaPlayer().getMediaDescriptor()) continue;
                            Element otherMediaEl = doc.createElement("media");
                            otherMediaEl.setAttribute("guid", UUID.randomUUID().toString());
                            otherMediaEl.setAttribute("location", md.mediaURL);
                            mediaFileEl.appendChild(otherMediaEl);
                        }
                    }
                } else {
                    mediaEl.setAttribute("location", "");
                }
            } else {
                String mediaUrl = this.encoderInfo.getMediaFile();
                if (mediaUrl != null) {
                    mediaEl.setAttribute("location", mediaUrl);
                } else {
                    mediaEl.setAttribute("location", "");
                }
            }
            if (!mediaFileEl.hasChildNodes()) {
                mediaFileEl.appendChild(mediaEl);
            } else {
                mediaFileEl.insertBefore(mediaEl, mediaFileEl.getFirstChild());
            }
            interlinearTextEl.appendChild(mediaFileEl);
            List<Property> properties = transcription.getDocProperties();
            if (properties != null) {
                String languages = null;
                for (int i4 = 0; i4 < properties.size(); ++i4) {
                    Property prop = properties.get(i4);
                    if (!prop.getName().equals("languages")) continue;
                    languages = (String)prop.getValue();
                    break;
                }
                if (languages != null) {
                    String[] lang = languages.split(" ");
                    ArrayList<String> langList = new ArrayList<String>();
                    for (String element : lang) {
                        langList.add(element);
                    }
                    if (langList.size() > 0) {
                        Element languagesEl = doc.createElement("languages");
                        interlinearTextEl.appendChild(languagesEl);
                        for (int i5 = 0; i5 < properties.size(); ++i5) {
                            Property prop = properties.get(i5);
                            if (!langList.contains(prop.getName())) continue;
                            Element languageEl = this.createLanguageElement(doc, prop);
                            languagesEl.appendChild(languageEl);
                        }
                    }
                }
            }
            try {
                IoUtil.writeEncodedFile("UTF-8", this.encoderInfo.getPath(), docEl);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (ParserConfigurationException pce) {
            ServerLogger.LOG.warning("Could not create a document: " + pce.getMessage());
        }
    }

    private Element createDocElement(Document doc) {
        Element root = doc.createElement("document");
        root.setAttribute("version", "2");
        return root;
    }

    private Element createItemElement(Document doc, String tierName, Annotation ann) {
        if (ann.getValue().isEmpty() && !this.exportEmptyItems) {
            return null;
        }
        Element text = doc.createElement("item");
        text.setTextContent(ann.getValue());
        List<String> values = this.encoderInfo.getTypeLangValues(tierName);
        String type = null;
        type = this.isPunctType(ann) ? "punct" : values.get(0);
        text.setAttribute("type", type);
        text.setAttribute("lang", values.get(1));
        return text;
    }

    private Element createLanguageElement(Document doc, Property prop) {
        Element lang = doc.createElement("language");
        lang.setAttribute("lang", prop.getName());
        String[] value = ((String)prop.getValue()).split("-");
        String font = null;
        String vernacular = null;
        if (value.length == 1) {
            font = value[0];
        } else if (value.length == 2) {
            font = value[0];
            vernacular = value[1];
        }
        if (font != null) {
            lang.setAttribute("font", font);
        }
        if (vernacular != null) {
            lang.setAttribute("vernacular", vernacular);
        }
        return lang;
    }

    private boolean isPunctType(Annotation ann) {
        String value = ((AbstractAnnotation)ann).getExtRefValue(2);
        if (value != null && value.equals("http://www.isocat.org/rest/dc/1372")) {
            return true;
        }
        String regex = "\\p{P}";
        return ann.getValue().matches(regex);
    }

    private Element createParaGraphElement(Document doc, Annotation ann) {
        Element paraGr = doc.createElement("paragraph");
        paraGr.setAttribute("guid", this.getGuidValue(ann, "paragraph"));
        return paraGr;
    }

    private String getGuidValue(Annotation ann, String elementType) {
        if (ann != null) {
            String guid = ann.getId();
            if (guid != null) {
                int index = guid.indexOf("_flexid_");
                guid = index > 0 ? guid.substring(index + "_flexid_".length()) : null;
            }
            if (elementType != null && (elementType.equals("word") || elementType.equals("morph"))) {
                String annValue = ann.getValue();
                if (guid == null) {
                    guid = this.guidMap.get(annValue);
                }
                if (guid == null) {
                    guid = UUID.randomUUID().toString();
                }
                if (!this.guidMap.containsKey(annValue)) {
                    this.guidMap.put(annValue, guid);
                }
            }
            if (guid != null) {
                return guid;
            }
        }
        return UUID.randomUUID().toString();
    }

    private void addPhraseElement(Document doc, Element phrasesEI, Annotation phraseAnn) {
        if (doc == null || phrasesEI == null || phraseAnn == null) {
            return;
        }
        if (this.mediaGUID == null) {
            this.mediaGUID = UUID.randomUUID().toString();
        }
        TierImpl phraseTier = (TierImpl)phraseAnn.getTier();
        Element phrEl = doc.createElement("phrase");
        phrasesEI.appendChild(phrEl);
        phrEl.setAttribute("guid", this.getGuidValue(phraseAnn, "phrase"));
        phrEl.setAttribute("speaker", phraseTier.getParticipant());
        phrEl.setAttribute("begin-time-offset", Long.toString(phraseAnn.getBeginTimeBoundary()));
        phrEl.setAttribute("end-time-offset", Long.toString(phraseAnn.getEndTimeBoundary()));
        phrEl.setAttribute("media-file", this.mediaGUID);
        Element phrItemEl = this.createItemElement(doc, phraseTier.getName(), phraseAnn);
        if (phrItemEl != null) {
            phrEl.appendChild(phrItemEl);
        }
        List<TierImpl> selectedItemTiers = this.encoderInfo.getMappingForItem("phrase");
        List<TierImpl> wordTiers = this.encoderInfo.getMappingForElement("word");
        List<TierImpl> childTiers = phraseTier.getChildTiers();
        if (childTiers != null) {
            boolean wordTierAdded = false;
            for (int i = 0; i < childTiers.size(); ++i) {
                List<Annotation> childAnns;
                TierImpl childTier = childTiers.get(i);
                if (selectedItemTiers.contains(childTier)) {
                    childAnns = phraseAnn.getChildrenOnTier(childTier);
                    if (childAnns == null || childAnns.size() <= 0 || (phrItemEl = this.createItemElement(doc, childTier.getName(), childAnns.get(0))) == null) continue;
                    phrEl.appendChild(phrItemEl);
                    continue;
                }
                if (!wordTiers.contains(childTier) || wordTierAdded) continue;
                Element wordsEl = doc.createElement("words");
                phrEl.appendChild(wordsEl);
                childAnns = phraseAnn.getChildrenOnTier(childTier);
                if (childAnns != null) {
                    Collections.sort(childAnns, this.comparator);
                    for (int w = 0; w < childAnns.size(); ++w) {
                        this.addWordElement(doc, wordsEl, childAnns.get(w));
                    }
                }
                wordTierAdded = true;
            }
        }
    }

    private void addWordElement(Document doc, Element wordsEl, Annotation wordAnn) {
        if (doc == null || wordsEl == null || wordAnn == null) {
            return;
        }
        TierImpl wordTier = (TierImpl)wordAnn.getTier();
        Element wordEl = doc.createElement("word");
        wordsEl.appendChild(wordEl);
        Element wordItemEl = null;
        wordItemEl = this.createItemElement(doc, wordTier.getName(), wordAnn);
        if (wordItemEl != null) {
            wordEl.appendChild(wordItemEl);
        }
        if (wordItemEl == null || !wordItemEl.getAttribute("type").equals("punct")) {
            wordEl.setAttribute("guid", this.getGuidValue(wordAnn, "word"));
        }
        List<TierImpl> selectedItemTiers = this.encoderInfo.getMappingForItem("word");
        List<TierImpl> morphTiers = this.encoderInfo.getMappingForElement("morph");
        List<TierImpl> childTiers = wordTier.getChildTiers();
        if (childTiers != null) {
            boolean morphTierAdded = false;
            for (int i = 0; i < childTiers.size(); ++i) {
                List<Annotation> childAnns;
                TierImpl childTier = childTiers.get(i);
                if (selectedItemTiers.contains(childTier)) {
                    Element chWordItemEl;
                    childAnns = wordAnn.getChildrenOnTier(childTier);
                    if (childAnns == null || childAnns.size() <= 0 || (chWordItemEl = this.createItemElement(doc, childTier.getName(), childAnns.get(0))) == null) continue;
                    wordEl.appendChild(chWordItemEl);
                    continue;
                }
                if (!morphTiers.contains(childTier) || morphTierAdded) continue;
                childAnns = wordAnn.getChildrenOnTier(childTier);
                if (childAnns != null && childAnns.size() > 0) {
                    Element morphsEl = doc.createElement("morphemes");
                    wordEl.appendChild(morphsEl);
                    Collections.sort(childAnns, this.comparator);
                    for (int w = 0; w < childAnns.size(); ++w) {
                        this.addMorphElement(doc, morphsEl, childAnns.get(w));
                    }
                }
                morphTierAdded = true;
            }
        }
        if (wordItemEl != null && !wordItemEl.hasChildNodes() && wordItemEl.getNextSibling() != null && (wordItemEl.getTextContent() == null || wordItemEl.getTextContent().isEmpty())) {
            wordEl.removeChild(wordItemEl);
        }
        if (!wordEl.hasChildNodes() && !this.exportEmptyItems) {
            wordsEl.removeChild(wordEl);
        }
    }

    private void addMorphElement(Document doc, Element morphsEl, Annotation morphAnn) {
        List<TierImpl> childTiers;
        if (doc == null || morphsEl == null || morphAnn == null) {
            return;
        }
        TierImpl morphTier = (TierImpl)morphAnn.getTier();
        Element morphEl = doc.createElement("morph");
        morphsEl.appendChild(morphEl);
        boolean morphTypeFound = false;
        morphEl.setAttribute("guid", this.getGuidValue(null, "morph"));
        morphEl.setAttribute("type", "root");
        List<TierImpl> morphTypeTiersList = this.encoderInfo.getMorphTypeTiers();
        List<TierImpl> selectedItemTiers = this.encoderInfo.getMappingForItem("morph");
        Element morphItemEl = this.createItemElement(doc, morphAnn.getTier().getName(), morphAnn);
        if (morphItemEl != null) {
            morphEl.appendChild(morphItemEl);
        }
        if ((childTiers = morphTier.getChildTiers()) != null) {
            for (int i = 0; i < childTiers.size(); ++i) {
                List<Annotation> childAnns;
                TierImpl childTier = childTiers.get(i);
                if (selectedItemTiers.contains(childTier)) {
                    childAnns = morphAnn.getChildrenOnTier(childTier);
                    if (childAnns == null || childAnns.size() <= 0 || (morphItemEl = this.createItemElement(doc, childTier.getName(), childAnns.get(0))) == null) continue;
                    morphEl.appendChild(morphItemEl);
                    continue;
                }
                if (morphTypeFound || !morphTypeTiersList.contains(childTier) || (childAnns = morphAnn.getChildrenOnTier(childTier)) == null || childAnns.size() <= 0) continue;
                morphEl.setAttribute("guid", this.getGuidValue(childAnns.get(0), "morph"));
                morphEl.setAttribute("type", childAnns.get(0).getValue());
                morphTypeFound = true;
            }
        }
        if (!morphEl.hasChildNodes() && !this.exportEmptyItems) {
            morphsEl.removeChild(morphEl);
        }
    }

    private void printEncoder() {
        if (this.encoderInfo != null) {
            System.out.println("FLEx encoder information:");
            System.out.println("Tiers for interlinear text:");
            List<TierImpl> tiers = this.encoderInfo.getMappingForElement("interlinear-text");
            this.printTier(tiers);
            System.out.println("Tiers for interlinear text items:");
            tiers = this.encoderInfo.getMappingForItem("interlinear-text");
            this.printTier(tiers);
            System.out.println("Tiers for paragraph:");
            tiers = this.encoderInfo.getMappingForElement("paragraph");
            this.printTier(tiers);
            System.out.println("Tiers for paragraph items:");
            tiers = this.encoderInfo.getMappingForItem("paragraph");
            this.printTier(tiers);
            System.out.println("Tiers for phrase:");
            tiers = this.encoderInfo.getMappingForElement("phrase");
            this.printTier(tiers);
            System.out.println("Tiers for phrase items:");
            tiers = this.encoderInfo.getMappingForItem("phrase");
            this.printTier(tiers);
            System.out.println("Tiers for words:");
            tiers = this.encoderInfo.getMappingForElement("word");
            this.printTier(tiers);
            System.out.println("Tiers for words items:");
            tiers = this.encoderInfo.getMappingForItem("word");
            this.printTier(tiers);
            System.out.println("Tiers for morphemes:");
            tiers = this.encoderInfo.getMappingForElement("morph");
            this.printTier(tiers);
            System.out.println("Tiers for morphemes item:");
            tiers = this.encoderInfo.getMappingForItem("morph");
            this.printTier(tiers);
        } else {
            System.out.println("No encoder information available.");
        }
    }

    private void printTier(List<TierImpl> tiers) {
        if (tiers == null || tiers.size() == 0) {
            System.out.println("None.");
        } else {
            for (TierImpl t : tiers) {
                System.out.println(t.getName());
            }
        }
    }
}

